/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.utils;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class AstAnnotationUtils
implements GroovyObject {
    private static final Map<AnnotatedNode, AnnotationMetadata> annotationMetadataCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AstAnnotationUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * WARNING - void declaration
     */
    public static AnnotationMetadata getAnnotationMetadata(SourceUnit sourceUnit, CompilationUnit compilationUnit, AnnotatedNode annotatedNode) {
        void var1_1;
        Reference sourceUnit2 = new Reference((Object)sourceUnit);
        Reference compilationUnit2 = new Reference((Object)var1_1);
        public final class _getAnnotationMetadata_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sourceUnit;
            private /* synthetic */ Reference compilationUnit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAnnotationMetadata_closure1(Object _outerInstance, Object _thisObject, Reference sourceUnit, Reference compilationUnit) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.sourceUnit = reference2 = sourceUnit;
                this.compilationUnit = reference = compilationUnit;
            }

            public AnnotationMetadata doCall(AnnotatedNode annotatedNode1) {
                return new GroovyAnnotationMetadataBuilder((SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.sourceUnit.get(), SourceUnit.class), (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.compilationUnit.get(), CompilationUnit.class)).build(annotatedNode1);
            }

            @Generated
            public AnnotationMetadata call(AnnotatedNode annotatedNode1) {
                return this.doCall(annotatedNode1);
            }

            @Generated
            public SourceUnit getSourceUnit() {
                return (SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.sourceUnit.get(), SourceUnit.class);
            }

            @Generated
            public CompilationUnit getCompilationUnit() {
                return (CompilationUnit)ScriptBytecodeAdapter.castToType((Object)this.compilationUnit.get(), CompilationUnit.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAnnotationMetadata_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (AnnotationMetadata)ScriptBytecodeAdapter.castToType((Object)annotationMetadataCache.computeIfAbsent(annotatedNode, (Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _getAnnotationMetadata_closure1(AstAnnotationUtils.class, AstAnnotationUtils.class, sourceUnit2, compilationUnit2)), Function.class)), AnnotationMetadata.class);
    }

    public static AnnotationMetadata getMethodAnnotationMetadata(SourceUnit sourceUnit, CompilationUnit compilationUnit, MethodNode annotatedNode) {
        return new GroovyAnnotationMetadataBuilder(sourceUnit, compilationUnit).buildOverridden(annotatedNode);
    }

    public static AnnotationMetadata getAnnotationMetadata(SourceUnit sourceUnit, CompilationUnit compilationUnit, AnnotatedNode parent, AnnotatedNode annotatedNode) {
        return new GroovyAnnotationMetadataBuilder(sourceUnit, compilationUnit).buildForParent(parent, annotatedNode);
    }

    public static AnnotationMetadata getAnnotationMetadata(SourceUnit sourceUnit, CompilationUnit compilationUnit, AnnotatedNode parent, AnnotatedNode annotatedNode, boolean inheritTypeAnnotations) {
        return AstAnnotationUtils.newBuilder(sourceUnit, compilationUnit).buildForParent(parent, annotatedNode, inheritTypeAnnotations);
    }

    public static GroovyAnnotationMetadataBuilder newBuilder(SourceUnit sourceUnit, CompilationUnit compilationUnit) {
        return new GroovyAnnotationMetadataBuilder(sourceUnit, compilationUnit);
    }

    @Internal
    public static void invalidateCache() {
        annotationMetadataCache.clear();
    }

    @Internal
    public static void invalidateCache(AnnotatedNode node) {
        if (DefaultTypeTransformation.booleanUnbox((Object)node)) {
            annotationMetadataCache.remove(node);
        }
    }

    public static boolean hasStereotype(SourceUnit sourceUnit, CompilationUnit compilationUnit, AnnotatedNode annotatedNode, String stereotype) {
        return AstAnnotationUtils.getAnnotationMetadata(sourceUnit, compilationUnit, annotatedNode).hasStereotype(stereotype);
    }

    public static boolean hasStereotype(SourceUnit sourceUnit, CompilationUnit compilationUnit, AnnotatedNode annotatedNode, Class<? extends Annotation> stereotype) {
        return AstAnnotationUtils.hasStereotype(sourceUnit, compilationUnit, annotatedNode, stereotype.getName());
    }

    public static boolean hasStereotype(SourceUnit sourceUnit, CompilationUnit compilationUnit, AnnotatedNode annotatedNode, List<String> stereotypes) {
        if (annotatedNode == null) {
            return false;
        }
        AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(sourceUnit, compilationUnit, annotatedNode);
        String stereotype = null;
        Iterator<String> iterator = stereotypes.iterator();
        while (iterator.hasNext()) {
            stereotype = ShortTypeHandling.castToString((Object)iterator.next());
            if (!annotationMetadata.hasStereotype(stereotype)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(String declaringType, AnnotatedNode annotatedNode) {
        if (AbstractAnnotationMetadataBuilder.isMetadataMutated((String)declaringType, (Object)annotatedNode)) {
            return true;
        }
        Object ann2 = null;
        for (Object ann2 : annotatedNode.getAnnotations()) {
            if (!(!AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(((AnnotationNode)ann2).getClassNode().getName()))) continue;
            return true;
        }
        return false;
    }

    public static AnnotationNode findAnnotation(AnnotatedNode annotatedNode, Class<?> type) {
        String annotationName = type.getName();
        return AstAnnotationUtils.findAnnotation(annotatedNode, annotationName);
    }

    public static AnnotationNode findAnnotation(AnnotatedNode annotatedNode, String annotationName) {
        if (annotatedNode != null) {
            List annotations = annotatedNode.getAnnotations();
            AnnotationNode ann2 = null;
            for (AnnotationNode ann2 : annotations) {
                AnnotationNode annotationNode;
                ClassNode annotationClassNode = ((AnnotationNode)ann2).getClassNode();
                if (ScriptBytecodeAdapter.compareEqual((Object)annotationClassNode.getName(), (Object)annotationName)) {
                    return (AnnotationNode)ScriptBytecodeAdapter.castToType(ann2, AnnotationNode.class);
                }
                boolean bl = AnnotationUtil.INTERNAL_ANNOTATION_NAMES == null ? annotationClassNode.getName() == null : DefaultGroovyMethods.isCase((Collection)AnnotationUtil.INTERNAL_ANNOTATION_NAMES, (Object)annotationClassNode.getName());
                if (!(!bl)) continue;
                ann2 = annotationNode = AstAnnotationUtils.findAnnotation((AnnotatedNode)annotationClassNode, annotationName);
                if (!(ann2 != null)) continue;
                return (AnnotationNode)ScriptBytecodeAdapter.castToType((Object)ann2, AnnotationNode.class);
            }
        }
        return (AnnotationNode)ScriptBytecodeAdapter.castToType(null, AnnotationNode.class);
    }

    public static boolean hasAnnotation(MethodNode methodNode, Class<? extends Annotation> annotationClass) {
        ClassNode classNode = new ClassNode(annotationClass);
        return AstAnnotationUtils.hasAnnotation(methodNode, classNode);
    }

    public static boolean hasAnnotation(MethodNode methodNode, ClassNode annotationClassNode) {
        return !methodNode.getAnnotations(annotationClassNode).isEmpty();
    }

    public static void copyAnnotations(AnnotatedNode from, AnnotatedNode to) {
        AstAnnotationUtils.copyAnnotations(from, to, null, null);
    }

    public static void copyAnnotations(AnnotatedNode from, AnnotatedNode to, Set<String> included, Set<String> excluded) {
        List annotationsToCopy = from.getAnnotations();
        AnnotationNode node = null;
        Iterator iterator = annotationsToCopy.iterator();
        while (iterator.hasNext()) {
            node = (AnnotationNode)ScriptBytecodeAdapter.castToType(iterator.next(), AnnotationNode.class);
            String annotationClassName = node.getClassNode().getName();
            if (!((excluded == null || !excluded.contains(annotationClassName)) && (included == null || included.contains(annotationClassName)))) continue;
            AnnotationNode copyOfAnnotationNode = AstAnnotationUtils.cloneAnnotation(node);
            to.addAnnotation(copyOfAnnotationNode);
        }
    }

    public static AnnotationNode cloneAnnotation(AnnotationNode node) {
        AnnotationNode copyOfAnnotationNode = new AnnotationNode(node.getClassNode());
        Map members = node.getMembers();
        Map.Entry entry = null;
        Iterator iterator = members.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            copyOfAnnotationNode.addMember(ShortTypeHandling.castToString(entry.getKey()), (Expression)ScriptBytecodeAdapter.castToType(entry.getValue(), Expression.class));
        }
        return copyOfAnnotationNode;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AstAnnotationUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @groovy.transform.Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @groovy.transform.Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        ConcurrentLinkedHashMap concurrentLinkedHashMap;
        annotationMetadataCache = concurrentLinkedHashMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)100).build();
    }
}

