/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.annotation;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.Script;
import io.micronaut.ast.groovy.utils.AstGenericUtils;
import io.micronaut.ast.groovy.utils.AstMessageUtils;
import io.micronaut.ast.groovy.utils.ExtendedParameter;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyAnnotationMetadataBuilder
extends AbstractAnnotationMetadataBuilder<AnnotatedNode, AnnotationNode> {
    public static final ClassNode ANN_OVERRIDE = ClassHelper.make(Override.class);
    public static final String VALIDATOR_KEY = "io.micronaut.VALIDATOR";
    final SourceUnit sourceUnit;
    final AnnotatedElementValidator elementValidator;
    final CompilationUnit compilationUnit;

    public GroovyAnnotationMetadataBuilder(SourceUnit sourceUnit, CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.sourceUnit = sourceUnit;
        if (sourceUnit != null) {
            ModuleNode ast = sourceUnit.getAST();
            if (ast != null) {
                Object validator = ast.getNodeMetaData((Object)VALIDATOR_KEY);
                if (validator instanceof AnnotatedElementValidator) {
                    AnnotatedElementValidator annotatedElementValidator;
                    this.elementValidator = annotatedElementValidator = (AnnotatedElementValidator)validator;
                } else {
                    this.elementValidator = SoftServiceLoader.load(AnnotatedElementValidator.class).firstAvailable().orElse(null);
                    ast.putNodeMetaData((Object)VALIDATOR_KEY, (Object)this.elementValidator);
                }
            } else {
                this.elementValidator = null;
            }
        } else {
            this.elementValidator = null;
        }
    }

    public AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupOrBuildForParameter(AnnotatedNode owningType, AnnotatedNode methodElement, AnnotatedNode parameterElement) {
        return super.lookupOrBuildForParameter((Object)owningType, (Object)methodElement, (Object)new ExtendedParameter((MethodNode)methodElement, (Parameter)parameterElement));
    }

    protected boolean isValidationRequired(AnnotatedNode member) {
        List annotations;
        if (member != null && CollectionUtils.isNotEmpty((Collection)(annotations = member.getAnnotations()))) {
            return annotations.stream().anyMatch(it -> it.getClassNode().getName().startsWith("jakarta.validation"));
        }
        return false;
    }

    protected boolean isExcludedAnnotation(@NonNull AnnotatedNode element, @NonNull String annotationName) {
        ClassNode classNode;
        if (element instanceof ClassNode && (classNode = (ClassNode)element).isAnnotationDefinition() && (annotationName.startsWith("java.lang.annotation") || annotationName.startsWith("org.codehaus.groovy.transform"))) {
            return false;
        }
        return super.isExcludedAnnotation((Object)element, annotationName);
    }

    protected AnnotatedNode getAnnotationMember(AnnotatedNode annotationElement, CharSequence member) {
        ClassNode classNode;
        List methods;
        if (annotationElement instanceof ClassNode && CollectionUtils.isNotEmpty((Collection)(methods = (classNode = (ClassNode)annotationElement).getMethods(member.toString())))) {
            return (AnnotatedNode)methods.iterator().next();
        }
        return null;
    }

    protected String getOriginatingClassName(AnnotatedNode originatingElement) {
        if (originatingElement instanceof ClassNode) {
            ClassNode classNode = (ClassNode)originatingElement;
            return classNode.getName();
        }
        if (originatingElement instanceof ExtendedParameter) {
            ExtendedParameter extendedParameter = (ExtendedParameter)originatingElement;
            return extendedParameter.getMethodNode().getDeclaringClass().getName();
        }
        if (originatingElement instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)originatingElement;
            return methodNode.getDeclaringClass().getName();
        }
        return originatingElement.getDeclaringClass().getName();
    }

    protected RetentionPolicy getRetentionPolicy(@NonNull AnnotatedNode annotation) {
        List annotations = annotation.getAnnotations();
        for (AnnotationNode ann : annotations) {
            Expression expr;
            Iterator i;
            if (!ann.getClassNode().getName().equals(Retention.class.getName()) || !(i = ann.getMembers().values().iterator()).hasNext() || !((expr = (Expression)i.next()) instanceof PropertyExpression)) continue;
            PropertyExpression propertyExpression = (PropertyExpression)expr;
            try {
                return RetentionPolicy.valueOf(propertyExpression.getPropertyAsString());
            }
            catch (Throwable e) {
                return RetentionPolicy.RUNTIME;
            }
        }
        return RetentionPolicy.RUNTIME;
    }

    protected AnnotatedElementValidator getElementValidator() {
        return this.elementValidator;
    }

    protected void addError(@NonNull AnnotatedNode originatingElement, @NonNull String error) {
        AstMessageUtils.error(this.sourceUnit, (ASTNode)originatingElement, error);
    }

    protected void addWarning(@NonNull AnnotatedNode originatingElement, @NonNull String warning) {
        AstMessageUtils.warning(this.sourceUnit, (ASTNode)originatingElement, warning);
    }

    protected boolean hasAnnotation(AnnotatedNode element, Class<? extends Annotation> annotation) {
        return !element.getAnnotations(ClassHelper.makeCached(annotation)).isEmpty();
    }

    protected boolean hasAnnotation(AnnotatedNode element, String annotation) {
        for (AnnotationNode ann : element.getAnnotations()) {
            if (!ann.getClassNode().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnnotations(AnnotatedNode element) {
        return CollectionUtils.isNotEmpty((Collection)element.getAnnotations());
    }

    protected VisitorContext createVisitorContext() {
        return new GroovyVisitorContext(this.sourceUnit, this.compilationUnit);
    }

    protected AnnotatedNode getTypeForAnnotation(AnnotationNode annotationMirror) {
        return annotationMirror.getClassNode();
    }

    protected String getRepeatableName(AnnotationNode annotationMirror) {
        return this.getRepeatableNameForType((AnnotatedNode)annotationMirror.getClassNode());
    }

    protected String getRepeatableNameForType(AnnotatedNode annotationType) {
        Expression expression;
        List annotationNodes = annotationType.getAnnotations(ClassHelper.makeCached(Repeatable.class));
        if (CollectionUtils.isNotEmpty((Collection)annotationNodes) && (expression = ((AnnotationNode)annotationNodes.get(0)).getMember("value")) instanceof ClassExpression) {
            return expression.getType().getName();
        }
        return null;
    }

    protected Optional<AnnotatedNode> getAnnotationMirror(String annotationName) {
        Optional<AnnotatedNode> classNode;
        Optional<Object> optional = classNode = this.compilationUnit == null ? Optional.empty() : Optional.ofNullable(this.compilationUnit.getClassNode(annotationName));
        if (classNode.isPresent()) {
            return classNode;
        }
        ClassNode cn = ClassUtils.forName((String)annotationName, (ClassLoader)GroovyAnnotationMetadataBuilder.class.getClassLoader()).map(ClassHelper::make).orElseGet(() -> ClassHelper.make((String)annotationName));
        if (!cn.getName().equals("java.lang.Object")) {
            return Optional.of(cn);
        }
        return Optional.empty();
    }

    protected String getAnnotationTypeName(AnnotationNode annotationMirror) {
        return annotationMirror.getClassNode().getName();
    }

    protected String getElementName(AnnotatedNode element) {
        if (element instanceof ClassNode) {
            return ((ClassNode)element).getName();
        }
        if (element instanceof MethodNode) {
            return ((MethodNode)element).getName();
        }
        if (element instanceof FieldNode) {
            return ((FieldNode)element).getName();
        }
        if (element instanceof PropertyNode) {
            return ((PropertyNode)element).getName();
        }
        if (element instanceof PackageNode) {
            return ((PackageNode)element).getName();
        }
        throw new IllegalArgumentException("Cannot establish name for node type: " + element.getClass().getName());
    }

    protected List<? extends AnnotationNode> getAnnotationsForType(AnnotatedNode element) {
        List annotations = element.getAnnotations();
        ArrayList<AnnotationNode> expanded = new ArrayList<AnnotationNode>(annotations.size());
        this.expandAnnotations(annotations, expanded);
        return expanded;
    }

    private void expandAnnotations(List<AnnotationNode> annotations, List<AnnotationNode> expanded) {
        for (AnnotationNode node : annotations) {
            Expression value = node.getMember("value");
            boolean repeatable = false;
            if (value instanceof ListExpression) {
                ListExpression listExpression = (ListExpression)value;
                for (Expression expression : listExpression.getExpressions()) {
                    if (!(expression instanceof AnnotationConstantExpression)) continue;
                    AnnotationConstantExpression annotationConstantExpression = (AnnotationConstantExpression)expression;
                    String name = this.getRepeatableNameForType((AnnotatedNode)expression.getType());
                    if (name == null || !name.equals(node.getClassNode().getName())) continue;
                    repeatable = true;
                    expanded.add((AnnotationNode)annotationConstantExpression.getValue());
                }
            }
            if (repeatable && node.getMembers().size() <= 1) continue;
            expanded.add(node);
        }
    }

    protected List<AnnotatedNode> buildHierarchy(AnnotatedNode element, boolean inheritTypeAnnotations, boolean declaredOnly) {
        if (declaredOnly) {
            return new ArrayList<AnnotatedNode>(Collections.singletonList(element));
        }
        if (element instanceof ClassNode) {
            ClassNode classNode = (ClassNode)element;
            ArrayList<AnnotatedNode> hierarchy = new ArrayList<AnnotatedNode>();
            hierarchy.add((AnnotatedNode)classNode);
            if (classNode.isAnnotationDefinition()) {
                return hierarchy;
            }
            this.populateTypeHierarchy(classNode, hierarchy);
            Collections.reverse(hierarchy);
            return hierarchy;
        }
        if (element instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)element;
            List<Object> hierarchy = inheritTypeAnnotations ? this.buildHierarchy((AnnotatedNode)methodNode.getDeclaringClass(), false, declaredOnly) : new ArrayList();
            if (!methodNode.getAnnotations(ANN_OVERRIDE).isEmpty()) {
                hierarchy.addAll(this.findOverriddenMethods(methodNode));
            }
            hierarchy.add(methodNode);
            return hierarchy;
        }
        if (element instanceof ExtendedParameter) {
            ExtendedParameter extendedParameter = (ExtendedParameter)element;
            ArrayList<AnnotatedNode> hierarchy = new ArrayList<AnnotatedNode>();
            MethodNode methodNode = extendedParameter.getMethodNode();
            if (!methodNode.getAnnotations(ANN_OVERRIDE).isEmpty()) {
                int variableIdx = Arrays.asList(methodNode.getParameters()).indexOf(extendedParameter.getParameter());
                for (MethodNode overridden : this.findOverriddenMethods(methodNode)) {
                    hierarchy.add(new ExtendedParameter(overridden, overridden.getParameters()[variableIdx]));
                }
            }
            hierarchy.add(extendedParameter);
            return hierarchy;
        }
        if (element == null) {
            return new ArrayList<AnnotatedNode>();
        }
        return new ArrayList<AnnotatedNode>(Collections.singletonList(element));
    }

    protected void readAnnotationRawValues(AnnotatedNode originatingElement, String annotationName, AnnotatedNode member, String memberName, Object annotationValue, Map<CharSequence, Object> annotationValues) {
        Object v;
        if (!annotationValues.containsKey(memberName) && (v = this.readAnnotationValue(originatingElement, member, annotationName, memberName, annotationValue)) != null) {
            this.validateAnnotationValue(originatingElement, annotationName, member, memberName, v);
            annotationValues.put(memberName, v);
        }
    }

    protected Map<? extends AnnotatedNode, ?> readAnnotationDefaultValues(String annotationName, AnnotatedNode annotationType) {
        LinkedHashMap<MethodNode, Object> defaultValues = new LinkedHashMap<MethodNode, Object>();
        if (annotationType instanceof ClassNode) {
            ClassNode classNode = (ClassNode)annotationType;
            ArrayList methods = new ArrayList(classNode.getMethods());
            for (MethodNode method : methods) {
                Statement stmt = method.getCode();
                Expression expression = null;
                if (stmt instanceof ReturnStatement) {
                    ReturnStatement returnStatement = (ReturnStatement)stmt;
                    expression = returnStatement.getExpression();
                } else if (stmt instanceof ExpressionStatement) {
                    ExpressionStatement expressionStatement = (ExpressionStatement)stmt;
                    expression = expressionStatement.getExpression();
                }
                if (!(expression instanceof ConstantExpression)) continue;
                ConstantExpression constantExpression = (ConstantExpression)expression;
                Object v = constantExpression.getValue();
                if (v instanceof String) {
                    String s = (String)v;
                    defaultValues.put(method, new ConstantExpression((Object)s));
                    continue;
                }
                if (v == null) continue;
                defaultValues.put(method, expression);
            }
        }
        return defaultValues;
    }

    protected Object readAnnotationValue(AnnotatedNode originatingElement, AnnotatedNode member, String annotationName, String memberName, Object annotationValue) {
        if (annotationValue instanceof ConstantExpression) {
            ConstantExpression constantExpression = (ConstantExpression)annotationValue;
            return this.readConstantExpression(originatingElement, annotationName, member, constantExpression);
        }
        if (annotationValue instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)annotationValue;
            Expression expression = pe.getObjectExpression();
            if (expression instanceof ClassExpression) {
                ClassExpression classExpression = (ClassExpression)expression;
                ClassNode propertyType = classExpression.getType();
                if (propertyType.isEnum()) {
                    return pe.getPropertyAsString();
                }
                if (propertyType.isResolved()) {
                    Class typeClass = propertyType.getTypeClass();
                    try {
                        Field f = ReflectionUtils.getRequiredField((Class)typeClass, (String)pe.getPropertyAsString());
                        f.setAccessible(true);
                        return f.get(typeClass);
                    }
                    catch (Throwable f) {}
                }
            }
        } else {
            if (annotationValue instanceof ClassExpression) {
                ClassExpression classExpression = (ClassExpression)annotationValue;
                return new AnnotationClassValue(classExpression.getType().getName());
            }
            if (annotationValue instanceof ListExpression) {
                ListExpression listExpression = (ListExpression)annotationValue;
                List expressions = listExpression.getExpressions();
                ArrayList<Object> converted = new ArrayList<Object>(expressions.size());
                for (Expression exp : expressions) {
                    if (exp instanceof PropertyExpression) {
                        PropertyExpression propertyExpression = (PropertyExpression)exp;
                        Expression valueExpression = propertyExpression.getProperty();
                        Expression objectExpression = propertyExpression.getObjectExpression();
                        if (valueExpression instanceof ConstantExpression) {
                            Object value;
                            ConstantExpression constantExpression = (ConstantExpression)valueExpression;
                            if (objectExpression instanceof ClassExpression && (value = this.readConstantExpression(originatingElement, annotationName, member, constantExpression)) != null) {
                                converted.add(value);
                            }
                        }
                    }
                    if (exp instanceof ConstantExpression) {
                        ConstantExpression constantExpression = (ConstantExpression)exp;
                        Object value = this.readConstantExpression(originatingElement, annotationName, member, constantExpression);
                        if (value == null) continue;
                        if (value instanceof EvaluatedExpressionReference) {
                            EvaluatedExpressionReference expressionReference = (EvaluatedExpressionReference)value;
                            value = expressionReference.annotationValue();
                        }
                        converted.add(value);
                        continue;
                    }
                    if (!(exp instanceof ClassExpression)) continue;
                    ClassExpression classExpression = (ClassExpression)exp;
                    Object typeName = classExpression.getType().isArray() ? "[L" + classExpression.getType().getComponentType().getName() + ";" : classExpression.getType().getName();
                    converted.add(new AnnotationClassValue((String)typeName));
                }
                Object array = GroovyAnnotationMetadataBuilder.toArray(member, converted);
                if (this.isEvaluatedExpression(array)) {
                    return this.buildEvaluatedExpressionReference(originatingElement, annotationName, memberName, array);
                }
                return array;
            }
            if (annotationValue instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)annotationValue;
                Variable variable = variableExpression.getAccessedVariable();
                if (variable != null && variable.hasInitialExpression()) {
                    return this.readAnnotationValue(originatingElement, member, annotationName, memberName, (Object)variable.getInitialExpression());
                }
            } else if (annotationValue != null && ClassUtils.isJavaLangType(annotationValue.getClass())) {
                return annotationValue;
            }
        }
        return null;
    }

    private static Object toArray(AnnotatedNode member, Collection<?> collection) {
        if (!(member instanceof MethodNode)) {
            throw new IllegalStateException("Expected instance of MethodNode got: " + member);
        }
        MethodNode methodNode = (MethodNode)member;
        ClassNode returnType = methodNode.getReturnType();
        if (!returnType.isArray()) {
            throw new IllegalStateException("Expected a method returning an array got: " + member);
        }
        Class arrayType = Object.class;
        ClassNode component = returnType.getComponentType();
        if (component != null) {
            if (component.isEnum()) {
                arrayType = String.class;
                collection = collection.stream().map(val -> {
                    if (val instanceof Enum) {
                        Enum anEnum = (Enum)val;
                        return anEnum.name();
                    }
                    return val;
                }).toList();
            } else if (component.isResolved()) {
                arrayType = component.getTypeClass();
                if (Annotation.class.isAssignableFrom(arrayType)) {
                    arrayType = AnnotationValue.class;
                } else if (Class.class.isAssignableFrom(arrayType)) {
                    arrayType = AnnotationClassValue.class;
                } else if (EvaluatedExpressionReference.class.isAssignableFrom(arrayType)) {
                    arrayType = EvaluatedExpressionReference.class;
                }
            }
        }
        if (collection.isEmpty()) {
            return Array.newInstance(arrayType, 0);
        }
        if (collection.stream().allMatch(val -> val instanceof AnnotationClassValue)) {
            arrayType = AnnotationClassValue.class;
        } else if (collection.stream().allMatch(val -> val instanceof AnnotationValue)) {
            arrayType = AnnotationValue.class;
        } else if (collection.stream().anyMatch(val -> val instanceof EvaluatedExpressionReference)) {
            arrayType = Object.class;
        }
        if (arrayType.isPrimitive()) {
            Class wrapperType = ReflectionUtils.getWrapperType(arrayType);
            Class<?> primitiveArrayType = Array.newInstance(arrayType, 0).getClass();
            Object[] emptyWrapperArray = (Object[])Array.newInstance(wrapperType, 0);
            Object[] wrapperArray = collection.toArray(emptyWrapperArray);
            return ConversionService.SHARED.convertRequired((Object)wrapperArray, primitiveArrayType);
        }
        return ConversionService.SHARED.convert(collection, Array.newInstance(arrayType, 0).getClass()).orElse(null);
    }

    private Object readConstantExpression(AnnotatedNode originatingElement, String annotationName, AnnotatedNode member, ConstantExpression constantExpression) {
        if (constantExpression instanceof AnnotationConstantExpression) {
            AnnotationConstantExpression ann = (AnnotationConstantExpression)constantExpression;
            AnnotationNode value = (AnnotationNode)ann.getValue();
            return this.readNestedAnnotationValue(originatingElement, value);
        }
        Object value = constantExpression.getValue();
        if (value == null) {
            return null;
        }
        if (this.isEvaluatedExpression(value)) {
            String memberName = this.getAnnotationMemberName(member);
            return this.buildEvaluatedExpressionReference(originatingElement, annotationName, memberName, value);
        }
        if (value instanceof Collection) {
            List<Object> collection = (List<Object>)value;
            Object array = GroovyAnnotationMetadataBuilder.toArray(member, collection = collection.stream().map(this::convertConstantValue).toList());
            if (this.isEvaluatedExpression(array)) {
                return this.buildEvaluatedExpressionReference(originatingElement, annotationName, this.getAnnotationMemberName(member), array);
            }
            return array;
        }
        return this.convertConstantValue(value);
    }

    private Object convertConstantValue(Object value) {
        if (value instanceof ClassNode) {
            ClassNode classNode = (ClassNode)value;
            return new AnnotationClassValue(classNode.getName());
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.getName().equals("org.codehaus.groovy.ast.decompiled.EnumConstantWrapper")) {
            return ReflectionUtils.getFieldValue(valueClass, (String)"constant", (Object)value).orElse(null);
        }
        if (valueClass.getName().equals("org.codehaus.groovy.ast.decompiled.TypeWrapper")) {
            String desc = ReflectionUtils.getFieldValue(valueClass, (String)"desc", (Object)value).orElse(null);
            if (desc == null) {
                return null;
            }
            StringBuilder arraySuffix = new StringBuilder();
            while (desc.startsWith("[")) {
                desc = desc.substring(1);
                arraySuffix.append("[]");
            }
            String className = desc.substring(1, desc.length() - 1).replace("/", ".") + arraySuffix;
            return new AnnotationClassValue(className);
        }
        if (value instanceof CharSequence) {
            value = value.toString();
        }
        return value;
    }

    protected Map<? extends AnnotatedNode, ?> readAnnotationRawValues(AnnotationNode annotationMirror) {
        Map members = annotationMirror.getMembers();
        LinkedHashMap values = new LinkedHashMap();
        ClassNode annotationClassNode = annotationMirror.getClassNode();
        members.forEach((key, value) -> values.put((MethodNode)annotationClassNode.getMethods(key).get(0), value));
        return values;
    }

    protected <K extends Annotation> Optional<AnnotationValue<K>> getAnnotationValues(AnnotatedNode originatingElement, AnnotatedNode member, Class<K> annotationType) {
        ClassNode annotationTypeNode;
        List anns;
        if (member != null && CollectionUtils.isNotEmpty((Collection)(anns = member.getAnnotations(annotationTypeNode = ClassHelper.make(annotationType))))) {
            AnnotationNode ann = (AnnotationNode)anns.get(0);
            LinkedHashMap<CharSequence, Object> converted = new LinkedHashMap<CharSequence, Object>();
            ClassNode annotationNode = ann.getClassNode();
            for (Map.Entry entry : ann.getMembers().entrySet()) {
                String key = (String)entry.getKey();
                Expression value = (Expression)entry.getValue();
                MethodNode annotationMember = annotationNode.getMethod(key, new Parameter[0]);
                this.readAnnotationRawValues(originatingElement, annotationType.getName(), (AnnotatedNode)annotationMember, key, (Object)value, converted);
            }
            Map annotationDefaults = this.getCachedAnnotationDefaults(annotationType.getName(), annotationTypeNode);
            if (!annotationDefaults.isEmpty()) {
                Iterator i = converted.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry next = i.next();
                    Object v = annotationDefaults.get(next.getKey());
                    if (v == null || !v.equals(next.getValue())) continue;
                    i.remove();
                }
            }
            return Optional.of(AnnotationValue.builder(annotationType).members(converted).build());
        }
        return Optional.empty();
    }

    protected String getAnnotationMemberName(AnnotatedNode member) {
        return ((MethodNode)member).getName();
    }

    private void populateTypeHierarchy(ClassNode classNode, List<AnnotatedNode> hierarchy) {
        while (classNode != null) {
            ClassNode[] interfaces;
            for (ClassNode anInterface : interfaces = classNode.getInterfaces()) {
                if (hierarchy.contains(anInterface) || anInterface.getName().equals(GroovyObject.class.getName())) continue;
                hierarchy.add((AnnotatedNode)anInterface);
                this.populateTypeHierarchy(anInterface, hierarchy);
            }
            if ((classNode = classNode.getSuperClass()) == null || classNode.equals((Object)ClassHelper.OBJECT_TYPE) || classNode.getName().equals(Script.class.getName()) || classNode.getName().equals(GroovyObjectSupport.class.getName())) break;
            hierarchy.add((AnnotatedNode)classNode);
        }
    }

    private List<MethodNode> findOverriddenMethods(MethodNode methodNode) {
        ArrayList<MethodNode> overriddenMethods = new ArrayList<MethodNode>();
        ClassNode classNode = methodNode.getDeclaringClass();
        String methodName = methodNode.getName();
        Map<String, Map<String, ClassNode>> genericsInfo = AstGenericUtils.buildAllGenericElementInfo(classNode, this.createVisitorContext());
        block0: while (classNode != null && !classNode.getName().equals(Object.class.getName())) {
            for (ClassNode i : classNode.getAllInterfaces()) {
                for (MethodNode parent : i.getMethods(methodName)) {
                    if (!this.methodOverrides(methodNode, parent, genericsInfo.get(i.getName()))) continue;
                    overriddenMethods.add(parent);
                }
            }
            if ((classNode = classNode.getSuperClass()) == null || classNode.getName().equals(Object.class.getName())) continue;
            for (MethodNode parent : classNode.getMethods(methodName)) {
                if (!this.methodOverrides(methodNode, parent, genericsInfo.get(classNode.getName()))) continue;
                if (!parent.isPrivate()) {
                    overriddenMethods.add(parent);
                }
                if (!parent.getAnnotations(ANN_OVERRIDE).isEmpty()) continue;
                break block0;
            }
        }
        return overriddenMethods;
    }

    private boolean methodOverrides(MethodNode child, MethodNode parent, Map<String, ClassNode> genericsSpec) {
        Parameter[] parentParameters;
        Parameter[] childParameters = child.getParameters();
        if (childParameters.length == (parentParameters = parent.getParameters()).length) {
            int n = childParameters.length;
            for (int i = 0; i < n; ++i) {
                ClassNode bType;
                ClassNode aType = childParameters[i].getType();
                if (aType.equals((Object)(bType = parentParameters[i].getType()))) continue;
                if (bType.isGenericsPlaceHolder() && genericsSpec != null) {
                    ClassNode classNode = genericsSpec.get(bType.getUnresolvedName());
                    if (aType.equals((Object)classNode)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

