/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyParameterElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.annotation.AbstractAnnotationElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.MethodElementAnnotationsHelper;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;

@Internal
public class GroovyMethodElement
extends AbstractGroovyElement
implements MethodElement {
    protected ParameterElement[] parameters;
    private final MethodNode methodNode;
    private final GroovyClassElement owningType;
    private ClassElement declaringType;
    private Map<String, ClassElement> declaredTypeArguments;
    private Map<String, ClassElement> typeArguments;
    @Nullable
    private ClassElement returnType;
    @Nullable
    private ClassElement genericReturnType;
    private final MethodElementAnnotationsHelper helper;

    GroovyMethodElement(GroovyClassElement owningType, GroovyVisitorContext visitorContext, GroovyNativeElement nativeElement, MethodNode methodNode, ElementAnnotationMetadataFactory annotationMetadata) {
        super(visitorContext, nativeElement, annotationMetadata);
        this.methodNode = methodNode;
        this.owningType = owningType;
        this.helper = new MethodElementAnnotationsHelper((AbstractAnnotationElement)this, annotationMetadata);
    }

    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        return this.helper.getMethodAnnotationMetadata(this.presetAnnotationMetadata);
    }

    public ElementAnnotationMetadata getMethodAnnotationMetadata() {
        return this.helper.getMethodAnnotationMetadata(this.presetAnnotationMetadata);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.helper.getAnnotationMetadata(this.presetAnnotationMetadata);
    }

    @Override
    protected AbstractGroovyElement copyConstructor() {
        return new GroovyMethodElement(this.owningType, this.visitorContext, this.getNativeType(), this.methodNode, this.elementAnnotationMetadataFactory);
    }

    @Override
    protected void copyValues(AbstractGroovyElement element) {
        ((GroovyMethodElement)element).parameters = this.parameters;
    }

    public MethodElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (MethodElement)super.withAnnotationMetadata(annotationMetadata);
    }

    public MethodElement withParameters(ParameterElement ... newParameters) {
        GroovyMethodElement methodElement = (GroovyMethodElement)this.copy();
        methodElement.parameters = newParameters;
        return methodElement;
    }

    public MethodElement withNewOwningType(ClassElement owningType) {
        GroovyMethodElement groovyMethodElement = new GroovyMethodElement((GroovyClassElement)owningType, this.visitorContext, this.getNativeType(), this.methodNode, this.elementAnnotationMetadataFactory);
        this.copyValues(groovyMethodElement);
        return groovyMethodElement;
    }

    public ClassElement[] getThrownTypes() {
        Object[] exceptions = this.methodNode.getExceptions();
        if (ArrayUtils.isNotEmpty((Object[])exceptions)) {
            return (ClassElement[])Arrays.stream(exceptions).map(cn -> this.newClassElement((ClassNode)cn, this.getDeclaringType().getTypeArguments())).toArray(ClassElement[]::new);
        }
        return ClassElement.ZERO_CLASS_ELEMENTS;
    }

    public Set<ElementModifier> getModifiers() {
        return this.resolveModifiers(this.methodNode);
    }

    public String toString() {
        ClassNode declaringClass = this.methodNode.getDeclaringClass();
        if (declaringClass == null) {
            declaringClass = this.owningType.classNode;
        }
        return declaringClass.getName() + "." + this.methodNode.getName() + "(..)";
    }

    public String getName() {
        return this.methodNode.getName();
    }

    public boolean isAbstract() {
        return this.methodNode.isAbstract();
    }

    public boolean isStatic() {
        return this.methodNode.isStatic();
    }

    public boolean isPublic() {
        return this.methodNode.isPublic() || this.methodNode.isSyntheticPublic() && !this.isPackagePrivate();
    }

    public boolean isPrivate() {
        return this.methodNode.isPrivate();
    }

    @Override
    public boolean isPackagePrivate() {
        return this.methodNode.isPackageScope();
    }

    public boolean isFinal() {
        return this.methodNode.isFinal();
    }

    public boolean isProtected() {
        return this.methodNode.isProtected();
    }

    public boolean isDefault() {
        return !this.isAbstract() && this.getDeclaringType().isInterface();
    }

    public Map<String, ClassElement> getDeclaredTypeArguments() {
        if (this.declaredTypeArguments == null) {
            this.declaredTypeArguments = this.resolveMethodTypeArguments(this.getNativeType(), this.methodNode, this.getDeclaringType().getTypeArguments());
        }
        return this.declaredTypeArguments;
    }

    public Map<String, ClassElement> getTypeArguments() {
        if (this.typeArguments == null) {
            this.typeArguments = super.getTypeArguments();
        }
        return this.typeArguments;
    }

    @NonNull
    public ClassElement getGenericReturnType() {
        if (this.genericReturnType == null) {
            this.genericReturnType = this.newClassElement(this.methodNode.getReturnType(), this.getTypeArguments());
        }
        return this.genericReturnType;
    }

    @NonNull
    public ClassElement getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.newClassElement(this.methodNode.getReturnType());
        }
        return this.returnType;
    }

    public ParameterElement[] getParameters() {
        Parameter[] parameters = this.methodNode.getParameters();
        if (this.parameters == null) {
            this.parameters = (ParameterElement[])Arrays.stream(parameters).map(this::newParameter).toArray(ParameterElement[]::new);
        }
        return this.parameters;
    }

    private GroovyParameterElement newParameter(Parameter parameter) {
        return new GroovyParameterElement(this, this.visitorContext, new GroovyNativeElement.Parameter(parameter, this.methodNode), parameter, this.elementAnnotationMetadataFactory);
    }

    public ClassElement getDeclaringType() {
        if (this.declaringType == null) {
            ClassNode declaringClassNode = this.methodNode.getDeclaringClass();
            if (declaringClassNode == null) {
                return this.owningType;
            }
            Map typeArguments = this.getOwningType().getTypeArguments(declaringClassNode.getName());
            this.declaringType = this.newClassElement(declaringClassNode, typeArguments);
        }
        return this.declaringType;
    }

    public GroovyClassElement getOwningType() {
        return this.owningType;
    }

    public List<? extends GenericPlaceholderElement> getDeclaredTypeVariables() {
        GenericsType[] genericsTypes = this.methodNode.getGenericsTypes();
        if (genericsTypes == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(genericsTypes).map(gt -> (GenericPlaceholderElement)this.newClassElement((GenericsType)gt)).toList();
    }
}

