/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;

@Internal
public class GroovyFieldElement
extends AbstractGroovyElement
implements FieldElement {
    private final GroovyClassElement owningType;
    private final FieldNode fieldNode;
    @Nullable
    private GroovyClassElement declaringType;
    @Nullable
    private ClassElement type;
    @Nullable
    private ClassElement genericType;

    GroovyFieldElement(GroovyVisitorContext visitorContext, GroovyClassElement owningType, FieldNode fieldNode, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        super(visitorContext, new GroovyNativeElement.Field(fieldNode, owningType.getNativeType()), annotationMetadataFactory);
        this.owningType = owningType;
        this.fieldNode = fieldNode;
    }

    @Override
    protected AbstractGroovyElement copyConstructor() {
        return new GroovyFieldElement(this.visitorContext, this.owningType, this.fieldNode, this.elementAnnotationMetadataFactory);
    }

    public FieldElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (FieldElement)super.withAnnotationMetadata(annotationMetadata);
    }

    public GroovyClassElement getOwningType() {
        return this.owningType;
    }

    public Set<ElementModifier> getModifiers() {
        return super.resolveModifiers(this.fieldNode);
    }

    public String toString() {
        return this.fieldNode.getName();
    }

    public ClassElement getGenericField() {
        return this.newClassElement(this.fieldNode.getType(), this.getDeclaringType().getTypeArguments());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    public String getName() {
        return this.fieldNode.getName();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.fieldNode.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.fieldNode.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.fieldNode.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.fieldNode.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.fieldNode.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.fieldNode.getModifiers());
    }

    @Override
    public boolean isPackagePrivate() {
        return !Modifier.isPublic(this.fieldNode.getModifiers()) && !Modifier.isProtected(this.fieldNode.getModifiers()) && !Modifier.isPrivate(this.fieldNode.getModifiers());
    }

    @NonNull
    public ClassElement getType() {
        if (this.type == null) {
            this.type = this.newClassElement(this.fieldNode.getType());
        }
        return this.type;
    }

    public ClassElement getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.newClassElement(this.fieldNode.getType(), this.getDeclaringType().getTypeArguments());
        }
        return this.genericType;
    }

    public GroovyClassElement getDeclaringType() {
        if (this.declaringType == null) {
            ClassNode declaringClass = this.fieldNode.getDeclaringClass();
            if (declaringClass == null) {
                throw new IllegalStateException("Declaring class could not be established");
            }
            if (this.owningType.getNativeType().annotatedNode().equals(declaringClass)) {
                this.declaringType = this.owningType;
            } else {
                Map typeArguments = this.getOwningType().getTypeArguments(declaringClass.getName());
                this.declaringType = (GroovyClassElement)this.newClassElement(declaringClass, typeArguments);
            }
        }
        return this.declaringType;
    }
}

