/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.GenericElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.GenericPlaceholderElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Internal
final class GroovyGenericPlaceholderElement
extends GroovyClassElement
implements GenericPlaceholderElement {
    private final GroovyNativeElement placeholderNativeElement;
    private final Element declaringElement;
    private final String variableName;
    private final GroovyClassElement resolved;
    private final List<GroovyClassElement> bounds;
    private final boolean rawType;
    private final ElementAnnotationMetadata typeAnnotationMetadata;
    @Nullable
    private ElementAnnotationMetadata genericTypeAnnotationMetadata;

    GroovyGenericPlaceholderElement(GroovyVisitorContext visitorContext, Element declaringElement, GroovyNativeElement placeholderNativeElement, @Nullable GroovyClassElement resolved, List<GroovyClassElement> bounds, int arrayDimensions, boolean rawType, String variableName) {
        this(visitorContext, declaringElement, placeholderNativeElement, variableName, resolved, bounds, GroovyGenericPlaceholderElement.selectClassElementRepresentingThisPlaceholder(resolved, bounds), arrayDimensions, rawType);
    }

    GroovyGenericPlaceholderElement(GroovyVisitorContext visitorContext, Element declaringElement, GroovyNativeElement placeholderNativeElement, String variableName, @Nullable GroovyClassElement resolved, List<GroovyClassElement> bounds, GroovyClassElement classElementRepresentingThisPlaceholder, int arrayDimensions, boolean rawType) {
        super(visitorContext, classElementRepresentingThisPlaceholder.getNativeType(), classElementRepresentingThisPlaceholder.getElementAnnotationMetadataFactory(), classElementRepresentingThisPlaceholder.resolvedTypeArguments, arrayDimensions);
        this.declaringElement = declaringElement;
        this.placeholderNativeElement = placeholderNativeElement;
        this.variableName = variableName;
        this.resolved = resolved;
        this.bounds = bounds;
        this.rawType = rawType;
        this.typeAnnotationMetadata = new GenericPlaceholderElementAnnotationMetadata((GenericPlaceholderElement)this, (ClassElement)classElementRepresentingThisPlaceholder);
    }

    private static GroovyClassElement selectClassElementRepresentingThisPlaceholder(@Nullable GroovyClassElement resolved, @NonNull List<GroovyClassElement> bounds) {
        if (resolved != null) {
            return resolved;
        }
        return (GroovyClassElement)WildcardElement.findUpperType(bounds, bounds);
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }

    @Override
    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        return this.getGenericTypeAnnotationMetadata();
    }

    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getGenericTypeAnnotationMetadata() {
        if (this.genericTypeAnnotationMetadata == null) {
            this.genericTypeAnnotationMetadata = this.elementAnnotationMetadataFactory.buildGenericTypeAnnotations((GenericElement)this);
        }
        return this.genericTypeAnnotationMetadata;
    }

    @Override
    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getTypeAnnotationMetadata() {
        return this.typeAnnotationMetadata;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return new AnnotationMetadataHierarchy(true, new AnnotationMetadata[]{super.getAnnotationMetadata(), this.getGenericTypeAnnotationMetadata()});
    }

    public GroovyNativeElement getGenericNativeType() {
        return this.placeholderNativeElement;
    }

    public boolean isRawType() {
        return this.rawType;
    }

    @Override
    protected GroovyClassElement copyConstructor() {
        return new GroovyGenericPlaceholderElement(this.visitorContext, this.declaringElement, this.placeholderNativeElement, this.variableName, this.resolved, this.bounds, GroovyGenericPlaceholderElement.selectClassElementRepresentingThisPlaceholder(this.resolved, this.bounds), this.getArrayDimensions(), this.rawType);
    }

    @NonNull
    public List<GroovyClassElement> getBounds() {
        return this.bounds;
    }

    @NonNull
    public String getVariableName() {
        return this.variableName;
    }

    public Optional<Element> getDeclaringElement() {
        return Optional.ofNullable(this.declaringElement);
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new GroovyGenericPlaceholderElement(this.visitorContext, this.declaringElement, this.placeholderNativeElement, this.variableName, this.resolved, this.bounds, GroovyGenericPlaceholderElement.selectClassElementRepresentingThisPlaceholder(this.resolved, this.bounds), arrayDimensions, this.rawType);
    }

    public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        Objects.requireNonNull(fold, "Function argument cannot be null");
        return fold.apply((ClassElement)this);
    }

    public Optional<ClassElement> getResolved() {
        return Optional.ofNullable(this.resolved);
    }

    @Nullable
    public GroovyClassElement getResolvedInternal() {
        return this.resolved;
    }
}

