/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.annotation;

import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.AbstractElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;

public final class GroovyElementAnnotationMetadataFactory
extends AbstractElementAnnotationMetadataFactory<AnnotatedNode, AnnotationNode> {
    public GroovyElementAnnotationMetadataFactory(boolean isReadOnly, GroovyAnnotationMetadataBuilder metadataBuilder) {
        super(isReadOnly, (AbstractAnnotationMetadataBuilder)metadataBuilder);
    }

    public ElementAnnotationMetadataFactory readOnly() {
        return new GroovyElementAnnotationMetadataFactory(true, (GroovyAnnotationMetadataBuilder)this.metadataBuilder);
    }

    protected AnnotatedNode getNativeElement(Element element) {
        return ((AbstractGroovyElement)element).getNativeType().annotatedNode();
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForClass(ClassElement classElement) {
        GroovyNativeElement clazz = (GroovyNativeElement)classElement.getNativeType();
        return this.metadataBuilder.lookupOrBuild((Object)clazz, (Object)this.getTypeAnnotationsOnly((ClassNode)clazz.annotatedNode()));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForGenericPlaceholder(GenericPlaceholderElement placeholderElement) {
        GroovyNativeElement.Placeholder placeholder = (GroovyNativeElement.Placeholder)placeholderElement.getGenericNativeType();
        return this.metadataBuilder.lookupOrBuild((Object)placeholder, (Object)this.getTypeAnnotationsOnly(placeholder.annotatedNode()));
    }

    protected AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata lookupTypeAnnotationsForWildcard(WildcardElement wildcardElement) {
        GroovyNativeElement wildcard = (GroovyNativeElement)wildcardElement.getGenericNativeType();
        return this.metadataBuilder.lookupOrBuild((Object)wildcard, (Object)this.getTypeAnnotationsOnly((ClassNode)wildcard.annotatedNode()));
    }

    private AnnotatedNode getTypeAnnotationsOnly(ClassNode classNode) {
        AnnotatedNode annotatedNode = new AnnotatedNode();
        List typeAnnotations = classNode.getTypeAnnotations();
        if (CollectionUtils.isNotEmpty((Collection)typeAnnotations)) {
            annotatedNode.addAnnotations(typeAnnotations);
        }
        return annotatedNode;
    }
}

