/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.utils;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.visitor.VisitorContext;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class AstGenericUtils
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AstGenericUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Map<String, ClassNode> createGenericsSpec(ClassNode classNode) {
        Object[] existingGenericTypes = classNode.getGenericsTypes();
        boolean hasGenericTypes = ArrayUtils.isNotEmpty((Object[])existingGenericTypes);
        if (!classNode.isPrimaryClassNode()) {
            if (hasGenericTypes) {
                GenericsType[] redirectTypes = classNode.redirect().getGenericsTypes();
                LinkedHashMap<String, ClassNode> ret = new LinkedHashMap<String, ClassNode>();
                AstGenericUtils.populateGenericsSpec(redirectTypes, (GenericsType[])existingGenericTypes, ret);
                return ret;
            }
            classNode = classNode.redirect();
            LinkedHashMap<String, ClassNode> ret = new LinkedHashMap<String, ClassNode>();
            GenericsType[] redirectTypes = classNode.getGenericsTypes();
            if (redirectTypes != null) {
                GenericsType gt2 = null;
                GenericsType[] genericsTypeArray = redirectTypes;
                if (redirectTypes != null) {
                    for (GenericsType gt2 : genericsTypeArray) {
                        if (gt2.isPlaceholder()) {
                            ClassNode[] classNodeArray = gt2.getUpperBounds();
                            if ((classNodeArray == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, classNodeArray)) != false) {
                                ret.put(gt2.getName(), (ClassNode)BytecodeInterface8.objectArrayGet((Object[])gt2.getUpperBounds(), (int)0));
                                continue;
                            }
                            ClassNode classNode2 = gt2.getLowerBound();
                            if ((classNode2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, classNode2)) != false) {
                                ret.put(gt2.getName(), gt2.getLowerBound());
                                continue;
                            }
                            ret.put(gt2.getName(), ClassHelper.OBJECT_TYPE);
                            continue;
                        }
                        ret.put(gt2.getName(), gt2.getType());
                    }
                }
            }
            return ret;
        }
        if (!hasGenericTypes) {
            return Collections.emptyMap();
        }
        return AstGenericUtils.createGenericsSpec(classNode, Collections.emptyMap());
    }

    public static Map<String, ClassNode> createGenericsSpec(ClassNode current, Map<String, ClassNode> oldSpec) {
        LinkedHashMap<String, ClassNode> ret = new LinkedHashMap<String, ClassNode>(oldSpec);
        Object[] sgts = current.getGenericsTypes();
        if (sgts != null) {
            Object[] spec = new ClassNode[sgts.length];
            int i = 0;
            while (i < spec.length) {
                ClassNode classNode = GenericsUtils.correctToGenericsSpec(ret, (GenericsType)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])sgts, (int)i)));
                BytecodeInterface8.objectArraySet((Object[])spec, (int)i, (Object)classNode);
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
            Object[] newGts = current.redirect().getGenericsTypes();
            if (newGts == null) {
                return ret;
            }
            ret.clear();
            int i2 = 0;
            while (i2 < spec.length) {
                ret.put(((GenericsType)BytecodeInterface8.objectArrayGet((Object[])newGts, (int)i2)).getName(), (ClassNode)BytecodeInterface8.objectArrayGet((Object[])spec, (int)i2));
                int n = i2;
                int cfr_ignored_1 = n + 1;
            }
        }
        return ret;
    }

    public static Map<String, ClassNode> createGenericsSpec(MethodNode methodNode, Map<String, ClassNode> genericsSpec) {
        GenericsType[] redirectTypes = methodNode.getGenericsTypes();
        if (redirectTypes != null) {
            GenericsType gt2 = null;
            GenericsType[] genericsTypeArray = redirectTypes;
            if (redirectTypes != null) {
                for (GenericsType gt2 : genericsTypeArray) {
                    if (gt2.isPlaceholder()) {
                        ClassNode[] classNodeArray = gt2.getUpperBounds();
                        if ((classNodeArray == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, classNodeArray)) != false) {
                            genericsSpec.put(gt2.getName(), (ClassNode)BytecodeInterface8.objectArrayGet((Object[])gt2.getUpperBounds(), (int)0));
                            continue;
                        }
                        ClassNode classNode = gt2.getLowerBound();
                        if ((classNode == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, classNode)) != false) {
                            genericsSpec.put(gt2.getName(), gt2.getLowerBound());
                            continue;
                        }
                        genericsSpec.put(gt2.getName(), ClassHelper.OBJECT_TYPE);
                        continue;
                    }
                    genericsSpec.put(gt2.getName(), gt2.getType());
                }
            }
        }
        return genericsSpec;
    }

    private static void populateGenericsSpec(GenericsType[] redirectTypes, GenericsType[] genericTypes, HashMap<String, ClassNode> boundTypes) {
        if (DefaultTypeTransformation.booleanUnbox((Object)redirectTypes) && redirectTypes.length == genericTypes.length) {
            int i = 0;
            GenericsType redirect = null;
            GenericsType[] genericsTypeArray = redirectTypes;
            if (redirectTypes != null) {
                int n = genericsTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    redirect = genericsTypeArray[n2];
                    ++n2;
                    CallSite specifiedType = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])genericTypes, (int)i));
                    ClassNode specifiedClassNode = specifiedType.getType();
                    if (redirect.isPlaceholder() && DefaultTypeTransformation.booleanUnbox((Object)specifiedClassNode)) {
                        if (specifiedType.isPlaceholder()) {
                            ClassNode[] classNodeArray = specifiedType.getUpperBounds();
                            if ((classNodeArray == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, classNodeArray)) != false) {
                                boundTypes.put(redirect.getName(), (ClassNode)BytecodeInterface8.objectArrayGet((Object[])specifiedType.getUpperBounds(), (int)0));
                            } else {
                                ClassNode classNode = specifiedType.getLowerBound();
                                if ((classNode == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, classNode)) != false) {
                                    boundTypes.put(redirect.getName(), specifiedType.getLowerBound());
                                } else {
                                    boundTypes.put(redirect.getName(), specifiedClassNode.redirect().getPlainNodeReference());
                                }
                            }
                        } else {
                            GenericsType[] specifiedGenerics = specifiedType.getType().getGenericsTypes();
                            if ((specifiedGenerics == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, specifiedGenerics)) != false) {
                                boundTypes.put(redirect.getName(), specifiedType.getType());
                            } else {
                                boundTypes.put(redirect.getName(), specifiedClassNode.redirect());
                            }
                        }
                    }
                    int n3 = i;
                    int cfr_ignored_0 = n3 + 1;
                }
            }
        }
    }

    public static ClassNode resolveInterfaceGenericType(ClassNode classNode, Class<?> itfe) {
        Reference itfe2 = new Reference(itfe);
        public final class _resolveInterfaceGenericType_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference itfe;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveInterfaceGenericType_closure1(Object _outerInstance, Object _thisObject, Reference itfe) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.itfe = reference = itfe;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((ClassNode)it).getName(), (Object)((Class)((Object)IndyInterface.bootstrap("cast", "()", 0, this.itfe.get()))).getName());
            }

            @Generated
            public Class getItfe() {
                return IndyInterface.bootstrap("cast", "()", 0, this.itfe.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveInterfaceGenericType_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite foundInterface = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.find((Collection)classNode.getAllInterfaces(), (Closure)new _resolveInterfaceGenericType_closure1(AstGenericUtils.class, AstGenericUtils.class, itfe2)));
        if (foundInterface != null) {
            GenericsType[] genericsTypeArray = foundInterface.getGenericsTypes();
            if ((genericsTypeArray == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, genericsTypeArray)) != false) {
                Object object = BytecodeInterface8.objectArrayGet((Object[])foundInterface.getGenericsTypes(), (int)0);
                return object != null ? ((GenericsType)object).getType() : null;
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassNode resolveTypeReference(ClassNode classNode, Map<String, ClassNode> boundTypes) {
        block21: {
            if (classNode == null) {
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            if (classNode.isGenericsPlaceHolder()) {
                GenericsType[] genericsTypeArray = classNode.getGenericsTypes();
                if ((genericsTypeArray == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, genericsTypeArray)) != false) {
                    String typeVar = ((GenericsType)BytecodeInterface8.objectArrayGet((Object[])classNode.getGenericsTypes(), (int)0)).getName();
                    if (boundTypes.containsKey(typeVar)) {
                        CallSite resolved = IndyInterface.bootstrap("cast", "()", 0, boundTypes.get(typeVar));
                        if (!resolved.isGenericsPlaceHolder()) return resolved;
                        return AstGenericUtils.resolveTypeReference((ClassNode)resolved, boundTypes);
                    }
                    break block21;
                } else {
                    if (classNode.isResolved() || ClassHelper.isPrimitiveType((ClassNode)classNode)) {
                        try {
                            return classNode;
                        }
                        catch (ClassNotFoundException ignored) {
                            ClassNode classNode2 = classNode;
                            return classNode2;
                        }
                    }
                    ClassNode redirectNode = classNode.redirect();
                    String redirectName = redirectNode.getName();
                    if (!ScriptBytecodeAdapter.compareNotEqual((Object)redirectName, (Object)classNode.getUnresolvedName())) return ClassHelper.OBJECT_TYPE;
                    return redirectNode;
                }
            }
            if (classNode.isArray() && classNode.getComponentType().isGenericsPlaceHolder()) {
                Object[] componentGenericTypes = classNode.getComponentType().getGenericsTypes();
                if ((componentGenericTypes == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, componentGenericTypes)) != false) {
                    String typeVar = ((GenericsType)BytecodeInterface8.objectArrayGet((Object[])componentGenericTypes, (int)0)).getName();
                    if (boundTypes.containsKey(typeVar)) {
                        return boundTypes.get(typeVar).makeArray();
                    }
                }
            }
        }
        try {
            return classNode;
        }
        catch (ClassNotFoundException ignored) {
            ClassNode classNode3 = classNode;
            return classNode3;
        }
    }

    public static Map<String, Map<String, ClassNode>> buildAllGenericElementInfo(ClassNode classNode, VisitorContext visitorContext) {
        LinkedHashMap<String, Map<String, Object>> typeArguments = new LinkedHashMap<String, Map<String, Object>>();
        AstGenericUtils.populateTypeArguments(classNode, typeArguments);
        LinkedHashMap<String, Map<String, ClassNode>> elements = new LinkedHashMap<String, Map<String, ClassNode>>(typeArguments.size());
        Set<Map.Entry<String, Map<String, Object>>> set = typeArguments.entrySet();
        CallSite entry = null;
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = set != null ? set.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                entry = IndyInterface.bootstrap("cast", "()", 0, iterator.next());
                CallSite value = IndyInterface.bootstrap("cast", "()", 0, entry.getValue());
                LinkedHashMap submap = new LinkedHashMap(value.size());
                CallSite genericEntry = null;
                Set set2 = value.entrySet();
                Iterator iterator2 = set2 != null ? set2.iterator() : null;
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        genericEntry = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                        Object v = genericEntry.getValue();
                        CallSite te = null;
                        if (v instanceof ClassNode) {
                            te = IndyInterface.bootstrap("cast", "()", 0, v);
                        } else if (v instanceof Class) {
                            te = ClassHelper.makeCached((Class)((Object)IndyInterface.bootstrap("cast", "()", 0, v)));
                        } else if (v instanceof String) {
                            String className = ((String)v).toString();
                            te = AstGenericUtils.findGenericClassInNode(classNode, className);
                            if (te == null) {
                                CallSite ce = IndyInterface.bootstrap("cast", "()", 0, visitorContext.getClassElement(className).orElse(null));
                                CallSite callSite = ce;
                                Object nativeType = callSite != null ? callSite.getNativeType() : null;
                                if (nativeType instanceof ClassNode) {
                                    te = IndyInterface.bootstrap("cast", "()", 0, nativeType);
                                }
                            }
                        }
                        if (!(te != null)) continue;
                        submap.put(genericEntry.getKey(), te);
                    }
                }
                elements.put((String)entry.getKey(), submap);
            }
        }
        return elements;
    }

    public static ClassNode findGenericClassInNode(ClassNode classNode, String className) {
        Object[] genericsTypes = classNode.getGenericsTypes();
        if (ArrayUtils.isNotEmpty((Object[])genericsTypes)) {
            Object gt2 = null;
            Object[] objectArray = genericsTypes;
            if (genericsTypes != null) {
                for (Object gt2 : objectArray) {
                    ClassNode classNode2 = gt2.getType();
                    if (!ScriptBytecodeAdapter.compareEqual((Object)(classNode2 != null ? classNode2.getName() : null), (Object)className)) continue;
                    return gt2.getType();
                }
            }
        }
        ClassNode[] interfaces = classNode.getInterfaces();
        ClassNode i2 = null;
        ClassNode[] classNodeArray = interfaces;
        if (interfaces != null) {
            for (ClassNode i2 : classNodeArray) {
                if (ScriptBytecodeAdapter.compareEqual((Object)i2.getName(), (Object)classNode.getName())) continue;
                ClassNode node = AstGenericUtils.findGenericClassInNode(i2, className);
                if (!(node != null)) continue;
                return node;
            }
        }
        if (!classNode.isInterface()) {
            ClassNode superClass = classNode.getSuperClass();
            while (superClass != null && ScriptBytecodeAdapter.compareNotEqual((Object)superClass.getName(), (Object)ClassHelper.OBJECT)) {
                ClassNode node = AstGenericUtils.findGenericClassInNode(superClass, className);
                if (node != null) {
                    return node;
                }
                superClass.getSuperClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public static void populateTypeArguments(ClassNode typeElement, Map<String, Map<String, Object>> typeArguments) {
        ClassNode current = typeElement;
        ClassNode last = null;
        while (current != null) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)current, (Object)ClassHelper.OBJECT_TYPE)) {
                Object[] superArguments = current.redirect().getGenericsTypes();
                if (ArrayUtils.isNotEmpty((Object[])superArguments)) {
                    Map<String, ClassNode> genericSpec = AstGenericUtils.createGenericsSpec(current);
                    LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>(3);
                    Map<String, ClassNode> map = genericSpec;
                    if ((map == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, map)) != false) {
                        Object gt2 = null;
                        Object[] objectArray = superArguments;
                        if (superArguments != null) {
                            for (Object gt2 : objectArray) {
                                CallSite cn = IndyInterface.bootstrap("cast", "()", 0, genericSpec.get(gt2.getName()));
                                if (!(cn != null)) continue;
                                arguments.put(gt2.getName(), AstGenericUtils.resolveTypeReference((ClassNode)cn, genericSpec));
                            }
                        }
                    }
                    if (last != null) {
                        AstGenericUtils.carryForwardTypeArguments(last, typeArguments, arguments);
                    }
                    typeArguments.put(current.getName(), arguments);
                }
            }
            AstGenericUtils.populateTypeArgumentsForInterfaces(typeArguments, current);
            current.getUnresolvedSuperClass();
        }
    }

    private static void populateTypeArgumentsForInterfaces(Map<String, Map<String, Object>> typeArguments, ClassNode current) {
        ClassNode anInterface = null;
        ClassNode[] classNodeArray = current.getInterfaces();
        if (classNodeArray != null) {
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                anInterface = classNodeArray[n2];
                ++n2;
                String name = anInterface.getName();
                if (!(!typeArguments.containsKey(name))) continue;
                Map<String, ClassNode> genericSpec = AstGenericUtils.createGenericsSpec(anInterface);
                Map<String, ClassNode> map = genericSpec;
                if ((map == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, map)) != false) {
                    CallSite types = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                    Object entry = null;
                    Iterator iterator = DefaultGroovyMethods.iterator(genericSpec);
                    if (iterator != null) {
                        while (iterator.hasNext()) {
                            entry = iterator.next();
                            ClassNode classNode = AstGenericUtils.resolveTypeReference((ClassNode)IndyInterface.bootstrap("cast", "()", 0, ((Map.Entry)entry).getValue()), genericSpec);
                            ScriptBytecodeAdapter.invokeMethodN(AstGenericUtils.class, (Object)types, (String)"putAt", (Object[])new Object[]{((Map.Entry)entry).getKey(), classNode});
                        }
                    }
                    AstGenericUtils.carryForwardTypeArguments(current, typeArguments, (Map<String, Object>)((Object)types));
                    typeArguments.put(name, (Map<String, Object>)((Object)types));
                }
                AstGenericUtils.populateTypeArgumentsForInterfaces(typeArguments, anInterface);
            }
        }
    }

    private static void carryForwardTypeArguments(ClassNode child, Map<String, Map<String, Object>> typeArguments, Map<String, Object> types) {
        Reference types2 = new Reference(types);
        String childName = child.getName();
        if (typeArguments.containsKey(childName)) {
            public final class _carryForwardTypeArguments_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference types;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _carryForwardTypeArguments_closure2(Object _outerInstance, Object _thisObject, Reference types) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.types = reference = types;
                }

                public Object doCall(String arg, Object type) {
                    if (IndyInterface.bootstrap("cast", "()", 0, this.types.get()).containsKey(arg)) {
                        return IndyInterface.bootstrap("cast", "()", 0, this.types.get()).put(arg, type);
                    }
                    return null;
                }

                @Generated
                public Object call(String arg, Object type) {
                    return this.doCall(arg, type);
                }

                @Generated
                public Map getTypes() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.types.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _carryForwardTypeArguments_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            typeArguments.get(childName).forEach((BiConsumer<String, Object>)((Object)IndyInterface.bootstrap("cast", "()", 0, new _carryForwardTypeArguments_closure2(AstGenericUtils.class, AstGenericUtils.class, types2))));
        }
    }

    public static void extractPlaceholders(ClassNode node, Map<String, Object> map, Map<String, ClassNode> boundTypes) {
        if (node == null) {
            return;
        }
        if (node.isArray()) {
            AstGenericUtils.extractPlaceholders(node.getComponentType(), map, boundTypes);
            return;
        }
        if (!node.isUsingGenerics() || !node.isRedirectNode()) {
            return;
        }
        Object[] parameterized = node.getGenericsTypes();
        if (parameterized == null || parameterized.length == 0) {
            return;
        }
        Object[] redirectGenericsTypes = node.redirect().getGenericsTypes();
        if (redirectGenericsTypes == null) {
            redirectGenericsTypes = parameterized;
        }
        int i = 0;
        while (i < redirectGenericsTypes.length) {
            CallSite redirectType = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])redirectGenericsTypes, (int)i));
            if (redirectType.isPlaceholder()) {
                String name = redirectType.getName();
                if (!map.containsKey(name) && !(i >= parameterized.length)) {
                    CallSite value = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])parameterized, (int)i));
                    ClassNode cn = value.getType();
                    ClassNode typeRef = AstGenericUtils.resolveTypeReference(cn);
                    if (value.isWildcard()) {
                        ClassNode lowerBound = value.getLowerBound();
                        if (lowerBound != null) {
                            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                            map.put(name, Collections.singletonMap(cn.getName(), newMap));
                            AstGenericUtils.extractPlaceholders(lowerBound, newMap, boundTypes);
                        }
                        ClassNode[] upperBounds = value.getUpperBounds();
                        if (upperBounds != null) {
                            ClassNode upperBound2 = null;
                            ClassNode[] classNodeArray = upperBounds;
                            if (upperBounds != null) {
                                for (ClassNode upperBound2 : classNodeArray) {
                                    if (upperBound2.isGenericsPlaceHolder()) {
                                        map.put(name, AstGenericUtils.resolveTypeReference(upperBound2, boundTypes));
                                        continue;
                                    }
                                    LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                                    map.put(name, Collections.singletonMap(upperBound2.getName(), newMap));
                                    if (!cn.isUsingGenerics()) continue;
                                    AstGenericUtils.extractPlaceholders(upperBound2, newMap, boundTypes);
                                }
                            }
                        }
                    } else if (!value.isPlaceholder()) {
                        if (!cn.isUsingGenerics()) {
                            map.put(name, typeRef);
                        } else {
                            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                            map.put(name, Collections.singletonMap(cn.getName(), newMap));
                            AstGenericUtils.extractPlaceholders(cn, newMap, boundTypes);
                        }
                    } else if (boundTypes.containsKey(value.getName())) {
                        map.put(name, AstGenericUtils.resolveTypeReference((ClassNode)IndyInterface.bootstrap("cast", "()", 0, boundTypes.get(value.getName())), boundTypes));
                    } else {
                        map.put(name, AstGenericUtils.resolveTypeReference(value.getType(), boundTypes));
                    }
                }
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AstGenericUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public static ClassNode resolveTypeReference(ClassNode classNode) {
        return AstGenericUtils.resolveTypeReference(classNode, (Map<String, ClassNode>)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "emptyMap", 0, Collections.class))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

