/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyMethodElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import org.codehaus.groovy.ast.Parameter;

@Internal
public class GroovyParameterElement
extends AbstractGroovyElement
implements ParameterElement {
    private final Parameter parameter;
    private final GroovyMethodElement methodElement;
    private ClassElement typeElement;
    private ClassElement genericType;

    GroovyParameterElement(GroovyMethodElement methodElement, GroovyVisitorContext visitorContext, GroovyNativeElement nativeElement, Parameter parameter, ElementAnnotationMetadataFactory elementAnnotationMetadata) {
        super(visitorContext, nativeElement, elementAnnotationMetadata);
        this.parameter = parameter;
        this.methodElement = methodElement;
    }

    @Override
    @NonNull
    protected AbstractGroovyElement copyConstructor() {
        return new GroovyParameterElement(this.methodElement, this.visitorContext, this.getNativeType(), this.parameter, this.elementAnnotationMetadataFactory);
    }

    public ParameterElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (ParameterElement)super.withAnnotationMetadata(annotationMetadata);
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    @NonNull
    public ClassElement getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.newClassElement(this.parameter.getType(), this.methodElement.getTypeArguments());
        }
        return this.genericType;
    }

    @NonNull
    public String getName() {
        return this.parameter.getName();
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return true;
    }

    public GroovyMethodElement getMethodElement() {
        return this.methodElement;
    }

    @NonNull
    public ClassElement getType() {
        if (this.typeElement == null) {
            this.typeElement = this.newClassElement(this.parameter.getType());
        }
        return this.typeElement;
    }
}

