/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.PropertyElementAnnotationMetadata;
import java.util.Optional;

@Internal
final class GroovyPropertyElement
extends AbstractGroovyElement
implements PropertyElement {
    private final ClassElement type;
    private final String name;
    private final PropertyElement.AccessKind readAccessKind;
    private final PropertyElement.AccessKind writeAccessKind;
    private final ClassElement owningElement;
    @Nullable
    private final MethodElement getter;
    @Nullable
    private final MethodElement setter;
    @Nullable
    private final FieldElement field;
    private final boolean excluded;
    private final PropertyElementAnnotationMetadata annotationMetadata;

    GroovyPropertyElement(GroovyVisitorContext visitorContext, ClassElement owningElement, ClassElement type, @Nullable MethodElement getter, @Nullable MethodElement setter, @Nullable FieldElement field, ElementAnnotationMetadataFactory annotationMetadataFactory, String name, PropertyElement.AccessKind readAccessKind, PropertyElement.AccessKind writeAccessKind, boolean excluded) {
        super(visitorContext, GroovyPropertyElement.selectNativeType(getter, setter, field), annotationMetadataFactory);
        this.type = type;
        this.getter = getter;
        this.setter = setter;
        this.field = field;
        this.name = name;
        this.readAccessKind = readAccessKind;
        this.writeAccessKind = writeAccessKind;
        this.owningElement = owningElement;
        this.excluded = excluded;
        this.annotationMetadata = new PropertyElementAnnotationMetadata((Element)this, getter, setter, field, null, false);
    }

    public Optional<AnnotationMetadata> getWriteTypeAnnotationMetadata() {
        return Optional.of(this.annotationMetadata.getWriteAnnotationMetadata());
    }

    public Optional<AnnotationMetadata> getReadTypeAnnotationMetadata() {
        return Optional.of(this.annotationMetadata.getReadAnnotationMetadata());
    }

    @Override
    @NonNull
    protected AbstractGroovyElement copyConstructor() {
        return new GroovyPropertyElement(this.visitorContext, this.owningElement, this.type, this.getter, this.setter, this.field, this.elementAnnotationMetadataFactory, this.name, this.readAccessKind, this.writeAccessKind, this.excluded);
    }

    public MemberElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (MemberElement)super.withAnnotationMetadata(annotationMetadata);
    }

    private static GroovyNativeElement selectNativeType(MethodElement getter, MethodElement setter, FieldElement field) {
        if (getter instanceof AbstractGroovyElement) {
            return (GroovyNativeElement)getter.getNativeType();
        }
        if (setter instanceof AbstractGroovyElement) {
            return (GroovyNativeElement)setter.getNativeType();
        }
        if (field instanceof AbstractGroovyElement) {
            return (GroovyNativeElement)field.getNativeType();
        }
        throw new IllegalStateException();
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    protected ElementAnnotationMetadata getElementAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @NonNull
    public ClassElement getType() {
        return this.type;
    }

    @NonNull
    public ClassElement getGenericType() {
        return this.type;
    }

    public Optional<FieldElement> getField() {
        return Optional.ofNullable(this.field);
    }

    public Optional<MethodElement> getWriteMethod() {
        return Optional.ofNullable(this.setter);
    }

    public Optional<MethodElement> getReadMethod() {
        return Optional.ofNullable(this.getter);
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return true;
    }

    public String toString() {
        return this.getDeclaringType().getName() + "." + this.name;
    }

    public PropertyElement.AccessKind getReadAccessKind() {
        return this.readAccessKind;
    }

    public PropertyElement.AccessKind getWriteAccessKind() {
        return this.writeAccessKind;
    }

    public boolean isReadOnly() {
        return switch (this.writeAccessKind) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyElement.AccessKind.METHOD -> {
                if (this.setter == null) {
                    yield true;
                }
                yield false;
            }
            case PropertyElement.AccessKind.FIELD -> this.field == null || this.field.isFinal();
        };
    }

    public boolean isWriteOnly() {
        return switch (this.readAccessKind) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyElement.AccessKind.METHOD -> {
                if (this.getter == null) {
                    yield true;
                }
                yield false;
            }
            case PropertyElement.AccessKind.FIELD -> this.field == null;
        };
    }

    public ClassElement getDeclaringType() {
        if (this.field != null) {
            return this.field.getDeclaringType();
        }
        if (this.getter != null) {
            return this.getter.getDeclaringType();
        }
        if (this.setter != null) {
            return this.setter.getDeclaringType();
        }
        throw new IllegalStateException();
    }

    public ClassElement getOwningType() {
        return this.owningElement;
    }

    @Override
    public Optional<String> getDocumentation() {
        return super.getDocumentation();
    }
}

