/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import groovy.lang.groovydoc.Groovydoc;
import groovy.transform.PackageScope;
import io.micronaut.ast.groovy.visitor.GroovyAnnotationElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumElement;
import io.micronaut.ast.groovy.visitor.GroovyGenericPlaceholderElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.ast.groovy.visitor.GroovyWildcardElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.AbstractAnnotationElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

@Internal
public abstract class AbstractGroovyElement
extends AbstractAnnotationElement {
    private static final Pattern JAVADOC_PATTERN = Pattern.compile("(/\\s*\\*\\*)|\\s*\\*|(\\s*[*/])");
    protected final SourceUnit sourceUnit;
    protected final CompilationUnit compilationUnit;
    protected final GroovyVisitorContext visitorContext;
    private final GroovyNativeElement nativeElement;

    protected AbstractGroovyElement(GroovyVisitorContext visitorContext, GroovyNativeElement nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        super(annotationMetadataFactory);
        this.visitorContext = visitorContext;
        this.compilationUnit = visitorContext.getCompilationUnit();
        this.nativeElement = nativeElement;
        this.sourceUnit = visitorContext.getSourceUnit();
    }

    @NonNull
    protected abstract AbstractGroovyElement copyConstructor();

    protected void copyValues(@NonNull AbstractGroovyElement element) {
        element.presetAnnotationMetadata = this.presetAnnotationMetadata;
    }

    @NonNull
    protected final AbstractGroovyElement copy() {
        AbstractGroovyElement element = this.copyConstructor();
        this.copyValues(element);
        return element;
    }

    public Element withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        AbstractGroovyElement element = this.copy();
        element.presetAnnotationMetadata = annotationMetadata;
        return element;
    }

    @NonNull
    public GroovyNativeElement getNativeType() {
        return this.nativeElement;
    }

    public boolean isPackagePrivate() {
        return this.hasDeclaredAnnotation(PackageScope.class);
    }

    @NonNull
    protected final ClassElement newClassElement(@NonNull ClassNode type, @Nullable Map<String, ClassElement> genericsSpec) {
        if (genericsSpec == null) {
            return this.newClassElement(type);
        }
        return this.newClassElement(this.getNativeType(), type, genericsSpec, new HashSet<Object>(), false, false);
    }

    @NonNull
    protected final ClassElement newClassElement(GenericsType genericsType) {
        return this.newClassElement(this.getNativeType(), this.getNativeType().annotatedNode(), genericsType, genericsType, Collections.emptyMap(), new HashSet<Object>(), false);
    }

    @NonNull
    protected final ClassElement newClassElement(ClassNode type) {
        return this.newClassElement(this.getNativeType(), type, Collections.emptyMap(), new HashSet<Object>(), false, false);
    }

    @NonNull
    private ClassElement newClassElement(@Nullable GroovyNativeElement declaredElement, AnnotatedNode genericsOwner, GenericsType genericsType, GenericsType redirectType, Map<String, ClassElement> parentTypeArguments, Set<Object> visitedTypes, boolean isRawType) {
        if (parentTypeArguments == null) {
            parentTypeArguments = Collections.emptyMap();
        }
        if (genericsType.isWildcard()) {
            return this.resolveWildcard(declaredElement, genericsOwner, genericsType, redirectType, parentTypeArguments, visitedTypes);
        }
        if (genericsType.isPlaceholder()) {
            return this.resolvePlaceholder(declaredElement, genericsOwner, genericsType, redirectType, parentTypeArguments, visitedTypes, isRawType);
        }
        return this.newClassElement(declaredElement, genericsType.getType(), parentTypeArguments, visitedTypes, genericsType.isPlaceholder(), isRawType);
    }

    @NonNull
    private ClassElement newClassElement(@Nullable GroovyNativeElement declaredElement, ClassNode classNode, Map<String, ClassElement> parentTypeArguments, Set<Object> visitedTypes, boolean isTypeVariable, boolean isRawTypeParameter) {
        return this.newClassElement(declaredElement, classNode, parentTypeArguments, visitedTypes, isTypeVariable, isRawTypeParameter, false);
    }

    @NonNull
    private ClassElement newClassElement(@Nullable GroovyNativeElement declaredElement, ClassNode classNode, Map<String, ClassElement> parentTypeArguments, Set<Object> visitedTypes, boolean isTypeVariable, boolean isRawTypeParameter, boolean stripTypeArguments) {
        if (parentTypeArguments == null) {
            parentTypeArguments = Collections.emptyMap();
        }
        if (classNode.isArray()) {
            ClassNode componentType = classNode.getComponentType();
            return this.newClassElement(declaredElement, componentType, parentTypeArguments, visitedTypes, isTypeVariable, isRawTypeParameter).toArray();
        }
        if (classNode.isGenericsPlaceHolder()) {
            Object redirectType;
            Object genericsType;
            Object[] genericsTypes = classNode.getGenericsTypes();
            if (ArrayUtils.isNotEmpty((Object[])genericsTypes)) {
                genericsType = genericsTypes[0];
                Object[] redirectTypes = classNode.redirect().getGenericsTypes();
                redirectType = ArrayUtils.isNotEmpty((Object[])redirectTypes) ? redirectTypes[0] : new GenericsType(classNode.redirect());
            } else {
                redirectType = genericsType = new GenericsType(classNode.redirect());
            }
            return this.newClassElement(declaredElement, this.getNativeType().annotatedNode(), (GenericsType)genericsType, (GenericsType)redirectType, parentTypeArguments, visitedTypes, isRawTypeParameter);
        }
        if (ClassHelper.isPrimitiveType((ClassNode)classNode)) {
            return PrimitiveElement.valueOf((String)classNode.getName());
        }
        if (classNode.isEnum()) {
            return new GroovyEnumElement(this.visitorContext, new GroovyNativeElement.Class(classNode), this.elementAnnotationMetadataFactory);
        }
        if (classNode.isAnnotationDefinition()) {
            return new GroovyAnnotationElement(this.visitorContext, new GroovyNativeElement.Class(classNode), this.elementAnnotationMetadataFactory);
        }
        Record groovyNativeElement = declaredElement == null ? new GroovyNativeElement.Class(classNode) : new GroovyNativeElement.ClassWithOwner(classNode, declaredElement);
        Map<String, ClassElement> newTypeArguments = stripTypeArguments ? this.resolveTypeArgumentsToObject(classNode) : this.resolveClassTypeArguments((GroovyNativeElement)((Object)groovyNativeElement), classNode, (Map<String, ClassElement>)parentTypeArguments, visitedTypes);
        return new GroovyClassElement(this.visitorContext, (GroovyNativeElement)((Object)groovyNativeElement), this.elementAnnotationMetadataFactory, newTypeArguments, 0, isTypeVariable);
    }

    @NonNull
    private ClassElement resolvePlaceholder(GroovyNativeElement owner, AnnotatedNode genericsOwner, GenericsType genericsType, GenericsType redirectType, Map<String, ClassElement> parentTypeArguments, Set<Object> visitedTypes, boolean isRawType) {
        ClassNode placeholderClassNode = genericsType.getType();
        String variableName = genericsType.getName();
        ClassElement resolvedBound = parentTypeArguments.get(variableName);
        List<GroovyClassElement> bounds = null;
        AbstractGroovyElement declaredElement = this;
        GroovyClassElement resolved = null;
        int arrayDimensions = 0;
        if (resolvedBound != null) {
            if (resolvedBound instanceof WildcardElement) {
                WildcardElement wildcardElement = (WildcardElement)resolvedBound;
                if (wildcardElement.isBounded()) {
                    return wildcardElement;
                }
            } else if (resolvedBound instanceof GroovyGenericPlaceholderElement) {
                GroovyGenericPlaceholderElement groovyGenericPlaceholderElement = (GroovyGenericPlaceholderElement)resolvedBound;
                bounds = groovyGenericPlaceholderElement.getBounds();
                declaredElement = groovyGenericPlaceholderElement.getRequiredDeclaringElement();
                resolved = groovyGenericPlaceholderElement.getResolvedInternal();
                arrayDimensions = groovyGenericPlaceholderElement.getArrayDimensions();
                isRawType = groovyGenericPlaceholderElement.isRawType();
            } else if (resolvedBound instanceof GroovyClassElement) {
                GroovyClassElement resolvedClassElement;
                resolved = resolvedClassElement = (GroovyClassElement)resolvedBound;
                arrayDimensions = resolved.getArrayDimensions();
                isRawType = resolved.isRawType();
            } else {
                return resolvedBound;
            }
        }
        GroovyNativeElement.Placeholder groovyPlaceholderNativeElement = new GroovyNativeElement.Placeholder(placeholderClassNode, owner, variableName);
        if (bounds == null) {
            PlaceholderEntry placeholderEntry;
            boolean alreadyVisitedPlaceholder;
            ArrayList<ClassNode> classNodeBounds = new ArrayList<ClassNode>();
            AbstractGroovyElement.addBounds(genericsType, classNodeBounds);
            if (genericsType != redirectType) {
                AbstractGroovyElement.addBounds(redirectType, classNodeBounds);
            }
            if (!(alreadyVisitedPlaceholder = visitedTypes.contains(placeholderEntry = new PlaceholderEntry(genericsOwner, variableName)))) {
                visitedTypes.add(placeholderEntry);
            }
            boolean finalIsRawType = isRawType;
            bounds = classNodeBounds.stream().map(classNode -> {
                if (alreadyVisitedPlaceholder && classNode.isGenericsPlaceHolder()) {
                    classNode = classNode.redirect();
                }
                return classNode;
            }).filter(classNode -> !alreadyVisitedPlaceholder || !classNode.isGenericsPlaceHolder()).map(classNode -> {
                boolean stripTypeArguments = alreadyVisitedPlaceholder;
                return (GroovyClassElement)this.newClassElement((GroovyNativeElement)groovyPlaceholderNativeElement, (ClassNode)classNode, parentTypeArguments, visitedTypes, true, finalIsRawType, stripTypeArguments);
            }).toList();
            if (bounds.isEmpty()) {
                bounds = Collections.singletonList((GroovyClassElement)this.getObjectClassElement());
            }
        }
        return new GroovyGenericPlaceholderElement(this.visitorContext, (Element)declaredElement, groovyPlaceholderNativeElement, resolved, bounds, arrayDimensions, isRawType, variableName);
    }

    private static void addBounds(GenericsType genericsType, List<ClassNode> classNodeBounds) {
        if (genericsType.getUpperBounds() != null) {
            for (ClassNode ub : genericsType.getUpperBounds()) {
                if (classNodeBounds.contains(ub)) continue;
                classNodeBounds.add(ub);
            }
        } else {
            ClassNode type = genericsType.getType();
            if (!classNodeBounds.contains(type)) {
                classNodeBounds.add(type);
            }
        }
    }

    @NonNull
    private ClassElement getObjectClassElement() {
        return this.visitorContext.getClassElement(Object.class).orElseThrow(() -> new IllegalStateException("java.lang.Object element not found"));
    }

    @NonNull
    private ClassElement resolveWildcard(GroovyNativeElement declaredElement, AnnotatedNode genericsOwner, GenericsType genericsType, GenericsType redirectType, Map<String, ClassElement> parentTypeArguments, Set<Object> visitedTypes) {
        ClassElement definedTypeBound;
        ClassElement upperType;
        Stream<ClassNode> lowerBounds = Stream.ofNullable(genericsType.getLowerBound());
        ClassNode[] genericsUpperBounds = genericsType.getUpperBounds();
        Stream<ClassNode> upperBounds = genericsUpperBounds == null || genericsUpperBounds.length == 0 ? Stream.empty() : Arrays.stream(genericsUpperBounds);
        List<ClassElement> upperBoundsAsElements = upperBounds.map(classNode -> this.newClassElement(declaredElement, (ClassNode)classNode, parentTypeArguments, visitedTypes, true, false)).toList();
        List<ClassElement> lowerBoundsAsElements = lowerBounds.map(classNode -> this.newClassElement(declaredElement, (ClassNode)classNode, parentTypeArguments, visitedTypes, true, false)).toList();
        if (upperBoundsAsElements.isEmpty()) {
            upperBoundsAsElements = Collections.singletonList(this.getObjectClassElement());
        }
        if ((upperType = WildcardElement.findUpperType(upperBoundsAsElements, lowerBoundsAsElements)).getType().getName().equals("java.lang.Object") && redirectType != null && redirectType != genericsType && (definedTypeBound = this.newClassElement(declaredElement, genericsOwner, redirectType, redirectType, parentTypeArguments, visitedTypes, false)) instanceof GroovyGenericPlaceholderElement) {
            GroovyGenericPlaceholderElement groovyGenericPlaceholderElement = (GroovyGenericPlaceholderElement)definedTypeBound;
            upperType = WildcardElement.findUpperType(groovyGenericPlaceholderElement.getBounds(), Collections.emptyList());
        }
        if (upperType.isPrimitive()) {
            return upperType;
        }
        GroovyNativeElement.ClassWithOwner wildcardNativeElement = new GroovyNativeElement.ClassWithOwner(genericsType.getType(), declaredElement);
        return new GroovyWildcardElement(wildcardNativeElement, upperBoundsAsElements.stream().map(GroovyClassElement.class::cast).toList(), lowerBoundsAsElements.stream().map(GroovyClassElement.class::cast).toList(), this.elementAnnotationMetadataFactory, (GroovyClassElement)upperType);
    }

    @NonNull
    protected final Map<String, ClassElement> resolveMethodTypeArguments(GroovyNativeElement declaredElement, MethodNode methodNode, @Nullable Map<String, ClassElement> parentTypeArguments) {
        if (parentTypeArguments == null) {
            parentTypeArguments = Collections.emptyMap();
        }
        return this.resolveTypeArguments(declaredElement, (AnnotatedNode)methodNode, methodNode.getGenericsTypes(), methodNode.getGenericsTypes(), parentTypeArguments, new HashSet<Object>());
    }

    @NonNull
    protected final Map<String, ClassElement> resolveClassTypeArguments(GroovyNativeElement declaredElement, ClassNode classNode, @Nullable Map<String, ClassElement> parentTypeArguments, Set<Object> visitedTypes) {
        return this.resolveTypeArguments(declaredElement, (AnnotatedNode)classNode, classNode.getGenericsTypes(), classNode.redirect().getGenericsTypes(), parentTypeArguments, visitedTypes);
    }

    @NonNull
    private Map<String, ClassElement> resolveTypeArguments(GroovyNativeElement declaredElement, AnnotatedNode genericsOwner, GenericsType[] genericsTypes, GenericsType[] redirectTypes, @Nullable Map<String, ClassElement> parentTypeArguments, Set<Object> visitedTypes) {
        if (redirectTypes == null || redirectTypes.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap resolved = CollectionUtils.newLinkedHashMap((int)redirectTypes.length);
        if (genericsTypes != null && genericsTypes.length == redirectTypes.length) {
            for (int i = 0; i < genericsTypes.length; ++i) {
                GenericsType genericsType = genericsTypes[i];
                GenericsType redirectType = redirectTypes[i];
                ClassElement classElement = this.newClassElement(declaredElement, genericsOwner, genericsType, redirectType, parentTypeArguments, visitedTypes, false);
                resolved.put(redirectType.getName(), classElement);
            }
        } else {
            boolean isRaw = genericsTypes == null;
            for (GenericsType redirectType : redirectTypes) {
                String variableName = redirectType.getName();
                resolved.put(variableName, this.newClassElement(declaredElement, genericsOwner, redirectType, redirectType, parentTypeArguments, visitedTypes, isRaw));
            }
        }
        return resolved;
    }

    @NonNull
    protected final Map<String, ClassElement> resolveTypeArgumentsToObject(ClassNode classNode) {
        GenericsType[] redirectTypes = classNode.redirect().getGenericsTypes();
        if (redirectTypes == null || redirectTypes.length == 0) {
            return Collections.emptyMap();
        }
        ClassElement objectClassElement = this.getObjectClassElement();
        LinkedHashMap resolved = CollectionUtils.newLinkedHashMap((int)redirectTypes.length);
        for (GenericsType redirectType : redirectTypes) {
            String variableName = redirectType.getName();
            resolved.put(variableName, objectClassElement);
        }
        return resolved;
    }

    public Optional<String> getDocumentation(boolean parse) {
        GroovyNativeElement nativeType = this.getNativeType();
        AnnotatedNode annotatedNode = nativeType.annotatedNode();
        Groovydoc groovydoc = annotatedNode.getGroovydoc();
        if (groovydoc == null || groovydoc.getContent() == null) {
            return Optional.empty();
        }
        if (parse) {
            return Optional.of(JAVADOC_PATTERN.matcher(annotatedNode.getGroovydoc().getContent()).replaceAll("").trim());
        }
        return Optional.of(annotatedNode.getGroovydoc().getContent());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof AbstractGroovyElement)) {
            return false;
        }
        AbstractGroovyElement that = (AbstractGroovyElement)((Object)o);
        return this.nativeElement.annotatedNode().equals(that.nativeElement.annotatedNode());
    }

    public int hashCode() {
        return this.nativeElement.annotatedNode().hashCode();
    }

    protected Set<ElementModifier> resolveModifiers(MethodNode methodNode) {
        return this.resolveModifiers(methodNode.getModifiers());
    }

    protected Set<ElementModifier> resolveModifiers(FieldNode fieldNode) {
        return this.resolveModifiers(fieldNode.getModifiers());
    }

    protected Set<ElementModifier> resolveModifiers(ClassNode classNode) {
        return this.resolveModifiers(classNode.getModifiers());
    }

    private Set<ElementModifier> resolveModifiers(int mod) {
        HashSet<ElementModifier> modifiers = new HashSet<ElementModifier>(5);
        if (Modifier.isPrivate(mod)) {
            modifiers.add(ElementModifier.PRIVATE);
        } else if (Modifier.isProtected(mod)) {
            modifiers.add(ElementModifier.PROTECTED);
        } else if (Modifier.isPublic(mod)) {
            modifiers.add(ElementModifier.PUBLIC);
        }
        if (Modifier.isAbstract(mod)) {
            modifiers.add(ElementModifier.ABSTRACT);
        } else if (Modifier.isStatic(mod)) {
            modifiers.add(ElementModifier.STATIC);
        }
        if (Modifier.isFinal(mod)) {
            modifiers.add(ElementModifier.FINAL);
        }
        return modifiers;
    }

    record PlaceholderEntry(AnnotatedNode owner, String placeholderName) {
    }
}

