/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.GroovyAnnotationElement;
import io.micronaut.ast.groovy.visitor.GroovyBeanDefinitionBuilder;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyConstructorElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumConstantElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumElement;
import io.micronaut.ast.groovy.visitor.GroovyFieldElement;
import io.micronaut.ast.groovy.visitor.GroovyMethodElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementFactory;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;

@Internal
public class GroovyElementFactory
implements ElementFactory<AnnotatedNode, ClassNode, MethodNode, FieldNode> {
    private final GroovyVisitorContext visitorContext;

    public GroovyElementFactory(GroovyVisitorContext groovyVisitorContext) {
        this.visitorContext = groovyVisitorContext;
    }

    @NonNull
    public ClassElement newClassElement(ClassNode classNode, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        if (classNode.isArray()) {
            ClassNode componentType = classNode.getComponentType();
            ClassElement componentElement = this.newClassElement(componentType, annotationMetadataFactory);
            return componentElement.toArray();
        }
        if (ClassHelper.isPrimitiveType((ClassNode)classNode)) {
            return PrimitiveElement.valueOf((String)classNode.getName());
        }
        if (classNode.isEnum()) {
            return new GroovyEnumElement(this.visitorContext, new GroovyNativeElement.Class(classNode), annotationMetadataFactory);
        }
        if (classNode.isAnnotationDefinition()) {
            return new GroovyAnnotationElement(this.visitorContext, new GroovyNativeElement.Class(classNode), annotationMetadataFactory);
        }
        if (classNode.isGenericsPlaceHolder()) {
            throw new IllegalArgumentException("Placeholder cannot be created without declared element!");
        }
        return new GroovyClassElement(this.visitorContext, new GroovyNativeElement.Class(classNode), annotationMetadataFactory);
    }

    @NonNull
    public ClassElement newClassElement(@NonNull ClassNode classNode, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory, @NonNull Map<String, ClassElement> resolvedGenerics) {
        if (CollectionUtils.isNotEmpty(resolvedGenerics)) {
            return this.newClassElement(classNode, annotationMetadataFactory).withTypeArguments(resolvedGenerics);
        }
        return this.newClassElement(classNode, annotationMetadataFactory);
    }

    @NonNull
    public GroovyMethodElement newMethodElement(@NonNull ClassElement owningType, @NonNull MethodNode method, @NonNull ElementAnnotationMetadataFactory elementAnnotationMetadataFactory) {
        if (!(owningType instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyClassElement");
        }
        return new GroovyMethodElement((GroovyClassElement)owningType, this.visitorContext, new GroovyNativeElement.Method(method), method, elementAnnotationMetadataFactory);
    }

    @NonNull
    public ClassElement newSourceClassElement(ClassNode classNode, final @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        if (classNode.isArray()) {
            ClassNode componentType = classNode.getComponentType();
            ClassElement componentElement = this.newSourceClassElement(componentType, annotationMetadataFactory);
            return componentElement.toArray();
        }
        if (ClassHelper.isPrimitiveType((ClassNode)classNode)) {
            return PrimitiveElement.valueOf((String)classNode.getName());
        }
        if (classNode.isEnum()) {
            return new GroovyEnumElement(this.visitorContext, new GroovyNativeElement.Class(classNode), annotationMetadataFactory){

                @NonNull
                public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                    return new GroovyBeanDefinitionBuilder((Element)this, type, annotationMetadataFactory, this.visitorContext);
                }
            };
        }
        return new GroovyClassElement(this.visitorContext, new GroovyNativeElement.Class(classNode), annotationMetadataFactory){

            @NonNull
            public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                return new GroovyBeanDefinitionBuilder((Element)this, type, annotationMetadataFactory, this.visitorContext);
            }
        };
    }

    @NonNull
    public GroovyMethodElement newSourceMethodElement(@NonNull ClassElement owningType, @NonNull MethodNode method, @NonNull ElementAnnotationMetadataFactory elementAnnotationMetadataFactory) {
        if (!(owningType instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyClassElement");
        }
        return new GroovyMethodElement((GroovyClassElement)owningType, this.visitorContext, new GroovyNativeElement.Method(method), method, elementAnnotationMetadataFactory){

            @NonNull
            public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                return new GroovyBeanDefinitionBuilder((Element)this, type, this.elementAnnotationMetadataFactory, this.visitorContext);
            }
        };
    }

    @NonNull
    public ConstructorElement newConstructorElement(@NonNull ClassElement owningType, @NonNull MethodNode constructor, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        if (!(owningType instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyClassElement");
        }
        if (!(constructor instanceof ConstructorNode)) {
            throw new IllegalArgumentException("Constructor must be a ConstructorNode");
        }
        return new GroovyConstructorElement((GroovyClassElement)owningType, this.visitorContext, (GroovyNativeElement)new GroovyNativeElement.Method(constructor), (ConstructorNode)constructor, annotationMetadataFactory);
    }

    @NonNull
    public EnumConstantElement newEnumConstantElement(@NonNull ClassElement declaringClass, @NonNull FieldNode enumConstant, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        if (!(declaringClass instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyEnumElement");
        }
        return new GroovyEnumConstantElement((GroovyClassElement)declaringClass, this.visitorContext, enumConstant, annotationMetadataFactory);
    }

    @NonNull
    public GroovyFieldElement newFieldElement(@NonNull ClassElement owningType, @NonNull FieldNode field, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        if (!(owningType instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyClassElement");
        }
        return new GroovyFieldElement(this.visitorContext, (GroovyClassElement)owningType, field, annotationMetadataFactory);
    }
}

