/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.util.Set;
import org.codehaus.groovy.ast.FieldNode;

@Internal
public final class GroovyEnumConstantElement
extends AbstractGroovyElement
implements EnumConstantElement {
    private final GroovyClassElement declaringEnum;
    private final FieldNode variable;

    GroovyEnumConstantElement(GroovyClassElement declaringEnum, GroovyVisitorContext visitorContext, FieldNode variable, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        super(visitorContext, new GroovyNativeElement.Field(variable, declaringEnum.getNativeType()), annotationMetadataFactory);
        this.declaringEnum = declaringEnum;
        this.variable = variable;
    }

    @Override
    protected AbstractGroovyElement copyConstructor() {
        return new GroovyEnumConstantElement(this.declaringEnum, this.visitorContext, this.variable, this.elementAnnotationMetadataFactory);
    }

    public FieldElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (FieldElement)super.withAnnotationMetadata(annotationMetadata);
    }

    public ClassElement getDeclaringType() {
        return this.declaringEnum;
    }

    @NonNull
    public ClassElement getType() {
        return this.declaringEnum;
    }

    public Set<ElementModifier> getModifiers() {
        return ENUM_CONSTANT_MODIFIERS;
    }

    @Override
    public boolean isPackagePrivate() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isStatic() {
        return true;
    }

    public boolean isPublic() {
        return true;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public String getName() {
        return this.variable.getName();
    }

    public String toString() {
        return this.variable.getName();
    }
}

