/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.Script;
import groovy.transform.Trait;
import io.micronaut.ast.groovy.utils.AstClassUtils;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyElementFactory;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyPackageElement;
import io.micronaut.ast.groovy.visitor.GroovyPropertyElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.context.annotation.BeanProperties;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.ast.utils.AstBeanPropertiesUtils;
import io.micronaut.inject.ast.utils.EnclosedElementsQuery;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;

@Internal
public class GroovyClassElement
extends AbstractGroovyElement
implements ArrayableClassElement {
    private static final Predicate<MethodNode> JUNK_METHOD_FILTER = m -> {
        String methodName = m.getName();
        return m.isStaticConstructor() || methodName.startsWith("$") || methodName.contains("trait$") || methodName.startsWith("super$") || methodName.equals("setMetaClass") || m.getReturnType().getNameWithoutPackage().equals("MetaClass") || m.getDeclaringClass().equals((Object)ClassHelper.GROOVY_OBJECT_TYPE) || m.getDeclaringClass().equals((Object)ClassHelper.OBJECT_TYPE);
    };
    private static final Predicate<FieldNode> JUNK_FIELD_FILTER = m -> {
        String fieldName = m.getName();
        return fieldName.startsWith("__$") || fieldName.contains("trait$") || fieldName.equals("metaClass") || m.getDeclaringClass().equals((Object)ClassHelper.GROOVY_OBJECT_TYPE) || m.getDeclaringClass().equals((Object)ClassHelper.OBJECT_TYPE);
    };
    protected final ClassNode classNode;
    protected Map<String, ClassElement> resolvedTypeArguments;
    private final int arrayDimensions;
    private final boolean isTypeVar;
    private List<PropertyElement> properties;
    private List<PropertyElement> nativeProperties;
    @Nullable
    private ElementAnnotationMetadata elementTypeAnnotationMetadata;
    @Nullable
    private ClassElement theType;
    private final GroovyEnclosedElementsQuery groovyEnclosedElementsQuery = new GroovyEnclosedElementsQuery(false);
    private final GroovyEnclosedElementsQuery groovySourceEnclosedElementsQuery = new GroovyEnclosedElementsQuery(true);
    @Nullable
    private AnnotationMetadata annotationMetadata;

    public GroovyClassElement(GroovyVisitorContext visitorContext, GroovyNativeElement nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        this(visitorContext, nativeElement, annotationMetadataFactory, null, 0);
    }

    GroovyClassElement(GroovyVisitorContext visitorContext, GroovyNativeElement nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, Map<String, ClassElement> resolvedTypeArguments, int arrayDimensions) {
        this(visitorContext, nativeElement, annotationMetadataFactory, resolvedTypeArguments, arrayDimensions, false);
    }

    GroovyClassElement(GroovyVisitorContext visitorContext, GroovyNativeElement nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, Map<String, ClassElement> resolvedTypeArguments, int arrayDimensions, boolean isTypeVar) {
        super(visitorContext, nativeElement, annotationMetadataFactory);
        this.resolvedTypeArguments = resolvedTypeArguments;
        this.arrayDimensions = arrayDimensions;
        this.classNode = (ClassNode)nativeElement.annotatedNode();
        if (this.classNode.isArray()) {
            this.classNode.setName(this.classNode.getComponentType().getName());
        }
        this.isTypeVar = isTypeVar;
    }

    @Override
    protected GroovyClassElement copyConstructor() {
        return new GroovyClassElement(this.visitorContext, this.getNativeType(), this.elementAnnotationMetadataFactory, this.resolvedTypeArguments, this.arrayDimensions, this.isTypeVar);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        if (this.presetAnnotationMetadata != null) {
            return this.presetAnnotationMetadata;
        }
        if (this.annotationMetadata == null) {
            this.annotationMetadata = this.getNativeType() instanceof GroovyNativeElement.ClassWithOwner ? new AnnotationMetadataHierarchy(true, new AnnotationMetadata[]{super.getAnnotationMetadata(), this.getTypeAnnotationMetadata()}) : super.getAnnotationMetadata();
        }
        return this.annotationMetadata;
    }

    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        if (this.getNativeType() instanceof GroovyNativeElement.ClassWithOwner) {
            return this.getTypeAnnotationMetadata();
        }
        return super.getAnnotationMetadataToWrite();
    }

    public ClassElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (ClassElement)super.withAnnotationMetadata(annotationMetadata);
    }

    public ClassElement withTypeArguments(Map<String, ClassElement> typeArguments) {
        return new GroovyClassElement(this.visitorContext, this.getNativeType(), this.elementAnnotationMetadataFactory, typeArguments, this.arrayDimensions);
    }

    @NonNull
    public final ClassElement withTypeArguments(@NonNull Collection<ClassElement> typeArguments) {
        if (typeArguments.isEmpty()) {
            return this.withTypeArguments(Collections.emptyMap());
        }
        Set<String> genericNames = this.getTypeArguments().keySet();
        if (genericNames.size() != typeArguments.size()) {
            throw new IllegalStateException("Expected to have: " + genericNames.size() + " type arguments! Got: " + typeArguments.size());
        }
        LinkedHashMap boundByName = CollectionUtils.newLinkedHashMap((int)typeArguments.size());
        Iterator<String> keys = genericNames.iterator();
        Iterator<ClassElement> args = typeArguments.iterator();
        while (keys.hasNext() && args.hasNext()) {
            ClassElement next = args.next();
            Object nativeType = next.getNativeType();
            if (nativeType instanceof Class) {
                Class aClass = (Class)nativeType;
                next = this.visitorContext.getClassElement(aClass).orElse(next);
            }
            boundByName.put(keys.next(), next);
        }
        return this.withTypeArguments(boundByName);
    }

    public boolean isTypeVariable() {
        return this.isTypeVar;
    }

    public <T extends Element> List<T> getEnclosedElements(@NonNull ElementQuery<T> query) {
        return this.groovyEnclosedElementsQuery.getEnclosedElements((ClassElement)this, query);
    }

    public final <T extends Element> List<T> getSourceEnclosedElements(@NonNull ElementQuery<T> query) {
        return this.groovySourceEnclosedElementsQuery.getEnclosedElements((ClassElement)this, query);
    }

    public Set<ElementModifier> getModifiers() {
        return this.resolveModifiers(this.classNode);
    }

    public boolean isInner() {
        return this.classNode instanceof InnerClassNode;
    }

    public Optional<ClassElement> getEnclosingType() {
        if (this.isInner()) {
            return Optional.ofNullable(this.classNode.getOuterClass()).map(inner -> this.newClassElement((ClassNode)inner, this.getTypeArguments()));
        }
        return Optional.empty();
    }

    public boolean isInterface() {
        return this.classNode.isInterface();
    }

    public boolean isPrimitive() {
        return this.classNode.isArray() && ClassUtils.getPrimitiveType((String)this.classNode.getComponentType().getName()).isPresent();
    }

    public Collection<ClassElement> getInterfaces() {
        Object[] interfaces = this.classNode.getInterfaces();
        if (ArrayUtils.isNotEmpty((Object[])interfaces)) {
            return Arrays.stream(interfaces).filter(inf -> !inf.getName().equals("groovy.lang.GroovyObject")).map(inf -> this.newClassElement((ClassNode)inf, this.getTypeArguments())).toList();
        }
        return Collections.emptyList();
    }

    public Optional<ClassElement> getSuperType() {
        ClassNode superClass = this.classNode.getUnresolvedSuperClass();
        if (superClass != null && !superClass.equals((Object)ClassHelper.OBJECT_TYPE)) {
            return Optional.of(this.newClassElement(superClass, this.getTypeArguments()));
        }
        return Optional.empty();
    }

    @NonNull
    public Optional<MethodElement> getPrimaryConstructor() {
        Optional primaryConstructor = super.getPrimaryConstructor();
        if (primaryConstructor.isPresent()) {
            return primaryConstructor;
        }
        return this.possibleDefaultEmptyConstructor();
    }

    public Optional<MethodElement> getDefaultConstructor() {
        Optional defaultConstructor = super.getDefaultConstructor();
        if (defaultConstructor.isPresent()) {
            return defaultConstructor;
        }
        return this.possibleDefaultEmptyConstructor();
    }

    private Optional<MethodElement> possibleDefaultEmptyConstructor() {
        List constructors = this.classNode.getDeclaredConstructors();
        if (CollectionUtils.isEmpty((Collection)constructors) && !this.classNode.isAbstract() && !this.classNode.isEnum()) {
            return this.createMethodElement((MethodNode)new ConstructorNode(1, (Statement)new BlockStatement()));
        }
        return Optional.empty();
    }

    private Optional<MethodElement> createMethodElement(MethodNode method) {
        return Optional.ofNullable(method).map(executableElement -> {
            if (executableElement instanceof ConstructorNode) {
                return this.visitorContext.getElementFactory().newConstructorElement((ClassElement)this, (MethodNode)executableElement, this.elementAnnotationMetadataFactory);
            }
            return this.visitorContext.getElementFactory().newMethodElement((ClassElement)this, (MethodNode)executableElement, this.elementAnnotationMetadataFactory);
        });
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments() {
        if (this.resolvedTypeArguments == null) {
            this.resolvedTypeArguments = this.resolveClassTypeArguments(this.getNativeType(), this.classNode, Collections.emptyMap(), new HashSet<Object>());
        }
        return this.resolvedTypeArguments;
    }

    public List<PropertyElement> getSyntheticBeanProperties() {
        if (this.nativeProperties == null) {
            PropertyElementQuery configuration = new PropertyElementQuery();
            configuration.allowStaticProperties(true);
            Set nativeProps = this.getPropertyNodes().stream().map(PropertyNode::getName).collect(Collectors.toCollection(LinkedHashSet::new));
            this.nativeProperties = AstBeanPropertiesUtils.resolveBeanProperties((PropertyElementQuery)configuration, (ClassElement)this, () -> this.getEnclosedElements(ElementQuery.ALL_METHODS.onlyInstance()), () -> this.getPropertyNodes().stream().map(propertyNode -> this.visitorContext.getElementFactory().newFieldElement((ClassElement)this, propertyNode.getField(), this.elementAnnotationMetadataFactory)).collect(Collectors.toList()), (boolean)true, (Set)nativeProps, methodElement -> Optional.empty(), methodElement -> Optional.empty(), value -> this.mapPropertyElement(nativeProps, (AstBeanPropertiesUtils.BeanPropertyData)value, configuration, true));
        }
        return this.nativeProperties;
    }

    public List<PropertyElement> getBeanProperties(PropertyElementQuery propertyElementQuery) {
        Set nativeProps = this.getPropertyNodes().stream().map(PropertyNode::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        return AstBeanPropertiesUtils.resolveBeanProperties((PropertyElementQuery)propertyElementQuery, (ClassElement)this, () -> this.getEnclosedElements(ElementQuery.ALL_METHODS.onlyInstance()), () -> this.getEnclosedElements(ElementQuery.ALL_FIELDS), (boolean)true, (Set)nativeProps, methodElement -> Optional.empty(), methodElement -> Optional.empty(), value -> this.mapPropertyElement(nativeProps, (AstBeanPropertiesUtils.BeanPropertyData)value, propertyElementQuery, false));
    }

    public List<PropertyElement> getBeanProperties() {
        if (this.properties == null) {
            this.properties = this.getBeanProperties(PropertyElementQuery.of((AnnotationMetadata)this));
        }
        return this.properties;
    }

    @Nullable
    private GroovyPropertyElement mapPropertyElement(Set<String> nativeProps, AstBeanPropertiesUtils.BeanPropertyData value, PropertyElementQuery conf, boolean nativePropertiesOnly) {
        if (value.type == null) {
            value.type = PrimitiveElement.VOID;
        }
        final AtomicReference<GroovyPropertyElement> ref = new AtomicReference<GroovyPropertyElement>();
        if (conf.getAccessKinds().contains(BeanProperties.AccessKind.METHOD) && nativeProps.remove(value.propertyName)) {
            AnnotationMetadataProvider methodAnnotationMetadataProvider = new AnnotationMetadataProvider(){

                public AnnotationMetadata getAnnotationMetadata() {
                    return ((AnnotationMetadataProvider)ref.get()).getAnnotationMetadata();
                }
            };
            AnnotationMetadataProvider annotationMetadataProvider = new AnnotationMetadataProvider(){

                public AnnotationMetadata getAnnotationMetadata() {
                    return new AnnotationMetadataHierarchy(new AnnotationMetadata[]{GroovyClassElement.this, ((AnnotationMetadataProvider)ref.get()).getAnnotationMetadata()});
                }
            };
            if (nativePropertiesOnly && value.field == null) {
                return null;
            }
            if (value.field != null && value.readAccessKind != BeanProperties.AccessKind.METHOD) {
                String getterName = NameUtils.getterNameFor((String)value.propertyName, (boolean)value.type.equals(PrimitiveElement.BOOLEAN));
                value.getter = MethodElement.of((ClassElement)this, (ClassElement)value.field.getDeclaringType(), (AnnotationMetadataProvider)methodAnnotationMetadataProvider, (AnnotationMetadataProvider)annotationMetadataProvider, (AbstractAnnotationMetadataBuilder)this.visitorContext.getAnnotationMetadataBuilder(), (ClassElement)value.field.getGenericType(), (ClassElement)value.field.getGenericType(), (String)getterName, (boolean)value.field.isStatic(), (boolean)value.field.isFinal(), (ParameterElement[])new ParameterElement[0]);
                value.readAccessKind = BeanProperties.AccessKind.METHOD;
            } else if (nativePropertiesOnly) {
                value.getter = null;
                value.readAccessKind = null;
            }
            if (value.field != null && !value.field.isFinal() && value.writeAccessKind != BeanProperties.AccessKind.METHOD) {
                value.setter = MethodElement.of((ClassElement)this, (ClassElement)value.field.getDeclaringType(), (AnnotationMetadataProvider)methodAnnotationMetadataProvider, (AnnotationMetadataProvider)annotationMetadataProvider, (AbstractAnnotationMetadataBuilder)this.visitorContext.getAnnotationMetadataBuilder(), (ClassElement)PrimitiveElement.VOID, (ClassElement)PrimitiveElement.VOID, (String)NameUtils.setterNameFor((String)value.propertyName), (boolean)value.field.isStatic(), (boolean)value.field.isFinal(), (ParameterElement[])new ParameterElement[]{ParameterElement.of((ClassElement)value.field.getGenericType(), (String)value.propertyName, (AnnotationMetadataProvider)methodAnnotationMetadataProvider, (AbstractAnnotationMetadataBuilder)this.visitorContext.getAnnotationMetadataBuilder())});
                value.writeAccessKind = BeanProperties.AccessKind.METHOD;
            } else if (nativePropertiesOnly) {
                value.setter = null;
                value.writeAccessKind = null;
            }
        } else if (nativePropertiesOnly) {
            return null;
        }
        if (value.writeAccessKind != BeanProperties.AccessKind.METHOD) {
            value.setter = null;
        }
        if (value.readAccessKind != BeanProperties.AccessKind.METHOD) {
            value.getter = null;
        }
        GroovyPropertyElement propertyElement = new GroovyPropertyElement(this.visitorContext, (ClassElement)this, value.type, value.getter, value.setter, value.field, this.elementAnnotationMetadataFactory, value.propertyName, value.readAccessKind == null ? PropertyElement.AccessKind.METHOD : PropertyElement.AccessKind.valueOf((String)value.readAccessKind.name()), value.writeAccessKind == null ? PropertyElement.AccessKind.METHOD : PropertyElement.AccessKind.valueOf((String)value.writeAccessKind.name()), value.isExcluded);
        ref.set(propertyElement);
        return propertyElement;
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new GroovyClassElement(this.visitorContext, this.getNativeType(), this.elementAnnotationMetadataFactory, this.resolvedTypeArguments, arrayDimensions);
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public String toString() {
        return this.classNode.getName();
    }

    public String getName() {
        return this.classNode.getName();
    }

    public String getSimpleName() {
        return this.classNode.getNameWithoutPackage();
    }

    public String getPackageName() {
        return this.classNode.getPackageName();
    }

    public PackageElement getPackage() {
        PackageNode aPackage = this.classNode.getPackage();
        if (aPackage != null) {
            return new GroovyPackageElement(this.visitorContext, aPackage, this.elementAnnotationMetadataFactory);
        }
        return PackageElement.DEFAULT_PACKAGE;
    }

    public boolean isAbstract() {
        return this.classNode.isAbstract();
    }

    public boolean isStatic() {
        return this.classNode.isStaticClass() || Modifier.isStatic(this.classNode.getModifiers());
    }

    public boolean isPublic() {
        return (this.classNode.isSyntheticPublic() || Modifier.isPublic(this.classNode.getModifiers())) && !this.isPackagePrivate();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.classNode.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.classNode.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.classNode.getModifiers());
    }

    public boolean isAssignable(String type) {
        return AstClassUtils.isSubclassOfOrImplementsInterface(this.classNode, type);
    }

    public boolean isAssignable(ClassElement type) {
        if (this.equals(type)) {
            return true;
        }
        return AstClassUtils.isSubclassOfOrImplementsInterface(this.classNode, type.getName());
    }

    public Optional<ClassElement> getOptionalValueType() {
        if (this.isAssignable(Optional.class)) {
            return this.getFirstTypeArgument().or(() -> this.visitorContext.getClassElement(Object.class));
        }
        if (this.isAssignable(OptionalLong.class)) {
            return this.visitorContext.getClassElement(Long.class);
        }
        if (this.isAssignable(OptionalDouble.class)) {
            return this.visitorContext.getClassElement(Double.class);
        }
        if (this.isAssignable(OptionalInt.class)) {
            return this.visitorContext.getClassElement(Integer.class);
        }
        return Optional.empty();
    }

    @NonNull
    public List<? extends ClassElement> getBoundGenericTypes() {
        GenericsType[] genericsTypes = this.classNode.getGenericsTypes();
        if (genericsTypes == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(genericsTypes).map(gt -> this.newClassElement((GenericsType)gt)).toList();
    }

    @NonNull
    public List<? extends GenericPlaceholderElement> getDeclaredGenericPlaceholders() {
        return this.getBoundGenericTypes();
    }

    private List<PropertyNode> getPropertyNodes() {
        ArrayList propertyNodes = new ArrayList();
        for (ClassNode classNode = this.classNode; classNode != null && !classNode.equals((Object)ClassHelper.OBJECT_TYPE) && !classNode.equals((Object)ClassHelper.Enum_Type); classNode = classNode.getSuperClass()) {
            propertyNodes.addAll(classNode.getProperties());
        }
        ArrayList<PropertyNode> propertyElements = new ArrayList<PropertyNode>();
        for (PropertyNode propertyNode : propertyNodes) {
            if (!propertyNode.isPublic()) continue;
            propertyElements.add(propertyNode);
        }
        return propertyElements;
    }

    public ClassElement getType() {
        if (this.theType == null) {
            GroovyNativeElement nativeType = this.getNativeType();
            ClassNode thisClassNode = (ClassNode)nativeType.annotatedNode();
            ClassNode redirect = thisClassNode.redirect();
            this.theType = new GroovyClassElement(this.visitorContext, new GroovyNativeElement.Class(redirect), this.elementAnnotationMetadataFactory, this.resolvedTypeArguments, this.arrayDimensions, this.isTypeVar);
        }
        return this.theType;
    }

    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getTypeAnnotationMetadata() {
        if (this.elementTypeAnnotationMetadata == null) {
            this.elementTypeAnnotationMetadata = this.elementAnnotationMetadataFactory.buildTypeAnnotations((ClassElement)this);
        }
        return this.elementTypeAnnotationMetadata;
    }

    private final class GroovyEnclosedElementsQuery
    extends EnclosedElementsQuery<ClassNode, AnnotatedNode> {
        private final boolean isSource;

        private GroovyEnclosedElementsQuery(boolean isSource) {
            this.isSource = isSource;
        }

        protected boolean hasAnnotation(AnnotatedNode element, Class<? extends Annotation> annotation) {
            if (element.getAnnotations() != null) {
                return element.getAnnotations().stream().anyMatch(a -> a.getClassNode().getName().equals(annotation.getName()));
            }
            return false;
        }

        protected ClassNode getNativeClassType(ClassElement classElement) {
            return (ClassNode)((GroovyClassElement)classElement).getNativeType().annotatedNode();
        }

        protected String getElementName(AnnotatedNode element) {
            if (element instanceof ClassNode) {
                ClassNode cn = (ClassNode)element;
                return cn.getName();
            }
            if (element instanceof MethodNode) {
                MethodNode methodNode = (MethodNode)element;
                return methodNode.getName();
            }
            if (element instanceof FieldNode) {
                FieldNode fieldNode = (FieldNode)element;
                return fieldNode.getName();
            }
            return "";
        }

        protected Set<AnnotatedNode> getExcludedNativeElements(ElementQuery.Result<?> result) {
            if (result.isExcludePropertyElements()) {
                HashSet<AnnotatedNode> excluded = new HashSet<AnnotatedNode>();
                for (PropertyElement excludePropertyElement : GroovyClassElement.this.getBeanProperties()) {
                    excludePropertyElement.getReadMethod().filter(m -> !m.isSynthetic()).ifPresent(methodElement -> excluded.add(((GroovyNativeElement)methodElement.getNativeType()).annotatedNode()));
                    excludePropertyElement.getWriteMethod().filter(m -> !m.isSynthetic()).ifPresent(methodElement -> excluded.add(((GroovyNativeElement)methodElement.getNativeType()).annotatedNode()));
                    excludePropertyElement.getField().ifPresent(fieldElement -> excluded.add(((GroovyNativeElement)fieldElement.getNativeType()).annotatedNode()));
                }
                return excluded;
            }
            return super.getExcludedNativeElements(result);
        }

        protected ClassNode getSuperClass(ClassNode classNode) {
            return classNode.getSuperClass();
        }

        protected Collection<ClassNode> getInterfaces(ClassNode classNode) {
            return Arrays.stream(classNode.getInterfaces()).filter(interfaceNode -> !interfaceNode.getName().equals(GroovyObject.class.getName())).toList();
        }

        protected List<AnnotatedNode> getEnclosedElements(ClassNode classNode, ElementQuery.Result<?> result, boolean includeAbstract) {
            Class elementType = result.getElementType();
            return this.getEnclosedElements(classNode, result, elementType, includeAbstract);
        }

        private List<AnnotatedNode> getEnclosedElements(ClassNode classNode, ElementQuery.Result<?> result, Class<?> elementType, boolean includeAbstract) {
            if (elementType == MemberElement.class) {
                return Stream.concat(this.getEnclosedElements(classNode, result, FieldElement.class, includeAbstract).stream(), this.getEnclosedElements(classNode, result, MethodElement.class, includeAbstract).stream()).toList();
            }
            if (elementType == MethodElement.class) {
                return classNode.getMethods().stream().filter(methodNode -> !JUNK_METHOD_FILTER.test((MethodNode)methodNode) && (methodNode.getModifiers() & 0x1000) == 0 && (includeAbstract || this.isNonAbstract(classNode, (MethodNode)methodNode))).map(m -> m).toList();
            }
            if (elementType == FieldElement.class) {
                return classNode.getFields().stream().filter(fieldNode -> (!fieldNode.isEnum() || result.isIncludeEnumConstants()) && !JUNK_FIELD_FILTER.test((FieldNode)fieldNode) && (fieldNode.getModifiers() & 0x1000) == 0).map(m -> m).toList();
            }
            if (elementType == ConstructorElement.class) {
                return classNode.getDeclaredConstructors().stream().filter(methodNode -> !JUNK_METHOD_FILTER.test((MethodNode)methodNode) && (methodNode.getModifiers() & 0x1000) == 0).map(m -> m).toList();
            }
            if (elementType == ClassElement.class) {
                return StreamSupport.stream(Spliterators.spliteratorUnknownSize(classNode.getInnerClasses(), 16), false).filter(innerClassNode -> (innerClassNode.getModifiers() & 0x1000) == 0).map(m -> m).toList();
            }
            throw new IllegalStateException("Unknown result type: " + elementType);
        }

        private boolean isNonAbstract(ClassNode classNode, MethodNode methodNode) {
            if (methodNode.isDefault()) {
                return false;
            }
            if (methodNode.isPrivate() && classNode.isInterface()) {
                return true;
            }
            if (!methodNode.isAbstract() && classNode.isInterface()) {
                return false;
            }
            return !methodNode.isAbstract();
        }

        protected boolean excludeClass(ClassNode classNode) {
            String packageName = Objects.requireNonNullElse(classNode.getPackageName(), "");
            if (packageName.startsWith("org.spockframework.lang") || packageName.startsWith("spock.mock") || packageName.startsWith("spock.lang")) {
                return true;
            }
            String className = classNode.getName();
            return Object.class.getName().equals(className) || Enum.class.getName().equals(className) || GroovyObjectSupport.class.getName().equals(className) || Script.class.getName().equals(className);
        }

        protected boolean isAbstractClass(ClassNode classNode) {
            return classNode.isAbstract();
        }

        protected boolean isInterface(ClassNode classNode) {
            if (classNode.isInterface()) {
                return true;
            }
            List annotations = classNode.getAnnotations();
            if (annotations != null) {
                return annotations.stream().anyMatch(a -> a.getClassNode().getName().equals(Trait.class.getName()));
            }
            return false;
        }

        protected Element toAstElement(AnnotatedNode nativeType, Class<?> elementType) {
            GroovyElementFactory elementFactory = GroovyClassElement.this.visitorContext.getElementFactory();
            if (this.isSource) {
                if (!(nativeType instanceof ConstructorNode) && nativeType instanceof MethodNode) {
                    MethodNode methodNode = (MethodNode)nativeType;
                    return elementFactory.newSourceMethodElement((ClassElement)GroovyClassElement.this, methodNode, GroovyClassElement.this.elementAnnotationMetadataFactory);
                }
                if (nativeType instanceof ClassNode) {
                    ClassNode cn = (ClassNode)nativeType;
                    return elementFactory.newSourceClassElement(cn, GroovyClassElement.this.elementAnnotationMetadataFactory);
                }
            }
            if (nativeType instanceof ConstructorNode) {
                ConstructorNode constructorNode = (ConstructorNode)nativeType;
                return elementFactory.newConstructorElement((ClassElement)GroovyClassElement.this, (MethodNode)constructorNode, GroovyClassElement.this.elementAnnotationMetadataFactory);
            }
            if (nativeType instanceof MethodNode) {
                MethodNode methodNode = (MethodNode)nativeType;
                return elementFactory.newMethodElement((ClassElement)GroovyClassElement.this, methodNode, GroovyClassElement.this.elementAnnotationMetadataFactory);
            }
            if (nativeType instanceof FieldNode) {
                FieldNode fieldNode = (FieldNode)nativeType;
                if (fieldNode.isEnum()) {
                    return elementFactory.newEnumConstantElement((ClassElement)GroovyClassElement.this, fieldNode, GroovyClassElement.this.elementAnnotationMetadataFactory);
                }
                return elementFactory.newFieldElement((ClassElement)GroovyClassElement.this, fieldNode, GroovyClassElement.this.elementAnnotationMetadataFactory);
            }
            if (nativeType instanceof ClassNode) {
                ClassNode cn = (ClassNode)nativeType;
                return elementFactory.newClassElement(cn, GroovyClassElement.this.elementAnnotationMetadataFactory);
            }
            throw new IllegalStateException("Unknown element: " + nativeType);
        }
    }
}

