/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import groovy.lang.GroovyClassLoader;
import io.micronaut.ast.groovy.GroovyNativeElementHelper;
import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.ast.groovy.annotation.GroovyElementAnnotationMetadataFactory;
import io.micronaut.ast.groovy.scan.ClassPathAnnotationScanner;
import io.micronaut.ast.groovy.utils.AstMessageUtils;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyBeanDefinitionBuilder;
import io.micronaut.ast.groovy.visitor.GroovyClassWriterOutputVisitor;
import io.micronaut.ast.groovy.visitor.GroovyElementFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.expressions.context.DefaultExpressionCompilationContextFactory;
import io.micronaut.expressions.context.ExpressionCompilationContextFactory;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.visitor.util.VisitorContextUtils;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;

@Internal
public class GroovyVisitorContext
implements VisitorContext {
    private static final MutableConvertibleValues<Object> VISITOR_ATTRIBUTES = new MutableConvertibleValuesMap();
    private final CompilationUnit compilationUnit;
    private final ClassWriterOutputVisitor outputVisitor;
    private final SourceUnit sourceUnit;
    private final MutableConvertibleValues<Object> attributes;
    private final List<String> generatedResources = new ArrayList<String>();
    private final GroovyElementFactory groovyElementFactory;
    private final List<AbstractBeanDefinitionBuilder> beanDefinitionBuilders = new ArrayList<AbstractBeanDefinitionBuilder>();
    private final GroovyElementAnnotationMetadataFactory elementAnnotationMetadataFactory;
    private final ExpressionCompilationContextFactory expressionCompilationContextFactory;
    private final GroovyNativeElementHelper nativeElementHelper;
    private final GroovyAnnotationMetadataBuilder annotationMetadataBuilder;

    public GroovyVisitorContext(SourceUnit sourceUnit, @Nullable CompilationUnit compilationUnit) {
        this(sourceUnit, compilationUnit, new GroovyClassWriterOutputVisitor(compilationUnit));
    }

    public GroovyVisitorContext(SourceUnit sourceUnit, @Nullable CompilationUnit compilationUnit, ClassWriterOutputVisitor outputVisitor) {
        this.sourceUnit = sourceUnit;
        this.compilationUnit = compilationUnit;
        this.outputVisitor = outputVisitor;
        this.attributes = VISITOR_ATTRIBUTES;
        this.nativeElementHelper = new GroovyNativeElementHelper();
        this.groovyElementFactory = new GroovyElementFactory(this);
        this.annotationMetadataBuilder = new GroovyAnnotationMetadataBuilder(sourceUnit, compilationUnit, this.nativeElementHelper, this);
        this.elementAnnotationMetadataFactory = new GroovyElementAnnotationMetadataFactory(false, this.annotationMetadataBuilder);
        this.expressionCompilationContextFactory = new DefaultExpressionCompilationContextFactory((VisitorContext)this);
    }

    public VisitorContext.Language getLanguage() {
        return VisitorContext.Language.GROOVY;
    }

    @NonNull
    public Iterable<URL> getClasspathResources(@NonNull String path) {
        try {
            Enumeration resources = this.compilationUnit.getClassLoader().getResources(path);
            return CollectionUtils.enumerationToIterable((Enumeration)resources);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Optional<ClassElement> getClassElement(String name) {
        return this.getClassElement(name, (ElementAnnotationMetadataFactory)this.getElementAnnotationMetadataFactory());
    }

    public Optional<ClassElement> getClassElement(String name, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        if (name == null) {
            return Optional.empty();
        }
        if (this.compilationUnit == null) {
            return Optional.ofNullable(this.classNodeFromClassLoader(name)).map(cn -> this.groovyElementFactory.newClassElement((ClassNode)cn, annotationMetadataFactory));
        }
        ClassNodeResolver.LookupResult lookupResult = this.compilationUnit.getClassNodeResolver().resolveName(name, this.compilationUnit);
        Optional<ClassNode> classNode = lookupResult != null ? Optional.ofNullable(lookupResult.getClassNode()) : Optional.ofNullable(this.compilationUnit.getClassNode(name));
        ClassNode finalClassNode = classNode.orElseGet(() -> this.classNodeFromClassLoader(name));
        return Optional.ofNullable(finalClassNode).map(cn -> this.groovyElementFactory.newClassElement((ClassNode)cn, annotationMetadataFactory));
    }

    private ClassNode classNodeFromClassLoader(String name) {
        GroovyClassLoader classLoader;
        ClassNode cn = null;
        if (this.sourceUnit != null && (classLoader = this.sourceUnit.getClassLoader()) != null) {
            cn = ClassUtils.forName((String)name, (ClassLoader)classLoader).map(ClassHelper::make).orElse(null);
        }
        return cn;
    }

    public Optional<ClassElement> getClassElement(Class<?> type) {
        ClassNode classNode = ClassHelper.makeCached(type);
        return Optional.of(this.groovyElementFactory.newClassElement(classNode, (ElementAnnotationMetadataFactory)this.getElementAnnotationMetadataFactory()));
    }

    @NonNull
    public ClassElement[] getClassElements(@NonNull String aPackage, String ... stereotypes) {
        ArgumentUtils.requireNonNull((String)"aPackage", (Object)aPackage);
        ArgumentUtils.requireNonNull((String)"stereotypes", (Object)stereotypes);
        if (this.compilationUnit == null) {
            return ClassElement.ZERO_CLASS_ELEMENTS;
        }
        ClassPathAnnotationScanner scanner = new ClassPathAnnotationScanner((ClassLoader)this.compilationUnit.getClassLoader());
        ArrayList classElements = new ArrayList();
        for (String s : stereotypes) {
            scanner.scan(s, aPackage).forEach(aClass -> {
                ClassNode classNode = ClassHelper.make((Class)aClass);
                classElements.add(this.groovyElementFactory.newClassElement(classNode, (ElementAnnotationMetadataFactory)this.getElementAnnotationMetadataFactory()));
            });
        }
        return classElements.toArray(ClassElement.ZERO_CLASS_ELEMENTS);
    }

    @NonNull
    public GroovyElementFactory getElementFactory() {
        return this.groovyElementFactory;
    }

    @NonNull
    public GroovyElementAnnotationMetadataFactory getElementAnnotationMetadataFactory() {
        return this.elementAnnotationMetadataFactory;
    }

    public ExpressionCompilationContextFactory getExpressionCompilationContextFactory() {
        return this.expressionCompilationContextFactory;
    }

    public GroovyAnnotationMetadataBuilder getAnnotationMetadataBuilder() {
        return this.annotationMetadataBuilder;
    }

    public void info(String message, @Nullable Element element) {
        StringBuilder msg = new StringBuilder("Note: ").append(message);
        if (element instanceof AbstractGroovyElement) {
            AbstractGroovyElement abstractGroovyElement = (AbstractGroovyElement)element;
            AnnotatedNode expr = abstractGroovyElement.getNativeType().annotatedNode();
            String sample = this.sourceUnit.getSample(expr.getLineNumber(), expr.getColumnNumber(), new Janitor());
            msg.append("\n\n").append(sample);
        }
        System.out.println(msg);
    }

    public void info(String message) {
        System.out.println("Note: " + message);
    }

    public void fail(String message, @Nullable Element element) {
        if (element instanceof AbstractGroovyElement) {
            AbstractGroovyElement abstractGroovyElement = (AbstractGroovyElement)element;
            AstMessageUtils.error(this.sourceUnit, (ASTNode)abstractGroovyElement.getNativeType().annotatedNode(), message);
        } else {
            AstMessageUtils.error(this.sourceUnit, null, message);
        }
    }

    public final void fail(String message, ASTNode expr) {
        AstMessageUtils.error(this.sourceUnit, expr, message);
    }

    public void warn(String message, @Nullable Element element) {
        if (element instanceof AbstractGroovyElement) {
            AbstractGroovyElement abstractGroovyElement = (AbstractGroovyElement)element;
            AstMessageUtils.warning(this.sourceUnit, (ASTNode)abstractGroovyElement.getNativeType().annotatedNode(), message);
        } else {
            AstMessageUtils.warning(this.sourceUnit, null, message);
        }
    }

    public OutputStream visitClass(String classname, @Nullable Element originatingElement) throws IOException {
        return this.outputVisitor.visitClass(classname, originatingElement);
    }

    public OutputStream visitClass(String classname, Element ... originatingElements) throws IOException {
        return this.outputVisitor.visitClass(classname, originatingElements);
    }

    public void visitServiceDescriptor(String type, String classname) {
        this.outputVisitor.visitServiceDescriptor(type, classname);
    }

    public void visitServiceDescriptor(String type, String classname, Element originatingElement) {
        this.outputVisitor.visitServiceDescriptor(type, classname, originatingElement);
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path, Element ... originatingElements) {
        return this.outputVisitor.visitMetaInfFile(path, originatingElements);
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return this.outputVisitor.visitGeneratedFile(path);
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path, Element ... originatingElements) {
        return this.outputVisitor.visitGeneratedFile(path, originatingElements);
    }

    public Optional<GeneratedFile> visitGeneratedSourceFile(String packageName, String fileNameWithoutExtension, Element ... originatingElements) {
        return this.outputVisitor.visitGeneratedSourceFile(packageName, fileNameWithoutExtension, originatingElements);
    }

    public void finish() {
        this.outputVisitor.finish();
    }

    SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Internal
    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @Internal
    public GroovyNativeElementHelper getNativeElementHelper() {
        return this.nativeElementHelper;
    }

    public Map<String, String> getOptions() {
        return VisitorContextUtils.getSystemOptions();
    }

    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        return this.attributes.put(key, value);
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        return this.attributes.remove(key);
    }

    public MutableConvertibleValues<Object> clear() {
        return this.attributes.clear();
    }

    public Set<String> names() {
        return this.attributes.names();
    }

    public Collection<Object> values() {
        return this.attributes.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.attributes.get(name, conversionContext);
    }

    public Collection<String> getGeneratedResources() {
        return Collections.unmodifiableCollection(this.generatedResources);
    }

    public void addGeneratedResource(@NonNull String resource) {
        this.generatedResources.add(resource);
    }

    @Internal
    public List<AbstractBeanDefinitionBuilder> getBeanElementBuilders() {
        ArrayList<AbstractBeanDefinitionBuilder> current = new ArrayList<AbstractBeanDefinitionBuilder>(this.beanDefinitionBuilders);
        this.beanDefinitionBuilders.clear();
        return current;
    }

    @Internal
    void addBeanDefinitionBuilder(GroovyBeanDefinitionBuilder groovyBeanDefinitionBuilder) {
        this.beanDefinitionBuilders.add(groovyBeanDefinitionBuilder);
    }
}

