/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy;

import groovy.lang.GroovyObject;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.utils.NativeElementsHelper;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;

@Internal
public final class GroovyNativeElementHelper
extends NativeElementsHelper<ClassNode, MethodNode> {
    protected boolean overrides(MethodNode subMethod, MethodNode superMethod, ClassNode owner) {
        Parameter[] subParameters;
        Parameter[] superParameters = superMethod.getParameters();
        if (superParameters.length != (subParameters = subMethod.getParameters()).length || !subMethod.getName().equals(superMethod.getName())) {
            return false;
        }
        int n = superParameters.length;
        for (int i = 0; i < n; ++i) {
            ClassNode superType = superParameters[i].getType();
            ClassNode subType = subParameters[i].getType();
            if (this.isAssignable(subType, superType)) continue;
            return false;
        }
        ClassNode subDeclaringClass = subMethod.getDeclaringClass();
        ClassNode superDeclaringClass = superMethod.getDeclaringClass();
        return this.isAssignable(subDeclaringClass, superDeclaringClass);
    }

    private boolean isAssignable(ClassNode c1, ClassNode c2) {
        if (c1.equals((Object)c2)) {
            return true;
        }
        if (c2.isInterface()) {
            return c1.implementsInterface(c2);
        }
        return c1.isDerivedFrom(c2);
    }

    @NonNull
    protected String getMethodName(MethodNode element) {
        return element.getName();
    }

    protected ClassNode getSuperClass(ClassNode classNode) {
        return classNode.getSuperClass();
    }

    @NonNull
    protected Collection<ClassNode> getInterfaces(ClassNode classNode) {
        return List.of(classNode.getInterfaces());
    }

    @NonNull
    protected List<MethodNode> getMethods(ClassNode classNode) {
        return classNode.getMethods();
    }

    protected boolean excludeClass(ClassNode classNode) {
        return classNode.getName().equals(Object.class.getName()) || classNode.getName().equals(GroovyObject.class.getName());
    }

    protected boolean isInterface(ClassNode classNode) {
        return classNode.isInterface();
    }
}

