/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

final class JavaFileObjects {
    private JavaFileObjects() {
    }

    static JavaFileObject forSourceString(String fullyQualifiedName, String source) {
        Objects.requireNonNull(fullyQualifiedName);
        if (fullyQualifiedName.startsWith("package ")) {
            throw new IllegalArgumentException(String.format("fullyQualifiedName starts with \"package\" (%s). Did you forget to specify the name and specify just the source text?", fullyQualifiedName));
        }
        return new StringSourceJavaFileObject(fullyQualifiedName, Objects.requireNonNull(source));
    }

    static JavaFileObject forSourceLines(String fullyQualifiedName, String ... lines) {
        return JavaFileObjects.forSourceLines(fullyQualifiedName, Arrays.asList(lines));
    }

    static JavaFileObject forSourceLines(String fullyQualifiedName, Iterable<String> lines) {
        return JavaFileObjects.forSourceString(fullyQualifiedName, String.join((CharSequence)"\n", lines));
    }

    private static final class StringSourceJavaFileObject
    extends SimpleJavaFileObject {
        final String source;
        final long lastModified;

        StringSourceJavaFileObject(String fullyQualifiedName, String source) {
            super(StringSourceJavaFileObject.createUri(fullyQualifiedName), JavaFileObject.Kind.SOURCE);
            this.source = source;
            this.lastModified = System.currentTimeMillis();
        }

        private static URI createUri(String fullyQualifiedClassName) {
            return URI.create(fullyQualifiedClassName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }

        @Override
        public OutputStream openOutputStream() {
            throw new IllegalStateException();
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.source.getBytes(Charset.defaultCharset()));
        }

        @Override
        public Writer openWriter() {
            throw new IllegalStateException();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) {
            return new StringReader(this.source);
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }
    }
}

