/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import io.micronaut.annotation.processing.test.JavaFileObjects;
import io.micronaut.annotation.processing.test.JavaParser;
import java.io.File;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public final class Parser {
    private static final TreeScanner<Boolean, Boolean> HAS_ERRONEOUS_NODE = new TreeScanner<Boolean, Boolean>(){

        @Override
        public Boolean visitErroneous(ErroneousTree node, Boolean p) {
            return true;
        }

        @Override
        public Boolean scan(Iterable<? extends Tree> nodes, Boolean p) {
            for (Tree tree : nodes) {
                if (!Parser.isTrue(this.scan(tree, p))) continue;
                return true;
            }
            return p;
        }

        @Override
        public Boolean scan(Tree tree, Boolean p) {
            return Parser.isTrue(p) ? p : (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return Parser.isTrue(r1) || Parser.isTrue(r2);
        }
    };

    public static boolean hasErrorNode(Tree tree) {
        return Parser.isTrue(HAS_ERRONEOUS_NODE.scan(tree, (Boolean)false));
    }

    public static Iterable<? extends Element> parse(JavaFileObject ... sources) {
        try (JavaParser javaParser = new JavaParser();){
            Iterable<? extends Element> iterable = javaParser.parse(sources);
            return iterable;
        }
    }

    public static Iterable<? extends Element> parseLines(String className, String ... lines) {
        return Parser.parse(JavaFileObjects.forSourceLines(className.replace('.', File.separatorChar) + ".java", lines));
    }

    public static Iterable<? extends JavaFileObject> generate(String className, String code) {
        return Parser.generate(JavaFileObjects.forSourceString(className, code));
    }

    public static Iterable<? extends JavaFileObject> generate(JavaFileObject ... sources) {
        try (JavaParser javaParser = new JavaParser();){
            Iterable<? extends JavaFileObject> iterable = javaParser.generate(sources);
            return iterable;
        }
    }

    private static boolean isTrue(Boolean p) {
        return Boolean.TRUE.equals(p);
    }
}

