/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.tools.JavaFileObject;
import org.codehaus.groovy.runtime.IOGroovyMethods;

final class JavaFileObjectClassLoader
extends ClassLoader {
    private final Collection<JavaFileObject> files = new ArrayList<JavaFileObject>();

    public JavaFileObjectClassLoader(Iterable<? extends JavaFileObject> files) {
        for (JavaFileObject javaFileObject : files) {
            this.files.add(javaFileObject);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String fileName = name.replace('.', '/') + ".class";
        JavaFileObject generated = this.files.stream().filter(it -> it.getName().endsWith(fileName)).findFirst().orElse(null);
        if (generated == null) return super.findClass(name);
        try (InputStream io = generated.openInputStream();){
            byte[] bytes = IOGroovyMethods.getBytes((InputStream)io);
            Class<?> clazz = super.defineClass(name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException e) {
            return super.findClass(name);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        String fileName = "/CLASS_OUTPUT/" + name;
        final JavaFileObject generated = this.files.stream().filter(it -> it.getName().equals(fileName)).findFirst().orElse(null);
        if (generated == null) {
            return super.findResources(name);
        }
        URL url = new URL(null, generated.toUri().toString(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) {
                return new URLConnection(u){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return generated.openInputStream();
                    }
                };
            }
        });
        return Collections.enumeration(Collections.singletonList(url));
    }
}

