/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.inject.processing.JavaModelUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor8;
import javax.lang.model.util.Types;

public abstract class SuperclassAwareTypeVisitor<R, P>
extends AbstractTypeVisitor8<R, P> {
    private final Set<String> processed = new HashSet<String>();
    private final Types types;

    protected SuperclassAwareTypeVisitor(Types types) {
        this.types = types;
    }

    @Override
    public R visitDeclared(DeclaredType type, P p) {
        Element element = type.asElement();
        while (JavaModelUtils.isClassOrInterface((Element)element) && !element.toString().equals(Object.class.getName())) {
            TypeElement typeElement = (TypeElement)element;
            List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
            for (Element element2 : enclosedElements) {
                boolean isAcceptable = this.isAcceptable(element2);
                if (!isAcceptable) continue;
                if (element2 instanceof ExecutableElement) {
                    ExecutableElement ee = (ExecutableElement)element2;
                    String qualifiedName = ee.getSimpleName().toString();
                    qualifiedName = qualifiedName + "(" + ee.getParameters().stream().map(variableElement -> this.types.erasure(variableElement.asType()).toString()).collect(Collectors.joining(",")) + ")";
                    qualifiedName = this.types.erasure(ee.getReturnType()).toString() + "." + qualifiedName;
                    if (this.processed.contains(qualifiedName)) continue;
                    this.processed.add(qualifiedName);
                    this.accept(type, element2, p);
                    continue;
                }
                String qualifiedName = this.types.erasure(element2.asType()).toString() + "." + element2.getSimpleName().toString();
                if (this.processed.contains(qualifiedName)) continue;
                this.processed.add(qualifiedName);
                this.accept(type, element2, p);
            }
            List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
            for (TypeMirror anInterface : interfaces) {
                if (!(anInterface instanceof DeclaredType)) continue;
                DeclaredType interfaceType = (DeclaredType)anInterface;
                this.visitDeclared(interfaceType, p);
            }
            TypeMirror typeMirror = typeElement.getSuperclass();
            if (!(typeMirror instanceof DeclaredType)) break;
            element = ((DeclaredType)typeMirror).asElement();
        }
        return null;
    }

    protected abstract boolean isAcceptable(Element var1);

    protected abstract void accept(DeclaredType var1, Element var2, P var3);

    @Override
    public R visitIntersection(IntersectionType t, P p) {
        return null;
    }

    @Override
    public R visitPrimitive(PrimitiveType t, P p) {
        return null;
    }

    @Override
    public R visitNull(NullType t, P p) {
        return null;
    }

    @Override
    public R visitArray(ArrayType t, P p) {
        return null;
    }

    @Override
    public R visitError(ErrorType t, P p) {
        return null;
    }

    @Override
    public R visitTypeVariable(TypeVariable t, P p) {
        return null;
    }

    @Override
    public R visitWildcard(WildcardType t, P p) {
        return null;
    }

    @Override
    public R visitExecutable(ExecutableType t, P p) {
        return null;
    }

    @Override
    public R visitNoType(NoType t, P p) {
        return null;
    }

    @Override
    public R visitUnion(UnionType t, P p) {
        return null;
    }
}

