/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@Internal
class ExecutableElementParamInfo {
    private boolean requiresReflection;
    private AnnotationMetadata metadata;
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private Map<String, Object> genericParameters = new LinkedHashMap<String, Object>();
    private Map<String, AnnotationMetadata> annotationMetadata = new LinkedHashMap<String, AnnotationMetadata>();
    private Map<String, Map<String, Object>> genericTypes = new LinkedHashMap<String, Map<String, Object>>();

    ExecutableElementParamInfo(boolean requiresReflection, AnnotationMetadata metadata) {
        this.requiresReflection = requiresReflection;
        this.metadata = metadata != null ? metadata : AnnotationMetadata.EMPTY_METADATA;
    }

    void addParameter(String paramName, Object type, Object genericType) {
        this.parameters.put(paramName, type);
        this.genericParameters.put(paramName, genericType);
    }

    void addAnnotationMetadata(String paramName, AnnotationMetadata metadata) {
        this.annotationMetadata.put(paramName, metadata);
    }

    void addGenericTypes(String paramName, Map<String, Object> generics) {
        this.genericTypes.put(paramName, generics);
    }

    Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    Map<String, Object> getGenericParameters() {
        return Collections.unmodifiableMap(this.genericParameters);
    }

    Map<String, AnnotationMetadata> getParameterMetadata() {
        return Collections.unmodifiableMap(this.annotationMetadata);
    }

    Map<String, Map<String, Object>> getGenericTypes() {
        return Collections.unmodifiableMap(this.genericTypes);
    }

    boolean isRequiresReflection() {
        return this.requiresReflection;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.metadata;
    }
}

