/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class ModelUtils {
    private final Elements elementUtils;
    private final Types typeUtils;

    protected ModelUtils(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    public Types getTypeUtils() {
        return this.typeUtils;
    }

    @Nullable
    public final TypeElement classElementFor(Element element) {
        while (element != null && !JavaModelUtils.isClassOrInterface((Element)element) && !JavaModelUtils.isEnum((Element)element)) {
            element = element.getEnclosingElement();
        }
        if (element instanceof TypeElement) {
            return (TypeElement)element;
        }
        return null;
    }

    String simpleBinaryNameFor(TypeElement typeElement) {
        Name elementBinaryName = this.elementUtils.getBinaryName(typeElement);
        PackageElement packageElement = this.elementUtils.getPackageOf(typeElement);
        String packageName = packageElement.getQualifiedName().toString();
        return elementBinaryName.toString().replaceFirst(packageName + "\\.", "");
    }

    Optional<ExecutableElement> findGetterMethodFor(Element field) {
        String getterName = this.getterNameFor(field);
        TypeElement typeElement = this.classElementFor(field);
        if (typeElement == null) {
            return Optional.empty();
        }
        List<? extends Element> elements = typeElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
        return methods.stream().filter(method -> {
            String methodName = method.getSimpleName().toString();
            if (getterName.equals(methodName)) {
                Set<Modifier> modifiers = method.getModifiers();
                return !modifiers.contains((Object)Modifier.STATIC) && modifiers.contains((Object)Modifier.PUBLIC) || !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PROTECTED);
            }
            return false;
        }).findFirst();
    }

    Optional<ExecutableElement> findSetterMethodFor(Element field) {
        String name = field.getSimpleName().toString();
        if (field.asType().getKind() == TypeKind.BOOLEAN && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
            name = name.replaceFirst("^(is)(.+)", "$2");
        }
        String setterName = this.setterNameFor(name);
        TypeElement typeElement = this.classElementFor(field);
        if (typeElement == null) {
            return Optional.empty();
        }
        List<? extends Element> elements = typeElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
        return methods.stream().filter(method -> {
            String methodName = method.getSimpleName().toString();
            if (setterName.equals(methodName)) {
                Set<Modifier> modifiers = method.getModifiers();
                return !modifiers.contains((Object)Modifier.STATIC) && modifiers.contains((Object)Modifier.PUBLIC) || !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PROTECTED);
            }
            return false;
        }).findFirst();
    }

    String getterNameFor(Element field) {
        String methodNamePrefix = "get";
        if (field.asType().getKind() == TypeKind.BOOLEAN) {
            methodNamePrefix = "is";
        }
        return methodNamePrefix + NameUtils.capitalize((String)field.getSimpleName().toString());
    }

    String setterNameFor(String fieldName) {
        return "set" + NameUtils.capitalize((String)fieldName);
    }

    @Nullable
    public ExecutableElement concreteConstructorFor(TypeElement classElement, AnnotationUtils annotationUtils) {
        List<ExecutableElement> constructors = this.findNonPrivateConstructors(classElement);
        if (constructors.isEmpty()) {
            return null;
        }
        if (constructors.size() == 1) {
            return constructors.get(0);
        }
        Optional<ExecutableElement> element = constructors.stream().filter(ctor -> {
            AnnotationMetadata annotationMetadata = annotationUtils.getAnnotationMetadata((Element)ctor);
            return annotationMetadata.hasStereotype(Inject.class) || annotationMetadata.hasStereotype(Creator.class);
        }).findFirst();
        if (!element.isPresent()) {
            element = constructors.stream().filter(ctor -> ctor.getModifiers().contains((Object)Modifier.PUBLIC)).findFirst();
        }
        return element.orElse(null);
    }

    List<ExecutableElement> findNonPrivateConstructors(TypeElement classElement) {
        List<ExecutableElement> ctors = ElementFilter.constructorsIn(classElement.getEnclosedElements());
        return ctors.stream().filter(ctor -> !ctor.getModifiers().contains((Object)Modifier.PRIVATE)).collect(Collectors.toList());
    }

    Optional<ExecutableElement> findAccessibleNoArgumentInstanceMethod(TypeElement classElement, String methodName) {
        return ElementFilter.methodsIn(this.elementUtils.getAllMembers(classElement)).stream().filter(m -> m.getSimpleName().toString().equals(methodName) && !this.isPrivate((Element)m) && !this.isStatic((Element)m)).findFirst();
    }

    Class<?> classOfPrimitiveFor(String primitiveType) {
        return (Class)ClassUtils.getPrimitiveType((String)primitiveType).orElseThrow(() -> new IllegalArgumentException("Unknown primitive type: " + primitiveType));
    }

    Class<?> classOfPrimitiveArrayFor(String primitiveType) {
        return (Class)ClassUtils.arrayTypeForPrimitive((String)primitiveType).orElseThrow(() -> new IllegalArgumentException("Unsupported primitive type " + primitiveType));
    }

    TypeElement superClassFor(TypeElement element) {
        TypeMirror superclass = element.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        DeclaredType kind = (DeclaredType)superclass;
        return (TypeElement)kind.asElement();
    }

    Object resolveTypeReference(TypeElement typeElement) {
        TypeMirror type = typeElement.asType();
        if (type != null) {
            return this.resolveTypeReference(type);
        }
        return typeElement.getQualifiedName().toString();
    }

    boolean isObjectClass(TypeElement element) {
        return element.getSuperclass().getKind() == TypeKind.NONE;
    }

    @Nullable
    Object resolveTypeReference(Element element) {
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return this.resolveTypeReferenceForTypeElement(typeElement);
        }
        return null;
    }

    String resolveTypeReferenceForTypeElement(TypeElement typeElement) {
        return JavaModelUtils.getClassName((TypeElement)typeElement);
    }

    String resolveTypeName(TypeMirror type) {
        Object reference = this.resolveTypeReference(type);
        if (reference instanceof Class) {
            return ((Class)reference).getName();
        }
        return reference.toString();
    }

    Object resolveTypeReference(TypeMirror type) {
        TypeMirror erased;
        Element element;
        Object result = Void.TYPE;
        if (type.getKind().isPrimitive()) {
            result = this.resolvePrimitiveTypeReference(type);
        } else if (type.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            TypeMirror componentType = arrayType.getComponentType();
            if (componentType.getKind().isPrimitive()) {
                result = this.classOfPrimitiveArrayFor(this.resolvePrimitiveTypeReference(componentType).getName());
            } else {
                TypeMirror erased2 = this.typeUtils.erasure(componentType);
                Element e = this.typeUtils.asElement(erased2);
                if (e instanceof TypeElement) {
                    result = this.resolveTypeReferenceForTypeElement((TypeElement)e) + "[]";
                }
            }
        } else if (type.getKind() != TypeKind.VOID && type.getKind() != TypeKind.ERROR && (element = this.typeUtils.asElement(erased = this.typeUtils.erasure(type))) instanceof TypeElement) {
            TypeElement te = (TypeElement)element;
            result = this.resolveTypeReferenceForTypeElement(te);
        }
        return result;
    }

    boolean isPackagePrivate(Element element) {
        Set<Modifier> modifiers = element.getModifiers();
        return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    boolean isInheritedAndNotPublic(TypeElement concreteClass, TypeElement declaringClass, Element methodOrField) {
        PackageElement packageOfDeclaringClass = this.elementUtils.getPackageOf(declaringClass);
        PackageElement packageOfConcreteClass = this.elementUtils.getPackageOf(concreteClass);
        return declaringClass != concreteClass && !packageOfDeclaringClass.getQualifiedName().equals(packageOfConcreteClass.getQualifiedName()) && (this.isProtected(methodOrField) || !this.isPublic(methodOrField));
    }

    Optional<ExecutableElement> overridingOrHidingMethod(ExecutableElement overridden, TypeElement classElement, boolean strict) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.elementUtils.getAllMembers(classElement));
        for (ExecutableElement method : methods) {
            if (!(strict ? this.elementUtils.overrides(method, overridden, classElement) : !method.equals(overridden) && method.getSimpleName().equals(overridden.getSimpleName()))) continue;
            return Optional.of(method);
        }
        TypeElement superClass = this.superClassFor(classElement);
        if (superClass != null && !this.isObjectClass(superClass)) {
            return this.overridingOrHidingMethod(overridden, superClass, strict);
        }
        return Optional.empty();
    }

    boolean isPrivate(Element element) {
        return element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    boolean isProtected(Element element) {
        return element.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    boolean isPublic(Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    boolean isOptional(TypeMirror mirror) {
        return this.typeUtils.erasure(mirror).toString().equals(Optional.class.getName());
    }

    private Class resolvePrimitiveTypeReference(TypeMirror type) {
        Class<?> result;
        if (type instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)type;
            result = this.classOfPrimitiveFor(dt.asElement().getSimpleName().toString());
        } else if (type instanceof PrimitiveType) {
            PrimitiveType pt = (PrimitiveType)type;
            TypeKind kind = pt.getKind();
            switch (kind) {
                case VOID: {
                    return Void.TYPE;
                }
                case INT: {
                    return Integer.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
            }
            result = this.classOfPrimitiveFor(type.toString());
        } else {
            result = this.classOfPrimitiveFor(type.toString());
        }
        return result;
    }

    public Optional<ElementKind> resolveKind(Element element, ElementKind expected) {
        Optional<ElementKind> elementKind = this.resolveKind(element);
        if (elementKind.isPresent() && elementKind.get() == expected) {
            return elementKind;
        }
        return Optional.empty();
    }

    public Optional<ElementKind> resolveKind(Element element) {
        if (element != null) {
            try {
                ElementKind kind = element.getKind();
                return Optional.of(kind);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

