/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class GenericUtils {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final ModelUtils modelUtils;

    protected GenericUtils(Elements elementUtils, Types typeUtils, ModelUtils modelUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.modelUtils = modelUtils;
    }

    Map<String, Map<String, Object>> buildGenericTypeArgumentInfo(DeclaredType dt) {
        Element element = dt.asElement();
        return this.buildGenericTypeArgumentInfo(element, dt);
    }

    public Map<String, Map<String, Object>> buildGenericTypeArgumentInfo(@Nonnull Element element) {
        return this.buildGenericTypeArgumentInfo(element, null);
    }

    public Map<String, Map<String, TypeMirror>> buildGenericTypeArgumentElementInfo(@Nonnull Element element) {
        Map<String, Map<String, Object>> data = this.buildGenericTypeArgumentInfo(element, null);
        HashMap<String, Map<String, TypeMirror>> elements = new HashMap<String, Map<String, TypeMirror>>(data.size());
        for (Map.Entry<String, Map<String, Object>> entry : data.entrySet()) {
            Map<String, Object> value = entry.getValue();
            HashMap<String, TypeMirror> submap = new HashMap<String, TypeMirror>(value.size());
            for (Map.Entry<String, Object> genericEntry : value.entrySet()) {
                TypeElement te = this.elementUtils.getTypeElement(genericEntry.getValue().toString());
                if (te == null) continue;
                submap.put(genericEntry.getKey(), te.asType());
            }
            elements.put(entry.getKey(), submap);
        }
        return elements;
    }

    private Map<String, Map<String, Object>> buildGenericTypeArgumentInfo(@Nonnull Element element, @Nullable DeclaredType dt) {
        List<? extends TypeMirror> typeArguments;
        HashMap<String, Map<String, Object>> beanTypeArguments = new HashMap<String, Map<String, Object>>();
        if (dt != null && CollectionUtils.isNotEmpty(typeArguments = dt.getTypeArguments())) {
            TypeElement typeElement = (TypeElement)element;
            Map<String, Object> directTypeArguments = this.resolveBoundTypes(dt);
            if (CollectionUtils.isNotEmpty(directTypeArguments)) {
                beanTypeArguments.put(typeElement.getQualifiedName().toString(), directTypeArguments);
            }
        }
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            this.populateTypeArguments(typeElement, beanTypeArguments);
        }
        return beanTypeArguments;
    }

    protected TypeMirror interfaceGenericTypeFor(TypeElement element, Class interfaceType) {
        return this.interfaceGenericTypeFor(element, interfaceType.getName());
    }

    protected TypeMirror interfaceGenericTypeFor(TypeElement element, String interfaceName) {
        List<? extends TypeMirror> typeMirrors = this.interfaceGenericTypesFor(element, interfaceName);
        return typeMirrors.isEmpty() ? null : typeMirrors.get(0);
    }

    public List<? extends TypeMirror> interfaceGenericTypesFor(TypeElement element, String interfaceName) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement te;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Element declaredElement = declaredType.asElement();
            if (!(declaredElement instanceof TypeElement) || !interfaceName.equals((te = (TypeElement)declaredElement).getQualifiedName().toString())) continue;
            return declaredType.getTypeArguments();
        }
        return Collections.emptyList();
    }

    protected Optional<TypeMirror> getFirstTypeArgument(TypeMirror type) {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        TypeMirror typeMirror = null;
        if (type instanceof DeclaredType && CollectionUtils.isNotEmpty(typeArguments = (declaredType = (DeclaredType)type).getTypeArguments())) {
            typeMirror = typeArguments.get(0);
        }
        return Optional.ofNullable(typeMirror);
    }

    protected Map<String, Object> resolveGenericTypes(TypeMirror type, Map<String, Object> boundTypes) {
        TypeVariable var;
        TypeMirror upperBound;
        if (type.getKind().isPrimitive() || type.getKind() == TypeKind.VOID || type.getKind() == TypeKind.ARRAY) {
            return Collections.emptyMap();
        }
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            return this.resolveGenericTypes(declaredType, (TypeElement)declaredType.asElement(), boundTypes);
        }
        if (type instanceof TypeVariable && (upperBound = (var = (TypeVariable)type).getUpperBound()) instanceof DeclaredType) {
            return this.resolveGenericTypes(upperBound, boundTypes);
        }
        return Collections.emptyMap();
    }

    protected Map<String, Object> resolveGenericTypes(DeclaredType type, TypeElement typeElement, Map<String, Object> boundTypes) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        LinkedHashMap<String, Object> resolvedParameters = new LinkedHashMap<String, Object>();
        List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
        if (typeArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                String parameterName = typeParameterElement.toString();
                TypeMirror mirror = i.next();
                TypeKind kind = mirror.getKind();
                switch (kind) {
                    case TYPEVAR: {
                        TypeVariable tv = (TypeVariable)mirror;
                        if (boundTypes.containsKey(tv.toString())) {
                            resolvedParameters.put(parameterName, boundTypes.get(tv.toString()));
                            break;
                        }
                        TypeMirror upperBound = tv.getUpperBound();
                        TypeMirror lowerBound = tv.getLowerBound();
                        if (upperBound.getKind() != TypeKind.NULL) {
                            resolvedParameters.put(parameterName, this.resolveTypeReference(upperBound, boundTypes));
                            break;
                        }
                        if (lowerBound.getKind() == TypeKind.NULL) break;
                        resolvedParameters.put(parameterName, this.resolveTypeReference(lowerBound, boundTypes));
                        break;
                    }
                    case ARRAY: 
                    case BOOLEAN: 
                    case BYTE: 
                    case CHAR: 
                    case DOUBLE: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case SHORT: {
                        this.resolveGenericTypeParameterForPrimitiveOrArray(resolvedParameters, parameterName, mirror, boundTypes);
                        break;
                    }
                    case DECLARED: {
                        this.resolveGenericTypeParameter(resolvedParameters, parameterName, mirror, boundTypes);
                        break;
                    }
                    case WILDCARD: {
                        WildcardType wcType = (WildcardType)mirror;
                        TypeMirror extendsBound = wcType.getExtendsBound();
                        TypeMirror superBound = wcType.getSuperBound();
                        if (extendsBound != null) {
                            this.resolveGenericTypeParameter(resolvedParameters, parameterName, extendsBound, boundTypes);
                            break;
                        }
                        if (superBound != null) {
                            if (superBound instanceof TypeVariable) {
                                TypeVariable superTypeVar = (TypeVariable)superBound;
                                TypeMirror upperBound = superTypeVar.getUpperBound();
                                if (upperBound == null || type.equals(upperBound)) break;
                                this.resolveGenericTypeParameter(resolvedParameters, parameterName, superBound, boundTypes);
                                break;
                            }
                            this.resolveGenericTypeParameter(resolvedParameters, parameterName, superBound, boundTypes);
                            break;
                        }
                        resolvedParameters.put(parameterName, Object.class);
                    }
                }
            }
        }
        return resolvedParameters;
    }

    protected Object resolveTypeReference(TypeMirror mirror) {
        return this.resolveTypeReference(mirror, Collections.emptyMap());
    }

    protected Object resolveTypeReference(TypeMirror mirror, Map<String, Object> boundTypes) {
        TypeKind kind = mirror.getKind();
        switch (kind) {
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)mirror;
                String name = tv.toString();
                if (boundTypes.containsKey(name)) {
                    return boundTypes.get(name);
                }
                return this.resolveTypeReference(tv.getUpperBound(), boundTypes);
            }
            case WILDCARD: {
                WildcardType wcType = (WildcardType)mirror;
                TypeMirror extendsBound = wcType.getExtendsBound();
                TypeMirror superBound = wcType.getSuperBound();
                if (extendsBound == null && superBound == null) {
                    return Object.class.getName();
                }
                if (extendsBound != null) {
                    return this.resolveTypeReference(this.typeUtils.erasure(extendsBound), boundTypes);
                }
                if (superBound != null) {
                    return this.resolveTypeReference(superBound, boundTypes);
                }
                return this.resolveTypeReference(this.typeUtils.getWildcardType(extendsBound, superBound), boundTypes);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)mirror;
                Object reference = this.resolveTypeReference(arrayType.getComponentType(), boundTypes);
                if (reference instanceof Class) {
                    Class componentType = (Class)reference;
                    return Array.newInstance(componentType, 0).getClass();
                }
                if (reference instanceof String) {
                    return reference + "[]";
                }
                return this.modelUtils.resolveTypeReference(mirror);
            }
        }
        return this.modelUtils.resolveTypeReference(mirror);
    }

    protected DeclaredType resolveTypeVariable(Element element, TypeVariable typeVariable) {
        Element enclosing = element.getEnclosingElement();
        while (enclosing instanceof Parameterizable) {
            Parameterizable parameterizable = (Parameterizable)enclosing;
            String name = typeVariable.toString();
            for (TypeParameterElement typeParameterElement : parameterizable.getTypeParameters()) {
                List<? extends TypeMirror> bounds;
                if (!name.equals(typeParameterElement.toString()) || (bounds = typeParameterElement.getBounds()).size() != 1) continue;
                TypeMirror typeMirror = bounds.get(0);
                TypeKind kind = typeMirror.getKind();
                switch (kind) {
                    case DECLARED: {
                        return (DeclaredType)typeMirror;
                    }
                    case TYPEVAR: {
                        return this.resolveTypeVariable(element, (TypeVariable)typeMirror);
                    }
                }
                return null;
            }
            enclosing = enclosing.getEnclosingElement();
        }
        return null;
    }

    protected Map<String, Object> resolveBoundTypes(DeclaredType type) {
        LinkedHashMap<String, Object> boundTypes = new LinkedHashMap<String, Object>(2);
        TypeElement element = (TypeElement)type.asElement();
        List<? extends TypeParameterElement> typeParameters = element.getTypeParameters();
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                boundTypes.put(typeParameterElement.toString(), this.resolveTypeReference(i.next(), boundTypes));
            }
        }
        return boundTypes;
    }

    protected Map<String, TypeMirror> resolveBoundGenerics(TypeElement declaringType, TypeMirror returnType, Map<String, Map<String, TypeMirror>> genericsInfo) {
        if (returnType instanceof NoType) {
            return Collections.emptyMap();
        }
        if (returnType instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)returnType;
            Element e = dt.asElement();
            List<? extends TypeMirror> typeArguments = dt.getTypeArguments();
            if (e instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)e;
                Map<String, TypeMirror> boundGenerics = this.resolveBoundGenerics(declaringType, genericsInfo);
                if (!this.modelUtils.resolveKind(typeElement, ElementKind.ENUM).isPresent()) {
                    return this.alignNewGenericsInfo(typeElement.getTypeParameters(), typeArguments, boundGenerics);
                }
            }
        } else if (returnType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)returnType;
            TypeMirror upperBound = tv.getUpperBound();
            Map<String, TypeMirror> boundGenerics = this.resolveBoundGenerics(declaringType, genericsInfo);
            TypeMirror bound = boundGenerics.get(tv.toString());
            if (bound != null) {
                return Collections.singletonMap(tv.toString(), bound);
            }
            Map<String, TypeMirror> generics = this.resolveBoundGenerics(declaringType, upperBound, genericsInfo);
            if (!generics.isEmpty()) {
                return generics;
            }
            return this.resolveBoundGenerics(declaringType, tv.getLowerBound(), genericsInfo);
        }
        return Collections.emptyMap();
    }

    private Map<String, TypeMirror> resolveBoundGenerics(TypeElement typeElement, Map<String, Map<String, TypeMirror>> genericsInfo) {
        Map<String, TypeMirror> boundGenerics;
        String declaringTypeName = null;
        if (typeElement != null) {
            declaringTypeName = typeElement.getQualifiedName().toString();
        }
        if ((boundGenerics = genericsInfo.get(declaringTypeName)) == null) {
            boundGenerics = Collections.emptyMap();
        }
        return boundGenerics;
    }

    public Map<String, Map<String, TypeMirror>> alignNewGenericsInfo(TypeElement typeElement, List<? extends TypeMirror> typeArguments, Map<String, TypeMirror> genericsInfo) {
        String typeName = typeElement.getQualifiedName().toString();
        List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
        Map<String, TypeMirror> resolved = this.alignNewGenericsInfo(typeParameters, typeArguments, genericsInfo);
        if (!resolved.isEmpty()) {
            return Collections.singletonMap(typeName, resolved);
        }
        return Collections.emptyMap();
    }

    public Map<String, TypeMirror> alignNewGenericsInfo(List<? extends TypeParameterElement> typeParameters, List<? extends TypeMirror> typeArguments, Map<String, TypeMirror> genericsInfo) {
        if (typeArguments.size() == typeParameters.size()) {
            HashMap<String, TypeMirror> resolved = new HashMap<String, TypeMirror>(typeArguments.size());
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                TypeMirror typeParameterMirror = i.next();
                String variableName = typeParameterElement.getSimpleName().toString();
                this.resolveVariableForMirror(genericsInfo, resolved, variableName, typeParameterMirror);
            }
            return resolved;
        }
        return Collections.emptyMap();
    }

    private void resolveVariableForMirror(Map<String, TypeMirror> genericsInfo, Map<String, TypeMirror> resolved, String variableName, TypeMirror mirror) {
        if (mirror instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)mirror;
            this.resolveTypeVariable(genericsInfo, resolved, variableName, tv);
        } else if (mirror instanceof WildcardType) {
            WildcardType wt = (WildcardType)mirror;
            TypeMirror extendsBound = wt.getExtendsBound();
            this.resolveVariableForMirror(genericsInfo, resolved, variableName, extendsBound);
        } else if (mirror instanceof DeclaredType) {
            resolved.put(variableName, mirror);
        } else if (mirror instanceof ArrayType) {
            resolved.put(variableName, mirror);
        }
    }

    private void resolveTypeVariable(Map<String, TypeMirror> genericsInfo, Map<String, TypeMirror> resolved, String variableName, TypeVariable variable) {
        String name = variable.toString();
        TypeMirror element = genericsInfo.get(name);
        if (element != null) {
            resolved.put(variableName, element);
        } else {
            TypeMirror upperBound = variable.getUpperBound();
            if (upperBound instanceof TypeVariable) {
                this.resolveTypeVariable(genericsInfo, resolved, variableName, (TypeVariable)upperBound);
            } else if (upperBound instanceof DeclaredType) {
                resolved.put(variableName, upperBound);
            } else {
                TypeMirror lowerBound = variable.getLowerBound();
                if (lowerBound instanceof TypeVariable) {
                    this.resolveTypeVariable(genericsInfo, resolved, variableName, (TypeVariable)lowerBound);
                } else if (lowerBound instanceof DeclaredType) {
                    resolved.put(variableName, lowerBound);
                }
            }
        }
    }

    private void resolveGenericTypeParameter(Map<String, Object> resolvedParameters, String parameterName, TypeMirror mirror, Map<String, Object> boundTypes) {
        if (mirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)mirror;
            List<? extends TypeMirror> nestedArguments = declaredType.getTypeArguments();
            if (nestedArguments.isEmpty()) {
                resolvedParameters.put(parameterName, this.resolveTypeReference(this.typeUtils.erasure(mirror), resolvedParameters));
            } else {
                resolvedParameters.put(parameterName, Collections.singletonMap(this.resolveTypeReference(this.typeUtils.erasure(mirror), resolvedParameters), this.resolveGenericTypes(declaredType, boundTypes)));
            }
        } else if (mirror instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)mirror;
            String variableName = tv.toString();
            if (boundTypes.containsKey(variableName)) {
                resolvedParameters.put(parameterName, boundTypes.get(variableName));
            } else {
                TypeMirror upperBound = tv.getUpperBound();
                if (upperBound instanceof DeclaredType) {
                    this.resolveGenericTypeParameter(resolvedParameters, parameterName, upperBound, boundTypes);
                }
            }
        }
    }

    private void populateTypeArguments(TypeElement typeElement, Map<String, Map<String, Object>> typeArguments) {
        TypeElement current = typeElement;
        while (current != null) {
            this.populateTypeArgumentsForInterfaces(typeArguments, current);
            TypeMirror superclass = current.getSuperclass();
            if (superclass.getKind() == TypeKind.NONE) {
                current = null;
                continue;
            }
            if (!(superclass instanceof DeclaredType)) break;
            DeclaredType dt = (DeclaredType)superclass;
            List<? extends TypeMirror> superArguments = dt.getTypeArguments();
            Element te = dt.asElement();
            if (!(te instanceof TypeElement)) break;
            TypeElement child = current;
            current = (TypeElement)te;
            if (!CollectionUtils.isNotEmpty(superArguments)) continue;
            Map<String, Object> boundTypes = typeArguments.get(child.getQualifiedName().toString());
            if (boundTypes == null) {
                boundTypes = Collections.emptyMap();
            }
            Map<String, Object> types = this.resolveGenericTypes(dt, current, boundTypes);
            String name = current.getQualifiedName().toString();
            typeArguments.put(name, types);
        }
    }

    private void populateTypeArgumentsForInterfaces(Map<String, Map<String, Object>> typeArguments, TypeElement child) {
        for (TypeMirror typeMirror : child.getInterfaces()) {
            DeclaredType declaredType;
            Element element;
            if (!(typeMirror instanceof DeclaredType) || !((element = (declaredType = (DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
            TypeElement te = (TypeElement)element;
            String name = te.getQualifiedName().toString();
            if (!typeArguments.containsKey(name)) {
                Map<String, Object> boundTypes = typeArguments.get(child.getQualifiedName().toString());
                if (boundTypes == null) {
                    boundTypes = Collections.emptyMap();
                }
                Map<String, Object> types = this.resolveGenericTypes(declaredType, te, boundTypes);
                typeArguments.put(name, types);
            }
            this.populateTypeArgumentsForInterfaces(typeArguments, te);
        }
    }

    private void resolveGenericTypeParameterForPrimitiveOrArray(Map<String, Object> resolvedParameters, String parameterName, TypeMirror mirror, Map<String, Object> boundTypes) {
        resolvedParameters.put(parameterName, Collections.singletonMap(this.resolveTypeReference(this.typeUtils.erasure(mirror), resolvedParameters), this.resolveGenericTypes(mirror, boundTypes)));
    }
}

