/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.ExecutableElementParamInfo;
import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.JavaConfigurationMetadataBuilder;
import io.micronaut.annotation.processing.PublicAbstractMethodVisitor;
import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.aop.Adapter;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.PropertySource;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.ConfigurationMetadataWriter;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.writer.BeanDefinitionReferenceWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ExecutableMethodWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner8;

@Internal
@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations"})
public class BeanDefinitionInjectProcessor
extends AbstractInjectAnnotationProcessor {
    private static final String AROUND_TYPE = "io.micronaut.aop.Around";
    private static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
    private static final String[] ANNOTATION_STEREOTYPES = new String[]{"javax.annotation.PostConstruct", "javax.annotation.PreDestroy", "javax.inject.Inject", "javax.inject.Qualifier", "javax.inject.Singleton", "io.micronaut.context.annotation.Bean", "io.micronaut.context.annotation.Replaces", "io.micronaut.context.annotation.Value", "io.micronaut.context.annotation.Property", "io.micronaut.context.annotation.Executable", "io.micronaut.aop.Around", "io.micronaut.aop.Introduction"};
    private static final String ANN_CONSTRAINT = "javax.validation.Constraint";
    private static final String ANN_VALID = "javax.validation.Valid";
    private static final Predicate<AnnotationMetadata> IS_CONSTRAINT = am -> am.hasStereotype(ANN_CONSTRAINT) || am.hasStereotype(ANN_VALID);
    private static final String ANN_CONFIGURATION_ADVICE = "io.micronaut.runtime.context.env.ConfigurationAdvice";
    private static final String ANN_VALIDATED = "io.micronaut.validation.Validated";
    private JavaConfigurationMetadataBuilder metadataBuilder;
    private Set<String> beanDefinitions;
    private Set<String> processed = new HashSet<String>();
    private boolean processingOver;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.metadataBuilder = new JavaConfigurationMetadataBuilder(this.elementUtils, this.typeUtils, this.annotationUtils);
        this.beanDefinitions = new LinkedHashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingOver = roundEnv.processingOver();
        if (!(annotations = annotations.stream().filter(ann -> !ann.getQualifiedName().toString().equals("kotlin.Metadata")).filter(ann -> this.annotationUtils.hasStereotype((Element)ann, ANNOTATION_STEREOTYPES) || AbstractAnnotationMetadataBuilder.isAnnotationMapped((String)ann.getQualifiedName().toString())).collect(Collectors.toSet())).isEmpty()) {
            TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
            TypeMirror groovyObjectType = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
            annotations.forEach(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().filter(element -> element.getKind() != ElementKind.ANNOTATION_TYPE).forEach(element -> {
                TypeElement typeElement = this.modelUtils.classElementFor((Element)element);
                if (element.getKind() == ElementKind.ENUM) {
                    this.error((Element)element, "Enum types cannot be defined as beans", new Object[0]);
                    return;
                }
                if (typeElement == null || groovyObjectType != null && this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType)) {
                    return;
                }
                String name = typeElement.getQualifiedName().toString();
                if (!(this.beanDefinitions.contains(name) || this.processed.contains(name) || name.endsWith("$Intercepted"))) {
                    boolean isInterface = JavaModelUtils.resolveKind((Element)typeElement, (ElementKind)ElementKind.INTERFACE).isPresent();
                    if (!isInterface) {
                        this.beanDefinitions.add(name);
                    } else if (this.annotationUtils.hasStereotype((Element)typeElement, INTRODUCTION_TYPE) || this.annotationUtils.hasStereotype((Element)typeElement, ConfigurationReader.class)) {
                        this.beanDefinitions.add(name);
                    }
                }
            }));
        }
        for (String name : this.processed) {
            this.beanDefinitions.remove(name);
        }
        int count = this.beanDefinitions.size();
        if (count > 0) {
            this.note("Creating bean classes for %s type elements", count);
            this.beanDefinitions.forEach(className -> {
                if (this.processed.add((String)className)) {
                    TypeElement refreshedClassElement = this.elementUtils.getTypeElement((CharSequence)className);
                    try {
                        AnnBeanElementVisitor visitor = new AnnBeanElementVisitor(refreshedClassElement);
                        refreshedClassElement.accept(visitor, className);
                        visitor.getBeanDefinitionWriters().forEach((name, writer) -> {
                            String beanDefinitionName = writer.getBeanDefinitionName();
                            if (this.processed.add(beanDefinitionName)) {
                                this.processBeanDefinitions(refreshedClassElement, (BeanDefinitionVisitor)writer);
                            }
                        });
                    }
                    catch (PostponeToNextRoundException e) {
                        this.processed.remove(className);
                    }
                }
            });
            AnnotationUtils.invalidateCache();
        }
        if (this.processingOver) {
            try {
                this.writeConfigurationMetadata();
                this.writeBeanDefinitionsToMetaInf();
            }
            finally {
                AnnotationUtils.invalidateCache();
                AbstractAnnotationMetadataBuilder.clearMutated();
            }
        }
        return false;
    }

    private void writeConfigurationMetadata() {
        if (this.metadataBuilder.hasMetadata()) {
            ServiceLoader<ConfigurationMetadataWriter> writers = ServiceLoader.load(ConfigurationMetadataWriter.class, this.getClass().getClassLoader());
            try {
                for (ConfigurationMetadataWriter writer : writers) {
                    try {
                        writer.write((ConfigurationMetadataBuilder)this.metadataBuilder, this.classWriterOutputVisitor);
                    }
                    catch (IOException e) {
                        this.error("Error occurred writing configuration metadata: %s", e.getMessage());
                    }
                }
            }
            catch (ServiceConfigurationError e) {
                this.warning("Unable to load ConfigurationMetadataWriter due to : %s", e.getMessage());
            }
        }
    }

    private void writeBeanDefinitionsToMetaInf() {
        try {
            this.classWriterOutputVisitor.finish();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.error("Error occurred writing META-INF files: %s", message != null ? message : e);
        }
    }

    private void processBeanDefinitions(TypeElement beanClassElement, BeanDefinitionVisitor beanDefinitionWriter) {
        try {
            beanDefinitionWriter.visitBeanDefinitionEnd();
            beanDefinitionWriter.accept(this.classWriterOutputVisitor);
            String beanDefinitionName = beanDefinitionWriter.getBeanDefinitionName();
            String beanTypeName = beanDefinitionWriter.getBeanTypeName();
            List<? extends TypeMirror> interfaces = beanClassElement.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                List<? extends TypeMirror> typeArguments;
                DeclaredType declaredType;
                Element element;
                if (!(typeMirror instanceof DeclaredType) || !((element = (declaredType = (DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
                TypeElement te = (TypeElement)element;
                String name = te.getQualifiedName().toString();
                if (!Provider.class.getName().equals(name) || (typeArguments = declaredType.getTypeArguments()).isEmpty()) continue;
                beanTypeName = this.genericUtils.resolveTypeReference(typeArguments.get(0)).toString();
            }
            AnnotationMetadata annotationMetadata = beanDefinitionWriter.getAnnotationMetadata();
            BeanDefinitionReferenceWriter beanDefinitionReferenceWriter = new BeanDefinitionReferenceWriter(beanTypeName, beanDefinitionName, annotationMetadata);
            beanDefinitionReferenceWriter.setRequiresMethodProcessing(beanDefinitionWriter.requiresMethodProcessing());
            String className = beanDefinitionReferenceWriter.getBeanDefinitionQualifiedClassName();
            this.processed.add(className);
            beanDefinitionReferenceWriter.setContextScope(this.annotationUtils.hasStereotype((Element)beanClassElement, Context.class));
            beanDefinitionReferenceWriter.accept(this.classWriterOutputVisitor);
        }
        catch (IOException e) {
            String message = e.getMessage();
            this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
        }
    }

    private String getPropertyMetadataTypeReference(TypeMirror valueType) {
        if (this.modelUtils.isOptional(valueType)) {
            return this.genericUtils.getFirstTypeArgument(valueType).map(typeMirror -> this.modelUtils.resolveTypeName((TypeMirror)typeMirror)).orElseGet(() -> this.modelUtils.resolveTypeName(valueType));
        }
        return this.modelUtils.resolveTypeName(valueType);
    }

    private AnnotationMetadata addPropertyMetadata(AnnotationMetadata annotationMetadata, VariableElement element, String propertyName) {
        PropertyMetadata pm = this.metadataBuilder.visitProperty(this.getPropertyMetadataTypeReference(element.asType()), propertyName, null, null);
        return this.addPropertyMetadata(annotationMetadata, pm);
    }

    private AnnotationMetadata addPropertyMetadata(AnnotationMetadata annotationMetadata, PropertyMetadata propertyMetadata) {
        return DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)annotationMetadata, (String)PropertySource.class.getName(), (String)"value", Collections.singletonList(new io.micronaut.core.annotation.AnnotationValue(Property.class.getName(), Collections.singletonMap("name", propertyMetadata.getPath()))));
    }

    private AnnotationMetadata addAnnotation(AnnotationMetadata annotationMetadata, String annotation) {
        JavaAnnotationMetadataBuilder metadataBuilder = this.javaVisitorContext.getAnnotationUtils().newAnnotationBuilder();
        annotationMetadata = metadataBuilder.annotate(annotationMetadata, io.micronaut.core.annotation.AnnotationValue.builder((String)annotation).build());
        return annotationMetadata;
    }

    private static class PostponeToNextRoundException
    extends RuntimeException {
        private PostponeToNextRoundException() {
        }
    }

    static class DynamicName
    implements Name {
        private final CharSequence name;

        public DynamicName(CharSequence name) {
            this.name = name;
        }

        @Override
        public boolean contentEquals(CharSequence cs) {
            return this.name.equals(cs);
        }

        @Override
        public int length() {
            return this.name.length();
        }

        @Override
        public char charAt(int index) {
            return this.name.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.name.subSequence(start, end);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicName that = (DynamicName)o;
            return this.name.equals(that.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    class AnnBeanElementVisitor
    extends ElementScanner8<Object, Object> {
        private final TypeElement concreteClass;
        private final AnnotationMetadata concreteClassMetadata;
        private final Map<Name, BeanDefinitionVisitor> beanDefinitionWriters;
        private final boolean isConfigurationPropertiesType;
        private final boolean isFactoryType;
        private final boolean isExecutableType;
        private final boolean isAopProxyType;
        private final OptionalValues<Boolean> aopSettings;
        private final boolean isDeclaredBean;
        private ConfigurationMetadata configurationMetadata;
        private ExecutableElementParamInfo constructorParameterInfo;
        private AtomicInteger adaptedMethodIndex = new AtomicInteger(0);
        private AtomicInteger factoryMethodIndex = new AtomicInteger(0);
        private Set<Name> visitedTypes = new HashSet<Name>();

        AnnBeanElementVisitor(TypeElement concreteClass) {
            this.concreteClass = concreteClass;
            this.concreteClassMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(concreteClass);
            this.beanDefinitionWriters = new LinkedHashMap<Name, BeanDefinitionVisitor>();
            this.isFactoryType = this.concreteClassMetadata.hasStereotype(Factory.class);
            this.isConfigurationPropertiesType = this.concreteClassMetadata.hasDeclaredStereotype(ConfigurationReader.class) || this.concreteClassMetadata.hasDeclaredStereotype(EachProperty.class);
            this.isAopProxyType = this.concreteClassMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) && !BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(concreteClass);
            this.aopSettings = this.isAopProxyType ? this.concreteClassMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class) : OptionalValues.empty();
            ExecutableElement constructor = BeanDefinitionInjectProcessor.this.modelUtils.concreteConstructorFor(concreteClass, BeanDefinitionInjectProcessor.this.annotationUtils);
            this.constructorParameterInfo = this.populateParameterData(null, constructor, Collections.emptyMap());
            this.isExecutableType = this.isAopProxyType || this.concreteClassMetadata.hasStereotype(Executable.class);
            this.isDeclaredBean = this.isExecutableType || this.isConfigurationPropertiesType || this.isFactoryType || this.concreteClassMetadata.hasStereotype(Scope.class) || this.concreteClassMetadata.hasStereotype(DefaultScope.class) || this.constructorParameterInfo.getAnnotationMetadata().hasStereotype(Inject.class);
        }

        TypeElement getConcreteClass() {
            return this.concreteClass;
        }

        Map<Name, BeanDefinitionVisitor> getBeanDefinitionWriters() {
            return this.beanDefinitionWriters;
        }

        @Override
        public Object visitType(TypeElement classElement, Object o) {
            Name classElementQualifiedName = classElement.getQualifiedName();
            if (this.visitedTypes.contains(classElementQualifiedName)) {
                return o;
            }
            boolean isInterface = JavaModelUtils.isInterface((Element)classElement);
            this.visitedTypes.add(classElementQualifiedName);
            AnnotationMetadata typeAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(classElement);
            if (this.isConfigurationPropertiesType) {
                this.configurationMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperties(this.concreteClass, null);
                if (isInterface) {
                    typeAnnotationMetadata = BeanDefinitionInjectProcessor.this.addAnnotation(typeAnnotationMetadata, BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE);
                }
            }
            if (typeAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.INTRODUCTION_TYPE)) {
                ExecutableElementParamInfo constructorData;
                AopProxyWriter aopProxyWriter = this.createIntroductionAdviceWriter(classElement);
                ExecutableElement constructor = JavaModelUtils.resolveKind((Element)classElement, (ElementKind)ElementKind.CLASS).isPresent() ? BeanDefinitionInjectProcessor.this.modelUtils.concreteConstructorFor(classElement, BeanDefinitionInjectProcessor.this.annotationUtils) : null;
                ExecutableElementParamInfo executableElementParamInfo = constructorData = constructor != null ? this.populateParameterData(null, constructor, Collections.emptyMap()) : null;
                if (constructorData != null) {
                    aopProxyWriter.visitBeanDefinitionConstructor(constructorData.getAnnotationMetadata(), constructorData.isRequiresReflection(), constructorData.getParameters(), constructorData.getParameterMetadata(), constructorData.getGenericTypes());
                } else {
                    aopProxyWriter.visitBeanDefinitionConstructor(AnnotationMetadata.EMPTY_METADATA, false);
                }
                this.beanDefinitionWriters.put(classElementQualifiedName, (BeanDefinitionVisitor)aopProxyWriter);
                this.visitIntroductionAdviceInterface(classElement, typeAnnotationMetadata, aopProxyWriter);
                if (!isInterface) {
                    List elements = classElement.getEnclosedElements().stream().filter(element -> element.getKind() != ElementKind.CONSTRUCTOR).collect(Collectors.toList());
                    return this.scan(elements, o);
                }
                return null;
            }
            Element enclosingElement = classElement.getEnclosingElement();
            Name qualifiedName = this.concreteClass.getQualifiedName();
            if (!JavaModelUtils.isClass((Element)enclosingElement) || qualifiedName.equals(classElementQualifiedName)) {
                if (qualifiedName.equals(classElementQualifiedName)) {
                    boolean isBean;
                    boolean bl = isBean = this.isAopProxyType || this.isConfigurationPropertiesType || typeAnnotationMetadata.hasStereotype(ANNOTATION_STEREOTYPES) || this.constructorParameterInfo.getAnnotationMetadata().hasStereotype(Inject.class);
                    if (isBean) {
                        PackageElement packageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(classElement);
                        if (packageElement.isUnnamed()) {
                            BeanDefinitionInjectProcessor.this.error(classElement, "Micronaut beans cannot be in the default package", new Object[0]);
                            return null;
                        }
                        BeanDefinitionVisitor beanDefinitionWriter = this.getOrCreateBeanDefinitionWriter(classElement, qualifiedName);
                        if (this.isAopProxyType) {
                            if (BeanDefinitionInjectProcessor.this.modelUtils.isFinal(classElement)) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + classElement, new Object[0]);
                                return null;
                            }
                            Object[] interceptorTypes = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(this.concreteClass).getAnnotationNamesByStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE).toArray();
                            this.resolveAopProxyWriter(beanDefinitionWriter, this.aopSettings, false, this.constructorParameterInfo, interceptorTypes);
                        }
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(classElement)) {
                        return null;
                    }
                }
                List elements = classElement.getEnclosedElements().stream().filter(element -> element.getKind() != ElementKind.CONSTRUCTOR).collect(Collectors.toList());
                if (this.isConfigurationPropertiesType) {
                    List<? extends Element> members = BeanDefinitionInjectProcessor.this.elementUtils.getAllMembers(classElement);
                    ElementFilter.fieldsIn(members).forEach(field -> {
                        AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata((Element)field);
                        boolean isConfigBuilder = fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class);
                        if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic((Element)field)) {
                            return;
                        }
                        if (!BeanDefinitionInjectProcessor.this.modelUtils.isFinal((Element)field) || isConfigBuilder) {
                            this.visitConfigurationProperty((VariableElement)field, fieldAnnotationMetadata);
                        }
                    });
                    ElementFilter.methodsIn(members).forEach(method -> {
                        Element e;
                        boolean isCandidateMethod;
                        boolean bl = isCandidateMethod = !BeanDefinitionInjectProcessor.this.modelUtils.isStatic((Element)method) && !BeanDefinitionInjectProcessor.this.modelUtils.isPrivate((Element)method) && !BeanDefinitionInjectProcessor.this.modelUtils.isAbstract((Element)method);
                        if (isCandidateMethod && (e = method.getEnclosingElement()) instanceof TypeElement && !e.equals(classElement)) {
                            BeanDefinitionVisitor writer;
                            String methodName = method.getSimpleName().toString();
                            if (method.getParameters().size() == 1 && NameUtils.isSetterName((String)methodName)) {
                                this.visitConfigurationPropertySetter((ExecutableElement)method);
                            } else if (NameUtils.isGetterName((String)methodName) && !(writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName())).isValidated() && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((Element)method, BeanDefinitionInjectProcessor.ANN_CONSTRAINT)) {
                                writer.setValidated(true);
                            }
                        }
                    });
                } else {
                    TypeElement superClass = BeanDefinitionInjectProcessor.this.modelUtils.superClassFor(classElement);
                    if (superClass != null && !BeanDefinitionInjectProcessor.this.modelUtils.isObjectClass(superClass)) {
                        superClass.accept(this, o);
                    }
                }
                return this.scan(elements, o);
            }
            return null;
        }

        public BeanDefinitionVisitor getOrCreateBeanDefinitionWriter(TypeElement classElement, Name qualifiedName) {
            BeanDefinitionVisitor beanDefinitionWriter = this.beanDefinitionWriters.get(qualifiedName);
            if (beanDefinitionWriter == null) {
                beanDefinitionWriter = this.createBeanDefinitionWriterFor(classElement);
                DynamicName proxyKey = this.createProxyKey(beanDefinitionWriter.getBeanDefinitionName());
                this.beanDefinitionWriters.put(qualifiedName, beanDefinitionWriter);
                BeanDefinitionVisitor proxyWriter = this.beanDefinitionWriters.get(proxyKey);
                AnnotationMetadataHierarchy annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, this.constructorParameterInfo.getAnnotationMetadata()});
                if (proxyWriter != null) {
                    proxyWriter.visitBeanDefinitionConstructor((AnnotationMetadata)annotationMetadata, this.constructorParameterInfo.isRequiresReflection(), this.constructorParameterInfo.getParameters(), this.constructorParameterInfo.getParameterMetadata(), this.constructorParameterInfo.getGenericTypes());
                }
                beanDefinitionWriter.visitBeanDefinitionConstructor((AnnotationMetadata)annotationMetadata, this.constructorParameterInfo.isRequiresReflection(), this.constructorParameterInfo.getParameters(), this.constructorParameterInfo.getParameterMetadata(), this.constructorParameterInfo.getGenericTypes());
                if (this.constructorParameterInfo.isValidated()) {
                    beanDefinitionWriter.setValidated(true);
                }
            }
            return beanDefinitionWriter;
        }

        private void visitIntroductionAdviceInterface(final TypeElement classElement, final AnnotationMetadata typeAnnotationMetadata, AopProxyWriter aopProxyWriter) {
            final String introductionTypeName = classElement.getQualifiedName().toString();
            final boolean isConfigProps = typeAnnotationMetadata.hasAnnotation(BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE);
            if (isConfigProps) {
                BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperties(classElement, null);
            }
            classElement.asType().accept(new PublicAbstractMethodVisitor<Object, AopProxyWriter>(classElement, BeanDefinitionInjectProcessor.this.modelUtils, BeanDefinitionInjectProcessor.this.elementUtils){

                @Override
                protected boolean isAcceptableMethod(ExecutableElement executableElement) {
                    return super.isAcceptableMethod(executableElement) || BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(executableElement).hasDeclaredStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE);
                }

                @Override
                protected void accept(DeclaredType type, Element element, AopProxyWriter aopProxyWriter) {
                    ExecutableElement method = (ExecutableElement)element;
                    boolean isAbstract = BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(method);
                    Map<String, Object> boundTypes = BeanDefinitionInjectProcessor.this.genericUtils.resolveBoundTypes(type);
                    ExecutableElementParamInfo params = AnnBeanElementVisitor.this.populateParameterData(introductionTypeName, method, boundTypes);
                    Object owningType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(method.getEnclosingElement());
                    if (owningType == null) {
                        throw new IllegalStateException("Owning type cannot be null");
                    }
                    TypeMirror returnTypeMirror = method.getReturnType();
                    Object returnType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnTypeMirror);
                    Object resolvedReturnType = BeanDefinitionInjectProcessor.this.genericUtils.resolveTypeReference(returnTypeMirror, boundTypes);
                    Map<String, Object> returnTypeGenerics = BeanDefinitionInjectProcessor.this.genericUtils.resolveGenericTypes(returnTypeMirror, boundTypes);
                    String methodName = method.getSimpleName().toString();
                    Map<String, Object> methodParameters = params.getParameters();
                    Map<String, Object> genericParameters = params.getGenericParameters();
                    Map<String, AnnotationMetadata> parameterAnnotationMetadata = params.getParameterMetadata();
                    Map<String, Map<String, Object>> methodGenericTypes = params.getGenericTypes();
                    Object annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.isAnnotated(introductionTypeName, method) || JavaAnnotationMetadataBuilder.hasAnnotation(method, Override.class) ? BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(introductionTypeName, classElement, method) : new AnnotationMetadataReference(aopProxyWriter.getBeanDefinitionName() + "Class", typeAnnotationMetadata);
                    if (!annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_VALIDATED) && AnnBeanElementVisitor.this.isDeclaredBean && params.getParameterMetadata().values().stream().anyMatch(IS_CONSTRAINT)) {
                        annotationMetadata = BeanDefinitionInjectProcessor.this.addAnnotation(annotationMetadata, BeanDefinitionInjectProcessor.ANN_VALIDATED);
                    }
                    if (isConfigProps && isAbstract) {
                        JavaAnnotationMetadataBuilder metadataBuilder;
                        if (!aopProxyWriter.isValidated()) {
                            aopProxyWriter.setValidated(IS_CONSTRAINT.test(annotationMetadata));
                        }
                        if (!NameUtils.isGetterName((String)methodName)) {
                            BeanDefinitionInjectProcessor.this.error(classElement, "Only getter methods are allowed on @ConfigurationProperties interfaces: " + method, new Object[0]);
                            return;
                        }
                        if (!methodParameters.isEmpty()) {
                            BeanDefinitionInjectProcessor.this.error(classElement, "Only zero argument getter methods are allowed on @ConfigurationProperties interfaces: " + method, new Object[0]);
                            return;
                        }
                        String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                        String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
                        String propertyType = BeanDefinitionInjectProcessor.this.getPropertyMetadataTypeReference(returnTypeMirror);
                        if ("void".equals(propertyType)) {
                            BeanDefinitionInjectProcessor.this.error(classElement, "Getter methods must return a value @ConfigurationProperties interfaces: " + method, new Object[0]);
                            return;
                        }
                        PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(classElement, classElement, propertyType, propertyName, docComment, annotationMetadata.stringValue(Bindable.class, "defaultValue").orElse(null));
                        annotationMetadata = BeanDefinitionInjectProcessor.this.addPropertyMetadata(annotationMetadata, propertyMetadata);
                        TypeElement typeElement = !ClassUtils.isJavaBasicType((String)propertyType) ? this.resolveTypeElement(returnTypeMirror) : null;
                        AnnotationValueBuilder builder = io.micronaut.core.annotation.AnnotationValue.builder((String)BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE);
                        if (typeElement != null && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((Element)typeElement, Scope.class)) {
                            builder.member("bean", true);
                        }
                        if (typeAnnotationMetadata.hasStereotype(EachProperty.class)) {
                            builder.member("iterable", true);
                        }
                        if ((annotationMetadata = (metadataBuilder = BeanDefinitionInjectProcessor.this.javaVisitorContext.getAnnotationUtils().newAnnotationBuilder()).annotate((AnnotationMetadata)annotationMetadata, builder.build())).hasStereotype(BeanDefinitionInjectProcessor.ANN_CONSTRAINT) && !annotationMetadata.hasStereotype(Executable.class)) {
                            aopProxyWriter.visitExecutableMethod(owningType, returnType, resolvedReturnType, returnTypeGenerics, methodName, methodParameters, genericParameters, parameterAnnotationMetadata, methodGenericTypes, annotationMetadata, JavaModelUtils.isInterface((Element)method.getEnclosingElement()));
                        }
                    }
                    if (annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                        Object[] interceptorTypes = annotationMetadata.getAnnotationNamesByStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE).toArray();
                        aopProxyWriter.visitInterceptorTypes(interceptorTypes);
                    }
                    if (annotationMetadata.hasStereotype(Executable.class)) {
                        aopProxyWriter.visitExecutableMethod(owningType, returnType, resolvedReturnType, returnTypeGenerics, methodName, methodParameters, genericParameters, parameterAnnotationMetadata, methodGenericTypes, annotationMetadata, JavaModelUtils.isInterface((Element)method.getEnclosingElement()));
                    }
                    if (isAbstract) {
                        aopProxyWriter.visitIntroductionMethod(owningType, returnType, resolvedReturnType, returnTypeGenerics, methodName, methodParameters, genericParameters, parameterAnnotationMetadata, methodGenericTypes, annotationMetadata);
                    } else {
                        aopProxyWriter.visitAroundMethod(owningType, returnType, resolvedReturnType, returnTypeGenerics, methodName, methodParameters, genericParameters, parameterAnnotationMetadata, methodGenericTypes, annotationMetadata, JavaModelUtils.isInterface((Element)method.getEnclosingElement()));
                    }
                }

                @Nullable
                private TypeElement resolveTypeElement(TypeMirror typeMirror) {
                    Element element;
                    if (typeMirror instanceof DeclaredType && (element = ((DeclaredType)typeMirror).asElement()) instanceof TypeElement) {
                        return (TypeElement)element;
                    }
                    return null;
                }
            }, aopProxyWriter);
        }

        @Override
        public Object visitExecutable(ExecutableElement method, Object o) {
            if (method.getKind() == ElementKind.CONSTRUCTOR) {
                BeanDefinitionInjectProcessor.this.error("Unexpected call to visitExecutable for ctor %s of %s", method.getSimpleName(), o);
                return null;
            }
            if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic(method) || BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(method)) {
                return null;
            }
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(method);
            Object methodAnnotationMetadata = annotationMetadata instanceof AnnotationMetadataHierarchy ? annotationMetadata : new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, annotationMetadata});
            TypeKind returnKind = method.getReturnType().getKind();
            if (returnKind == TypeKind.ERROR && !BeanDefinitionInjectProcessor.this.processingOver) {
                throw new PostponeToNextRoundException();
            }
            if (this.isFactoryType && methodAnnotationMetadata.hasDeclaredStereotype(new Class[]{Bean.class, Scope.class}) && returnKind == TypeKind.DECLARED) {
                this.visitBeanFactoryMethod(method);
                return null;
            }
            boolean injected = methodAnnotationMetadata.hasDeclaredStereotype(Inject.class);
            boolean postConstruct = methodAnnotationMetadata.hasDeclaredStereotype("javax.annotation.PostConstruct");
            boolean preDestroy = methodAnnotationMetadata.hasDeclaredStereotype("javax.annotation.PreDestroy");
            if (injected || postConstruct || preDestroy || methodAnnotationMetadata.hasDeclaredStereotype(ConfigurationInject.class)) {
                if (this.isDeclaredBean) {
                    this.visitAnnotatedMethod(method, o);
                } else if (injected) {
                    this.visitAnnotatedMethod(method, o);
                }
                return null;
            }
            Set<Modifier> modifiers = method.getModifiers();
            boolean hasInvalidModifiers = BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(method) || modifiers.contains((Object)Modifier.STATIC) || methodAnnotationMetadata.hasAnnotation(Internal.class) || BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(method);
            boolean isPublic = modifiers.contains((Object)Modifier.PUBLIC) && !hasInvalidModifiers;
            boolean isExecutable = !hasInvalidModifiers && (this.isExecutableThroughType(method.getEnclosingElement(), (AnnotationMetadata)methodAnnotationMetadata, annotationMetadata, modifiers, isPublic) || annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE));
            boolean hasConstraints = false;
            if (this.isDeclaredBean && !methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_VALIDATED) && method.getParameters().stream().anyMatch(p -> BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((Element)p, BeanDefinitionInjectProcessor.ANN_CONSTRAINT) || BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((Element)p, BeanDefinitionInjectProcessor.ANN_VALID))) {
                hasConstraints = true;
                methodAnnotationMetadata = BeanDefinitionInjectProcessor.this.javaVisitorContext.getAnnotationUtils().newAnnotationBuilder().annotate((AnnotationMetadata)methodAnnotationMetadata, io.micronaut.core.annotation.AnnotationValue.builder((String)BeanDefinitionInjectProcessor.ANN_VALIDATED).build());
            }
            if (isExecutable) {
                this.visitExecutableMethod(method, (AnnotationMetadata)methodAnnotationMetadata);
                return null;
            }
            if (this.isConfigurationPropertiesType && !BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(method) && !BeanDefinitionInjectProcessor.this.modelUtils.isStatic(method)) {
                BeanDefinitionVisitor writer;
                String methodName = method.getSimpleName().toString();
                if (NameUtils.isSetterName((String)methodName) && method.getParameters().size() == 1) {
                    this.visitConfigurationPropertySetter(method);
                } else if (NameUtils.isGetterName((String)methodName) && !(writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName())).isValidated() && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((Element)method, BeanDefinitionInjectProcessor.ANN_CONSTRAINT)) {
                    writer.setValidated(true);
                }
            } else if (isPublic && hasConstraints) {
                this.visitExecutableMethod(method, (AnnotationMetadata)methodAnnotationMetadata);
            }
            return null;
        }

        private boolean isExecutableThroughType(Element enclosingElement, AnnotationMetadata annotationMetadataHierarchy, AnnotationMetadata declaredMetadata, Set<Modifier> modifiers, boolean isPublic) {
            return this.isExecutableType && (isPublic || modifiers.isEmpty() && this.concreteClass.equals(enclosingElement)) || annotationMetadataHierarchy.hasDeclaredStereotype(Executable.class) || declaredMetadata.hasAnnotation(Executable.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitConfigurationPropertySetter(ExecutableElement method) {
            TypeElement declaringClass;
            BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
            VariableElement parameter = method.getParameters().get(0);
            TypeMirror valueType = parameter.asType();
            Object fieldType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(valueType);
            Map<Object, Object> genericTypes = Collections.emptyMap();
            TypeKind typeKind = valueType.getKind();
            if (!typeKind.isPrimitive() && typeKind != TypeKind.ARRAY) {
                genericTypes = BeanDefinitionInjectProcessor.this.genericUtils.resolveGenericTypes(valueType, Collections.emptyMap());
            }
            if ((declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method)) != null) {
                AnnotationMetadata methodAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(method);
                String propertyName = NameUtils.getPropertyNameForSetter((String)method.getSimpleName().toString());
                if (methodAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                    writer.visitConfigBuilderMethod(fieldType, NameUtils.getterNameFor((String)propertyName), methodAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder);
                    try {
                        this.visitConfigurationBuilder(declaringClass, method, valueType, writer);
                    }
                    finally {
                        writer.visitConfigBuilderEnd();
                    }
                } else {
                    if (this.shouldExclude(this.configurationMetadata, propertyName)) {
                        return;
                    }
                    String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                    String setterName = method.getSimpleName().toString();
                    PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, BeanDefinitionInjectProcessor.this.getPropertyMetadataTypeReference(valueType), propertyName, docComment, null);
                    AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.addPropertyMetadata(AnnotationMetadata.EMPTY_METADATA, propertyMetadata);
                    boolean requiresReflection = true;
                    if (BeanDefinitionInjectProcessor.this.modelUtils.isPublic(method)) {
                        requiresReflection = false;
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isPackagePrivate(method) || BeanDefinitionInjectProcessor.this.modelUtils.isProtected(method)) {
                        PackageElement declaringPackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(declaringClass);
                        PackageElement concretePackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(this.concreteClass);
                        requiresReflection = !declaringPackage.getQualifiedName().equals(concretePackage.getQualifiedName());
                    }
                    writer.visitSetterValue(BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(declaringClass), BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(method.getReturnType()), annotationMetadata, requiresReflection, fieldType, setterName, genericTypes, BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(method.getParameters().get(0)), true);
                }
            }
        }

        void visitBeanFactoryMethod(final ExecutableElement beanMethod) {
            TypeMirror returnType;
            TypeElement producedElement;
            if (this.isFactoryType && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((Element)this.concreteClass, BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                this.visitExecutableMethod(beanMethod, BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(beanMethod));
            }
            if ((producedElement = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(BeanDefinitionInjectProcessor.this.typeUtils.asElement(returnType = beanMethod.getReturnType()))) == null) {
                return;
            }
            final String producedTypeName = producedElement.getQualifiedName().toString();
            ExecutableElementParamInfo beanMethodParams = this.populateParameterData(producedTypeName, beanMethod, Collections.emptyMap());
            final BeanDefinitionWriter beanMethodWriter = this.createFactoryBeanMethodWriterFor(beanMethod, producedElement);
            Map<String, Map<String, Object>> beanTypeArguments = null;
            if (returnType instanceof DeclaredType) {
                DeclaredType dt = (DeclaredType)returnType;
                beanTypeArguments = BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentInfo(dt);
                beanMethodWriter.visitTypeArguments(beanTypeArguments);
            }
            String beanMethodName = beanMethod.getSimpleName().toString();
            Map<String, Object> beanMethodParameters = beanMethodParams.getParameters();
            StringBuilder methodKey = new StringBuilder(beanMethodName).append("(").append(beanMethodParameters.values().stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
            this.beanDefinitionWriters.put(new DynamicName(methodKey), (BeanDefinitionVisitor)beanMethodWriter);
            Object beanMethodDeclaringType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(beanMethod.getEnclosingElement());
            final AnnotationMetadata methodAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(producedElement, beanMethod);
            beanMethodWriter.visitBeanFactoryMethod(beanMethodDeclaringType, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnType), beanMethodName, methodAnnotationMetadata, beanMethodParameters, beanMethodParams.getParameterMetadata(), beanMethodParams.getGenericTypes());
            if (methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) && !BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(this.concreteClass)) {
                Object[] interceptorTypes = methodAnnotationMetadata.getAnnotationNamesByStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE).toArray();
                TypeElement returnTypeElement = (TypeElement)((DeclaredType)beanMethod.getReturnType()).asElement();
                if (BeanDefinitionInjectProcessor.this.modelUtils.isFinal(returnTypeElement)) {
                    BeanDefinitionInjectProcessor.this.error(returnTypeElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + returnTypeElement, new Object[0]);
                    return;
                }
                ExecutableElement constructor = JavaModelUtils.isClass((Element)returnTypeElement) ? BeanDefinitionInjectProcessor.this.modelUtils.concreteConstructorFor(returnTypeElement, BeanDefinitionInjectProcessor.this.annotationUtils) : null;
                ExecutableElementParamInfo constructorData = constructor != null ? this.populateParameterData(null, constructor, Collections.emptyMap()) : null;
                OptionalValues aopSettings = methodAnnotationMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class);
                LinkedHashMap<CharSequence, Boolean> finalSettings = new LinkedHashMap<CharSequence, Boolean>();
                for (CharSequence setting : aopSettings) {
                    Optional entry = aopSettings.get(setting);
                    entry.ifPresent(val -> finalSettings.put(setting, (Boolean)val));
                }
                finalSettings.put(Interceptor.PROXY_TARGET, true);
                AopProxyWriter proxyWriter = this.resolveAopProxyWriter((BeanDefinitionVisitor)beanMethodWriter, (OptionalValues<Boolean>)OptionalValues.of(Boolean.class, finalSettings), true, constructorData, interceptorTypes);
                if (beanTypeArguments != null) {
                    proxyWriter.visitTypeArguments(beanTypeArguments);
                }
                returnType.accept(new PublicMethodVisitor<Object, AopProxyWriter>(BeanDefinitionInjectProcessor.this.typeUtils){

                    @Override
                    protected void accept(DeclaredType type, Element element, AopProxyWriter aopProxyWriter) {
                        AnnotationMetadata annotationMetadata;
                        ExecutableElement method = (ExecutableElement)element;
                        Object owningType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(method.getEnclosingElement());
                        if (owningType == null) {
                            throw new IllegalStateException("Owning type cannot be null");
                        }
                        TypeMirror returnTypeMirror = method.getReturnType();
                        TypeMirror returnType = method.getReturnType();
                        HashMap returnTypeGenerics = new HashMap();
                        BeanDefinitionInjectProcessor.this.genericUtils.resolveBoundGenerics((TypeElement)method.getEnclosingElement(), returnType, BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentElementInfo(AnnBeanElementVisitor.this.concreteClass)).forEach((key, value) -> returnTypeGenerics.put(key, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference((TypeMirror)value)));
                        Object resolvedReturnType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnType);
                        TypeElement enclosingElement = (TypeElement)method.getEnclosingElement();
                        Map<String, Object> boundTypes = BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentInfo(AnnBeanElementVisitor.this.concreteClass).get(enclosingElement.getQualifiedName().toString());
                        if (boundTypes == null) {
                            boundTypes = Collections.emptyMap();
                        }
                        ExecutableElementParamInfo params = AnnBeanElementVisitor.this.populateParameterData(null, method, boundTypes);
                        String methodName = method.getSimpleName().toString();
                        Map<String, Object> methodParameters = params.getParameters();
                        Map<String, AnnotationMetadata> methodQualifier = params.getParameterMetadata();
                        Map<String, Map<String, Object>> methodGenericTypes = params.getGenericTypes();
                        Map<String, Object> genericParameters = params.getGenericParameters();
                        boolean isAnnotationReference = false;
                        if (BeanDefinitionInjectProcessor.this.annotationUtils.isAnnotated(producedTypeName, method)) {
                            annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(beanMethod, method);
                        } else {
                            isAnnotationReference = true;
                            annotationMetadata = new AnnotationMetadataReference(beanMethodWriter.getBeanDefinitionName() + "Class", methodAnnotationMetadata);
                        }
                        ExecutableMethodWriter executableMethodWriter = beanMethodWriter.visitExecutableMethod(owningType, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnTypeMirror), resolvedReturnType, returnTypeGenerics, methodName, methodParameters, genericParameters, methodQualifier, methodGenericTypes, annotationMetadata, JavaModelUtils.isInterface((Element)method.getEnclosingElement()));
                        aopProxyWriter.visitAroundMethod(owningType, resolvedReturnType, resolvedReturnType, returnTypeGenerics, methodName, methodParameters, genericParameters, methodQualifier, methodGenericTypes, (AnnotationMetadata)(!isAnnotationReference ? new AnnotationMetadataReference(executableMethodWriter.getClassName(), annotationMetadata) : annotationMetadata), JavaModelUtils.isInterface((Element)method.getEnclosingElement()));
                    }
                }, proxyWriter);
            } else if (methodAnnotationMetadata.hasStereotype(Executable.class)) {
                returnType.accept(new PublicMethodVisitor<Object, BeanDefinitionWriter>(BeanDefinitionInjectProcessor.this.typeUtils){

                    @Override
                    protected void accept(DeclaredType type, Element element, BeanDefinitionWriter beanWriter) {
                        ExecutableElement method = (ExecutableElement)element;
                        Object owningType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(method.getEnclosingElement());
                        if (owningType == null) {
                            throw new IllegalStateException("Owning type cannot be null");
                        }
                        TypeMirror returnTypeMirror = method.getReturnType();
                        String methodName = method.getSimpleName().toString();
                        AnnotationMetadataReference annotationMetadata = new AnnotationMetadataReference(beanMethodWriter.getBeanDefinitionName() + "Class", methodAnnotationMetadata);
                        HashMap returnTypeGenerics = new HashMap();
                        BeanDefinitionInjectProcessor.this.genericUtils.resolveBoundGenerics((TypeElement)method.getEnclosingElement(), returnType, BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentElementInfo(type.asElement())).forEach((key, value) -> returnTypeGenerics.put(key, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference((TypeMirror)value)));
                        TypeElement enclosingElement = (TypeElement)method.getEnclosingElement();
                        Map<String, Object> boundTypes = BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentInfo(type).get(enclosingElement.getQualifiedName().toString());
                        if (boundTypes == null) {
                            boundTypes = Collections.emptyMap();
                        }
                        Object resolvedReturnType = BeanDefinitionInjectProcessor.this.genericUtils.resolveTypeReference(returnTypeMirror, boundTypes);
                        ExecutableElementParamInfo params = AnnBeanElementVisitor.this.populateParameterData(producedTypeName, method, boundTypes);
                        Map<String, Object> methodParameters = params.getParameters();
                        Map<String, Object> genericParameters = params.getGenericParameters();
                        Map<String, AnnotationMetadata> methodQualifier = params.getParameterMetadata();
                        Map<String, Map<String, Object>> methodGenericTypes = params.getGenericTypes();
                        beanMethodWriter.visitExecutableMethod(owningType, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnTypeMirror), resolvedReturnType, returnTypeGenerics, methodName, methodParameters, genericParameters, methodQualifier, methodGenericTypes, (AnnotationMetadata)annotationMetadata, JavaModelUtils.isInterface((Element)enclosingElement));
                    }
                }, beanMethodWriter);
            }
            if (methodAnnotationMetadata.isPresent(Bean.class, "preDestroy")) {
                Optional preDestroyMethod = methodAnnotationMetadata.getValue(Bean.class, "preDestroy", String.class);
                preDestroyMethod.ifPresent(destroyMethodName -> {
                    if (StringUtils.isNotEmpty((CharSequence)destroyMethodName)) {
                        TypeElement destroyMethodDeclaringClass = (TypeElement)BeanDefinitionInjectProcessor.this.typeUtils.asElement(returnType);
                        Optional<ExecutableElement> destroyMethodRef = BeanDefinitionInjectProcessor.this.modelUtils.findAccessibleNoArgumentInstanceMethod(destroyMethodDeclaringClass, (String)destroyMethodName);
                        if (destroyMethodRef.isPresent()) {
                            beanMethodWriter.visitPreDestroyMethod((Object)destroyMethodDeclaringClass.getQualifiedName().toString(), BeanDefinitionInjectProcessor.this.genericUtils.resolveTypeReference(destroyMethodRef.get().getReturnType()), destroyMethodName);
                        } else {
                            BeanDefinitionInjectProcessor.this.error(beanMethod, "@Bean method defines a preDestroy method that does not exist or is not public: " + destroyMethodName, new Object[0]);
                        }
                    }
                });
            }
        }

        void visitExecutableMethod(ExecutableElement method, AnnotationMetadata methodAnnotationMetadata) {
            Object typeRef;
            TypeMirror returnType = method.getReturnType();
            TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
            if (declaringClass == null || BeanDefinitionInjectProcessor.this.modelUtils.isObjectClass(declaringClass)) {
                return;
            }
            boolean isOwningClass = declaringClass.getQualifiedName().equals(this.concreteClass.getQualifiedName());
            if (isOwningClass && BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(this.concreteClass) && !this.concreteClassMetadata.hasStereotype(BeanDefinitionInjectProcessor.INTRODUCTION_TYPE)) {
                return;
            }
            if (!isOwningClass && BeanDefinitionInjectProcessor.this.modelUtils.overridingOrHidingMethod(method, this.concreteClass, true).isPresent()) {
                return;
            }
            HashMap returnTypeGenerics = new HashMap();
            BeanDefinitionInjectProcessor.this.genericUtils.resolveBoundGenerics((TypeElement)method.getEnclosingElement(), returnType, BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentElementInfo(this.concreteClass)).forEach((key, value) -> returnTypeGenerics.put(key, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference((TypeMirror)value)));
            Object resolvedReturnType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnType);
            TypeElement enclosingElement = (TypeElement)method.getEnclosingElement();
            Map<String, Object> boundTypes = BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentInfo(this.concreteClass).get(enclosingElement.getQualifiedName().toString());
            if (boundTypes == null) {
                boundTypes = Collections.emptyMap();
            }
            ExecutableElementParamInfo params = this.populateParameterData(null, method, boundTypes);
            BeanDefinitionVisitor beanWriter = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
            boolean preprocess = methodAnnotationMetadata.isTrue(Executable.class, "processOnStartup");
            if (preprocess) {
                beanWriter.setRequiresMethodProcessing(true);
            }
            if ((typeRef = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(method.getEnclosingElement())) == null) {
                typeRef = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(this.concreteClass);
            }
            AopProxyWriter proxyWriter = this.resolveAopWriter(beanWriter);
            ExecutableMethodWriter executableMethodWriter = null;
            if (proxyWriter == null || proxyWriter.isProxyTarget()) {
                executableMethodWriter = beanWriter.visitExecutableMethod(typeRef, resolvedReturnType, resolvedReturnType, returnTypeGenerics, method.getSimpleName().toString(), params.getParameters(), params.getGenericParameters(), params.getParameterMetadata(), params.getGenericTypes(), methodAnnotationMetadata, JavaModelUtils.isInterface((Element)enclosingElement));
            }
            if (methodAnnotationMetadata.hasStereotype(Adapter.class)) {
                this.visitAdaptedMethod(method, methodAnnotationMetadata);
            }
            if (!(beanWriter instanceof AopProxyWriter)) {
                boolean isPublic;
                boolean isConcrete = !BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(this.concreteClass);
                boolean bl = isPublic = method.getModifiers().contains((Object)Modifier.PUBLIC) || BeanDefinitionInjectProcessor.this.modelUtils.isPackagePrivate(method);
                if (this.isAopProxyType && isPublic || !this.isAopProxyType && methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) || methodAnnotationMetadata.hasDeclaredStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) && isConcrete) {
                    Object[] interceptorTypes = methodAnnotationMetadata.getAnnotationNamesByStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE).toArray();
                    OptionalValues settings = methodAnnotationMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class);
                    AopProxyWriter aopProxyWriter = this.resolveAopProxyWriter(beanWriter, (OptionalValues<Boolean>)settings, false, this.constructorParameterInfo, interceptorTypes);
                    aopProxyWriter.visitInterceptorTypes(interceptorTypes);
                    boolean isAnnotationReference = methodAnnotationMetadata instanceof AnnotationMetadataReference;
                    Object aroundMethodMetadata = !isAnnotationReference && executableMethodWriter != null ? new AnnotationMetadataReference(executableMethodWriter.getClassName(), methodAnnotationMetadata) : (methodAnnotationMetadata instanceof AnnotationMetadataHierarchy ? methodAnnotationMetadata : new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, methodAnnotationMetadata}));
                    if (BeanDefinitionInjectProcessor.this.modelUtils.isFinal(method)) {
                        if (methodAnnotationMetadata.hasDeclaredStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                            BeanDefinitionInjectProcessor.this.error(method, "Method defines AOP advice but is declared final. Change the method to be non-final in order for AOP advice to be applied.", new Object[0]);
                        } else if (this.isAopProxyType && isPublic && !declaringClass.equals(this.concreteClass)) {
                            if (executableMethodWriter == null) {
                                beanWriter.visitExecutableMethod(typeRef, resolvedReturnType, resolvedReturnType, returnTypeGenerics, method.getSimpleName().toString(), params.getParameters(), params.getGenericParameters(), params.getParameterMetadata(), params.getGenericTypes(), methodAnnotationMetadata, JavaModelUtils.isInterface((Element)enclosingElement));
                            }
                        } else {
                            BeanDefinitionInjectProcessor.this.error(method, "Public method inherits AOP advice but is declared final. Either make the method non-public or apply AOP advice only to public methods declared on the class.", new Object[0]);
                        }
                    } else {
                        if (aroundMethodMetadata.hasStereotype(Executable.class)) {
                            aopProxyWriter.visitExecutableMethod(typeRef, resolvedReturnType, resolvedReturnType, returnTypeGenerics, method.getSimpleName().toString(), params.getParameters(), params.getGenericParameters(), params.getParameterMetadata(), params.getGenericTypes(), aroundMethodMetadata, JavaModelUtils.isInterface((Element)enclosingElement));
                        }
                        aopProxyWriter.visitAroundMethod(typeRef, resolvedReturnType, resolvedReturnType, returnTypeGenerics, method.getSimpleName().toString(), params.getParameters(), params.getGenericParameters(), params.getParameterMetadata(), params.getGenericTypes(), aroundMethodMetadata, JavaModelUtils.isInterface((Element)enclosingElement));
                    }
                } else if (executableMethodWriter == null) {
                    beanWriter.visitExecutableMethod(typeRef, resolvedReturnType, resolvedReturnType, returnTypeGenerics, method.getSimpleName().toString(), params.getParameters(), params.getGenericParameters(), params.getParameterMetadata(), params.getGenericTypes(), methodAnnotationMetadata, JavaModelUtils.isInterface((Element)enclosingElement));
                }
            }
        }

        private void visitAdaptedMethod(final ExecutableElement method, final AnnotationMetadata methodAnnotationMetadata) {
            DeclaredType typeToImplement;
            Element element;
            Optional targetType = methodAnnotationMetadata.getValue(Adapter.class, String.class).flatMap(s -> {
                TypeMirror typeMirror;
                TypeElement typeElement = BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement((CharSequence)s);
                if (typeElement != null && (typeMirror = typeElement.asType()) instanceof DeclaredType) {
                    return Optional.of((DeclaredType)typeMirror);
                }
                return Optional.empty();
            });
            if (targetType.isPresent() && (element = (typeToImplement = (DeclaredType)targetType.get()).asElement()) instanceof TypeElement) {
                final TypeElement typeElement = (TypeElement)element;
                boolean isInterface = JavaModelUtils.isInterface((Element)element);
                if (isInterface) {
                    PackageElement packageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(this.concreteClass);
                    String packageName = packageElement.getQualifiedName().toString();
                    String declaringClassSimpleName = this.concreteClass.getSimpleName().toString();
                    String beanClassName = this.generateAdaptedMethodClassName(method, typeElement, declaringClassSimpleName);
                    AopProxyWriter aopProxyWriter = new AopProxyWriter(packageName, beanClassName, true, false, methodAnnotationMetadata, new Object[]{BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(typeToImplement)}, ArrayUtils.EMPTY_OBJECT_ARRAY);
                    aopProxyWriter.visitBeanDefinitionConstructor(methodAnnotationMetadata, false);
                    this.beanDefinitionWriters.put(BeanDefinitionInjectProcessor.this.elementUtils.getName(packageName + '.' + beanClassName), (BeanDefinitionVisitor)aopProxyWriter);
                    List<? extends TypeMirror> typeArguments = ((DeclaredType)typeElement.asType()).getTypeArguments();
                    final HashMap<String, TypeMirror> typeVariables = new HashMap<String, TypeMirror>(typeArguments.size());
                    for (TypeMirror typeMirror : typeArguments) {
                        typeVariables.put(typeMirror.toString(), typeMirror);
                    }
                    typeToImplement.accept(new PublicAbstractMethodVisitor<Object, AopProxyWriter>(typeElement, BeanDefinitionInjectProcessor.this.modelUtils, BeanDefinitionInjectProcessor.this.elementUtils){
                        boolean first;
                        {
                            super(classElement, modelUtils, elementUtils);
                            this.first = true;
                        }

                        @Override
                        protected void accept(DeclaredType type, Element element, AopProxyWriter aopProxyWriter) {
                            if (!this.first) {
                                BeanDefinitionInjectProcessor.this.error(method, "Interface to adapt [" + typeToImplement + "] is not a SAM type. More than one abstract method declared.", new Object[0]);
                                return;
                            }
                            this.first = false;
                            ExecutableElement targetMethod = (ExecutableElement)element;
                            List<? extends VariableElement> targetParameters = targetMethod.getParameters();
                            List<? extends VariableElement> sourceParameters = method.getParameters();
                            int paramLen = targetParameters.size();
                            if (paramLen == sourceParameters.size()) {
                                HashMap<String, Object> genericTypes = new HashMap<String, Object>();
                                for (int i = 0; i < paramLen; ++i) {
                                    TypeMirror thatType;
                                    TypeMirror thisType;
                                    VariableElement targetElement = targetParameters.get(i);
                                    VariableElement sourceElement = sourceParameters.get(i);
                                    TypeMirror targetType = targetElement.asType();
                                    TypeMirror sourceType = sourceElement.asType();
                                    if (targetType.getKind() == TypeKind.TYPEVAR) {
                                        TypeVariable tv = (TypeVariable)targetType;
                                        String variableName = tv.toString();
                                        if (typeVariables.containsKey(variableName)) {
                                            TypeMirror variableMirror = (TypeMirror)typeVariables.get(variableName);
                                            if (variableMirror.getKind() == TypeKind.TYPEVAR) {
                                                TypeVariable tv2 = (TypeVariable)variableMirror;
                                                TypeMirror lowerBound = tv2.getLowerBound();
                                                if (lowerBound.getKind() == TypeKind.DECLARED) {
                                                    targetType = lowerBound;
                                                } else {
                                                    TypeMirror upperBound = tv2.getUpperBound();
                                                    if (upperBound.getKind() == TypeKind.DECLARED) {
                                                        targetType = upperBound;
                                                    }
                                                }
                                            }
                                            genericTypes.put(variableName, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(sourceType));
                                        } else {
                                            TypeMirror lowerBound = tv.getLowerBound();
                                            if (lowerBound.getKind() == TypeKind.DECLARED) {
                                                targetType = lowerBound;
                                            } else {
                                                TypeMirror upperBound = tv.getUpperBound();
                                                if (upperBound.getKind() == TypeKind.DECLARED) {
                                                    targetType = upperBound;
                                                }
                                            }
                                        }
                                    }
                                    if (BeanDefinitionInjectProcessor.this.typeUtils.isAssignable(thisType = BeanDefinitionInjectProcessor.this.typeUtils.erasure(sourceType), thatType = BeanDefinitionInjectProcessor.this.typeUtils.erasure(targetType))) continue;
                                    BeanDefinitionInjectProcessor.this.error(method, "Cannot adapt method [" + method + "] to target method [" + targetMethod + "]. Type [" + sourceType + "] is not a subtype of type [" + targetType + "] for argument at position " + i, new Object[0]);
                                    return;
                                }
                                if (!genericTypes.isEmpty()) {
                                    Map typeData = Collections.singletonMap(BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(typeToImplement).toString(), genericTypes);
                                    aopProxyWriter.visitTypeArguments(typeData);
                                }
                                HashMap<String, Object> boundTypes = genericTypes;
                                ExecutableElementParamInfo params = AnnBeanElementVisitor.this.populateParameterData(typeElement.getQualifiedName().toString(), targetMethod, boundTypes);
                                Object owningType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(targetMethod.getEnclosingElement());
                                if (owningType == null) {
                                    throw new IllegalStateException("Owning type cannot be null");
                                }
                                TypeMirror returnTypeMirror = targetMethod.getReturnType();
                                Object resolvedReturnType = BeanDefinitionInjectProcessor.this.genericUtils.resolveTypeReference(returnTypeMirror, boundTypes);
                                Map<String, Object> returnTypeGenerics = BeanDefinitionInjectProcessor.this.genericUtils.resolveGenericTypes(returnTypeMirror, boundTypes);
                                String methodName = targetMethod.getSimpleName().toString();
                                Map<String, Object> methodParameters = params.getParameters();
                                Map<String, Object> genericParameters = params.getGenericParameters();
                                Map<String, AnnotationMetadata> methodQualifier = params.getParameterMetadata();
                                Map<String, Map<String, Object>> methodGenericTypes = params.getGenericTypes();
                                AnnotationClassValue[] adaptedArgumentTypes = new AnnotationClassValue[paramLen];
                                for (int i = 0; i < adaptedArgumentTypes.length; ++i) {
                                    VariableElement ve = sourceParameters.get(i);
                                    Object r = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(ve.asType());
                                    adaptedArgumentTypes[i] = r instanceof Class ? new AnnotationClassValue((Class)r) : new AnnotationClassValue(r.toString());
                                }
                                Map members = CollectionUtils.mapOf((Object[])new Object[]{"adaptedBean", new AnnotationClassValue(BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeName(AnnBeanElementVisitor.this.concreteClass.asType())), "adaptedMethod", method.getSimpleName().toString(), "adaptedArgumentTypes", adaptedArgumentTypes});
                                String qualifier = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(AnnBeanElementVisitor.this.concreteClass).getValue(Named.class, String.class).orElse(null);
                                if (StringUtils.isNotEmpty((CharSequence)qualifier)) {
                                    members.put("adaptedQualifier", qualifier);
                                }
                                AnnotationMetadata annotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)methodAnnotationMetadata, (String)Adapter.class.getName(), (Map)members);
                                aopProxyWriter.visitAroundMethod(owningType, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnTypeMirror), resolvedReturnType, returnTypeGenerics, methodName, methodParameters, genericParameters, methodQualifier, methodGenericTypes, annotationMetadata, JavaModelUtils.isInterface((Element)method.getEnclosingElement()));
                            } else {
                                BeanDefinitionInjectProcessor.this.error(method, "Cannot adapt method [" + method + "] to target method [" + targetMethod + "]. Argument lengths don't match.", new Object[0]);
                            }
                        }
                    }, aopProxyWriter);
                }
            }
        }

        private String generateAdaptedMethodClassName(ExecutableElement method, TypeElement typeElement, String declaringClassSimpleName) {
            String rootName = declaringClassSimpleName + '$' + typeElement.getSimpleName().toString() + '$' + method.getSimpleName().toString();
            return rootName + this.adaptedMethodIndex.incrementAndGet();
        }

        private AopProxyWriter resolveAopProxyWriter(BeanDefinitionVisitor beanWriter, OptionalValues<Boolean> aopSettings, boolean isFactoryType, ExecutableElementParamInfo constructorParameterInfo, Object ... interceptorTypes) {
            AopProxyWriter aopProxyWriter;
            BeanDefinitionVisitor aopWriter;
            String beanName = beanWriter.getBeanDefinitionName();
            DynamicName proxyKey = this.createProxyKey(beanName);
            BeanDefinitionVisitor beanDefinitionVisitor = aopWriter = beanWriter instanceof AopProxyWriter ? beanWriter : this.beanDefinitionWriters.get(proxyKey);
            if (aopWriter == null) {
                aopProxyWriter = new AopProxyWriter((BeanDefinitionWriter)beanWriter, aopSettings, interceptorTypes);
                if (constructorParameterInfo != null) {
                    aopProxyWriter.visitBeanDefinitionConstructor(constructorParameterInfo.getAnnotationMetadata(), constructorParameterInfo.isRequiresReflection(), constructorParameterInfo.getParameters(), constructorParameterInfo.getParameterMetadata(), constructorParameterInfo.getGenericTypes());
                } else {
                    aopProxyWriter.visitBeanDefinitionConstructor(AnnotationMetadata.EMPTY_METADATA, false);
                }
                if (isFactoryType) {
                    aopProxyWriter.visitSuperBeanDefinitionFactory(beanName);
                } else {
                    aopProxyWriter.visitSuperBeanDefinition(beanName);
                }
                aopWriter = aopProxyWriter;
                this.beanDefinitionWriters.put(proxyKey, aopWriter);
            } else {
                aopProxyWriter = (AopProxyWriter)aopWriter;
            }
            return aopProxyWriter;
        }

        void visitAnnotatedMethod(ExecutableElement method, Object o) {
            AnnotationMetadata annotationMetadata;
            boolean overriddenInjected;
            ExecutableElementParamInfo params = this.populateParameterData(null, method, Collections.emptyMap());
            TypeMirror returnType = method.getReturnType();
            TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
            if (declaringClass == null) {
                return;
            }
            boolean isParent = !declaringClass.getQualifiedName().equals(this.concreteClass.getQualifiedName());
            ExecutableElement overridingMethod = BeanDefinitionInjectProcessor.this.modelUtils.overridingOrHidingMethod(method, this.concreteClass, false).orElse(method);
            TypeElement overridingClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(overridingMethod);
            boolean overridden = isParent && overridingClass != null && !overridingClass.getQualifiedName().equals(declaringClass.getQualifiedName());
            boolean isPackagePrivate = BeanDefinitionInjectProcessor.this.modelUtils.isPackagePrivate(method);
            boolean isPrivate = BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(method);
            if (overridden && !isPrivate && !isPackagePrivate) {
                return;
            }
            PackageElement packageOfOverridingClass = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(overridingMethod);
            PackageElement packageOfDeclaringClass = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(declaringClass);
            boolean isPackagePrivateAndPackagesDiffer = overridden && isPackagePrivate && !packageOfOverridingClass.getQualifiedName().equals(packageOfDeclaringClass.getQualifiedName());
            boolean requiresReflection = isPrivate || isPackagePrivateAndPackagesDiffer;
            boolean bl = overriddenInjected = overridden && BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(overridingMethod).hasDeclaredStereotype(Inject.class);
            if (isParent && isPackagePrivate && !isPackagePrivateAndPackagesDiffer && overriddenInjected) {
                return;
            }
            if (isParent && overridden && !overriddenInjected && !isPackagePrivateAndPackagesDiffer && !isPrivate) {
                return;
            }
            if (!requiresReflection && BeanDefinitionInjectProcessor.this.modelUtils.isInheritedAndNotPublic(this.concreteClass, declaringClass, method)) {
                requiresReflection = true;
            }
            if ((annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(method)).hasDeclaredStereotype("javax.annotation.PostConstruct")) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                AopProxyWriter aopWriter = this.resolveAopWriter(writer);
                if (aopWriter != null && !aopWriter.isProxyTarget()) {
                    writer = aopWriter;
                }
                writer.visitPostConstructMethod(BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(declaringClass), requiresReflection, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnType), method.getSimpleName().toString(), params.getParameters(), params.getParameterMetadata(), params.getGenericTypes(), annotationMetadata);
            } else if (annotationMetadata.hasDeclaredStereotype("javax.annotation.PreDestroy")) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                AopProxyWriter aopWriter = this.resolveAopWriter(writer);
                if (aopWriter != null && !aopWriter.isProxyTarget()) {
                    writer = aopWriter;
                }
                writer.visitPreDestroyMethod(BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(declaringClass), requiresReflection, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnType), method.getSimpleName().toString(), params.getParameters(), params.getParameterMetadata(), params.getGenericTypes(), annotationMetadata);
            } else if (annotationMetadata.hasDeclaredStereotype(Inject.class) || annotationMetadata.hasDeclaredStereotype(ConfigurationInject.class)) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                writer.visitMethodInjectionPoint(BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(declaringClass), requiresReflection, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(returnType), method.getSimpleName().toString(), params.getParameters(), params.getParameterMetadata(), params.getGenericTypes(), annotationMetadata);
            } else {
                BeanDefinitionInjectProcessor.this.error("Unexpected call to visitAnnotatedMethod(%s)", method);
            }
        }

        @Nullable
        private AopProxyWriter resolveAopWriter(BeanDefinitionVisitor writer) {
            DynamicName proxyKey = this.createProxyKey(writer.getBeanDefinitionName());
            BeanDefinitionVisitor aopWriter = this.beanDefinitionWriters.get(proxyKey);
            if (aopWriter instanceof AopProxyWriter) {
                return (AopProxyWriter)aopWriter;
            }
            if (this.isAopProxyType) {
                Object[] interceptorTypes = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(this.concreteClass).getAnnotationNamesByStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE).toArray();
                return this.resolveAopProxyWriter(writer, this.aopSettings, this.isFactoryType, this.constructorParameterInfo, interceptorTypes);
            }
            return null;
        }

        @Override
        public Object visitVariable(VariableElement variable, Object o) {
            boolean isInjected;
            boolean isValue;
            if (variable.getKind() != ElementKind.FIELD) {
                return null;
            }
            if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic(variable) || BeanDefinitionInjectProcessor.this.modelUtils.isFinal(variable)) {
                return null;
            }
            AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(variable);
            if (fieldAnnotationMetadata.hasDeclaredAnnotation("org.jetbrains.annotations.Nullable")) {
                fieldAnnotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)fieldAnnotationMetadata, (String)"javax.annotation.Nullable", Collections.emptyMap());
            }
            boolean bl = isValue = !(isInjected = fieldAnnotationMetadata.hasStereotype(Inject.class)) && (fieldAnnotationMetadata.hasStereotype(Value.class) || fieldAnnotationMetadata.hasStereotype(Property.class));
            if (isInjected || isValue) {
                TypeMirror type;
                boolean requiresReflection;
                Name fieldName = variable.getSimpleName();
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(variable);
                if (declaringClass == null) {
                    return null;
                }
                boolean isPrivate = BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(variable);
                boolean bl2 = requiresReflection = isPrivate || BeanDefinitionInjectProcessor.this.modelUtils.isInheritedAndNotPublic(this.concreteClass, declaringClass, variable);
                if (!writer.isValidated() && fieldAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_CONSTRAINT)) {
                    writer.setValidated(true);
                }
                if ((type = variable.asType()).getKind() == TypeKind.ERROR && !BeanDefinitionInjectProcessor.this.processingOver) {
                    throw new PostponeToNextRoundException();
                }
                Object fieldType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(type);
                if (isValue) {
                    writer.visitFieldValue(BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(declaringClass), fieldType, fieldName.toString(), requiresReflection, fieldAnnotationMetadata, BeanDefinitionInjectProcessor.this.genericUtils.resolveGenericTypes(type, Collections.emptyMap()), this.isConfigurationPropertiesType);
                } else {
                    writer.visitFieldInjectionPoint(BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(declaringClass), fieldType, fieldName.toString(), requiresReflection, fieldAnnotationMetadata, BeanDefinitionInjectProcessor.this.genericUtils.resolveGenericTypes(type, Collections.emptyMap()));
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitConfigurationProperty(VariableElement field, AnnotationMetadata fieldAnnotationMetadata) {
            boolean isMethodInjected;
            Optional<ExecutableElement> setterMethod = BeanDefinitionInjectProcessor.this.modelUtils.findSetterMethodFor(field);
            boolean isInjected = fieldAnnotationMetadata.hasStereotype(Inject.class);
            boolean isValue = fieldAnnotationMetadata.hasStereotype(Value.class) || fieldAnnotationMetadata.hasStereotype(Property.class);
            boolean bl = isMethodInjected = isInjected || setterMethod.isPresent() && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((Element)setterMethod.get(), Inject.class);
            if (!isMethodInjected && !isValue) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                if (!writer.isValidated() && fieldAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_CONSTRAINT)) {
                    writer.setValidated(true);
                }
                TypeMirror fieldTypeMirror = field.asType();
                Object fieldType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(fieldTypeMirror);
                TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(field);
                if (declaringClass == null) {
                    return null;
                }
                String fieldName = field.getSimpleName().toString();
                if (fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                    boolean accessible = false;
                    if (BeanDefinitionInjectProcessor.this.modelUtils.isPublic(field)) {
                        accessible = true;
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isPackagePrivate(field) || BeanDefinitionInjectProcessor.this.modelUtils.isProtected(field)) {
                        PackageElement declaringPackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(declaringClass);
                        PackageElement concretePackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(this.concreteClass);
                        accessible = declaringPackage.getQualifiedName().equals(concretePackage.getQualifiedName());
                    }
                    if (accessible) {
                        writer.visitConfigBuilderField(fieldType, fieldName, fieldAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder);
                    } else {
                        Optional<ExecutableElement> getterMethod = BeanDefinitionInjectProcessor.this.modelUtils.findGetterMethodFor(field);
                        if (getterMethod.isPresent()) {
                            writer.visitConfigBuilderMethod(fieldType, getterMethod.get().getSimpleName().toString(), fieldAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder);
                        } else {
                            BeanDefinitionInjectProcessor.this.error(field, "ConfigurationBuilder applied to a non accessible (private or package-private/protected in a different package) field must have a corresponding non-private getter method.", new Object[0]);
                        }
                    }
                    try {
                        this.visitConfigurationBuilder(declaringClass, field, fieldTypeMirror, writer);
                    }
                    finally {
                        writer.visitConfigBuilderEnd();
                    }
                } else {
                    if (this.shouldExclude(this.configurationMetadata, fieldName)) {
                        return null;
                    }
                    if (setterMethod.isPresent()) {
                        ExecutableElement method = setterMethod.get();
                        String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                        BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, BeanDefinitionInjectProcessor.this.getPropertyMetadataTypeReference(fieldTypeMirror), fieldName, docComment, null);
                    } else {
                        boolean isPrivate = BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(field);
                        boolean requiresReflection = this.isInheritedAndNotPublic(BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(field), field.getModifiers());
                        if (!isPrivate) {
                            Object declaringType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(declaringClass);
                            String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(field);
                            PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, BeanDefinitionInjectProcessor.this.getPropertyMetadataTypeReference(fieldTypeMirror), fieldName, docComment, null);
                            fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.addPropertyMetadata(fieldAnnotationMetadata, propertyMetadata);
                            writer.visitFieldValue(declaringType, fieldType, fieldName, requiresReflection, fieldAnnotationMetadata, BeanDefinitionInjectProcessor.this.genericUtils.resolveGenericTypes(fieldTypeMirror, Collections.emptyMap()), this.isConfigurationPropertiesType);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public Object visitTypeParameter(TypeParameterElement e, Object o) {
            BeanDefinitionInjectProcessor.this.note("Visit param %s for %s", e.getSimpleName(), o);
            return super.visitTypeParameter(e, o);
        }

        @Override
        public Object visitUnknown(Element e, Object o) {
            BeanDefinitionInjectProcessor.this.note("Visit unknown %s for %s", e.getSimpleName(), o);
            return super.visitUnknown(e, o);
        }

        protected boolean isInheritedAndNotPublic(TypeElement declaringClass, Set<Modifier> modifiers) {
            PackageElement declaringPackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(declaringClass);
            PackageElement concretePackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(this.concreteClass);
            return !declaringClass.equals(this.concreteClass) && !declaringPackage.equals(concretePackage) && !modifiers.contains((Object)Modifier.PUBLIC);
        }

        private void visitConfigurationBuilder(final TypeElement declaringClass, Element builderElement, TypeMirror builderType, final BeanDefinitionVisitor writer) {
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(builderElement);
            final Boolean allowZeroArgs = annotationMetadata.getValue(ConfigurationBuilder.class, "allowZeroArgs", Boolean.class).orElse(false);
            final List<Object> prefixes = Arrays.asList((Object[])annotationMetadata.getValue(ConfigurationBuilder.class, "prefixes", String[].class).orElse(new String[]{"set"}));
            final String configurationPrefix = annotationMetadata.getValue(ConfigurationBuilder.class, String.class).map(v -> v + ".").orElse("");
            final Set includes = annotationMetadata.getValue(ConfigurationBuilder.class, "includes", Set.class).orElse(Collections.emptySet());
            final Set excludes = annotationMetadata.getValue(ConfigurationBuilder.class, "excludes", Set.class).orElse(Collections.emptySet());
            PublicMethodVisitor visitor = new PublicMethodVisitor(BeanDefinitionInjectProcessor.this.typeUtils){

                @Override
                protected void accept(DeclaredType type, Element element, Object o) {
                    String prefix;
                    ExecutableElement method = (ExecutableElement)element;
                    List<? extends VariableElement> params = method.getParameters();
                    String methodName = method.getSimpleName().toString();
                    String propertyName = NameUtils.decapitalize((String)methodName.substring((prefix = this.getMethodPrefix(prefixes, methodName)).length()));
                    if (AnnBeanElementVisitor.this.shouldExclude(includes, excludes, propertyName)) {
                        return;
                    }
                    int paramCount = params.size();
                    if (paramCount < 2) {
                        VariableElement paramType = paramCount == 1 ? params.get(0) : null;
                        Object expectedType = paramType != null ? BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(paramType.asType()) : null;
                        PropertyMetadata metadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(AnnBeanElementVisitor.this.concreteClass, declaringClass, expectedType != null ? expectedType.toString() : null, configurationPrefix + propertyName, null, null);
                        writer.visitConfigBuilderMethod(prefix, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(method.getReturnType()), methodName, expectedType, paramType != null ? BeanDefinitionInjectProcessor.this.genericUtils.resolveGenericTypes(paramType.asType(), Collections.emptyMap()) : null, metadata.getPath());
                    } else if (paramCount == 2) {
                        VariableElement first = params.get(0);
                        VariableElement second = params.get(1);
                        TypeMirror tu = BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement(TimeUnit.class.getName()).asType();
                        TypeMirror typeMirror = first.asType();
                        if (typeMirror.toString().equals("long") && BeanDefinitionInjectProcessor.this.typeUtils.isAssignable(second.asType(), tu)) {
                            PropertyMetadata metadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(AnnBeanElementVisitor.this.concreteClass, declaringClass, Duration.class.getName(), configurationPrefix + propertyName, null, null);
                            writer.visitConfigBuilderDurationMethod(prefix, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(method.getReturnType()), methodName, metadata.getPath());
                        }
                    }
                }

                @Override
                protected boolean isAcceptable(Element element) {
                    if (BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype(element, Deprecated.class)) {
                        return false;
                    }
                    Set<Modifier> modifiers = element.getModifiers();
                    if (element.getKind() == ElementKind.METHOD) {
                        ExecutableElement method = (ExecutableElement)element;
                        int paramCount = method.getParameters().size();
                        return modifiers.contains((Object)Modifier.PUBLIC) && (paramCount > 0 && paramCount < 3 || allowZeroArgs != false && paramCount == 0) && this.isPrefixedWith(method, prefixes);
                    }
                    return false;
                }

                private boolean isPrefixedWith(Element enclosedElement, List<String> prefixes2) {
                    String name = enclosedElement.getSimpleName().toString();
                    for (String prefix : prefixes2) {
                        if (!name.startsWith(prefix)) continue;
                        return true;
                    }
                    return false;
                }

                private String getMethodPrefix(List<String> prefixes2, String methodName) {
                    for (String prefix : prefixes2) {
                        if (!methodName.startsWith(prefix)) continue;
                        return prefix;
                    }
                    return methodName;
                }
            };
            builderType.accept(visitor, null);
        }

        private BeanDefinitionWriter createBeanDefinitionWriterFor(TypeElement typeElement) {
            TypeMirror providerTypeParam = BeanDefinitionInjectProcessor.this.genericUtils.interfaceGenericTypeFor(typeElement, Provider.class);
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(typeElement);
            PackageElement packageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(typeElement);
            String beanClassName = BeanDefinitionInjectProcessor.this.modelUtils.simpleBinaryNameFor(typeElement);
            boolean isInterface = JavaModelUtils.isInterface((Element)typeElement);
            if (this.configurationMetadata != null) {
                String existingPrefix = annotationMetadata.getValue(ConfigurationReader.class, "prefix", String.class).orElse("");
                annotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)annotationMetadata, (String)ConfigurationReader.class.getName(), (String)"prefix", (Object)(StringUtils.isNotEmpty((CharSequence)existingPrefix) ? existingPrefix + "." + this.configurationMetadata.getName() : this.configurationMetadata.getName()));
            }
            BeanDefinitionWriter beanDefinitionWriter = new BeanDefinitionWriter(packageElement.getQualifiedName().toString(), beanClassName, providerTypeParam == null ? BeanDefinitionInjectProcessor.this.elementUtils.getBinaryName(typeElement).toString() : providerTypeParam.toString(), isInterface, annotationMetadata);
            this.visitTypeArguments(typeElement, beanDefinitionWriter);
            return beanDefinitionWriter;
        }

        private void visitTypeArguments(TypeElement typeElement, BeanDefinitionWriter beanDefinitionWriter) {
            Map<String, Map<String, Object>> typeArguments = BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentInfo(typeElement);
            beanDefinitionWriter.visitTypeArguments(typeArguments);
        }

        private DynamicName createProxyKey(String beanName) {
            return new DynamicName(beanName + "$Proxy");
        }

        private AopProxyWriter createIntroductionAdviceWriter(TypeElement typeElement) {
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(typeElement);
            PackageElement packageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(typeElement);
            String beanClassName = BeanDefinitionInjectProcessor.this.modelUtils.simpleBinaryNameFor(typeElement);
            Object[] aroundInterceptors = annotationMetadata.getAnnotationNamesByStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE).toArray();
            Object[] introductionInterceptors = annotationMetadata.getAnnotationNamesByStereotype(Introduction.class).toArray();
            Object[] interfaceTypes = annotationMetadata.getValue(Introduction.class, "interfaces", String[].class).orElse(new String[0]);
            Object[] interceptorTypes = ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
            boolean isInterface = JavaModelUtils.isInterface((Element)typeElement);
            AopProxyWriter aopProxyWriter = new AopProxyWriter(packageElement.getQualifiedName().toString(), beanClassName, isInterface, annotationMetadata, interfaceTypes, interceptorTypes);
            if (ArrayUtils.isNotEmpty((Object[])interfaceTypes)) {
                List<? extends AnnotationMirror> annotationMirrors = typeElement.getAnnotationMirrors();
                HashSet<TypeElement> additionalInterfaces = new HashSet<TypeElement>(3);
                this.populateIntroductionInterfaces(annotationMirrors, additionalInterfaces);
                if (!additionalInterfaces.isEmpty()) {
                    for (TypeElement additionalInterface : additionalInterfaces) {
                        this.visitIntroductionAdviceInterface(additionalInterface, annotationMetadata, aopProxyWriter);
                    }
                }
            }
            return aopProxyWriter;
        }

        private void populateIntroductionInterfaces(List<? extends AnnotationMirror> annotationMirrors, Set<TypeElement> additionalInterfaces) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType.toString().equals(Introduction.class.getName())) {
                    Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                        ExecutableElement key = entry.getKey();
                        if (!key.toString().equalsIgnoreCase("interfaces()")) continue;
                        Object value = entry.getValue().getValue();
                        if (value instanceof List) {
                            for (Object v : (List)value) {
                                if (!(v instanceof AnnotationValue)) continue;
                                this.tryAddAnnotationValue(additionalInterfaces, (AnnotationValue)v);
                            }
                            continue;
                        }
                        if (!(value instanceof AnnotationValue)) continue;
                        this.tryAddAnnotationValue(additionalInterfaces, (AnnotationValue)value);
                    }
                    continue;
                }
                Element element = annotationType.asElement();
                if (!BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype(element, Introduction.class)) continue;
                this.populateIntroductionInterfaces(element.getAnnotationMirrors(), additionalInterfaces);
            }
        }

        private void tryAddAnnotationValue(Set<TypeElement> additionalInterfaces, AnnotationValue v) {
            TypeMirror tm;
            Object v2 = v.getValue();
            if (v2 instanceof TypeMirror && (tm = (TypeMirror)v2).getKind() == TypeKind.DECLARED) {
                DeclaredType dt = (DeclaredType)tm;
                additionalInterfaces.add((TypeElement)dt.asElement());
            }
        }

        private BeanDefinitionWriter createFactoryBeanMethodWriterFor(ExecutableElement method, TypeElement producedElement) {
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(producedElement, method, true);
            PackageElement producedPackageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(producedElement);
            PackageElement definingPackageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(this.concreteClass);
            boolean isInterface = JavaModelUtils.isInterface((Element)producedElement);
            String packageName = producedPackageElement.getQualifiedName().toString();
            String beanDefinitionPackage = definingPackageElement.getQualifiedName().toString();
            String shortClassName = BeanDefinitionInjectProcessor.this.modelUtils.simpleBinaryNameFor(producedElement);
            String upperCaseMethodName = NameUtils.capitalize((String)method.getSimpleName().toString());
            String factoryMethodBeanDefinitionName = beanDefinitionPackage + ".$" + this.concreteClass.getSimpleName().toString() + "$" + upperCaseMethodName + this.factoryMethodIndex.getAndIncrement() + "Definition";
            return new BeanDefinitionWriter(packageName, shortClassName, factoryMethodBeanDefinitionName, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(producedElement).toString(), isInterface, annotationMetadata);
        }

        private ExecutableElementParamInfo populateParameterData(@Nullable String declaringTypeName, ExecutableElement element, Map<String, Object> boundTypes) {
            if (element == null) {
                return new ExecutableElementParamInfo(false, null);
            }
            AnnotationMetadata elementMetadata = declaringTypeName == null ? BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(element) : BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().build(declaringTypeName, element);
            ExecutableElementParamInfo params = new ExecutableElementParamInfo(BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(element), elementMetadata);
            boolean isConstructBinding = elementMetadata.hasDeclaredStereotype(ConfigurationInject.class);
            if (isConstructBinding) {
                this.configurationMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperties(this.concreteClass, null);
            }
            element.getParameters().forEach(paramElement -> {
                String argName = paramElement.getSimpleName().toString();
                AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata((Element)paramElement);
                if (annotationMetadata.hasDeclaredAnnotation("org.jetbrains.annotations.Nullable")) {
                    annotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)annotationMetadata, (String)"javax.annotation.Nullable", Collections.emptyMap());
                }
                if (annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_CONSTRAINT)) {
                    params.setValidated(true);
                }
                TypeMirror typeMirror = paramElement.asType();
                if (isConstructBinding) {
                    if (Stream.of(Property.class, Value.class, Parameter.class).noneMatch(arg_0 -> ((AnnotationMetadata)annotationMetadata).hasAnnotation(arg_0))) {
                        AnnotationMetadata parameterTypeMetadata;
                        Element parameterElement = BeanDefinitionInjectProcessor.this.typeUtils.asElement(typeMirror);
                        AnnotationMetadata annotationMetadata2 = parameterTypeMetadata = parameterElement != null ? BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(parameterElement) : AnnotationMetadata.EMPTY_METADATA;
                        if (!parameterTypeMetadata.hasStereotype(Scope.class)) {
                            annotationMetadata = BeanDefinitionInjectProcessor.this.addPropertyMetadata(annotationMetadata, paramElement, argName);
                        }
                    }
                }
                params.addAnnotationMetadata(argName, annotationMetadata);
                TypeKind kind = typeMirror.getKind();
                if (kind == TypeKind.ERROR && !BeanDefinitionInjectProcessor.this.processingOver) {
                    throw new PostponeToNextRoundException();
                }
                switch (kind) {
                    case ARRAY: {
                        ArrayType arrayType = (ArrayType)typeMirror;
                        TypeMirror componentType = arrayType.getComponentType();
                        Object resolvedType = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(arrayType);
                        params.addParameter(argName, resolvedType, BeanDefinitionInjectProcessor.this.genericUtils.resolveTypeReference(arrayType, boundTypes));
                        params.addGenericTypes(argName, Collections.singletonMap("E", BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(componentType)));
                        break;
                    }
                    case TYPEVAR: {
                        TypeVariable typeVariable = (TypeVariable)typeMirror;
                        DeclaredType parameterType = BeanDefinitionInjectProcessor.this.genericUtils.resolveTypeVariable((Element)paramElement, typeVariable);
                        if (parameterType != null) {
                            params.addParameter(argName, BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(typeVariable), BeanDefinitionInjectProcessor.this.genericUtils.resolveTypeReference(typeVariable, boundTypes));
                            params.addGenericTypes(argName, Collections.singletonMap(typeVariable.toString(), BeanDefinitionInjectProcessor.this.genericUtils.resolveTypeReference(typeVariable, boundTypes)));
                            break;
                        }
                        BeanDefinitionInjectProcessor.this.error(element, "Unprocessable generic type [%s] for param [%s] of element %s", typeVariable, paramElement, element);
                        break;
                    }
                    case DECLARED: {
                        DeclaredType declaredType = (DeclaredType)typeMirror;
                        TypeElement typeElement = BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement(BeanDefinitionInjectProcessor.this.typeUtils.erasure(declaredType).toString());
                        if (typeElement == null) {
                            typeElement = (TypeElement)declaredType.asElement();
                        }
                        Object type = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeReference(typeElement);
                        params.addParameter(argName, type, type);
                        Map<String, Object> resolvedParameters = BeanDefinitionInjectProcessor.this.genericUtils.resolveGenericTypes(declaredType, typeElement, boundTypes);
                        if (resolvedParameters.isEmpty()) break;
                        params.addGenericTypes(argName, resolvedParameters);
                        break;
                    }
                    default: {
                        if (kind.isPrimitive()) {
                            String typeName;
                            if (typeMirror instanceof DeclaredType) {
                                DeclaredType dt = (DeclaredType)typeMirror;
                                typeName = dt.asElement().getSimpleName().toString();
                            } else {
                                typeName = BeanDefinitionInjectProcessor.this.modelUtils.resolveTypeName(typeMirror);
                            }
                            Class<?> argType = BeanDefinitionInjectProcessor.this.modelUtils.classOfPrimitiveFor(typeName);
                            params.addParameter(argName, argType, argType);
                            break;
                        }
                        BeanDefinitionInjectProcessor.this.error(element, "Unprocessable element type [%s] for param [%s] of element %s", new Object[]{kind, paramElement, element});
                    }
                }
            });
            return params;
        }

        private boolean shouldExclude(Set<String> includes, Set<String> excludes, String propertyName) {
            if (!includes.isEmpty() && !includes.contains(propertyName)) {
                return true;
            }
            return !excludes.isEmpty() && excludes.contains(propertyName);
        }

        private boolean shouldExclude(ConfigurationMetadata configurationMetadata, String propertyName) {
            return this.shouldExclude(configurationMetadata.getIncludes(), configurationMetadata.getExcludes(), propertyName);
        }
    }
}

