/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class JavaAnnotationMetadataBuilder
extends AbstractAnnotationMetadataBuilder<Element, AnnotationMirror> {
    private static final Map<String, Map<Element, AnnotationValue>> ANNOTATION_DEFAULTS = new HashMap<String, Map<Element, AnnotationValue>>();
    private final Elements elementUtils;
    private final Messager messager;
    private final AnnotationUtils annotationUtils;
    private final ModelUtils modelUtils;

    public JavaAnnotationMetadataBuilder(Elements elements, Messager messager, AnnotationUtils annotationUtils, ModelUtils modelUtils) {
        this.elementUtils = elements;
        this.messager = messager;
        this.annotationUtils = annotationUtils;
        this.modelUtils = modelUtils;
    }

    @Nullable
    protected AnnotatedElementValidator getElementValidator() {
        return this.annotationUtils.getElementValidator();
    }

    protected void addError(@NonNull Element originatingElement, @NonNull String error) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, error, originatingElement);
    }

    protected String getAnnotationMemberName(Element member) {
        return member.getSimpleName().toString();
    }

    @Nullable
    protected String getRepeatableName(AnnotationMirror annotationMirror) {
        Element typeElement = annotationMirror.getAnnotationType().asElement();
        return this.getRepeatableNameForType(typeElement);
    }

    @Nullable
    protected String getRepeatableNameForType(Element annotationType) {
        List<? extends AnnotationMirror> mirrors = annotationType.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            String name = annotationMirror.getAnnotationType().toString();
            if (!Repeatable.class.getName().equals(name)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : elementValues.keySet()) {
                AnnotationValue av;
                Object value;
                if (!executableElement.getSimpleName().toString().equals("value") || !((value = (av = elementValues.get(executableElement)).getValue()) instanceof DeclaredType)) continue;
                Element element = ((DeclaredType)value).asElement();
                return JavaModelUtils.getClassName((TypeElement)((TypeElement)element));
            }
        }
        return null;
    }

    protected Optional<Element> getAnnotationMirror(String annotationName) {
        return Optional.ofNullable(this.elementUtils.getTypeElement(annotationName));
    }

    protected VisitorContext createVisitorContext() {
        return this.annotationUtils.newVisitorContext();
    }

    @NonNull
    protected RetentionPolicy getRetentionPolicy(@NonNull Element annotation) {
        List<? extends AnnotationMirror> annotationMirrors = annotation.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
            if (!Retention.class.getName().equals(annotationTypeName)) continue;
            Iterator<? extends AnnotationValue> i = annotationMirror.getElementValues().values().iterator();
            if (!i.hasNext()) break;
            AnnotationValue av = i.next();
            String v = av.getValue().toString();
            return RetentionPolicy.valueOf(v);
        }
        return RetentionPolicy.RUNTIME;
    }

    protected boolean isMethodOrClassElement(Element element) {
        return element instanceof TypeElement || element instanceof ExecutableElement;
    }

    @NonNull
    protected String getDeclaringType(@NonNull Element element) {
        TypeElement typeElement = this.modelUtils.classElementFor(element);
        if (typeElement != null) {
            return typeElement.getQualifiedName().toString();
        }
        return element.getSimpleName().toString();
    }

    protected Element getTypeForAnnotation(AnnotationMirror annotationMirror) {
        return annotationMirror.getAnnotationType().asElement();
    }

    protected List<? extends AnnotationMirror> getAnnotationsForType(Element element) {
        ArrayList<? extends AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>(element.getAnnotationMirrors());
        annotationMirrors.removeIf(mirror -> this.getAnnotationTypeName((AnnotationMirror)mirror).equals("kotlin.Metadata"));
        return annotationMirrors;
    }

    protected List<Element> buildHierarchy(Element element, boolean inheritTypeAnnotations, boolean declaredOnly) {
        if (declaredOnly) {
            return Collections.singletonList(element);
        }
        if (element instanceof TypeElement) {
            ArrayList<Element> hierarchy = new ArrayList<Element>();
            hierarchy.add(element);
            this.populateTypeHierarchy(element, hierarchy);
            Collections.reverse(hierarchy);
            return hierarchy;
        }
        if (element instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)element;
            List<Object> hierarchy = inheritTypeAnnotations ? this.buildHierarchy(executableElement.getEnclosingElement(), false, declaredOnly) : new ArrayList();
            if (JavaAnnotationMetadataBuilder.hasAnnotation(executableElement, Override.class)) {
                hierarchy.addAll(this.findOverriddenMethods(executableElement));
            }
            hierarchy.add(element);
            return hierarchy;
        }
        if (element instanceof VariableElement) {
            ExecutableElement executableElement;
            ArrayList<Element> hierarchy = new ArrayList<Element>();
            VariableElement variable = (VariableElement)element;
            Element enclosingElement = variable.getEnclosingElement();
            if (enclosingElement instanceof ExecutableElement && JavaAnnotationMetadataBuilder.hasAnnotation(executableElement = (ExecutableElement)enclosingElement, Override.class)) {
                int variableIdx = executableElement.getParameters().indexOf(variable);
                for (ExecutableElement overridden : this.findOverriddenMethods(executableElement)) {
                    hierarchy.add(overridden.getParameters().get(variableIdx));
                }
            }
            hierarchy.add(variable);
            return hierarchy;
        }
        ArrayList<Element> single = new ArrayList<Element>();
        single.add(element);
        return single;
    }

    protected Map<? extends Element, ?> readAnnotationRawValues(AnnotationMirror annotationMirror) {
        return annotationMirror.getElementValues();
    }

    protected OptionalValues<?> getAnnotationValues(Element originatingElement, Element member, Class<?> annotationType) {
        List<? extends AnnotationMirror> annotationMirrors = member.getAnnotationMirrors();
        String annotationName = annotationType.getName();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().endsWith(annotationName)) continue;
            Map<Element, ?> values = this.readAnnotationRawValues(annotationMirror);
            LinkedHashMap<CharSequence, Object> converted = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<Element, ?> entry : values.entrySet()) {
                Element key = entry.getKey();
                Object value = entry.getValue();
                this.readAnnotationRawValues(originatingElement, annotationName, member, key.getSimpleName().toString(), value, converted);
            }
            return OptionalValues.of(Object.class, converted);
        }
        return OptionalValues.empty();
    }

    protected void readAnnotationRawValues(Element originatingElement, String annotationName, Element member, String memberName, Object annotationValue, Map<CharSequence, Object> annotationValues) {
        if (memberName != null && annotationValue instanceof AnnotationValue && !annotationValues.containsKey(memberName)) {
            MetadataAnnotationValueVisitor resolver = new MetadataAnnotationValueVisitor(originatingElement);
            ((AnnotationValue)annotationValue).accept(resolver, this);
            Object resolvedValue = resolver.resolvedValue;
            if (resolvedValue != null) {
                this.validateAnnotationValue(originatingElement, annotationName, member, memberName, resolvedValue);
                annotationValues.put(memberName, resolvedValue);
            }
        }
    }

    protected Object readAnnotationValue(Element originatingElement, Element member, String memberName, Object annotationValue) {
        if (memberName != null && annotationValue instanceof AnnotationValue) {
            MetadataAnnotationValueVisitor visitor = new MetadataAnnotationValueVisitor(originatingElement);
            ((AnnotationValue)annotationValue).accept(visitor, this);
            return visitor.resolvedValue;
        }
        return null;
    }

    protected Map<? extends Element, ?> readAnnotationDefaultValues(AnnotationMirror annotationMirror) {
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        Element element = annotationMirror.getAnnotationType().asElement();
        return this.readAnnotationDefaultValues(annotationTypeName, element);
    }

    protected Map<? extends Element, ?> readAnnotationDefaultValues(String annotationTypeName, Element element) {
        TypeElement annotationElement;
        String annotationName;
        Map<String, Map<Element, AnnotationValue>> defaults = ANNOTATION_DEFAULTS;
        if (element instanceof TypeElement && !defaults.containsKey(annotationName = (annotationElement = (TypeElement)element).getQualifiedName().toString())) {
            HashMap defaultValues = new HashMap();
            List<? extends Element> allMembers = this.elementUtils.getAllMembers(annotationElement);
            allMembers.stream().filter(member -> member.getEnclosingElement().equals(annotationElement)).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(this::isValidDefaultValue).forEach(executableElement -> {
                AnnotationValue defaultValue = executableElement.getDefaultValue();
                defaultValues.put(executableElement, defaultValue);
            });
            defaults.put(annotationName, defaultValues);
        }
        return ANNOTATION_DEFAULTS.get(annotationTypeName);
    }

    private boolean isValidDefaultValue(ExecutableElement executableElement) {
        Object v;
        AnnotationValue defaultValue = executableElement.getDefaultValue();
        if (defaultValue != null && (v = defaultValue.getValue()) != null) {
            if (v instanceof String) {
                return StringUtils.isNotEmpty((CharSequence)((CharSequence)v));
            }
            return true;
        }
        return false;
    }

    protected String getAnnotationTypeName(AnnotationMirror annotationMirror) {
        return JavaModelUtils.getClassName((TypeElement)((TypeElement)annotationMirror.getAnnotationType().asElement()));
    }

    protected String getElementName(Element element) {
        if (element instanceof TypeElement) {
            return ((TypeElement)element).getQualifiedName().toString();
        }
        return element.getSimpleName().toString();
    }

    private void populateTypeHierarchy(Element element, List<Element> hierarchy) {
        boolean isInterface = JavaModelUtils.resolveKind((Element)element, (ElementKind)ElementKind.INTERFACE).isPresent();
        if (isInterface) {
            TypeElement typeElement = (TypeElement)element;
            List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                if (!(typeMirror instanceof DeclaredType)) continue;
                Element interfaceElement = ((DeclaredType)typeMirror).asElement();
                hierarchy.add(interfaceElement);
                this.populateTypeHierarchy(interfaceElement, hierarchy);
            }
        } else {
            while (JavaModelUtils.resolveKind((Element)element, (ElementKind)ElementKind.CLASS).isPresent()) {
                DeclaredType declaredType;
                TypeElement typeElement = (TypeElement)element;
                List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
                for (TypeMirror typeMirror : interfaces) {
                    if (!(typeMirror instanceof DeclaredType)) continue;
                    Element interfaceElement = ((DeclaredType)typeMirror).asElement();
                    hierarchy.add(interfaceElement);
                    this.populateTypeHierarchy(interfaceElement, hierarchy);
                }
                TypeMirror superMirror = typeElement.getSuperclass();
                if (superMirror instanceof DeclaredType && !(declaredType = (DeclaredType)superMirror).toString().equals(Object.class.getName())) {
                    element = declaredType.asElement();
                    hierarchy.add(element);
                    continue;
                }
                break;
            }
        }
    }

    private List<ExecutableElement> findOverriddenMethods(ExecutableElement executableElement) {
        ArrayList<ExecutableElement> overridden = new ArrayList<ExecutableElement>();
        Element enclosingElement = executableElement.getEnclosingElement();
        if (enclosingElement instanceof TypeElement) {
            TypeElement supertype = (TypeElement)enclosingElement;
            while (supertype != null && !supertype.toString().equals(Object.class.getName())) {
                Optional<ExecutableElement> result = this.findOverridden(executableElement, supertype);
                if (result.isPresent()) {
                    ExecutableElement overriddenMethod = result.get();
                    overridden.add(overriddenMethod);
                }
                this.findOverriddenInterfaceMethod(executableElement, overridden, supertype);
                TypeMirror superclass = supertype.getSuperclass();
                if (!(superclass instanceof DeclaredType)) break;
                supertype = (TypeElement)((DeclaredType)superclass).asElement();
            }
        }
        return overridden;
    }

    private void findOverriddenInterfaceMethod(ExecutableElement executableElement, List<ExecutableElement> overridden, TypeElement supertype) {
        List<? extends TypeMirror> interfaces = supertype.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (!(typeMirror instanceof DeclaredType)) continue;
            DeclaredType iElement = (DeclaredType)typeMirror;
            TypeElement interfaceElement = (TypeElement)iElement.asElement();
            Optional<ExecutableElement> result = this.findOverridden(executableElement, interfaceElement);
            if (result.isPresent()) {
                overridden.add(result.get());
                continue;
            }
            this.findOverriddenInterfaceMethod(executableElement, overridden, interfaceElement);
        }
    }

    private Optional<ExecutableElement> findOverridden(ExecutableElement executableElement, TypeElement supertype) {
        Stream elements = supertype.getEnclosedElements().stream();
        return elements.filter(el -> el.getKind() == ElementKind.METHOD && el.getEnclosingElement().equals(supertype)).map(el -> (ExecutableElement)el).filter(method -> this.elementUtils.overrides(executableElement, (ExecutableElement)method, (TypeElement)method.getEnclosingElement())).findFirst();
    }

    public boolean hasAnnotation(Element element, Class<? extends Annotation> ann) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(ann.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(ExecutableElement method, Class<? extends Annotation> ann) {
        List<? extends AnnotationMirror> annotationMirrors = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(ann.getName())) continue;
            return true;
        }
        return false;
    }

    private class MetadataAnnotationValueVisitor
    extends AbstractAnnotationValueVisitor8<Object, Object> {
        private final Element originatingElement;
        private Object resolvedValue;

        MetadataAnnotationValueVisitor(Element originatingElement) {
            this.originatingElement = originatingElement;
        }

        @Override
        public Object visitBoolean(boolean b, Object o) {
            this.resolvedValue = b;
            return null;
        }

        @Override
        public Object visitByte(byte b, Object o) {
            this.resolvedValue = b;
            return null;
        }

        @Override
        public Object visitChar(char c, Object o) {
            this.resolvedValue = Character.valueOf(c);
            return null;
        }

        @Override
        public Object visitDouble(double d, Object o) {
            this.resolvedValue = d;
            return null;
        }

        @Override
        public Object visitFloat(float f, Object o) {
            this.resolvedValue = Float.valueOf(f);
            return null;
        }

        @Override
        public Object visitInt(int i, Object o) {
            this.resolvedValue = i;
            return null;
        }

        @Override
        public Object visitLong(long i, Object o) {
            this.resolvedValue = i;
            return null;
        }

        @Override
        public Object visitShort(short s, Object o) {
            this.resolvedValue = s;
            return null;
        }

        @Override
        public Object visitString(String s, Object o) {
            this.resolvedValue = s;
            return null;
        }

        @Override
        public Object visitType(TypeMirror t, Object o) {
            Element typeElement;
            if (t instanceof DeclaredType && (typeElement = ((DeclaredType)t).asElement()) instanceof TypeElement) {
                String className = JavaModelUtils.getClassName((TypeElement)((TypeElement)typeElement));
                this.resolvedValue = new AnnotationClassValue(className);
            }
            return null;
        }

        @Override
        public Object visitEnumConstant(VariableElement c, Object o) {
            this.resolvedValue = c.toString();
            return null;
        }

        @Override
        public Object visitAnnotation(AnnotationMirror a, Object o) {
            if (a instanceof AnnotationValue) {
                this.resolvedValue = JavaAnnotationMetadataBuilder.this.readNestedAnnotationValue(this.originatingElement, a);
            }
            return null;
        }

        @Override
        public Object visitArray(List<? extends AnnotationValue> vals, Object o) {
            ArrayValueVisitor arrayValueVisitor = new ArrayValueVisitor();
            for (AnnotationValue annotationValue : vals) {
                annotationValue.accept(arrayValueVisitor, o);
            }
            this.resolvedValue = arrayValueVisitor.getValues();
            return null;
        }

        private class ArrayValueVisitor
        extends AbstractAnnotationValueVisitor8<Object, Object> {
            private List values = new ArrayList();
            private Class arrayType;

            private ArrayValueVisitor() {
            }

            Object[] getValues() {
                if (this.arrayType != null) {
                    for (Object value : this.values) {
                        if (value == null || this.arrayType.isInstance(value)) continue;
                        return ArrayUtils.EMPTY_OBJECT_ARRAY;
                    }
                    return this.values.toArray((Object[])Array.newInstance(this.arrayType, this.values.size()));
                }
                return this.values.toArray(new Object[0]);
            }

            @Override
            public Object visitBoolean(boolean b, Object o) {
                this.arrayType = Boolean.class;
                this.values.add(b);
                return null;
            }

            @Override
            public Object visitByte(byte b, Object o) {
                this.arrayType = Byte.class;
                this.values.add(b);
                return null;
            }

            @Override
            public Object visitChar(char c, Object o) {
                this.arrayType = Character.class;
                this.values.add(Character.valueOf(c));
                return null;
            }

            @Override
            public Object visitDouble(double d, Object o) {
                this.arrayType = Double.class;
                this.values.add(d);
                return null;
            }

            @Override
            public Object visitFloat(float f, Object o) {
                this.arrayType = Float.class;
                this.values.add(Float.valueOf(f));
                return null;
            }

            @Override
            public Object visitInt(int i, Object o) {
                this.arrayType = Integer.class;
                this.values.add(i);
                return null;
            }

            @Override
            public Object visitLong(long i, Object o) {
                this.arrayType = Long.class;
                this.values.add(i);
                return null;
            }

            @Override
            public Object visitShort(short s, Object o) {
                this.arrayType = Short.class;
                this.values.add(s);
                return null;
            }

            @Override
            public Object visitString(String s, Object o) {
                this.arrayType = String.class;
                this.values.add(s);
                return null;
            }

            @Override
            public Object visitType(TypeMirror t, Object o) {
                Element typeElement;
                this.arrayType = AnnotationClassValue.class;
                if (t instanceof DeclaredType && (typeElement = ((DeclaredType)t).asElement()) instanceof TypeElement) {
                    String className = JavaModelUtils.getClassName((TypeElement)((TypeElement)typeElement));
                    this.values.add(new AnnotationClassValue(className));
                }
                return null;
            }

            @Override
            public Object visitEnumConstant(VariableElement c, Object o) {
                this.arrayType = String.class;
                this.values.add(c.getSimpleName().toString());
                return null;
            }

            @Override
            public Object visitAnnotation(AnnotationMirror a, Object o) {
                this.arrayType = io.micronaut.core.annotation.AnnotationValue.class;
                io.micronaut.core.annotation.AnnotationValue annotationValue = JavaAnnotationMetadataBuilder.this.readNestedAnnotationValue(MetadataAnnotationValueVisitor.this.originatingElement, a);
                this.values.add(annotationValue);
                return null;
            }

            @Override
            public Object visitArray(List<? extends AnnotationValue> vals, Object o) {
                return null;
            }
        }
    }
}

