/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.PublicAbstractMethodVisitor;
import io.micronaut.annotation.processing.visitor.LoadedVisitor;
import io.micronaut.aop.Introduction;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.VersionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner8;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations"})
public class TypeElementVisitorProcessor
extends AbstractInjectAnnotationProcessor {
    private boolean executed = false;
    private Collection<TypeElementVisitor> typeElementVisitors;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeElementVisitors = this.findTypeElementVisitors();
    }

    @Override
    public Set<String> getSupportedOptions() {
        Stream baseOption = super.getSupportedOptions().stream();
        Stream visitorsOptions = this.typeElementVisitors.stream().map(TypeElementVisitor::getSupportedOptions).flatMap(Collection::stream);
        Stream visitorsAnnotationsOptions = this.typeElementVisitors.stream().filter(tev -> tev.getClass().isAnnotationPresent(SupportedOptions.class)).map(Object::getClass).map(cls -> cls.getAnnotation(SupportedOptions.class)).flatMap(supportedOptions -> Arrays.stream(supportedOptions.value()));
        return Stream.of(baseOption, visitorsAnnotationsOptions, visitorsOptions).flatMap(BaseStream::sequential).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.executed) {
            return false;
        }
        this.processingEnv.getOptions().entrySet().stream().filter(entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith("micronaut")).forEach(entry -> System.setProperty((String)entry.getKey(), entry.getValue() == null ? "" : (String)entry.getValue()));
        ArrayList<LoadedVisitor> loadedVisitors = new ArrayList<LoadedVisitor>(this.typeElementVisitors.size());
        for (TypeElementVisitor visitor : this.typeElementVisitors) {
            try {
                loadedVisitors.add(new LoadedVisitor(visitor, this.javaVisitorContext, this.genericUtils, this.processingEnv));
            }
            catch (NoClassDefFoundError | TypeNotPresentException throwable) {}
        }
        OrderUtil.reverseSort(loadedVisitors);
        for (LoadedVisitor loadedVisitor : loadedVisitors) {
            try {
                loadedVisitor.getVisitor().start((VisitorContext)this.javaVisitorContext);
            }
            catch (Throwable e) {
                this.error("Error initializing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
            }
        }
        TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
        TypeMirror groovyObjectType = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
        roundEnv.getRootElements().stream().filter(element -> JavaModelUtils.isClassOrInterface((javax.lang.model.element.Element)element) || JavaModelUtils.isEnum((javax.lang.model.element.Element)element)).map(this.modelUtils::classElementFor).filter(typeElement -> typeElement == null || groovyObjectType == null || !this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType)).forEach(typeElement -> {
            String className = typeElement.getQualifiedName().toString();
            List<LoadedVisitor> matchedVisitors = loadedVisitors.stream().filter(v -> v.matches((TypeElement)typeElement)).collect(Collectors.toList());
            typeElement.accept(new ElementVisitor((TypeElement)typeElement, matchedVisitors), className);
        });
        for (LoadedVisitor loadedVisitor : loadedVisitors) {
            try {
                loadedVisitor.getVisitor().finish((VisitorContext)this.javaVisitorContext);
            }
            catch (Throwable e) {
                this.error("Error finalizing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
            }
        }
        this.javaVisitorContext.finish();
        this.executed = true;
        return false;
    }

    @NonNull
    protected Collection<TypeElementVisitor> findTypeElementVisitors() {
        HashMap<String, TypeElementVisitor> typeElementVisitors = new HashMap<String, TypeElementVisitor>(10);
        SoftServiceLoader serviceLoader = SoftServiceLoader.load(TypeElementVisitor.class, (ClassLoader)this.getClass().getClassLoader());
        for (ServiceDefinition definition : serviceLoader) {
            String version;
            Requires.Sdk sdk;
            TypeElementVisitor visitor;
            if (!definition.isPresent()) continue;
            try {
                visitor = (TypeElementVisitor)definition.load();
            }
            catch (Throwable e) {
                this.warning("TypeElementVisitor [" + definition.getName() + "] will be ignored due to loading error: " + e.getMessage(), new Object[0]);
                continue;
            }
            if (visitor == null) continue;
            Requires requires = visitor.getClass().getAnnotation(Requires.class);
            if (requires != null && (sdk = requires.sdk()) == Requires.Sdk.MICRONAUT && StringUtils.isNotEmpty((CharSequence)(version = requires.version())) && !VersionUtils.isAtLeastMicronautVersion((String)version)) {
                try {
                    this.warning("TypeElementVisitor [" + definition.getName() + "] will be ignored because Micronaut version [" + VersionUtils.MICRONAUT_VERSION + "] must be at least " + version, new Object[0]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            typeElementVisitors.put(definition.getName(), visitor);
        }
        return typeElementVisitors.values();
    }

    private class ElementVisitor
    extends ElementScanner8<Object, Object> {
        private final TypeElement concreteClass;
        private final List<LoadedVisitor> visitors;
        private AnnotationMetadata typeAnnotationMetadata;

        ElementVisitor(TypeElement concreteClass, List<LoadedVisitor> visitors) {
            this.concreteClass = concreteClass;
            this.visitors = visitors;
            this.typeAnnotationMetadata = TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(concreteClass);
        }

        @Override
        public Object visitType(TypeElement classElement, Object o) {
            boolean shouldVisit;
            for (LoadedVisitor visitor : this.visitors) {
                Element resultingElement = visitor.visit(classElement, this.typeAnnotationMetadata);
                if (resultingElement == null) continue;
                this.typeAnnotationMetadata = resultingElement.getAnnotationMetadata();
            }
            javax.lang.model.element.Element enclosingElement = classElement.getEnclosingElement();
            boolean bl = shouldVisit = !JavaModelUtils.isClass((javax.lang.model.element.Element)enclosingElement) || this.concreteClass.getQualifiedName().equals(classElement.getQualifiedName());
            if (shouldVisit) {
                if (this.typeAnnotationMetadata.hasStereotype(Introduction.class) || this.typeAnnotationMetadata.hasStereotype(Introspected.class) && TypeElementVisitorProcessor.this.modelUtils.isAbstract(classElement)) {
                    classElement.asType().accept(new PublicAbstractMethodVisitor<Object, Object>(classElement, TypeElementVisitorProcessor.this.modelUtils, TypeElementVisitorProcessor.this.elementUtils){

                        @Override
                        protected void accept(DeclaredType type, javax.lang.model.element.Element element, Object o) {
                            if (element instanceof ExecutableElement) {
                                ElementVisitor.this.visitExecutable((ExecutableElement)element, o);
                            }
                        }
                    }, null);
                    return null;
                }
                TypeElement superClass = TypeElementVisitorProcessor.this.modelUtils.superClassFor(classElement);
                if (superClass != null && !TypeElementVisitorProcessor.this.modelUtils.isObjectClass(superClass)) {
                    superClass.accept(this, o);
                }
                return this.scan(classElement.getEnclosedElements(), o);
            }
            return null;
        }

        @Override
        public Object visitExecutable(ExecutableElement executableElement, Object o) {
            AnnotationMetadataHierarchy methodAnnotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.typeAnnotationMetadata, TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(executableElement)});
            if (executableElement.getSimpleName().toString().equals("<init>")) {
                for (LoadedVisitor visitor : this.visitors) {
                    Element resultingElement = visitor.visit(executableElement, (AnnotationMetadata)methodAnnotationMetadata);
                    if (resultingElement == null) continue;
                    methodAnnotationMetadata = resultingElement.getAnnotationMetadata();
                }
                return null;
            }
            for (LoadedVisitor visitor : this.visitors) {
                Element resultingElement;
                if (!visitor.matches((AnnotationMetadata)methodAnnotationMetadata) || (resultingElement = visitor.visit(executableElement, (AnnotationMetadata)methodAnnotationMetadata)) == null) continue;
                methodAnnotationMetadata = resultingElement.getAnnotationMetadata();
            }
            return null;
        }

        @Override
        public Object visitVariable(VariableElement variable, Object o) {
            if (variable.getKind() != ElementKind.FIELD) {
                return null;
            }
            AnnotationMetadata fieldAnnotationMetadata = TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(variable);
            for (LoadedVisitor visitor : this.visitors) {
                Element resultingElement;
                if (!visitor.matches(fieldAnnotationMetadata) || (resultingElement = visitor.visit(variable, fieldAnnotationMetadata)) == null) continue;
                fieldAnnotationMetadata = resultingElement.getAnnotationMetadata();
            }
            return null;
        }
    }
}

