/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.Map;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Internal
class JavaParameterElement
extends AbstractJavaElement
implements ParameterElement {
    private final JavaVisitorContext visitorContext;
    private final JavaClassElement declaringClass;

    JavaParameterElement(JavaClassElement declaringClass, VariableElement element, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(element, annotationMetadata, visitorContext);
        this.declaringClass = declaringClass;
        this.visitorContext = visitorContext;
    }

    @NonNull
    public ClassElement getType() {
        TypeMirror parameterType = this.getNativeType().asType();
        return this.mirrorToClassElement(parameterType, this.visitorContext);
    }

    @NonNull
    public ClassElement getGenericType() {
        TypeMirror returnType = this.getNativeType().asType();
        Map<String, Map<String, TypeMirror>> declaredGenericInfo = this.declaringClass.getGenericTypeInfo();
        return this.parameterizedClassElement(returnType, this.visitorContext, declaredGenericInfo);
    }

    @Override
    public VariableElement getNativeType() {
        return (VariableElement)super.getNativeType();
    }
}

