/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations"})
public class ServiceDescriptionProcessor
extends AbstractInjectAnnotationProcessor {
    private final Map<String, Set<String>> serviceDescriptors = new HashMap<String, Set<String>>();

    @Override
    protected String getIncrementalProcessorType() {
        return "org.gradle.annotation.processing.aggregating";
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("io.micronaut.core.annotation.Generated");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                String serviceName;
                if (!(element instanceof TypeElement)) continue;
                String name = ((TypeElement)element).getQualifiedName().toString();
                Generated generated = element.getAnnotation(Generated.class);
                if (generated == null || !StringUtils.isNotEmpty((CharSequence)(serviceName = generated.service()))) continue;
                this.serviceDescriptors.computeIfAbsent(serviceName, s1 -> new HashSet()).add(name);
            }
        }
        if (roundEnv.processingOver() && !this.serviceDescriptors.isEmpty()) {
            this.classWriterOutputVisitor.writeServiceEntries(this.serviceDescriptors);
        }
        return true;
    }
}

