/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.annotation.processing.GenericUtils;
import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class AnnotationUtils {
    private static final int CACHE_SIZE = 100;
    private static final Map<Element, AnnotationMetadata> annotationMetadataCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(100L).build();
    private final Elements elementUtils;
    private final Messager messager;
    private final Types types;
    private final ModelUtils modelUtils;
    private final Filer filer;
    private final MutableConvertibleValues<Object> visitorAttributes;
    private final ProcessingEnvironment processingEnv;
    private final AnnotatedElementValidator elementValidator;
    private JavaAnnotationMetadataBuilder javaAnnotationMetadataBuilder;
    private final GenericUtils genericUtils;

    protected AnnotationUtils(ProcessingEnvironment processingEnv, Elements elementUtils, Messager messager, Types types, ModelUtils modelUtils, GenericUtils genericUtils, Filer filer, MutableConvertibleValues<Object> visitorAttributes) {
        this.elementUtils = elementUtils;
        this.messager = messager;
        this.types = types;
        this.modelUtils = modelUtils;
        this.genericUtils = genericUtils;
        this.filer = filer;
        this.visitorAttributes = visitorAttributes;
        this.processingEnv = processingEnv;
        SoftServiceLoader validators = SoftServiceLoader.load(AnnotatedElementValidator.class);
        Iterator i = validators.iterator();
        AnnotatedElementValidator elementValidator = null;
        while (i.hasNext()) {
            ServiceDefinition validator = (ServiceDefinition)i.next();
            if (!validator.isPresent()) continue;
            elementValidator = (AnnotatedElementValidator)validator.load();
            break;
        }
        this.javaAnnotationMetadataBuilder = this.newAnnotationBuilder();
        this.elementValidator = elementValidator;
    }

    protected AnnotationUtils(ProcessingEnvironment processingEnv, Elements elementUtils, Messager messager, Types types, ModelUtils modelUtils, GenericUtils genericUtils, Filer filer) {
        this(processingEnv, elementUtils, messager, types, modelUtils, genericUtils, filer, (MutableConvertibleValues<Object>)new MutableConvertibleValuesMap());
    }

    @Nullable
    public AnnotatedElementValidator getElementValidator() {
        return this.elementValidator;
    }

    protected boolean hasStereotype(Element element, Class<? extends Annotation> stereotype) {
        return this.hasStereotype(element, stereotype.getName());
    }

    protected boolean hasStereotype(Element element, String ... stereotypes) {
        return this.hasStereotype(element, Arrays.asList(stereotypes));
    }

    protected boolean hasStereotype(Element element, List<String> stereotypes) {
        if (element == null) {
            return false;
        }
        if (stereotypes.contains(element.toString())) {
            return true;
        }
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata(element);
        for (String stereotype : stereotypes) {
            if (!annotationMetadata.hasStereotype(stereotype)) continue;
            return true;
        }
        return false;
    }

    public AnnotationMetadata getAnnotationMetadata(Element element) {
        AnnotationMetadata metadata = annotationMetadataCache.get(element);
        if (metadata == null) {
            metadata = this.newAnnotationBuilder().buildOverridden(element);
            annotationMetadataCache.put(element, metadata);
        }
        return metadata;
    }

    public AnnotationMetadata getDeclaredAnnotationMetadata(Element element) {
        return this.javaAnnotationMetadataBuilder.buildDeclared(element);
    }

    public AnnotationMetadata getAnnotationMetadata(Element parent, Element element) {
        return this.newAnnotationBuilder().buildForParent(parent, element);
    }

    public boolean isAnnotated(String declaringType, ExecutableElement method) {
        if (AbstractAnnotationMetadataBuilder.isMetadataMutated((String)declaringType, (Object)method)) {
            return true;
        }
        List<? extends AnnotationMirror> annotationMirrors = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String typeName = annotationMirror.getAnnotationType().toString();
            if (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(typeName)) continue;
            return true;
        }
        return false;
    }

    public JavaAnnotationMetadataBuilder newAnnotationBuilder() {
        return new JavaAnnotationMetadataBuilder(this.elementUtils, this.messager, this, this.modelUtils);
    }

    public JavaVisitorContext newVisitorContext() {
        return new JavaVisitorContext(this.processingEnv, this.messager, this.elementUtils, this, this.types, this.modelUtils, this.genericUtils, this.filer, this.visitorAttributes);
    }

    @Internal
    static void invalidateCache() {
        annotationMetadataCache.clear();
    }

    @Internal
    public void invalidateMetadata(Element element) {
        if (element != null) {
            annotationMetadataCache.remove(element);
        }
    }
}

