/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.annotation.processing.AnnotationProcessingOutputVisitor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.GenericUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.util.VisitorContextUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

@Internal
public class JavaVisitorContext
implements VisitorContext {
    private final Messager messager;
    private final Elements elements;
    private final AnnotationUtils annotationUtils;
    private final Types types;
    private final ModelUtils modelUtils;
    private final AnnotationProcessingOutputVisitor outputVisitor;
    private final MutableConvertibleValues<Object> visitorAttributes;
    private final GenericUtils genericUtils;
    private final ProcessingEnvironment processingEnv;
    @Nullable
    private JavaFileManager standardFileManager;

    public JavaVisitorContext(ProcessingEnvironment processingEnv, Messager messager, Elements elements, AnnotationUtils annotationUtils, Types types, ModelUtils modelUtils, GenericUtils genericUtils, Filer filer, MutableConvertibleValues<Object> visitorAttributes) {
        this.messager = messager;
        this.elements = elements;
        this.annotationUtils = annotationUtils;
        this.types = types;
        this.modelUtils = modelUtils;
        this.genericUtils = genericUtils;
        this.outputVisitor = new AnnotationProcessingOutputVisitor(filer);
        this.visitorAttributes = visitorAttributes;
        this.processingEnv = processingEnv;
    }

    @NonNull
    public Iterable<URL> getClasspathResources(@NonNull String path) {
        this.info("EXPERIMENTAL: Compile time resource scanning is experimental", null);
        JavaFileManager standardFileManager = this.getStandardFileManager(this.processingEnv).orElse(null);
        if (standardFileManager != null) {
            try {
                ClassLoader classLoader = standardFileManager.getClassLoader(StandardLocation.CLASS_PATH);
                if (classLoader != null) {
                    Enumeration<URL> resources = classLoader.getResources(path);
                    return CollectionUtils.enumerationToIterable(resources);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public Optional<ClassElement> getClassElement(String name) {
        TypeElement typeElement = this.elements.getTypeElement(name);
        return Optional.ofNullable(typeElement).map(typeElement1 -> new JavaClassElement((TypeElement)typeElement1, this.annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)typeElement1), this, Collections.emptyMap()));
    }

    @NonNull
    public ClassElement[] getClassElements(@NonNull String aPackage, String ... stereotypes) {
        ArgumentUtils.requireNonNull((String)"aPackage", (Object)aPackage);
        ArgumentUtils.requireNonNull((String)"stereotypes", (Object)stereotypes);
        PackageElement packageElement = this.elements.getPackageElement(aPackage);
        if (packageElement != null) {
            ArrayList<ClassElement> classElements = new ArrayList<ClassElement>();
            this.populateClassElements(stereotypes, packageElement, classElements);
            return classElements.toArray(new ClassElement[0]);
        }
        return new ClassElement[0];
    }

    public void info(String message, @Nullable Element element) {
        this.printMessage(message, Diagnostic.Kind.NOTE, element);
    }

    public void info(String message) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    public void fail(String message, @Nullable Element element) {
        this.printMessage(message, Diagnostic.Kind.ERROR, element);
    }

    public void warn(String message, @Nullable Element element) {
        this.printMessage(message, Diagnostic.Kind.WARNING, element);
    }

    private void printMessage(String message, Diagnostic.Kind kind, @Nullable Element element) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            if (element != null) {
                javax.lang.model.element.Element el = (javax.lang.model.element.Element)element.getNativeType();
                this.messager.printMessage(kind, message, el);
            } else {
                this.messager.printMessage(kind, message);
            }
        }
    }

    public OutputStream visitClass(String classname, @Nullable Element originatingElement) throws IOException {
        return this.outputVisitor.visitClass(classname, originatingElement);
    }

    public void visitServiceDescriptor(String type, String classname) {
        this.outputVisitor.visitServiceDescriptor(type, classname);
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path) {
        return this.outputVisitor.visitMetaInfFile(path);
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return this.outputVisitor.visitGeneratedFile(path);
    }

    public void finish() {
        this.outputVisitor.finish();
    }

    public Messager getMessager() {
        return this.messager;
    }

    public ModelUtils getModelUtils() {
        return this.modelUtils;
    }

    public Elements getElements() {
        return this.elements;
    }

    public AnnotationUtils getAnnotationUtils() {
        return this.annotationUtils;
    }

    public Types getTypes() {
        return this.types;
    }

    public GenericUtils getGenericUtils() {
        return this.genericUtils;
    }

    public Map<String, String> getOptions() {
        Map processorOptions = VisitorContextUtils.getProcessorOptions((ProcessingEnvironment)this.processingEnv);
        Map systemPropsOptions = VisitorContextUtils.getSystemOptions();
        return Stream.of(processorOptions, systemPropsOptions).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> StringUtils.isNotEmpty((CharSequence)v2) ? v2 : v1));
    }

    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        this.visitorAttributes.put(key, value);
        return this;
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        this.visitorAttributes.remove(key);
        return this;
    }

    public MutableConvertibleValues<Object> clear() {
        this.visitorAttributes.clear();
        return this;
    }

    public Set<String> names() {
        return this.visitorAttributes.names();
    }

    public Collection<Object> values() {
        return this.visitorAttributes.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.visitorAttributes.get(name, conversionContext);
    }

    private void populateClassElements(@NonNull String[] stereotypes, PackageElement packageElement, List<ClassElement> classElements) {
        List<? extends javax.lang.model.element.Element> enclosedElements = packageElement.getEnclosedElements();
        for (javax.lang.model.element.Element element : enclosedElements) {
            if (element instanceof TypeElement) {
                JavaClassElement classElement;
                AnnotationMetadata annotationMetadata = this.annotationUtils.getAnnotationMetadata(element);
                if (!Arrays.stream(stereotypes).anyMatch(arg_0 -> ((AnnotationMetadata)annotationMetadata).hasStereotype(arg_0)) || (classElement = new JavaClassElement((TypeElement)element, annotationMetadata, this)).isAbstract()) continue;
                classElements.add(classElement);
                continue;
            }
            if (!(element instanceof PackageElement)) continue;
            this.populateClassElements(stereotypes, (PackageElement)element, classElements);
        }
    }

    private Optional<JavaFileManager> getStandardFileManager(ProcessingEnvironment processingEnv) {
        Optional contextMethod;
        if (this.standardFileManager == null && (contextMethod = ReflectionUtils.getMethod(processingEnv.getClass(), (String)"getContext", (Class[])new Class[0])).isPresent()) {
            Object context = ReflectionUtils.invokeMethod((Object)processingEnv, (Method)((Method)contextMethod.get()), (Object[])new Object[0]);
            try {
                if (context != null) {
                    Optional getMethod = ReflectionUtils.getMethod(context.getClass(), (String)"get", (Class[])new Class[]{Class.class});
                    this.standardFileManager = getMethod.map(method -> ReflectionUtils.invokeMethod((Object)context, (Method)method, (Object[])new Object[]{JavaFileManager.class})).orElse(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.ofNullable(this.standardFileManager);
    }
}

