/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.AbstractClassWriterOutputVisitor;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class AnnotationProcessingOutputVisitor
extends AbstractClassWriterOutputVisitor {
    private final Filer filer;
    private final Map<String, Optional<GeneratedFile>> metaInfFiles = new HashMap<String, Optional<GeneratedFile>>();
    private final Map<String, FileObject> openedFiles = new HashMap<String, FileObject>();
    private final Map<String, Optional<GeneratedFile>> generatedFiles = new HashMap<String, Optional<GeneratedFile>>();

    public AnnotationProcessingOutputVisitor(Filer filer) {
        super(AnnotationProcessingOutputVisitor.isEclipseFiler(filer));
        this.filer = filer;
    }

    private static boolean isEclipseFiler(Filer filer) {
        return filer.getClass().getTypeName().startsWith("org.eclipse.jdt");
    }

    public OutputStream visitClass(String classname, @Nullable Element originatingElement) throws IOException {
        return this.visitClass(classname, new Element[]{originatingElement});
    }

    public OutputStream visitClass(String classname, Element ... originatingElements) throws IOException {
        javax.lang.model.element.Element[] nativeOriginatingElements;
        if (ArrayUtils.isNotEmpty((Object[])originatingElements)) {
            ArrayList<javax.lang.model.element.Element> list = new ArrayList<javax.lang.model.element.Element>(originatingElements.length);
            for (Element originatingElement : originatingElements) {
                Object nativeType = originatingElement.getNativeType();
                if (!(nativeType instanceof javax.lang.model.element.Element)) continue;
                list.add((javax.lang.model.element.Element)nativeType);
            }
            nativeOriginatingElements = list.toArray(new javax.lang.model.element.Element[0]);
        } else {
            nativeOriginatingElements = new javax.lang.model.element.Element[]{};
        }
        JavaFileObject javaFileObject = this.filer.createClassFile(classname, nativeOriginatingElements);
        return javaFileObject.openOutputStream();
    }

    @Deprecated
    public Optional<GeneratedFile> visitMetaInfFile(String path) {
        return this.visitMetaInfFile(path, Element.EMPTY_ELEMENT_ARRAY);
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path, Element ... originatingElements) {
        return this.metaInfFiles.computeIfAbsent(path, s -> {
            String finalPath = "META-INF/" + path;
            javax.lang.model.element.Element[] nativeOriginatingElements = (javax.lang.model.element.Element[])Arrays.stream(originatingElements).map(e -> (javax.lang.model.element.Element)e.getNativeType()).toArray(javax.lang.model.element.Element[]::new);
            return Optional.of(new GeneratedFileObject(finalPath, nativeOriginatingElements));
        });
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return this.generatedFiles.computeIfAbsent(path, s -> Optional.of(new GeneratedFileObject(path, StandardLocation.SOURCE_OUTPUT, new javax.lang.model.element.Element[0])));
    }

    class GeneratedFileObject
    implements GeneratedFile {
        private final String path;
        private final StandardLocation classOutput;
        private final javax.lang.model.element.Element[] originatingElements;
        private FileObject inputObject;
        private FileObject outputObject;

        GeneratedFileObject(String path, javax.lang.model.element.Element ... originatingElements) {
            this.path = path;
            this.classOutput = StandardLocation.CLASS_OUTPUT;
            this.originatingElements = originatingElements;
        }

        GeneratedFileObject(String path, StandardLocation location, javax.lang.model.element.Element ... originatingElements) {
            this.path = path;
            this.classOutput = location;
            this.originatingElements = originatingElements;
        }

        public URI toURI() {
            try {
                return this.getOutputObject().toUri();
            }
            catch (IOException e) {
                throw new ClassGenerationException("Unable to return URI for file object: " + this.path);
            }
        }

        public String getName() {
            return this.path;
        }

        public Writer openWriter() throws IOException {
            return this.getOutputObject().openWriter();
        }

        public OutputStream openOutputStream() throws IOException {
            return this.getOutputObject().openOutputStream();
        }

        public InputStream openInputStream() throws IOException {
            if (this.inputObject == null) {
                this.inputObject = this.openFileForReading(this.path);
            }
            return this.inputObject.openInputStream();
        }

        public Reader openReader() throws IOException {
            if (this.inputObject == null) {
                this.inputObject = this.openFileForReading(this.path);
            }
            return this.inputObject.openReader(true);
        }

        public CharSequence getTextContent() throws IOException {
            try {
                if (this.inputObject == null) {
                    this.inputObject = this.openFileForReading(this.path);
                }
                return this.inputObject.getCharContent(true);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        private FileObject openFileForReading(String path) {
            return AnnotationProcessingOutputVisitor.this.openedFiles.computeIfAbsent(path, s -> {
                try {
                    return AnnotationProcessingOutputVisitor.this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", path);
                }
                catch (IOException e) {
                    throw new ClassGenerationException("Unable to open file for path: " + path, (Throwable)e);
                }
            });
        }

        private FileObject getOutputObject() throws IOException {
            if (this.outputObject == null) {
                this.outputObject = AnnotationProcessingOutputVisitor.this.filer.createResource(this.classOutput, "", this.path, this.originatingElements);
            }
            return this.outputObject;
        }
    }
}

