/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.JavaConfigurationMetadataBuilder;
import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.PublicAbstractMethodVisitor;
import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.aop.Adapter;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorConfiguration;
import io.micronaut.inject.writer.BeanDefinitionReferenceWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.OriginatingElements;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner8;

@Internal
@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations"})
public class BeanDefinitionInjectProcessor
extends AbstractInjectAnnotationProcessor {
    private static final String AROUND_TYPE = "io.micronaut.aop.Around";
    private static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
    private static final String[] ANNOTATION_STEREOTYPES = new String[]{"javax.annotation.PostConstruct", "javax.annotation.PreDestroy", "javax.inject.Inject", "javax.inject.Qualifier", "javax.inject.Singleton", "io.micronaut.context.annotation.Bean", "io.micronaut.context.annotation.Replaces", "io.micronaut.context.annotation.Value", "io.micronaut.context.annotation.Property", "io.micronaut.context.annotation.Executable", "io.micronaut.aop.Around", "io.micronaut.aop.Introduction"};
    private static final String ANN_CONSTRAINT = "javax.validation.Constraint";
    private static final String ANN_VALID = "javax.validation.Valid";
    private static final Predicate<AnnotationMetadata> IS_CONSTRAINT = am -> am.hasStereotype(ANN_CONSTRAINT) || am.hasStereotype(ANN_VALID);
    private static final String ANN_CONFIGURATION_ADVICE = "io.micronaut.runtime.context.env.ConfigurationAdvice";
    private static final String ANN_VALIDATED = "io.micronaut.validation.Validated";
    private JavaConfigurationMetadataBuilder metadataBuilder;
    private Set<String> beanDefinitions;
    private boolean processingOver;
    private final Set<String> processed = new HashSet<String>();

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.metadataBuilder = new JavaConfigurationMetadataBuilder(this.elementUtils, this.typeUtils, this.annotationUtils);
        ConfigurationMetadataBuilder.setConfigurationMetadataBuilder((ConfigurationMetadataBuilder)this.metadataBuilder);
        this.beanDefinitions = new LinkedHashSet<String>();
    }

    @Override
    @NonNull
    protected JavaVisitorContext newVisitorContext(@NonNull ProcessingEnvironment processingEnv) {
        return new JavaVisitorContext(processingEnv, this.messager, this.elementUtils, this.annotationUtils, this.typeUtils, this.modelUtils, this.genericUtils, this.filer, this.visitorAttributes){

            @NonNull
            public VisitorConfiguration getConfiguration() {
                return new VisitorConfiguration(){

                    public boolean includeTypeLevelAnnotationsInGenericArguments() {
                        return false;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingOver = roundEnv.processingOver();
        if (!(annotations = annotations.stream().filter(ann -> !ann.getQualifiedName().toString().equals("kotlin.Metadata")).filter(ann -> this.annotationUtils.hasStereotype((javax.lang.model.element.Element)ann, ANNOTATION_STEREOTYPES) || AbstractAnnotationMetadataBuilder.isAnnotationMapped((String)ann.getQualifiedName().toString())).collect(Collectors.toSet())).isEmpty()) {
            TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
            TypeMirror groovyObjectType = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
            annotations.forEach(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().filter(element -> element.getKind() != ElementKind.ANNOTATION_TYPE).forEach(element -> {
                TypeElement typeElement = this.modelUtils.classElementFor((javax.lang.model.element.Element)element);
                if (element.getKind() == ElementKind.ENUM) {
                    this.error((javax.lang.model.element.Element)element, "Enum types cannot be defined as beans", new Object[0]);
                    return;
                }
                if (typeElement == null || groovyObjectType != null && this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType)) {
                    return;
                }
                String name = typeElement.getQualifiedName().toString();
                if (!(this.beanDefinitions.contains(name) || this.processed.contains(name) || name.endsWith("$Intercepted"))) {
                    boolean isInterface = JavaModelUtils.resolveKind((javax.lang.model.element.Element)typeElement, (ElementKind)ElementKind.INTERFACE).isPresent();
                    if (!isInterface) {
                        this.beanDefinitions.add(name);
                    } else if (this.annotationUtils.hasStereotype((javax.lang.model.element.Element)typeElement, INTRODUCTION_TYPE) || this.annotationUtils.hasStereotype((javax.lang.model.element.Element)typeElement, ConfigurationReader.class)) {
                        this.beanDefinitions.add(name);
                    }
                }
            }));
        }
        for (String name : this.processed) {
            this.beanDefinitions.remove(name);
        }
        int count = this.beanDefinitions.size();
        if (count > 0) {
            this.note("Creating bean classes for %s type elements", count);
            this.beanDefinitions.forEach(className -> {
                if (this.processed.add((String)className)) {
                    TypeElement refreshedClassElement = this.elementUtils.getTypeElement((CharSequence)className);
                    try {
                        AnnBeanElementVisitor visitor = new AnnBeanElementVisitor(refreshedClassElement);
                        refreshedClassElement.accept(visitor, className);
                        visitor.getBeanDefinitionWriters().forEach((name, writer) -> {
                            String beanDefinitionName = writer.getBeanDefinitionName();
                            if (this.processed.add(beanDefinitionName)) {
                                this.processBeanDefinitions(refreshedClassElement, (BeanDefinitionVisitor)writer);
                            }
                        });
                        AnnotationUtils.invalidateMetadata(refreshedClassElement);
                    }
                    catch (PostponeToNextRoundException e) {
                        this.processed.remove(className);
                    }
                }
            });
            AnnotationUtils.invalidateCache();
        }
        if (this.processingOver) {
            try {
                this.writeBeanDefinitionsToMetaInf();
            }
            finally {
                AnnotationUtils.invalidateCache();
                AbstractAnnotationMetadataBuilder.clearMutated();
            }
        }
        return false;
    }

    private void writeBeanDefinitionsToMetaInf() {
        try {
            this.classWriterOutputVisitor.finish();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.error("Error occurred writing META-INF files: %s", message != null ? message : e);
        }
    }

    private void processBeanDefinitions(TypeElement beanClassElement, BeanDefinitionVisitor beanDefinitionWriter) {
        try {
            beanDefinitionWriter.visitBeanDefinitionEnd();
            beanDefinitionWriter.accept((ClassWriterOutputVisitor)this.classWriterOutputVisitor);
            String beanTypeName = beanDefinitionWriter.getBeanTypeName();
            List<? extends TypeMirror> interfaces = beanClassElement.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                List<? extends TypeMirror> typeArguments;
                DeclaredType declaredType;
                javax.lang.model.element.Element element;
                if (!(typeMirror instanceof DeclaredType) || !((element = (declaredType = (DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
                TypeElement te = (TypeElement)element;
                String name = te.getQualifiedName().toString();
                if (!Provider.class.getName().equals(name) || (typeArguments = declaredType.getTypeArguments()).isEmpty()) continue;
                beanTypeName = this.genericUtils.resolveTypeReference(typeArguments.get(0)).toString();
            }
            BeanDefinitionReferenceWriter beanDefinitionReferenceWriter = new BeanDefinitionReferenceWriter(beanTypeName, beanDefinitionWriter);
            beanDefinitionReferenceWriter.setRequiresMethodProcessing(beanDefinitionWriter.requiresMethodProcessing());
            String string = beanDefinitionReferenceWriter.getBeanDefinitionQualifiedClassName();
            this.processed.add(string);
            beanDefinitionReferenceWriter.setContextScope(this.annotationUtils.hasStereotype((javax.lang.model.element.Element)beanClassElement, Context.class));
            beanDefinitionReferenceWriter.accept((ClassWriterOutputVisitor)this.classWriterOutputVisitor);
        }
        catch (IOException e) {
            String message = e.getMessage();
            this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
        }
    }

    private String getPropertyMetadataTypeReference(TypeMirror valueType) {
        if (this.modelUtils.isOptional(valueType)) {
            return this.genericUtils.getFirstTypeArgument(valueType).map(typeMirror -> this.modelUtils.resolveTypeName((TypeMirror)typeMirror)).orElseGet(() -> this.modelUtils.resolveTypeName(valueType));
        }
        return this.modelUtils.resolveTypeName(valueType);
    }

    private AnnotationMetadata addPropertyMetadata(Element targetElement, PropertyMetadata propertyMetadata) {
        return targetElement.annotate(Property.class, builder -> builder.member("name", propertyMetadata.getPath())).getAnnotationMetadata();
    }

    static class DynamicName
    implements Name {
        private final CharSequence name;

        public DynamicName(CharSequence name) {
            this.name = name;
        }

        @Override
        public boolean contentEquals(CharSequence cs) {
            return this.name.equals(cs);
        }

        @Override
        public int length() {
            return this.name.length();
        }

        @Override
        public char charAt(int index) {
            return this.name.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.name.subSequence(start, end);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicName that = (DynamicName)o;
            return this.name.equals(that.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    class AnnBeanElementVisitor
    extends ElementScanner8<Object, Object> {
        private final TypeElement concreteClass;
        private final AnnotationMetadata concreteClassMetadata;
        private final Map<Name, BeanDefinitionVisitor> beanDefinitionWriters;
        private final boolean isConfigurationPropertiesType;
        private final boolean isFactoryType;
        private final boolean isExecutableType;
        private final boolean isAopProxyType;
        private final OptionalValues<Boolean> aopSettings;
        private final boolean isDeclaredBean;
        private final JavaElementFactory elementFactory;
        private final ClassElement concreteClassElement;
        private final MethodElement constructorElement;
        private final AnnotationMetadata constructorAnnotationMetadata;
        private ConfigurationMetadata configurationMetadata;
        private final AtomicInteger adaptedMethodIndex = new AtomicInteger(0);
        private final AtomicInteger factoryMethodIndex = new AtomicInteger(0);
        private AnnotationMetadata currentClassMetadata;
        private final Set<Name> visitedTypes = new HashSet<Name>();

        AnnBeanElementVisitor(TypeElement concreteClass) {
            this.concreteClass = concreteClass;
            this.currentClassMetadata = this.concreteClassMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(concreteClass);
            this.elementFactory = BeanDefinitionInjectProcessor.this.javaVisitorContext.getElementFactory();
            this.concreteClassElement = this.elementFactory.newClassElement(concreteClass, this.concreteClassMetadata);
            this.beanDefinitionWriters = new LinkedHashMap<Name, BeanDefinitionVisitor>();
            this.isFactoryType = this.concreteClassMetadata.hasStereotype(Factory.class);
            this.isConfigurationPropertiesType = this.concreteClassMetadata.hasDeclaredStereotype(ConfigurationReader.class) || this.concreteClassMetadata.hasDeclaredStereotype(EachProperty.class);
            this.isAopProxyType = this.concreteClassMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) && !this.concreteClassElement.isAbstract();
            this.aopSettings = this.isAopProxyType ? this.concreteClassMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class) : OptionalValues.empty();
            MethodElement constructorElement = this.constructorElement = (MethodElement)this.concreteClassElement.getPrimaryConstructor().orElse(null);
            if (constructorElement != null) {
                this.postponeIfParametersContainErrors((ExecutableElement)constructorElement.getNativeType());
            }
            this.constructorAnnotationMetadata = constructorElement != null ? constructorElement.getAnnotationMetadata() : AnnotationMetadata.EMPTY_METADATA;
            this.isExecutableType = this.isAopProxyType || this.concreteClassMetadata.hasStereotype(Executable.class);
            boolean hasQualifier = this.concreteClassMetadata.hasStereotype(Qualifier.class) && !this.concreteClassElement.isAbstract();
            this.isDeclaredBean = this.isDeclaredBean(constructorElement, hasQualifier);
        }

        private void postponeIfParametersContainErrors(ExecutableElement executableElement) {
            if (executableElement != null && !BeanDefinitionInjectProcessor.this.processingOver) {
                List<? extends VariableElement> parameters = executableElement.getParameters();
                for (VariableElement variableElement : parameters) {
                    TypeMirror typeMirror = variableElement.asType();
                    if (typeMirror.getKind() != TypeKind.ERROR) continue;
                    throw new PostponeToNextRoundException();
                }
            }
        }

        private boolean isDeclaredBean(@Nullable MethodElement constructor, boolean hasQualifier) {
            return this.isExecutableType || this.concreteClassMetadata.hasStereotype(Scope.class) || this.concreteClassMetadata.hasStereotype(DefaultScope.class) || constructor != null && constructor.hasStereotype(Inject.class) || hasQualifier;
        }

        Map<Name, BeanDefinitionVisitor> getBeanDefinitionWriters() {
            return this.beanDefinitionWriters;
        }

        @Override
        public Object visitType(TypeElement classElement, Object o) {
            AnnotationMetadata typeAnnotationMetadata;
            Name classElementQualifiedName = classElement.getQualifiedName();
            if ("java.lang.Record".equals(classElementQualifiedName.toString())) {
                return o;
            }
            if (this.visitedTypes.contains(classElementQualifiedName)) {
                return o;
            }
            boolean isInterface = this.concreteClassElement.isInterface();
            this.visitedTypes.add(classElementQualifiedName);
            this.currentClassMetadata = typeAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(classElement);
            if (this.isConfigurationPropertiesType) {
                this.configurationMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperties(this.concreteClass, this.concreteClassElement.getDocumentation().orElse(null));
                if (isInterface) {
                    this.currentClassMetadata = typeAnnotationMetadata = this.concreteClassElement.annotate(BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE).getAnnotationMetadata();
                }
            }
            Name qualifiedName = this.concreteClass.getQualifiedName();
            boolean isTypeConcreteClass = qualifiedName.equals(classElementQualifiedName);
            if (typeAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.INTRODUCTION_TYPE) && isTypeConcreteClass) {
                AopProxyWriter aopProxyWriter = this.createIntroductionAdviceWriter(this.concreteClassElement);
                if (this.constructorElement != null) {
                    aopProxyWriter.visitBeanDefinitionConstructor(this.constructorElement, this.concreteClassElement.isPrivate());
                } else {
                    aopProxyWriter.visitDefaultConstructor(this.concreteClassMetadata);
                }
                this.beanDefinitionWriters.put(classElementQualifiedName, (BeanDefinitionVisitor)aopProxyWriter);
                this.visitIntroductionAdviceInterface(classElement, typeAnnotationMetadata, aopProxyWriter);
                if (!isInterface) {
                    List elements = classElement.getEnclosedElements().stream().filter(element -> element.getKind() != ElementKind.CONSTRUCTOR).collect(Collectors.toList());
                    return this.scan(elements, o);
                }
                return null;
            }
            javax.lang.model.element.Element enclosingElement = classElement.getEnclosingElement();
            if (!JavaModelUtils.isClass((javax.lang.model.element.Element)enclosingElement) || isTypeConcreteClass) {
                if (isTypeConcreteClass) {
                    if (this.isDeclaredBean) {
                        PackageElement packageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(classElement);
                        if (packageElement.isUnnamed()) {
                            BeanDefinitionInjectProcessor.this.error(classElement, "Micronaut beans cannot be in the default package", new Object[0]);
                            return null;
                        }
                        BeanDefinitionVisitor beanDefinitionWriter = this.getOrCreateBeanDefinitionWriter(classElement, qualifiedName);
                        if (this.isAopProxyType) {
                            if (BeanDefinitionInjectProcessor.this.modelUtils.isFinal(classElement)) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + classElement, new Object[0]);
                                return null;
                            }
                            ClassElement[] interceptorTypes = this.resolveInterceptorElements(this.concreteClassMetadata, BeanDefinitionInjectProcessor.AROUND_TYPE);
                            this.resolveAopProxyWriter(beanDefinitionWriter, this.aopSettings, false, this.constructorElement, interceptorTypes);
                        }
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(classElement)) {
                        return null;
                    }
                }
                List elements = classElement.getEnclosedElements().stream().filter(element -> element.getKind() != ElementKind.CONSTRUCTOR).collect(Collectors.toList());
                if (this.isConfigurationPropertiesType) {
                    List<? extends javax.lang.model.element.Element> members = BeanDefinitionInjectProcessor.this.elementUtils.getAllMembers(classElement);
                    ElementFilter.fieldsIn(members).forEach(field -> {
                        if (classElement != field.getEnclosingElement()) {
                            AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getDeclaredAnnotationMetadata((javax.lang.model.element.Element)field);
                            boolean isConfigBuilder = fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class);
                            if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic((javax.lang.model.element.Element)field)) {
                                return;
                            }
                            if (!BeanDefinitionInjectProcessor.this.modelUtils.isFinal((javax.lang.model.element.Element)field) || isConfigBuilder) {
                                this.visitConfigurationProperty((VariableElement)field, fieldAnnotationMetadata);
                            }
                        }
                    });
                    ElementFilter.methodsIn(members).forEach(method -> {
                        javax.lang.model.element.Element e;
                        boolean isCandidateMethod;
                        boolean bl = isCandidateMethod = !BeanDefinitionInjectProcessor.this.modelUtils.isStatic((javax.lang.model.element.Element)method) && !BeanDefinitionInjectProcessor.this.modelUtils.isPrivate((javax.lang.model.element.Element)method) && !BeanDefinitionInjectProcessor.this.modelUtils.isAbstract((javax.lang.model.element.Element)method);
                        if (isCandidateMethod && (e = method.getEnclosingElement()) instanceof TypeElement && !e.equals(classElement)) {
                            BeanDefinitionVisitor writer;
                            String methodName = method.getSimpleName().toString();
                            if (method.getParameters().size() == 1 && NameUtils.isSetterName((String)methodName)) {
                                this.visitConfigurationPropertySetter((ExecutableElement)method);
                            } else if (NameUtils.isGetterName((String)methodName) && !(writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName())).isValidated()) {
                                writer.setValidated(IS_CONSTRAINT.test(BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)method)));
                            }
                        }
                    });
                } else {
                    TypeElement superClass = BeanDefinitionInjectProcessor.this.modelUtils.superClassFor(classElement);
                    if (superClass != null && !BeanDefinitionInjectProcessor.this.modelUtils.isObjectClass(superClass)) {
                        superClass.accept(this, o);
                    }
                }
                return this.scan(elements, o);
            }
            return null;
        }

        public BeanDefinitionVisitor getOrCreateBeanDefinitionWriter(TypeElement classElement, Name qualifiedName) {
            BeanDefinitionVisitor beanDefinitionWriter = this.beanDefinitionWriters.get(qualifiedName);
            if (beanDefinitionWriter == null) {
                beanDefinitionWriter = this.createBeanDefinitionWriterFor(classElement);
                DynamicName proxyKey = this.createProxyKey(beanDefinitionWriter.getBeanDefinitionName());
                this.beanDefinitionWriters.put(qualifiedName, beanDefinitionWriter);
                BeanDefinitionVisitor proxyWriter = this.beanDefinitionWriters.get(proxyKey);
                AnnotationMetadataHierarchy annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, this.constructorAnnotationMetadata});
                if (proxyWriter != null) {
                    if (this.constructorElement != null) {
                        proxyWriter.visitBeanDefinitionConstructor(this.constructorElement, this.constructorElement.isPrivate());
                    } else {
                        proxyWriter.visitDefaultConstructor((AnnotationMetadata)annotationMetadata);
                    }
                }
                if (this.constructorElement != null) {
                    beanDefinitionWriter.visitBeanDefinitionConstructor(this.constructorElement, this.constructorElement.isPrivate());
                } else {
                    beanDefinitionWriter.visitDefaultConstructor((AnnotationMetadata)annotationMetadata);
                }
            }
            return beanDefinitionWriter;
        }

        private void visitIntroductionAdviceInterface(final TypeElement classElement, final AnnotationMetadata typeAnnotationMetadata, AopProxyWriter aopProxyWriter) {
            JavaClassElement introductionType = this.elementFactory.newClassElement(classElement, typeAnnotationMetadata);
            boolean isConfigProps = typeAnnotationMetadata.hasAnnotation(BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE);
            if (isConfigProps) {
                BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperties(classElement, null);
            }
            classElement.asType().accept(new PublicAbstractMethodVisitor<Object, AopProxyWriter>(classElement, BeanDefinitionInjectProcessor.this.javaVisitorContext, (ClassElement)introductionType, isConfigProps){
                final /* synthetic */ ClassElement val$introductionType;
                final /* synthetic */ boolean val$isConfigProps;
                {
                    this.val$introductionType = classElement2;
                    this.val$isConfigProps = bl;
                    super(classElement3, visitorContext);
                }

                @Override
                protected boolean isAcceptableMethod(ExecutableElement executableElement) {
                    return super.isAcceptableMethod(executableElement) || BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(executableElement).hasDeclaredStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) || BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(classElement).hasDeclaredStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE);
                }

                @Override
                protected void accept(DeclaredType type, javax.lang.model.element.Element element, AopProxyWriter aopProxyWriter) {
                    ExecutableElement method = (ExecutableElement)element;
                    javax.lang.model.element.Element declaredTypeElement = type.asElement();
                    if (declaredTypeElement instanceof TypeElement) {
                        TypeElement owningType;
                        JavaClassElement declaringClassElement = AnnBeanElementVisitor.this.elementFactory.newClassElement((TypeElement)declaredTypeElement, AnnBeanElementVisitor.this.concreteClassMetadata);
                        if (!classElement.equals(declaredTypeElement)) {
                            aopProxyWriter.addOriginatingElement((Element)declaringClassElement);
                        }
                        if ((owningType = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method)) == null) {
                            throw new IllegalStateException("Owning type cannot be null");
                        }
                        JavaClassElement owningTypeElement = AnnBeanElementVisitor.this.elementFactory.newClassElement(owningType, typeAnnotationMetadata);
                        Object annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.isAnnotated(this.val$introductionType.getName(), method) || JavaAnnotationMetadataBuilder.hasAnnotation(method, Override.class) ? BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(this.val$introductionType.getName(), classElement, method) : new AnnotationMetadataReference(aopProxyWriter.getBeanDefinitionName() + "Class", typeAnnotationMetadata);
                        JavaMethodElement javaMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement(this.val$introductionType, method, (AnnotationMetadata)annotationMetadata);
                        String methodName = javaMethodElement.getName();
                        if (!annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_VALIDATED) && AnnBeanElementVisitor.this.isDeclaredBean && Arrays.stream(javaMethodElement.getParameters()).anyMatch(IS_CONSTRAINT)) {
                            annotationMetadata = javaMethodElement.annotate(BeanDefinitionInjectProcessor.ANN_VALIDATED).getAnnotationMetadata();
                        }
                        if (this.val$isConfigProps && javaMethodElement.isAbstract()) {
                            if (!aopProxyWriter.isValidated()) {
                                aopProxyWriter.setValidated(IS_CONSTRAINT.test(annotationMetadata));
                            }
                            if (!NameUtils.isGetterName((String)methodName)) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Only getter methods are allowed on @ConfigurationProperties interfaces: " + method, new Object[0]);
                                return;
                            }
                            if (javaMethodElement.hasParameters()) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Only zero argument getter methods are allowed on @ConfigurationProperties interfaces: " + method, new Object[0]);
                                return;
                            }
                            String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                            String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
                            String propertyType = javaMethodElement.getReturnType().getName();
                            if ("void".equals(propertyType)) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Getter methods must return a value @ConfigurationProperties interfaces: " + method, new Object[0]);
                                return;
                            }
                            PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(classElement, classElement, propertyType, propertyName, docComment, annotationMetadata.stringValue(Bindable.class, "defaultValue").orElse(null));
                            BeanDefinitionInjectProcessor.this.addPropertyMetadata(javaMethodElement, propertyMetadata);
                            annotationMetadata = javaMethodElement.annotate(BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE, annBuilder -> {
                                if (!javaMethodElement.getReturnType().isPrimitive() && javaMethodElement.getReturnType().hasStereotype(Scope.class)) {
                                    annBuilder.member("bean", true);
                                }
                                if (typeAnnotationMetadata.hasStereotype(EachProperty.class)) {
                                    annBuilder.member("iterable", true);
                                }
                            }).getAnnotationMetadata();
                        }
                        if (annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                            ClassElement[] interceptorTypes = AnnBeanElementVisitor.this.resolveInterceptorElements(annotationMetadata, BeanDefinitionInjectProcessor.AROUND_TYPE);
                            aopProxyWriter.visitInterceptorTypes(interceptorTypes);
                        }
                        if (javaMethodElement.isAbstract()) {
                            aopProxyWriter.visitIntroductionMethod((TypedElement)owningTypeElement, (MethodElement)javaMethodElement);
                        } else {
                            boolean isInterface = declaringClassElement.isInterface();
                            boolean isDefault = method.isDefault();
                            if (isInterface && isDefault) {
                                owningTypeElement = this.val$introductionType;
                            }
                            aopProxyWriter.visitAroundMethod((TypedElement)owningTypeElement, (MethodElement)javaMethodElement);
                        }
                    }
                }
            }, aopProxyWriter);
        }

        @Override
        public Object visitExecutable(ExecutableElement method, Object o) {
            if (method.getKind() == ElementKind.CONSTRUCTOR) {
                BeanDefinitionInjectProcessor.this.error("Unexpected call to visitExecutable for ctor %s of %s", method.getSimpleName(), o);
                return null;
            }
            if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic(method) || BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(method)) {
                return null;
            }
            this.postponeIfParametersContainErrors(method);
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(method);
            Object methodAnnotationMetadata = annotationMetadata instanceof AnnotationMetadataHierarchy ? annotationMetadata : new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, annotationMetadata});
            TypeKind returnKind = method.getReturnType().getKind();
            if (returnKind == TypeKind.ERROR && !BeanDefinitionInjectProcessor.this.processingOver) {
                throw new PostponeToNextRoundException();
            }
            JavaMethodElement javaMethodElement = this.elementFactory.newMethodElement(this.concreteClassElement, method, (AnnotationMetadata)methodAnnotationMetadata);
            if (this.isFactoryType && javaMethodElement.hasDeclaredStereotype(new Class[]{Bean.class, Scope.class}) && !javaMethodElement.getReturnType().isPrimitive()) {
                this.visitBeanFactoryMethod(javaMethodElement, method);
                return null;
            }
            boolean injected = methodAnnotationMetadata.hasDeclaredStereotype(Inject.class);
            boolean postConstruct = methodAnnotationMetadata.hasDeclaredStereotype("javax.annotation.PostConstruct");
            boolean preDestroy = methodAnnotationMetadata.hasDeclaredStereotype("javax.annotation.PreDestroy");
            if (injected || postConstruct || preDestroy || methodAnnotationMetadata.hasDeclaredStereotype(ConfigurationInject.class)) {
                if (this.isDeclaredBean) {
                    this.visitAnnotatedMethod(javaMethodElement, method, o);
                } else if (injected) {
                    this.visitAnnotatedMethod(javaMethodElement, method, o);
                }
                return null;
            }
            Set<Modifier> modifiers = method.getModifiers();
            boolean hasInvalidModifiers = javaMethodElement.isAbstract() || javaMethodElement.isStatic() || methodAnnotationMetadata.hasAnnotation(Internal.class) || javaMethodElement.isPrivate();
            boolean isPublic = javaMethodElement.isPublic() && !hasInvalidModifiers;
            boolean isExecutable = !hasInvalidModifiers && (this.isExecutableThroughType(method.getEnclosingElement(), (AnnotationMetadata)methodAnnotationMetadata, annotationMetadata, modifiers, isPublic) || annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE));
            boolean hasConstraints = false;
            if (this.isDeclaredBean && !methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_VALIDATED) && Arrays.stream(javaMethodElement.getParameters()).anyMatch(p -> p.hasStereotype(BeanDefinitionInjectProcessor.ANN_CONSTRAINT) || p.hasStereotype(BeanDefinitionInjectProcessor.ANN_VALID))) {
                hasConstraints = true;
                methodAnnotationMetadata = javaMethodElement.annotate(BeanDefinitionInjectProcessor.ANN_VALIDATED);
            }
            if (this.isDeclaredBean && isExecutable) {
                this.visitExecutableMethod(javaMethodElement, method, (AnnotationMetadata)methodAnnotationMetadata);
            } else if (this.isConfigurationPropertiesType && !BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(method) && !BeanDefinitionInjectProcessor.this.modelUtils.isStatic(method)) {
                BeanDefinitionVisitor writer;
                String methodName = javaMethodElement.getSimpleName();
                if (NameUtils.isSetterName((String)methodName) && javaMethodElement.getParameters().length == 1) {
                    this.visitConfigurationPropertySetter(method);
                } else if (NameUtils.isGetterName((String)methodName) && !(writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName())).isValidated()) {
                    writer.setValidated(IS_CONSTRAINT.test(methodAnnotationMetadata));
                }
            } else if (isPublic && hasConstraints) {
                this.visitExecutableMethod(javaMethodElement, method, (AnnotationMetadata)methodAnnotationMetadata);
            }
            return null;
        }

        private boolean isExecutableThroughType(javax.lang.model.element.Element enclosingElement, AnnotationMetadata annotationMetadataHierarchy, AnnotationMetadata declaredMetadata, Set<Modifier> modifiers, boolean isPublic) {
            return this.isExecutableType && (isPublic || modifiers.isEmpty() && this.concreteClass.equals(enclosingElement)) || annotationMetadataHierarchy.hasDeclaredStereotype(Executable.class) || declaredMetadata.hasStereotype(Executable.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitConfigurationPropertySetter(ExecutableElement method) {
            BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
            VariableElement parameter = method.getParameters().get(0);
            TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
            if (declaringClass != null) {
                AnnotationMetadata methodAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getDeclaredAnnotationMetadata(method);
                JavaClassElement javaClassElement = this.elementFactory.newClassElement(declaringClass, methodAnnotationMetadata);
                JavaMethodElement javaMethodElement = this.elementFactory.newMethodElement((ClassElement)javaClassElement, method, methodAnnotationMetadata);
                ParameterElement parameterElement = javaMethodElement.getParameters()[0];
                String propertyName = NameUtils.getPropertyNameForSetter((String)method.getSimpleName().toString());
                boolean isInterface = parameterElement.getType().isInterface();
                if (methodAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                    writer.visitConfigBuilderMethod(parameterElement.getType(), NameUtils.getterNameFor((String)propertyName), methodAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, isInterface);
                    try {
                        this.visitConfigurationBuilder(declaringClass, method, parameter.asType(), writer);
                    }
                    finally {
                        writer.visitConfigBuilderEnd();
                    }
                } else {
                    if (this.shouldExclude(this.configurationMetadata, propertyName)) {
                        return;
                    }
                    String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                    PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, parameterElement.getGenericType().getCanonicalName(), propertyName, docComment, null);
                    BeanDefinitionInjectProcessor.this.addPropertyMetadata(javaMethodElement, propertyMetadata);
                    boolean requiresReflection = true;
                    if (javaMethodElement.isPublic()) {
                        requiresReflection = false;
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isPackagePrivate(method) || javaMethodElement.isProtected()) {
                        String concretePackage;
                        String declaringPackage = javaClassElement.getPackageName();
                        requiresReflection = !declaringPackage.equals(concretePackage = this.concreteClassElement.getPackageName());
                    }
                    writer.visitSetterValue((TypedElement)javaClassElement, (MethodElement)javaMethodElement, requiresReflection, true);
                }
            }
        }

        void visitBeanFactoryMethod(JavaMethodElement beanMethodElement, final ExecutableElement beanMethod) {
            if (this.isFactoryType && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((javax.lang.model.element.Element)this.concreteClass, BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                this.visitExecutableMethod(beanMethodElement, beanMethod, BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(beanMethod));
            }
            final TypeElement producedElement = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(BeanDefinitionInjectProcessor.this.typeUtils.asElement(beanMethod.getReturnType()));
            TypeElement factoryElement = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(beanMethod);
            if (producedElement == null || factoryElement == null) {
                return;
            }
            final String producedTypeName = producedElement.getQualifiedName().toString();
            TypeMirror returnType = beanMethod.getReturnType();
            JavaClassElement declaringClassElement = this.elementFactory.newClassElement(factoryElement, this.concreteClassMetadata);
            final AnnotationMetadata methodAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(producedElement, beanMethod);
            JavaMethodElement javaMethodElement = this.elementFactory.newMethodElement((ClassElement)declaringClassElement, beanMethod, methodAnnotationMetadata);
            final BeanDefinitionWriter beanMethodWriter = this.createFactoryBeanMethodWriterFor(beanMethod, producedElement);
            Map allTypeArguments = javaMethodElement.getReturnType().getAllTypeArguments();
            beanMethodWriter.visitTypeArguments(allTypeArguments);
            this.beanDefinitionWriters.put(new DynamicName(javaMethodElement.getDescription(false)), (BeanDefinitionVisitor)beanMethodWriter);
            beanMethodWriter.visitBeanFactoryMethod(this.concreteClassElement, (MethodElement)javaMethodElement);
            if (methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) && !BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(this.concreteClass)) {
                ClassElement[] interceptorTypes = this.resolveInterceptorElements(methodAnnotationMetadata, BeanDefinitionInjectProcessor.AROUND_TYPE);
                TypeElement returnTypeElement = (TypeElement)((DeclaredType)beanMethod.getReturnType()).asElement();
                if (BeanDefinitionInjectProcessor.this.modelUtils.isFinal(returnTypeElement)) {
                    BeanDefinitionInjectProcessor.this.error(returnTypeElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + returnTypeElement, new Object[0]);
                    return;
                }
                MethodElement constructor = javaMethodElement.getGenericReturnType().getPrimaryConstructor().orElse(null);
                OptionalValues aopSettings = methodAnnotationMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class);
                LinkedHashMap<CharSequence, Boolean> finalSettings = new LinkedHashMap<CharSequence, Boolean>();
                for (CharSequence setting : aopSettings) {
                    Optional entry = aopSettings.get(setting);
                    entry.ifPresent(val -> finalSettings.put(setting, (Boolean)val));
                }
                finalSettings.put(Interceptor.PROXY_TARGET, true);
                AopProxyWriter proxyWriter = this.resolveAopProxyWriter((BeanDefinitionVisitor)beanMethodWriter, (OptionalValues<Boolean>)OptionalValues.of(Boolean.class, finalSettings), true, constructor, interceptorTypes);
                proxyWriter.visitTypeArguments(allTypeArguments);
                returnType.accept(new PublicMethodVisitor<Object, AopProxyWriter>(BeanDefinitionInjectProcessor.this.javaVisitorContext){

                    @Override
                    protected void accept(DeclaredType type, javax.lang.model.element.Element element, AopProxyWriter aopProxyWriter) {
                        ExecutableElement method = (ExecutableElement)element;
                        TypeElement owningType = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
                        JavaClassElement declaringClassElement = AnnBeanElementVisitor.this.elementFactory.newClassElement(owningType, AnnBeanElementVisitor.this.concreteClassMetadata);
                        Object annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.isAnnotated(producedTypeName, method) ? BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(beanMethod, method) : new AnnotationMetadataReference(beanMethodWriter.getBeanDefinitionName() + "Class", methodAnnotationMetadata);
                        JavaMethodElement advisedMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement((ClassElement)declaringClassElement, method, (AnnotationMetadata)annotationMetadata);
                        aopProxyWriter.visitAroundMethod((TypedElement)declaringClassElement, (MethodElement)advisedMethodElement);
                    }
                }, proxyWriter);
            } else if (methodAnnotationMetadata.hasStereotype(Executable.class)) {
                DeclaredType dt = (DeclaredType)returnType;
                final Map<String, Map<String, TypeMirror>> finalBeanTypeArgumentsMirrors = BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentElementInfo(dt.asElement(), dt);
                returnType.accept(new PublicMethodVisitor<Object, BeanDefinitionWriter>(BeanDefinitionInjectProcessor.this.javaVisitorContext){

                    @Override
                    protected void accept(DeclaredType type, javax.lang.model.element.Element element, BeanDefinitionWriter beanWriter) {
                        ExecutableElement method = (ExecutableElement)element;
                        TypeElement owningType = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
                        if (owningType == null) {
                            throw new IllegalStateException("Owning type cannot be null");
                        }
                        AnnotationMetadataReference annotationMetadata = new AnnotationMetadataReference(beanMethodWriter.getBeanDefinitionName() + "Class", methodAnnotationMetadata);
                        JavaClassElement declaringClassElement = AnnBeanElementVisitor.this.elementFactory.newClassElement(producedElement, AnnBeanElementVisitor.this.concreteClassMetadata);
                        JavaMethodElement executableMethod = AnnBeanElementVisitor.this.elementFactory.newMethodElement((ClassElement)declaringClassElement, method, (AnnotationMetadata)annotationMetadata, finalBeanTypeArgumentsMirrors);
                        beanMethodWriter.visitExecutableMethod((TypedElement)declaringClassElement, (MethodElement)executableMethod);
                    }
                }, beanMethodWriter);
            }
            if (methodAnnotationMetadata.isPresent(Bean.class, "preDestroy")) {
                Optional preDestroyMethod = methodAnnotationMetadata.getValue(Bean.class, "preDestroy", String.class);
                preDestroyMethod.ifPresent(arg_0 -> this.lambda$visitBeanFactoryMethod$6(returnType, (ClassElement)declaringClassElement, beanMethodWriter, beanMethod, arg_0));
            }
        }

        void visitExecutableMethod(MethodElement javaMethodElement, ExecutableElement method, AnnotationMetadata methodAnnotationMetadata) {
            TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
            if (declaringClass == null || BeanDefinitionInjectProcessor.this.modelUtils.isObjectClass(declaringClass)) {
                return;
            }
            boolean isOwningClass = declaringClass.getQualifiedName().equals(this.concreteClass.getQualifiedName());
            if (isOwningClass && BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(this.concreteClass) && !this.concreteClassMetadata.hasStereotype(BeanDefinitionInjectProcessor.INTRODUCTION_TYPE)) {
                return;
            }
            if (!isOwningClass && BeanDefinitionInjectProcessor.this.modelUtils.overridingOrHidingMethod(method, this.concreteClass, true).isPresent()) {
                return;
            }
            JavaClassElement declaringClassElement = this.elementFactory.newClassElement(declaringClass, this.concreteClassMetadata);
            BeanDefinitionVisitor beanWriter = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
            boolean preprocess = methodAnnotationMetadata.isTrue(Executable.class, "processOnStartup");
            if (preprocess) {
                beanWriter.setRequiresMethodProcessing(true);
            }
            if (methodAnnotationMetadata.hasStereotype(Adapter.class)) {
                this.visitAdaptedMethod(method, methodAnnotationMetadata);
            }
            boolean executableMethodVisited = false;
            if (!(beanWriter instanceof AopProxyWriter)) {
                boolean isPublic;
                boolean isConcrete = !this.concreteClassElement.isAbstract();
                boolean bl = isPublic = javaMethodElement.isPublic() || javaMethodElement.isPackagePrivate();
                if (this.isAopProxyType && isPublic || !this.isAopProxyType && methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) || methodAnnotationMetadata.hasDeclaredStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) && isConcrete) {
                    ClassElement[] interceptorTypes = this.resolveInterceptorElements(methodAnnotationMetadata, BeanDefinitionInjectProcessor.AROUND_TYPE);
                    OptionalValues settings = methodAnnotationMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class);
                    AopProxyWriter aopProxyWriter = this.resolveAopProxyWriter(beanWriter, (OptionalValues<Boolean>)settings, false, this.constructorElement, interceptorTypes);
                    aopProxyWriter.visitInterceptorTypes(interceptorTypes);
                    if (javaMethodElement.isFinal()) {
                        if (methodAnnotationMetadata.hasDeclaredStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                            BeanDefinitionInjectProcessor.this.error(method, "Method defines AOP advice but is declared final. Change the method to be non-final in order for AOP advice to be applied.", new Object[0]);
                        } else if (this.isAopProxyType && isPublic && !declaringClass.equals(this.concreteClass)) {
                            this.addOriginatingElementIfNecessary(beanWriter, declaringClass);
                            beanWriter.visitExecutableMethod((TypedElement)declaringClassElement, javaMethodElement);
                            executableMethodVisited = true;
                        } else {
                            BeanDefinitionInjectProcessor.this.error(method, "Public method inherits AOP advice but is declared final. Either make the method non-public or apply AOP advice only to public methods declared on the class.", new Object[0]);
                        }
                    } else {
                        this.addOriginatingElementIfNecessary(beanWriter, declaringClass);
                        aopProxyWriter.visitAroundMethod((TypedElement)declaringClassElement, javaMethodElement);
                        executableMethodVisited = true;
                    }
                }
            }
            if (!executableMethodVisited) {
                this.addOriginatingElementIfNecessary(beanWriter, declaringClass);
                beanWriter.visitExecutableMethod((TypedElement)declaringClassElement, javaMethodElement);
            }
        }

        private void visitAdaptedMethod(final ExecutableElement sourceMethod, AnnotationMetadata methodAnnotationMetadata) {
            TypeElement typeElement;
            boolean isInterface;
            Optional targetType;
            if (methodAnnotationMetadata instanceof AnnotationMetadataHierarchy) {
                methodAnnotationMetadata = ((AnnotationMetadataHierarchy)methodAnnotationMetadata).getDeclaredMetadata();
            }
            if ((targetType = methodAnnotationMetadata.getValue(Adapter.class, String.class).flatMap(s -> Optional.ofNullable(BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement((CharSequence)s)))).isPresent() && (isInterface = JavaModelUtils.isInterface((javax.lang.model.element.Element)(typeElement = (TypeElement)targetType.get())))) {
                JavaClassElement typeToImplementElement = this.elementFactory.newClassElement(typeElement, BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(typeElement));
                final DeclaredType typeToImplement = (DeclaredType)typeElement.asType();
                String packageName = this.concreteClassElement.getPackageName();
                String declaringClassSimpleName = this.concreteClassElement.getSimpleName();
                String beanClassName = this.generateAdaptedMethodClassName(sourceMethod, typeElement, declaringClassSimpleName);
                JavaMethodElement sourceMethodElement = this.elementFactory.newMethodElement(this.concreteClassElement, sourceMethod, methodAnnotationMetadata);
                AopProxyWriter aopProxyWriter = new AopProxyWriter(packageName, beanClassName, true, false, (Element)sourceMethodElement, (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, methodAnnotationMetadata}), new ClassElement[]{typeToImplementElement}, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, new ClassElement[0]);
                aopProxyWriter.visitDefaultConstructor(methodAnnotationMetadata);
                this.beanDefinitionWriters.put(BeanDefinitionInjectProcessor.this.elementUtils.getName(packageName + '.' + beanClassName), (BeanDefinitionVisitor)aopProxyWriter);
                Map typeVariables = typeToImplementElement.getTypeArguments();
                AnnotationMetadata finalMethodAnnotationMetadata = methodAnnotationMetadata;
                typeToImplement.accept(new PublicAbstractMethodVisitor<Object, AopProxyWriter>(typeElement, BeanDefinitionInjectProcessor.this.javaVisitorContext, (ClassElement)typeToImplementElement, (MethodElement)sourceMethodElement, typeVariables, typeElement, finalMethodAnnotationMetadata){
                    boolean first;
                    final /* synthetic */ ClassElement val$typeToImplementElement;
                    final /* synthetic */ MethodElement val$sourceMethodElement;
                    final /* synthetic */ Map val$typeVariables;
                    final /* synthetic */ TypeElement val$typeElement;
                    final /* synthetic */ AnnotationMetadata val$finalMethodAnnotationMetadata;
                    {
                        this.val$typeToImplementElement = classElement2;
                        this.val$sourceMethodElement = methodElement;
                        this.val$typeVariables = map;
                        this.val$typeElement = typeElement;
                        this.val$finalMethodAnnotationMetadata = annotationMetadata;
                        super(classElement, visitorContext);
                        this.first = true;
                    }

                    @Override
                    protected void accept(DeclaredType type, javax.lang.model.element.Element element, AopProxyWriter aopProxyWriter) {
                        if (!this.first) {
                            BeanDefinitionInjectProcessor.this.error(sourceMethod, "Interface to adapt [" + typeToImplement + "] is not a SAM type. More than one abstract method declared.", new Object[0]);
                            return;
                        }
                        this.first = false;
                        ExecutableElement targetMethod = (ExecutableElement)element;
                        JavaMethodElement targetMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement(this.val$typeToImplementElement, targetMethod, BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(targetMethod));
                        ParameterElement[] sourceParams = this.val$sourceMethodElement.getParameters();
                        ParameterElement[] targetParams = targetMethodElement.getParameters();
                        List<? extends VariableElement> targetParameters = targetMethod.getParameters();
                        int paramLen = targetParameters.size();
                        if (paramLen == sourceParams.length) {
                            LinkedHashMap<String, ClassElement> genericTypes = new LinkedHashMap<String, ClassElement>(paramLen);
                            for (int i = 0; i < paramLen; ++i) {
                                TypeVariable tv;
                                String variableName;
                                TypeMirror targetMirror = targetParameters.get(i).asType();
                                ClassElement targetType = targetParams[i].getGenericType();
                                ClassElement sourceType = sourceParams[i].getGenericType();
                                if (targetMirror.getKind() == TypeKind.TYPEVAR && this.val$typeVariables.containsKey(variableName = (tv = (TypeVariable)targetMirror).toString())) {
                                    genericTypes.put(variableName, sourceType);
                                }
                                if (sourceType.isAssignable(targetType.getName())) continue;
                                BeanDefinitionInjectProcessor.this.error(sourceMethod, "Cannot adapt method [" + sourceMethod + "] to target method [" + targetMethod + "]. Type [" + sourceType.getName() + "] is not a subtype of type [" + targetType.getName() + "] for argument at position " + i, new Object[0]);
                                return;
                            }
                            if (!genericTypes.isEmpty()) {
                                Map typeData = Collections.singletonMap(this.val$typeToImplementElement.getName(), genericTypes);
                                aopProxyWriter.visitTypeArguments(typeData);
                            }
                            JavaClassElement declaringClassElement = AnnBeanElementVisitor.this.elementFactory.newClassElement(this.val$typeElement, this.val$finalMethodAnnotationMetadata);
                            AnnotationClassValue[] adaptedArgumentTypes = new AnnotationClassValue[paramLen];
                            for (int i = 0; i < adaptedArgumentTypes.length; ++i) {
                                ParameterElement parameterElement = sourceParams[i];
                                adaptedArgumentTypes[i] = new AnnotationClassValue(parameterElement.getGenericType().getName());
                            }
                            JavaMethodElement javaMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement(AnnBeanElementVisitor.this.concreteClassElement, targetMethod, this.val$finalMethodAnnotationMetadata);
                            javaMethodElement.annotate(Adapter.class, builder -> {
                                AnnotationClassValue acv = new AnnotationClassValue(AnnBeanElementVisitor.this.concreteClassElement.getName());
                                builder.member("adaptedBean", new AnnotationClassValue[]{acv});
                                builder.member("adaptedMethod", this.val$sourceMethodElement.getName());
                                builder.member("adaptedArgumentTypes", adaptedArgumentTypes);
                                String qualifier = AnnBeanElementVisitor.this.concreteClassMetadata.stringValue(Named.class).orElse(null);
                                if (StringUtils.isNotEmpty((CharSequence)qualifier)) {
                                    builder.member("adaptedQualifier", qualifier);
                                }
                            });
                            aopProxyWriter.visitAroundMethod((TypedElement)declaringClassElement, (MethodElement)javaMethodElement);
                        } else {
                            BeanDefinitionInjectProcessor.this.error(sourceMethod, "Cannot adapt method [" + sourceMethod + "] to target method [" + targetMethod + "]. Argument lengths don't match.", new Object[0]);
                        }
                    }
                }, aopProxyWriter);
            }
        }

        private String generateAdaptedMethodClassName(ExecutableElement method, TypeElement typeElement, String declaringClassSimpleName) {
            String rootName = declaringClassSimpleName + '$' + typeElement.getSimpleName().toString() + '$' + method.getSimpleName().toString();
            return rootName + this.adaptedMethodIndex.incrementAndGet();
        }

        private AopProxyWriter resolveAopProxyWriter(BeanDefinitionVisitor beanWriter, OptionalValues<Boolean> aopSettings, boolean isFactoryType, MethodElement constructorElement, ClassElement ... interceptorTypes) {
            AopProxyWriter aopProxyWriter;
            BeanDefinitionVisitor aopWriter;
            String beanName = beanWriter.getBeanDefinitionName();
            DynamicName proxyKey = this.createProxyKey(beanName);
            BeanDefinitionVisitor beanDefinitionVisitor = aopWriter = beanWriter instanceof AopProxyWriter ? beanWriter : this.beanDefinitionWriters.get(proxyKey);
            if (aopWriter == null) {
                aopProxyWriter = new AopProxyWriter((BeanDefinitionWriter)beanWriter, aopSettings, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, interceptorTypes);
                if (constructorElement != null) {
                    aopProxyWriter.visitBeanDefinitionConstructor(constructorElement, constructorElement.isPrivate());
                } else {
                    aopProxyWriter.visitDefaultConstructor(AnnotationMetadata.EMPTY_METADATA);
                }
                if (isFactoryType) {
                    aopProxyWriter.visitSuperBeanDefinitionFactory(beanName);
                } else {
                    aopProxyWriter.visitSuperBeanDefinition(beanName);
                }
                aopWriter = aopProxyWriter;
                this.beanDefinitionWriters.put(proxyKey, aopWriter);
            } else {
                aopProxyWriter = (AopProxyWriter)aopWriter;
            }
            return aopProxyWriter;
        }

        void visitAnnotatedMethod(MethodElement javaMethodElement, ExecutableElement method, Object o) {
            boolean overriddenInjected;
            ClassElement declaringClass = javaMethodElement.getDeclaringType();
            boolean isParent = !declaringClass.getName().equals(this.concreteClassElement.getName());
            ExecutableElement overridingMethod = BeanDefinitionInjectProcessor.this.modelUtils.overridingOrHidingMethod(method, this.concreteClass, false).orElse(method);
            TypeElement overridingClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(overridingMethod);
            boolean overridden = isParent && overridingClass != null && !overridingClass.getQualifiedName().toString().equals(declaringClass.getName());
            boolean isPackagePrivate = javaMethodElement.isPackagePrivate();
            boolean isPrivate = javaMethodElement.isPrivate();
            if (overridden && !isPrivate && !isPackagePrivate) {
                return;
            }
            String packageOfOverridingClass = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(overridingMethod).getQualifiedName().toString();
            String packageOfDeclaringClass = declaringClass.getPackageName();
            boolean isPackagePrivateAndPackagesDiffer = overridden && isPackagePrivate && !packageOfOverridingClass.equals(packageOfDeclaringClass);
            boolean requiresReflection = isPrivate || isPackagePrivateAndPackagesDiffer;
            boolean bl = overriddenInjected = overridden && BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(overridingMethod).hasDeclaredStereotype(Inject.class);
            if (isParent && isPackagePrivate && !isPackagePrivateAndPackagesDiffer && overriddenInjected) {
                return;
            }
            if (isParent && overridden && !overriddenInjected && !isPackagePrivateAndPackagesDiffer && !isPrivate) {
                return;
            }
            if (!requiresReflection && BeanDefinitionInjectProcessor.this.modelUtils.isInheritedAndNotPublic(this.concreteClassElement, declaringClass, (Element)javaMethodElement)) {
                requiresReflection = true;
            }
            if (javaMethodElement.hasDeclaredStereotype("javax.annotation.PostConstruct")) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                AopProxyWriter aopWriter = this.resolveAopWriter(writer);
                if (aopWriter != null && !aopWriter.isProxyTarget()) {
                    writer = aopWriter;
                }
                this.addOriginatingElementIfNecessary(writer, declaringClass);
                writer.visitPostConstructMethod((TypedElement)declaringClass, javaMethodElement, requiresReflection);
            } else if (javaMethodElement.hasDeclaredStereotype("javax.annotation.PreDestroy")) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                AopProxyWriter aopWriter = this.resolveAopWriter(writer);
                if (aopWriter != null && !aopWriter.isProxyTarget()) {
                    writer = aopWriter;
                }
                this.addOriginatingElementIfNecessary(writer, declaringClass);
                writer.visitPreDestroyMethod((TypedElement)declaringClass, javaMethodElement, requiresReflection);
            } else if (javaMethodElement.hasDeclaredStereotype(Inject.class) || javaMethodElement.hasDeclaredStereotype(ConfigurationInject.class)) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                this.addOriginatingElementIfNecessary(writer, declaringClass);
                writer.visitMethodInjectionPoint((TypedElement)declaringClass, javaMethodElement, requiresReflection);
            } else {
                BeanDefinitionInjectProcessor.this.error("Unexpected call to visitAnnotatedMethod(%s)", method);
            }
        }

        @Nullable
        private AopProxyWriter resolveAopWriter(BeanDefinitionVisitor writer) {
            DynamicName proxyKey = this.createProxyKey(writer.getBeanDefinitionName());
            BeanDefinitionVisitor aopWriter = this.beanDefinitionWriters.get(proxyKey);
            if (aopWriter instanceof AopProxyWriter) {
                return (AopProxyWriter)aopWriter;
            }
            if (this.isAopProxyType) {
                ClassElement[] interceptorTypes = this.resolveInterceptorElements(this.concreteClassMetadata, BeanDefinitionInjectProcessor.AROUND_TYPE);
                return this.resolveAopProxyWriter(writer, this.aopSettings, this.isFactoryType, this.constructorElement, interceptorTypes);
            }
            return null;
        }

        @Override
        public Object visitVariable(VariableElement variable, Object o) {
            boolean isValue;
            if (variable.getKind() != ElementKind.FIELD) {
                return null;
            }
            if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic(variable)) {
                return null;
            }
            if (BeanDefinitionInjectProcessor.this.modelUtils.isFinal(variable)) {
                AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(variable);
                boolean isConfigBuilder = fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class);
                if (isConfigBuilder) {
                    this.visitConfigurationProperty(variable, fieldAnnotationMetadata);
                }
                return null;
            }
            AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(variable);
            boolean isInjected = fieldAnnotationMetadata.hasStereotype(Inject.class);
            boolean bl = isValue = !isInjected && (fieldAnnotationMetadata.hasStereotype(Value.class) || fieldAnnotationMetadata.hasStereotype(Property.class));
            if (isInjected || isValue) {
                TypeMirror type;
                boolean requiresReflection;
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(variable);
                if (declaringClass == null) {
                    return null;
                }
                JavaClassElement declaringClassElement = this.elementFactory.newClassElement(declaringClass, this.concreteClassMetadata);
                JavaFieldElement javaFieldElement = this.elementFactory.newFieldElement(variable, fieldAnnotationMetadata);
                this.addOriginatingElementIfNecessary(writer, declaringClass);
                boolean isPrivate = javaFieldElement.isPrivate();
                boolean bl2 = requiresReflection = isPrivate || BeanDefinitionInjectProcessor.this.modelUtils.isInheritedAndNotPublic(this.concreteClass, declaringClass, variable);
                if (!writer.isValidated()) {
                    writer.setValidated(IS_CONSTRAINT.test(fieldAnnotationMetadata));
                }
                if ((type = variable.asType()).getKind() == TypeKind.ERROR && !BeanDefinitionInjectProcessor.this.processingOver) {
                    throw new PostponeToNextRoundException();
                }
                if (isValue) {
                    writer.visitFieldValue((TypedElement)declaringClassElement, (FieldElement)javaFieldElement, requiresReflection, this.isConfigurationPropertiesType);
                } else {
                    writer.visitFieldInjectionPoint((TypedElement)declaringClassElement, (FieldElement)javaFieldElement, requiresReflection);
                }
            } else if (this.isConfigurationPropertiesType) {
                this.visitConfigurationProperty(variable, fieldAnnotationMetadata);
            }
            return null;
        }

        private void addOriginatingElementIfNecessary(BeanDefinitionVisitor writer, TypeElement declaringClass) {
            if (!this.concreteClass.equals(declaringClass)) {
                writer.addOriginatingElement((Element)this.elementFactory.newClassElement(declaringClass, this.currentClassMetadata));
            }
        }

        private void addOriginatingElementIfNecessary(BeanDefinitionVisitor writer, ClassElement declaringClass) {
            if (!this.concreteClassElement.getName().equals(declaringClass.getName())) {
                writer.addOriginatingElement((Element)declaringClass);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitConfigurationProperty(VariableElement field, AnnotationMetadata fieldAnnotationMetadata) {
            boolean isMethodInjected;
            Optional<ExecutableElement> setterMethod = BeanDefinitionInjectProcessor.this.modelUtils.findSetterMethodFor(field);
            boolean isInjected = fieldAnnotationMetadata.hasStereotype(Inject.class);
            boolean isValue = fieldAnnotationMetadata.hasStereotype(Value.class) || fieldAnnotationMetadata.hasStereotype(Property.class);
            boolean bl = isMethodInjected = isInjected || setterMethod.isPresent() && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((javax.lang.model.element.Element)setterMethod.get(), Inject.class);
            if (!isMethodInjected && !isValue) {
                TypeElement declaringClass;
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                if (!writer.isValidated()) {
                    writer.setValidated(IS_CONSTRAINT.test(fieldAnnotationMetadata));
                }
                if ((declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(field)) == null) {
                    return null;
                }
                JavaClassElement declaringClassElement = this.elementFactory.newClassElement(declaringClass, this.concreteClassMetadata);
                JavaFieldElement javaFieldElement = this.elementFactory.newFieldElement((ClassElement)declaringClassElement, field, fieldAnnotationMetadata);
                String fieldName = javaFieldElement.getName();
                if (fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                    boolean accessible = false;
                    if (BeanDefinitionInjectProcessor.this.modelUtils.isPublic(field)) {
                        accessible = true;
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isPackagePrivate(field) || BeanDefinitionInjectProcessor.this.modelUtils.isProtected(field)) {
                        String declaringPackage = declaringClassElement.getPackageName();
                        String concretePackage = this.concreteClassElement.getPackageName();
                        accessible = declaringPackage.equals(concretePackage);
                    }
                    boolean isInterface = javaFieldElement.getType().isInterface();
                    if (accessible) {
                        writer.visitConfigBuilderField(javaFieldElement.getType(), fieldName, fieldAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, isInterface);
                    } else {
                        Optional<ExecutableElement> getterMethod = BeanDefinitionInjectProcessor.this.modelUtils.findGetterMethodFor(field);
                        if (getterMethod.isPresent()) {
                            writer.visitConfigBuilderMethod(javaFieldElement.getType(), getterMethod.get().getSimpleName().toString(), fieldAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, isInterface);
                        } else {
                            BeanDefinitionInjectProcessor.this.error(field, "ConfigurationBuilder applied to a non accessible (private or package-private/protected in a different package) field must have a corresponding non-private getter method.", new Object[0]);
                        }
                    }
                    try {
                        this.visitConfigurationBuilder(declaringClass, field, field.asType(), writer);
                    }
                    finally {
                        writer.visitConfigBuilderEnd();
                    }
                } else {
                    if (this.shouldExclude(this.configurationMetadata, fieldName)) {
                        return null;
                    }
                    if (setterMethod.isPresent()) {
                        ExecutableElement method = setterMethod.get();
                        String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                        BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, BeanDefinitionInjectProcessor.this.getPropertyMetadataTypeReference(field.asType()), fieldName, docComment, null);
                    } else {
                        boolean isPrivate = javaFieldElement.isPrivate();
                        boolean requiresReflection = this.isInheritedAndNotPublic(BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(field), field.getModifiers());
                        if (!isPrivate) {
                            String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(field);
                            PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, BeanDefinitionInjectProcessor.this.getPropertyMetadataTypeReference(field.asType()), fieldName, docComment, null);
                            BeanDefinitionInjectProcessor.this.addPropertyMetadata(javaFieldElement, propertyMetadata);
                            writer.visitFieldValue((TypedElement)declaringClassElement, (FieldElement)javaFieldElement, requiresReflection, this.isConfigurationPropertiesType);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public Object visitTypeParameter(TypeParameterElement e, Object o) {
            BeanDefinitionInjectProcessor.this.note("Visit param %s for %s", e.getSimpleName(), o);
            return super.visitTypeParameter(e, o);
        }

        @Override
        public Object visitUnknown(javax.lang.model.element.Element e, Object o) {
            if (!JavaModelUtils.isRecordOrRecordComponent((javax.lang.model.element.Element)e)) {
                BeanDefinitionInjectProcessor.this.note("Visit unknown %s for %s", e.getSimpleName(), o);
                return super.visitUnknown(e, o);
            }
            return o;
        }

        protected boolean isInheritedAndNotPublic(TypeElement declaringClass, Set<Modifier> modifiers) {
            PackageElement declaringPackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(declaringClass);
            PackageElement concretePackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(this.concreteClass);
            return !declaringClass.equals(this.concreteClass) && !declaringPackage.equals(concretePackage) && !modifiers.contains((Object)Modifier.PUBLIC);
        }

        private void visitConfigurationBuilder(final TypeElement declaringClass, javax.lang.model.element.Element builderElement, TypeMirror builderType, final BeanDefinitionVisitor writer) {
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(builderElement);
            final Boolean allowZeroArgs = annotationMetadata.getValue(ConfigurationBuilder.class, "allowZeroArgs", Boolean.class).orElse(false);
            final List<Object> prefixes = Arrays.asList((Object[])annotationMetadata.getValue(ConfigurationBuilder.class, "prefixes", String[].class).orElse(new String[]{"set"}));
            final String configurationPrefix = annotationMetadata.getValue(ConfigurationBuilder.class, String.class).map(v -> v + ".").orElse("");
            final Set includes = annotationMetadata.getValue(ConfigurationBuilder.class, "includes", Set.class).orElse(Collections.emptySet());
            final Set excludes = annotationMetadata.getValue(ConfigurationBuilder.class, "excludes", Set.class).orElse(Collections.emptySet());
            PublicMethodVisitor visitor = new PublicMethodVisitor(BeanDefinitionInjectProcessor.this.javaVisitorContext){

                @Override
                protected void accept(DeclaredType type, javax.lang.model.element.Element element, Object o) {
                    String prefix;
                    ExecutableElement method = (ExecutableElement)element;
                    List<? extends VariableElement> params = method.getParameters();
                    String methodName = method.getSimpleName().toString();
                    String propertyName = NameUtils.decapitalize((String)methodName.substring((prefix = this.getMethodPrefix(prefixes, methodName)).length()));
                    if (AnnBeanElementVisitor.this.shouldExclude(includes, excludes, propertyName)) {
                        return;
                    }
                    int paramCount = params.size();
                    JavaMethodElement javaMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement(AnnBeanElementVisitor.this.concreteClassElement, method, AnnotationMetadata.EMPTY_METADATA);
                    if (paramCount < 2) {
                        VariableElement paramType = paramCount == 1 ? params.get(0) : null;
                        ClassElement parameterElement = null;
                        if (paramType != null) {
                            parameterElement = AnnBeanElementVisitor.this.elementFactory.newParameterElement(AnnBeanElementVisitor.this.concreteClassElement, paramType, AnnotationMetadata.EMPTY_METADATA).getGenericType();
                        }
                        PropertyMetadata metadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(AnnBeanElementVisitor.this.concreteClass, declaringClass, parameterElement != null ? parameterElement.getName() : null, configurationPrefix + propertyName, null, null);
                        writer.visitConfigBuilderMethod(prefix, javaMethodElement.getReturnType(), methodName, parameterElement, parameterElement != null ? parameterElement.getTypeArguments() : null, metadata.getPath());
                    } else if (paramCount == 2) {
                        VariableElement first = params.get(0);
                        VariableElement second = params.get(1);
                        TypeMirror tu = BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement(TimeUnit.class.getName()).asType();
                        TypeMirror typeMirror = first.asType();
                        if (typeMirror.toString().equals("long") && BeanDefinitionInjectProcessor.this.typeUtils.isAssignable(second.asType(), tu)) {
                            PropertyMetadata metadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(AnnBeanElementVisitor.this.concreteClass, declaringClass, Duration.class.getName(), configurationPrefix + propertyName, null, null);
                            writer.visitConfigBuilderDurationMethod(prefix, javaMethodElement.getReturnType(), methodName, metadata.getPath());
                        }
                    }
                }

                @Override
                protected boolean isAcceptable(javax.lang.model.element.Element element) {
                    if (BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype(element, Deprecated.class)) {
                        return false;
                    }
                    Set<Modifier> modifiers = element.getModifiers();
                    if (element.getKind() == ElementKind.METHOD) {
                        ExecutableElement method = (ExecutableElement)element;
                        int paramCount = method.getParameters().size();
                        return modifiers.contains((Object)Modifier.PUBLIC) && (paramCount > 0 && paramCount < 3 || allowZeroArgs != false && paramCount == 0) && this.isPrefixedWith(method, prefixes);
                    }
                    return false;
                }

                private boolean isPrefixedWith(javax.lang.model.element.Element enclosedElement, List<String> prefixes2) {
                    String name = enclosedElement.getSimpleName().toString();
                    for (String prefix : prefixes2) {
                        if (!name.startsWith(prefix)) continue;
                        return true;
                    }
                    return false;
                }

                private String getMethodPrefix(List<String> prefixes2, String methodName) {
                    for (String prefix : prefixes2) {
                        if (!methodName.startsWith(prefix)) continue;
                        return prefix;
                    }
                    return methodName;
                }
            };
            builderType.accept(visitor, null);
        }

        private BeanDefinitionWriter createBeanDefinitionWriterFor(TypeElement typeElement) {
            AnnotationMetadata annotationMetadata;
            Object classElement;
            if (typeElement == this.concreteClass) {
                classElement = this.concreteClassElement;
                annotationMetadata = classElement.getAnnotationMetadata();
            } else {
                annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(typeElement);
                classElement = this.elementFactory.newClassElement(typeElement, annotationMetadata);
            }
            if (this.configurationMetadata != null) {
                String existingPrefix = annotationMetadata.stringValue(ConfigurationReader.class, "prefix").orElse("");
                String computedPrefix = StringUtils.isNotEmpty((CharSequence)existingPrefix) ? existingPrefix + "." + this.configurationMetadata.getName() : this.configurationMetadata.getName();
                classElement.annotate(ConfigurationReader.class, builder -> builder.member("prefix", computedPrefix));
            }
            BeanDefinitionWriter beanDefinitionWriter = new BeanDefinitionWriter(classElement, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder);
            beanDefinitionWriter.visitTypeArguments(classElement.getAllTypeArguments());
            return beanDefinitionWriter;
        }

        private DynamicName createProxyKey(String beanName) {
            return new DynamicName(beanName + "$Proxy");
        }

        private AopProxyWriter createIntroductionAdviceWriter(ClassElement typeElement) {
            AnnotationMetadata annotationMetadata = typeElement.getAnnotationMetadata();
            String packageName = typeElement.getPackageName();
            String beanClassName = typeElement.getSimpleName();
            Object[] aroundInterceptors = this.resolveInterceptorElements(annotationMetadata, BeanDefinitionInjectProcessor.AROUND_TYPE);
            Object[] introductionInterceptors = this.resolveInterceptorElements(annotationMetadata, Introduction.class.getName());
            Object[] interfaceTypes = (ClassElement[])Arrays.stream((Object[])annotationMetadata.getValue(Introduction.class, "interfaces", String[].class).orElse(new String[0])).map(ClassElement::of).toArray(ClassElement[]::new);
            ClassElement[] interceptorTypes = (ClassElement[])ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
            boolean isInterface = typeElement.isInterface();
            AopProxyWriter aopProxyWriter = new AopProxyWriter(packageName, beanClassName, isInterface, (Element)typeElement, annotationMetadata, (ClassElement[])interfaceTypes, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, interceptorTypes);
            Set additionalInterfaces = Arrays.stream(interfaceTypes).map(ce -> BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement(ce.getName())).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
            if (ArrayUtils.isNotEmpty((Object[])interfaceTypes)) {
                TypeElement te = (TypeElement)typeElement.getNativeType();
                List<? extends AnnotationMirror> annotationMirrors = te.getAnnotationMirrors();
                this.populateIntroductionInterfaces(annotationMirrors, additionalInterfaces);
                if (!additionalInterfaces.isEmpty()) {
                    for (TypeElement additionalInterface : additionalInterfaces) {
                        this.visitIntroductionAdviceInterface(additionalInterface, annotationMetadata, aopProxyWriter);
                    }
                }
            }
            return aopProxyWriter;
        }

        private void populateIntroductionInterfaces(List<? extends AnnotationMirror> annotationMirrors, Set<TypeElement> additionalInterfaces) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType.toString().equals(Introduction.class.getName())) {
                    Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                        ExecutableElement key = entry.getKey();
                        if (!key.toString().equalsIgnoreCase("interfaces()")) continue;
                        Object value = entry.getValue().getValue();
                        if (value instanceof List) {
                            for (Object v : (List)value) {
                                if (!(v instanceof AnnotationValue)) continue;
                                this.tryAddAnnotationValue(additionalInterfaces, (AnnotationValue)v);
                            }
                            continue;
                        }
                        if (!(value instanceof AnnotationValue)) continue;
                        this.tryAddAnnotationValue(additionalInterfaces, (AnnotationValue)value);
                    }
                    continue;
                }
                javax.lang.model.element.Element element = annotationType.asElement();
                if (!BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype(element, Introduction.class)) continue;
                this.populateIntroductionInterfaces(element.getAnnotationMirrors(), additionalInterfaces);
            }
        }

        private void tryAddAnnotationValue(Set<TypeElement> additionalInterfaces, AnnotationValue v) {
            TypeMirror tm;
            Object v2 = v.getValue();
            if (v2 instanceof TypeMirror && (tm = (TypeMirror)v2).getKind() == TypeKind.DECLARED) {
                DeclaredType dt = (DeclaredType)tm;
                additionalInterfaces.add((TypeElement)dt.asElement());
            }
        }

        private BeanDefinitionWriter createFactoryBeanMethodWriterFor(ExecutableElement method, TypeElement producedElement) {
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(producedElement, method, true);
            PackageElement producedPackageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(producedElement);
            PackageElement definingPackageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(this.concreteClass);
            boolean isInterface = JavaModelUtils.isInterface((javax.lang.model.element.Element)producedElement);
            String packageName = producedPackageElement.getQualifiedName().toString();
            String beanDefinitionPackage = definingPackageElement.getQualifiedName().toString();
            String shortClassName = BeanDefinitionInjectProcessor.this.modelUtils.simpleBinaryNameFor(producedElement);
            String upperCaseMethodName = NameUtils.capitalize((String)method.getSimpleName().toString());
            String factoryMethodBeanDefinitionName = beanDefinitionPackage + ".$" + this.concreteClass.getSimpleName().toString() + "$" + upperCaseMethodName + this.factoryMethodIndex.getAndIncrement() + "Definition";
            return new BeanDefinitionWriter(packageName, shortClassName, factoryMethodBeanDefinitionName, JavaModelUtils.getClassName((TypeElement)producedElement), isInterface, OriginatingElements.of((Element[])new Element[]{this.elementFactory.newMethodElement(this.concreteClassElement, method, annotationMetadata)}), annotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder);
        }

        private boolean shouldExclude(Set<String> includes, Set<String> excludes, String propertyName) {
            if (!includes.isEmpty() && !includes.contains(propertyName)) {
                return true;
            }
            return !excludes.isEmpty() && excludes.contains(propertyName);
        }

        private boolean shouldExclude(ConfigurationMetadata configurationMetadata, String propertyName) {
            return this.shouldExclude(configurationMetadata.getIncludes(), configurationMetadata.getExcludes(), propertyName);
        }

        private ClassElement[] resolveInterceptorElements(AnnotationMetadata annotationMetadata, String annotationName) {
            return (ClassElement[])annotationMetadata.getAnnotationNamesByStereotype(annotationName).stream().map(ClassElement::of).toArray(ClassElement[]::new);
        }

        private /* synthetic */ void lambda$visitBeanFactoryMethod$6(TypeMirror returnType, ClassElement declaringClassElement, BeanDefinitionWriter beanMethodWriter, ExecutableElement beanMethod, String destroyMethodName) {
            if (StringUtils.isNotEmpty((CharSequence)destroyMethodName)) {
                TypeElement destroyMethodDeclaringClass = (TypeElement)BeanDefinitionInjectProcessor.this.typeUtils.asElement(returnType);
                JavaClassElement destroyMethodDeclaringElement = this.elementFactory.newClassElement(destroyMethodDeclaringClass, AnnotationMetadata.EMPTY_METADATA);
                Optional<ExecutableElement> destroyMethodRef = BeanDefinitionInjectProcessor.this.modelUtils.findAccessibleNoArgumentInstanceMethod(destroyMethodDeclaringClass, destroyMethodName);
                if (destroyMethodRef.isPresent()) {
                    ExecutableElement executableElement = destroyMethodRef.get();
                    JavaMethodElement destroyMethodElement = this.elementFactory.newMethodElement(declaringClassElement, executableElement, AnnotationMetadata.EMPTY_METADATA);
                    beanMethodWriter.visitPreDestroyMethod((TypedElement)destroyMethodDeclaringElement, (MethodElement)destroyMethodElement, false);
                } else {
                    BeanDefinitionInjectProcessor.this.error(beanMethod, "@Bean method defines a preDestroy method that does not exist or is not public: " + destroyMethodName, new Object[0]);
                }
            }
        }
    }
}

