/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaEnumElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public abstract class AbstractJavaElement
implements Element,
AnnotationMetadataDelegate {
    private final javax.lang.model.element.Element element;
    private final JavaVisitorContext visitorContext;
    private AnnotationMetadata annotationMetadata;

    AbstractJavaElement(javax.lang.model.element.Element element, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        this.element = element;
        this.annotationMetadata = annotationMetadata;
        this.visitorContext = visitorContext;
    }

    @NonNull
    public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        TypeElement typeElement;
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        ArgumentUtils.requireNonNull((String)"consumer", consumer);
        AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
        consumer.accept(builder);
        AnnotationValue av = builder.build();
        AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
        this.annotationMetadata = annotationUtils.newAnnotationBuilder().annotate(this.annotationMetadata, av);
        String declaringTypeName = this instanceof MemberElement ? ((MemberElement)this).getOwningType().getName() : (this instanceof ParameterElement ? ((typeElement = this.visitorContext.getModelUtils().classElementFor((javax.lang.model.element.Element)this.getNativeType())) == null ? this.getName() : typeElement.getQualifiedName().toString()) : this.getName());
        AbstractAnnotationMetadataBuilder.addMutatedMetadata((String)declaringTypeName, (Object)this.element, (AnnotationMetadata)this.annotationMetadata);
        AnnotationUtils.invalidateMetadata(this.element);
        return this;
    }

    public boolean isPackagePrivate() {
        Set<Modifier> modifiers = this.element.getModifiers();
        return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    public String getName() {
        return this.element.getSimpleName().toString();
    }

    public boolean isAbstract() {
        return this.hasModifier(Modifier.ABSTRACT);
    }

    public boolean isStatic() {
        return this.hasModifier(Modifier.STATIC);
    }

    public boolean isPublic() {
        return this.hasModifier(Modifier.PUBLIC);
    }

    public boolean isPrivate() {
        return this.hasModifier(Modifier.PRIVATE);
    }

    public boolean isFinal() {
        return this.hasModifier(Modifier.FINAL);
    }

    public boolean isProtected() {
        return this.hasModifier(Modifier.PROTECTED);
    }

    public Object getNativeType() {
        return this.element;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public String toString() {
        return this.element.toString();
    }

    @NonNull
    protected ClassElement parameterizedClassElement(TypeMirror typeMirror, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> declaredGenericInfo) {
        return this.mirrorToClassElement(typeMirror, visitorContext, declaredGenericInfo, true);
    }

    @NonNull
    protected ClassElement mirrorToClassElement(TypeMirror returnType, JavaVisitorContext visitorContext) {
        return this.mirrorToClassElement(returnType, visitorContext, Collections.emptyMap(), true);
    }

    @NonNull
    protected ClassElement mirrorToClassElement(TypeMirror returnType, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo) {
        return this.mirrorToClassElement(returnType, visitorContext, genericsInfo, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    protected ClassElement mirrorToClassElement(TypeMirror returnType, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo222, boolean includeTypeAnnotations) {
        void genericsInfo222;
        if (genericsInfo222 == null) {
            Map genericsInfo222 = Collections.emptyMap();
        }
        if (returnType instanceof NoType) {
            return PrimitiveElement.VOID;
        }
        if (returnType instanceof DeclaredType) {
            AnnotationMetadata newAnnotationMetadata;
            DeclaredType dt = (DeclaredType)returnType;
            javax.lang.model.element.Element e = dt.asElement();
            if (!(e.asType() instanceof DeclaredType)) return this.mirrorToClassElement(e.asType(), visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222, (boolean)includeTypeAnnotations);
            List<? extends TypeMirror> typeArguments = dt.getTypeArguments();
            if (!(e instanceof TypeElement)) return PrimitiveElement.VOID;
            TypeElement typeElement = (TypeElement)e;
            Map<String, TypeMirror> boundGenerics = this.resolveBoundGenerics(visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222);
            AnnotationUtils annotationUtils = visitorContext.getAnnotationUtils();
            List<? extends AnnotationMirror> annotationMirrors = dt.getAnnotationMirrors();
            if (!annotationMirrors.isEmpty()) {
                newAnnotationMetadata = annotationUtils.newAnnotationBuilder().buildDeclared(typeElement, annotationMirrors, (boolean)includeTypeAnnotations);
            } else {
                AnnotationMetadata annotationMetadata = newAnnotationMetadata = includeTypeAnnotations != false ? annotationUtils.getAnnotationMetadata(typeElement) : AnnotationMetadata.EMPTY_METADATA;
            }
            if (visitorContext.getModelUtils().resolveKind(typeElement, ElementKind.ENUM).isPresent()) {
                return new JavaEnumElement(typeElement, newAnnotationMetadata, visitorContext);
            }
            Map<String, Map<String, TypeMirror>> genericsInfo222 = visitorContext.getGenericUtils().alignNewGenericsInfo(typeElement, typeArguments, boundGenerics);
            return new JavaClassElement(typeElement, newAnnotationMetadata, visitorContext, genericsInfo222);
        }
        if (returnType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)returnType;
            TypeMirror upperBound = tv.getUpperBound();
            Map<String, TypeMirror> boundGenerics = this.resolveBoundGenerics(visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222);
            TypeMirror bound = boundGenerics.get(tv.toString());
            if (bound == null || bound == tv) return this.mirrorToClassElement(upperBound, visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222, (boolean)includeTypeAnnotations);
            return this.mirrorToClassElement(bound, visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222, (boolean)includeTypeAnnotations);
        }
        if (returnType instanceof ArrayType) {
            ArrayType at = (ArrayType)returnType;
            TypeMirror componentType = at.getComponentType();
            ClassElement arrayType = this.mirrorToClassElement(componentType, visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222, (boolean)includeTypeAnnotations);
            return arrayType.toArray();
        }
        if (!(returnType instanceof PrimitiveType)) return PrimitiveElement.VOID;
        PrimitiveType pt = (PrimitiveType)returnType;
        return PrimitiveElement.valueOf((String)pt.getKind().name());
    }

    private Map<String, TypeMirror> resolveBoundGenerics(JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo) {
        Map<String, TypeMirror> boundGenerics;
        String declaringTypeName = null;
        TypeElement typeElement = visitorContext.getModelUtils().classElementFor(this.element);
        if (typeElement != null) {
            declaringTypeName = typeElement.getQualifiedName().toString();
        }
        if ((boundGenerics = genericsInfo.get(declaringTypeName)) == null) {
            boundGenerics = Collections.emptyMap();
        }
        return boundGenerics;
    }

    private boolean hasModifier(Modifier modifier) {
        return this.element.getModifiers().contains((Object)modifier);
    }
}

