/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.Map;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Internal
class JavaParameterElement
extends AbstractJavaElement
implements ParameterElement {
    private final JavaVisitorContext visitorContext;
    private final JavaClassElement declaringClass;
    private ClassElement typeElement;
    private ClassElement genericTypeElement;

    JavaParameterElement(JavaClassElement declaringClass, VariableElement element, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(element, annotationMetadata, visitorContext);
        this.declaringClass = declaringClass;
        this.visitorContext = visitorContext;
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    @NonNull
    public ClassElement getType() {
        if (this.typeElement == null) {
            TypeMirror parameterType = this.getNativeType().asType();
            this.typeElement = this.mirrorToClassElement(parameterType, this.visitorContext);
        }
        return this.typeElement;
    }

    @NonNull
    public ClassElement getGenericType() {
        if (this.genericTypeElement == null) {
            TypeMirror returnType = this.getNativeType().asType();
            Map<String, Map<String, TypeMirror>> declaredGenericInfo = this.declaringClass.getGenericTypeInfo();
            this.genericTypeElement = this.parameterizedClassElement(returnType, this.visitorContext, declaredGenericInfo);
        }
        return this.genericTypeElement;
    }

    @Override
    public VariableElement getNativeType() {
        return (VariableElement)super.getNativeType();
    }
}

