/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaParameterElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

@Internal
public class JavaMethodElement
extends AbstractJavaElement
implements MethodElement {
    private final ExecutableElement executableElement;
    private final JavaVisitorContext visitorContext;
    private final JavaClassElement declaringClass;
    private JavaClassElement resolvedDeclaringClass;
    private ParameterElement[] parameters;
    private ParameterElement continuationParameter;
    private ClassElement genericReturnType;
    private ClassElement returnType;

    public JavaMethodElement(JavaClassElement declaringClass, ExecutableElement executableElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(executableElement, annotationMetadata, visitorContext);
        this.executableElement = executableElement;
        this.visitorContext = visitorContext;
        this.declaringClass = declaringClass;
    }

    public boolean isDefault() {
        return this.executableElement.isDefault();
    }

    @NonNull
    public ClassElement getGenericReturnType() {
        if (this.genericReturnType == null) {
            this.genericReturnType = this.returnType(this.declaringClass.getGenericTypeInfo());
        }
        return this.genericReturnType;
    }

    @NonNull
    public ClassElement getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.returnType(Collections.emptyMap());
        }
        return this.returnType;
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.visitorContext.getElements().getDocComment(this.executableElement));
    }

    public boolean isSuspend() {
        this.getParameters();
        return this.continuationParameter != null;
    }

    public ParameterElement[] getParameters() {
        if (this.parameters == null) {
            List<? extends VariableElement> parameters = this.executableElement.getParameters();
            ArrayList<JavaParameterElement> elts = new ArrayList<JavaParameterElement>(parameters.size());
            Iterator<? extends VariableElement> i = parameters.iterator();
            while (i.hasNext()) {
                VariableElement variableElement = i.next();
                if (!i.hasNext() && this.isSuspend(variableElement)) {
                    this.continuationParameter = this.newParameterElement(variableElement, AnnotationMetadata.EMPTY_METADATA);
                    continue;
                }
                AnnotationMetadata annotationMetadata = this.visitorContext.getAnnotationUtils().getAnnotationMetadata(variableElement);
                JavaParameterElement javaParameterElement = this.newParameterElement(variableElement, annotationMetadata);
                if (annotationMetadata.hasDeclaredAnnotation("org.jetbrains.annotations.Nullable")) {
                    javaParameterElement.annotate("javax.annotation.Nullable").getAnnotationMetadata();
                }
                elts.add(javaParameterElement);
            }
            this.parameters = elts.toArray(new ParameterElement[0]);
        }
        return this.parameters;
    }

    public MethodElement withNewParameters(final ParameterElement ... newParameters) {
        return new JavaMethodElement(this.declaringClass, this.executableElement, this.getAnnotationMetadata(), this.visitorContext){

            @Override
            public ParameterElement[] getParameters() {
                return (ParameterElement[])ArrayUtils.concat((Object[])super.getParameters(), (Object[])newParameters);
            }
        };
    }

    public ParameterElement[] getSuspendParameters() {
        Object[] parameters = this.getParameters();
        if (this.isSuspend()) {
            return (ParameterElement[])ArrayUtils.concat((Object[])parameters, (Object[])new ParameterElement[]{this.continuationParameter});
        }
        return parameters;
    }

    @NonNull
    protected JavaParameterElement newParameterElement(@NonNull VariableElement variableElement, @NonNull AnnotationMetadata annotationMetadata) {
        return new JavaParameterElement(this.declaringClass, variableElement, annotationMetadata, this.visitorContext);
    }

    public ClassElement getDeclaringType() {
        if (this.resolvedDeclaringClass == null) {
            Element enclosingElement = this.executableElement.getEnclosingElement();
            if (enclosingElement instanceof TypeElement) {
                TypeElement te = (TypeElement)enclosingElement;
                this.resolvedDeclaringClass = this.declaringClass.getName().equals(te.getQualifiedName().toString()) ? this.declaringClass : new JavaClassElement(te, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(te), this.visitorContext, this.declaringClass.getGenericTypeInfo());
            } else {
                return this.declaringClass;
            }
        }
        return this.resolvedDeclaringClass;
    }

    public ClassElement getOwningType() {
        return this.declaringClass;
    }

    protected ClassElement returnType(Map<String, Map<String, TypeMirror>> info) {
        VariableElement varElement = (VariableElement)CollectionUtils.last(this.executableElement.getParameters());
        if (this.isSuspend(varElement)) {
            DeclaredType dType = (DeclaredType)varElement.asType();
            WildcardType wType = (WildcardType)dType.getTypeArguments().iterator().next();
            TypeMirror tm = wType.getSuperBound();
            if (tm instanceof DeclaredType && JavaMethodElement.sameType("kotlin.Unit", (DeclaredType)tm)) {
                return PrimitiveElement.VOID;
            }
            return this.mirrorToClassElement(tm, this.visitorContext, info, true);
        }
        TypeMirror returnType = this.executableElement.getReturnType();
        return this.mirrorToClassElement(returnType, this.visitorContext, info, true);
    }

    private static boolean sameType(String type, DeclaredType dt) {
        Element elt = dt.asElement();
        return elt instanceof TypeElement && type.equals(((TypeElement)elt).getQualifiedName().toString());
    }

    private boolean isSuspend(VariableElement ve) {
        if (ve != null && ve.asType() instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)ve.asType();
            return JavaMethodElement.sameType("kotlin.coroutines.Continuation", dt);
        }
        return false;
    }
}

