/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.JavaConfigurationMetadataBuilder;
import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.PublicAbstractMethodVisitor;
import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.aop.Adapter;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorBinding;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.BeanElementVisitor;
import io.micronaut.inject.visitor.VisitorConfiguration;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.BeanDefinitionReferenceWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.OriginatingElements;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner8;

@Internal
@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations"})
public class BeanDefinitionInjectProcessor
extends AbstractInjectAnnotationProcessor {
    private static final String AROUND_TYPE = "io.micronaut.aop.Around";
    private static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
    private static final String[] ANNOTATION_STEREOTYPES = new String[]{"javax.annotation.PostConstruct", "javax.annotation.PreDestroy", "jakarta.annotation.PreDestroy", "jakarta.annotation.PostConstruct", "javax.inject.Inject", "javax.inject.Qualifier", "javax.inject.Singleton", "jakarta.inject.Inject", "jakarta.inject.Qualifier", "jakarta.inject.Singleton", "io.micronaut.context.annotation.Bean", "io.micronaut.context.annotation.Replaces", "io.micronaut.context.annotation.Value", "io.micronaut.context.annotation.Property", "io.micronaut.context.annotation.Executable", "io.micronaut.aop.Around", "io.micronaut.aop.InterceptorBindingDefinitions", "io.micronaut.aop.InterceptorBinding", "io.micronaut.aop.Introduction"};
    private static final String ANN_CONSTRAINT = "javax.validation.Constraint";
    private static final String ANN_VALID = "javax.validation.Valid";
    private static final Predicate<AnnotationMetadata> IS_CONSTRAINT = am -> am.hasStereotype(ANN_CONSTRAINT) || am.hasStereotype(ANN_VALID);
    private static final String ANN_CONFIGURATION_ADVICE = "io.micronaut.runtime.context.env.ConfigurationAdvice";
    private static final String ANN_VALIDATED = "io.micronaut.validation.Validated";
    private JavaConfigurationMetadataBuilder metadataBuilder;
    private Set<String> beanDefinitions;
    private boolean processingOver;
    private final Set<String> processed = new HashSet<String>();

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.metadataBuilder = new JavaConfigurationMetadataBuilder(this.elementUtils, this.typeUtils, this.annotationUtils);
        ConfigurationMetadataBuilder.setConfigurationMetadataBuilder((ConfigurationMetadataBuilder)this.metadataBuilder);
        this.beanDefinitions = new LinkedHashSet<String>();
        for (BeanElementVisitor visitor : BeanElementVisitor.VISITORS) {
            if (!visitor.isEnabled()) continue;
            try {
                visitor.start((VisitorContext)this.javaVisitorContext);
            }
            catch (Exception e) {
                this.javaVisitorContext.fail("Error initializing bean element visitor [" + visitor.getClass().getName() + "]: " + e.getMessage(), null);
            }
        }
    }

    @Override
    @NonNull
    protected JavaVisitorContext newVisitorContext(@NonNull ProcessingEnvironment processingEnv) {
        return new JavaVisitorContext(processingEnv, this.messager, this.elementUtils, this.annotationUtils, this.typeUtils, this.modelUtils, this.genericUtils, this.filer, this.visitorAttributes, this.getVisitorKind()){

            @NonNull
            public VisitorConfiguration getConfiguration() {
                return new VisitorConfiguration(){

                    public boolean includeTypeLevelAnnotationsInGenericArguments() {
                        return false;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingOver = roundEnv.processingOver();
        if (!(annotations = annotations.stream().filter(ann -> {
            String name = ann.getQualifiedName().toString();
            String packageName = NameUtils.getPackageName((String)name);
            return !name.equals("kotlin.Metadata") && !AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName);
        }).filter(ann -> this.annotationUtils.hasStereotype((javax.lang.model.element.Element)ann, ANNOTATION_STEREOTYPES) || this.isProcessedAnnotation(ann.getQualifiedName().toString())).collect(Collectors.toSet())).isEmpty()) {
            TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
            TypeMirror typeMirror = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
            annotations.forEach(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().filter(element -> element.getKind() != ElementKind.ANNOTATION_TYPE).forEach(element -> {
                TypeElement typeElement = this.modelUtils.classElementFor((javax.lang.model.element.Element)element);
                if (typeElement == null) {
                    return;
                }
                if (element.getKind() == ElementKind.ENUM) {
                    AnnotationMetadata am = this.annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)element);
                    if (this.isDeclaredBeanInMetadata(am)) {
                        this.error((javax.lang.model.element.Element)element, "Enum types cannot be defined as beans", new Object[0]);
                    }
                    return;
                }
                if (groovyObjectType != null && this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType)) {
                    return;
                }
                String name = typeElement.getQualifiedName().toString();
                if (!(this.beanDefinitions.contains(name) || this.processed.contains(name) || name.endsWith("$Intercepted"))) {
                    boolean isInterface = JavaModelUtils.resolveKind((javax.lang.model.element.Element)typeElement, (ElementKind)ElementKind.INTERFACE).isPresent();
                    if (!isInterface) {
                        this.beanDefinitions.add(name);
                    } else if (this.annotationUtils.hasStereotype((javax.lang.model.element.Element)typeElement, INTRODUCTION_TYPE) || this.annotationUtils.hasStereotype((javax.lang.model.element.Element)typeElement, ConfigurationReader.class)) {
                        this.beanDefinitions.add(name);
                    }
                }
            }));
        }
        for (String string : this.processed) {
            this.beanDefinitions.remove(string);
        }
        int count = this.beanDefinitions.size();
        if (count > 0) {
            this.note("Creating bean classes for %s type elements", count);
            this.beanDefinitions.forEach(className -> {
                if (this.processed.add((String)className)) {
                    TypeElement refreshedClassElement = this.elementUtils.getTypeElement((CharSequence)className);
                    try {
                        AnnBeanElementVisitor visitor = new AnnBeanElementVisitor(refreshedClassElement);
                        refreshedClassElement.accept(visitor, className);
                        visitor.getBeanDefinitionWriters().forEach((name, writer) -> {
                            String beanDefinitionName = writer.getBeanDefinitionName();
                            if (this.processed.add(beanDefinitionName)) {
                                this.processBeanDefinitions((BeanDefinitionVisitor)writer);
                            }
                        });
                        AnnotationUtils.invalidateMetadata(refreshedClassElement);
                    }
                    catch (PostponeToNextRoundException e) {
                        this.processed.remove(className);
                    }
                }
            });
            AnnotationUtils.invalidateCache();
        }
        if (this.processingOver) {
            try {
                this.writeBeanDefinitionsToMetaInf();
                for (BeanElementVisitor visitor : BeanElementVisitor.VISITORS) {
                    if (!visitor.isEnabled()) continue;
                    try {
                        visitor.finish((VisitorContext)this.javaVisitorContext);
                    }
                    catch (Exception e) {
                        this.javaVisitorContext.fail("Error finalizing bean element visitor [" + visitor.getClass().getName() + "]: " + e.getMessage(), null);
                    }
                }
                List<AbstractBeanDefinitionBuilder> list = this.javaVisitorContext.getBeanElementBuilders();
                if (CollectionUtils.isNotEmpty(list)) {
                    try {
                        AbstractBeanDefinitionBuilder.writeBeanDefinitionBuilders((ClassWriterOutputVisitor)this.classWriterOutputVisitor, list);
                    }
                    catch (IOException e) {
                        String message = e.getMessage();
                        this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
                    }
                }
            }
            finally {
                AnnotationUtils.invalidateCache();
                AbstractAnnotationMetadataBuilder.clearMutated();
            }
        }
        return false;
    }

    private void writeBeanDefinitionsToMetaInf() {
        try {
            this.classWriterOutputVisitor.finish();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.error("Error occurred writing META-INF files: %s", message != null ? message : e);
        }
    }

    private void processBeanDefinitions(BeanDefinitionVisitor beanDefinitionWriter) {
        try {
            beanDefinitionWriter.visitBeanDefinitionEnd();
            if (beanDefinitionWriter.isEnabled()) {
                beanDefinitionWriter.accept((ClassWriterOutputVisitor)this.classWriterOutputVisitor);
                String beanTypeName = beanDefinitionWriter.getBeanTypeName();
                BeanDefinitionReferenceWriter beanDefinitionReferenceWriter = new BeanDefinitionReferenceWriter(beanTypeName, beanDefinitionWriter);
                beanDefinitionReferenceWriter.setRequiresMethodProcessing(beanDefinitionWriter.requiresMethodProcessing());
                String className = beanDefinitionReferenceWriter.getBeanDefinitionQualifiedClassName();
                this.processed.add(className);
                beanDefinitionReferenceWriter.setContextScope(beanDefinitionWriter.getAnnotationMetadata().hasDeclaredAnnotation(Context.class));
                beanDefinitionReferenceWriter.accept((ClassWriterOutputVisitor)this.classWriterOutputVisitor);
            }
        }
        catch (IOException e) {
            String message = e.getMessage();
            this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
        }
    }

    private String getPropertyMetadataTypeReference(TypeMirror valueType) {
        if (this.modelUtils.isOptional(valueType)) {
            return this.genericUtils.getFirstTypeArgument(valueType).map(typeMirror -> this.modelUtils.resolveTypeName((TypeMirror)typeMirror)).orElseGet(() -> this.modelUtils.resolveTypeName(valueType));
        }
        return this.modelUtils.resolveTypeName(valueType);
    }

    private AnnotationMetadata addPropertyMetadata(Element targetElement, PropertyMetadata propertyMetadata) {
        return targetElement.annotate(Property.class, builder -> builder.member("name", propertyMetadata.getPath())).getAnnotationMetadata();
    }

    private boolean isDeclaredBeanInMetadata(AnnotationMetadata concreteClassMetadata) {
        return concreteClassMetadata.hasDeclaredStereotype(Bean.class) || concreteClassMetadata.hasStereotype("javax.inject.Scope") || concreteClassMetadata.hasStereotype(DefaultScope.class);
    }

    static class DynamicName
    implements Name {
        private final CharSequence name;

        public DynamicName(CharSequence name) {
            this.name = name;
        }

        @Override
        public boolean contentEquals(CharSequence cs) {
            return this.name.equals(cs);
        }

        @Override
        public int length() {
            return this.name.length();
        }

        @Override
        public char charAt(int index) {
            return this.name.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.name.subSequence(start, end);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicName that = (DynamicName)o;
            return this.name.equals(that.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    class AnnBeanElementVisitor
    extends ElementScanner8<Object, Object> {
        private final TypeElement concreteClass;
        private final AnnotationMetadata concreteClassMetadata;
        private final Map<Name, BeanDefinitionVisitor> beanDefinitionWriters;
        private final boolean isConfigurationPropertiesType;
        private final boolean isFactoryType;
        private final boolean isExecutableType;
        private final boolean isAopProxyType;
        private final OptionalValues<Boolean> aopSettings;
        private final boolean isDeclaredBean;
        private final JavaElementFactory elementFactory;
        private final ClassElement concreteClassElement;
        private final MethodElement constructorElement;
        private final AnnotationMetadata constructorAnnotationMetadata;
        private ConfigurationMetadata configurationMetadata;
        private final AtomicInteger adaptedMethodIndex = new AtomicInteger(0);
        private final AtomicInteger factoryMethodIndex = new AtomicInteger(0);
        private AnnotationMetadata currentClassMetadata;
        private final Set<Name> visitedTypes = new HashSet<Name>();

        AnnBeanElementVisitor(TypeElement concreteClass) {
            this.concreteClass = concreteClass;
            this.currentClassMetadata = this.concreteClassMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(concreteClass);
            this.elementFactory = BeanDefinitionInjectProcessor.this.javaVisitorContext.getElementFactory();
            this.concreteClassElement = this.elementFactory.newClassElement(concreteClass, this.concreteClassMetadata);
            this.beanDefinitionWriters = new LinkedHashMap<Name, BeanDefinitionVisitor>();
            this.isFactoryType = this.concreteClassMetadata.hasStereotype(Factory.class);
            this.isConfigurationPropertiesType = this.concreteClassMetadata.hasDeclaredStereotype(ConfigurationReader.class) || this.concreteClassMetadata.hasDeclaredStereotype(EachProperty.class);
            this.isAopProxyType = !this.concreteClassElement.isAbstract() && !this.concreteClassElement.isAssignable(Interceptor.class) && this.hasAroundStereotype(this.concreteClassMetadata);
            this.aopSettings = this.isAopProxyType ? this.concreteClassMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class) : OptionalValues.empty();
            MethodElement constructorElement = this.constructorElement = (MethodElement)this.concreteClassElement.getPrimaryConstructor().orElse(null);
            if (constructorElement != null) {
                this.postponeIfParametersContainErrors((ExecutableElement)constructorElement.getNativeType());
            }
            this.constructorAnnotationMetadata = constructorElement != null ? constructorElement.getAnnotationMetadata() : AnnotationMetadata.EMPTY_METADATA;
            this.isExecutableType = this.isAopProxyType || this.concreteClassMetadata.hasStereotype(Executable.class);
            boolean hasQualifier = this.concreteClassMetadata.hasStereotype("javax.inject.Qualifier") && !this.concreteClassElement.isAbstract();
            this.isDeclaredBean = this.isDeclaredBean(constructorElement, hasQualifier);
        }

        private void postponeIfParametersContainErrors(ExecutableElement executableElement) {
            if (executableElement != null && !BeanDefinitionInjectProcessor.this.processingOver) {
                List<? extends VariableElement> parameters = executableElement.getParameters();
                for (VariableElement variableElement : parameters) {
                    TypeMirror typeMirror = variableElement.asType();
                    if (typeMirror.getKind() != TypeKind.ERROR) continue;
                    throw new PostponeToNextRoundException();
                }
            }
        }

        private boolean isDeclaredBean(@Nullable MethodElement constructor, boolean hasQualifier) {
            AnnotationMetadata concreteClassMetadata = this.concreteClassMetadata;
            return this.isExecutableType || BeanDefinitionInjectProcessor.this.isDeclaredBeanInMetadata(concreteClassMetadata) || constructor != null && constructor.hasStereotype("javax.inject.Inject") || hasQualifier;
        }

        Map<Name, BeanDefinitionVisitor> getBeanDefinitionWriters() {
            return this.beanDefinitionWriters;
        }

        @Override
        public Object visitType(TypeElement classElement, Object o) {
            AnnotationMetadata typeAnnotationMetadata;
            Name classElementQualifiedName = classElement.getQualifiedName();
            if ("java.lang.Record".equals(classElementQualifiedName.toString())) {
                return o;
            }
            if (this.visitedTypes.contains(classElementQualifiedName)) {
                return o;
            }
            boolean isInterface = this.concreteClassElement.isInterface();
            this.visitedTypes.add(classElementQualifiedName);
            this.currentClassMetadata = typeAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(classElement);
            if (this.isConfigurationPropertiesType) {
                this.configurationMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperties(this.concreteClass, this.concreteClassElement.getDocumentation().orElse(null));
                if (isInterface) {
                    this.currentClassMetadata = typeAnnotationMetadata = this.concreteClassElement.annotate(BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE).getAnnotationMetadata();
                }
            }
            Name qualifiedName = this.concreteClass.getQualifiedName();
            boolean isTypeConcreteClass = qualifiedName.equals(classElementQualifiedName);
            if (typeAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.INTRODUCTION_TYPE) && isTypeConcreteClass) {
                AopProxyWriter aopProxyWriter = this.createIntroductionAdviceWriter(this.concreteClassElement);
                if (this.constructorElement != null) {
                    aopProxyWriter.visitBeanDefinitionConstructor(this.constructorElement, this.concreteClassElement.isPrivate(), (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                } else {
                    aopProxyWriter.visitDefaultConstructor(this.concreteClassMetadata, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                }
                this.beanDefinitionWriters.put(classElementQualifiedName, (BeanDefinitionVisitor)aopProxyWriter);
                this.visitIntroductionAdviceInterface(classElement, typeAnnotationMetadata, aopProxyWriter);
                if (!isInterface) {
                    List elements = classElement.getEnclosedElements().stream().filter(element -> element.getKind() != ElementKind.CONSTRUCTOR).collect(Collectors.toList());
                    return this.scan(elements, o);
                }
                return null;
            }
            javax.lang.model.element.Element enclosingElement = classElement.getEnclosingElement();
            if (!JavaModelUtils.isClass((javax.lang.model.element.Element)enclosingElement) || isTypeConcreteClass) {
                if (isTypeConcreteClass) {
                    if (this.isDeclaredBean) {
                        PackageElement packageElement = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(classElement);
                        if (packageElement.isUnnamed()) {
                            BeanDefinitionInjectProcessor.this.error(classElement, "Micronaut beans cannot be in the default package", new Object[0]);
                            return null;
                        }
                        BeanDefinitionVisitor beanDefinitionWriter = this.getOrCreateBeanDefinitionWriter(classElement, qualifiedName);
                        if (this.isAopProxyType) {
                            if (BeanDefinitionInjectProcessor.this.modelUtils.isFinal(classElement)) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + classElement, new Object[0]);
                                return null;
                            }
                            io.micronaut.core.annotation.AnnotationValue[] interceptorTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)this.concreteClassMetadata, (InterceptorKind)InterceptorKind.AROUND);
                            this.resolveAopProxyWriter(beanDefinitionWriter, this.aopSettings, false, this.constructorElement, interceptorTypes);
                        }
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(classElement)) {
                        return null;
                    }
                }
                List elements = classElement.getEnclosedElements().stream().filter(element -> element.getKind() != ElementKind.CONSTRUCTOR).collect(Collectors.toList());
                if (this.isConfigurationPropertiesType) {
                    List<? extends javax.lang.model.element.Element> members = BeanDefinitionInjectProcessor.this.elementUtils.getAllMembers(classElement);
                    ElementFilter.fieldsIn(members).forEach(field -> {
                        if (classElement != field.getEnclosingElement()) {
                            AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getDeclaredAnnotationMetadata((javax.lang.model.element.Element)field);
                            boolean isConfigBuilder = fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class);
                            if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic((javax.lang.model.element.Element)field)) {
                                return;
                            }
                            if (!BeanDefinitionInjectProcessor.this.modelUtils.isFinal((javax.lang.model.element.Element)field) || isConfigBuilder) {
                                this.visitConfigurationProperty((VariableElement)field, fieldAnnotationMetadata);
                            }
                        }
                    });
                    ElementFilter.methodsIn(members).forEach(method -> {
                        javax.lang.model.element.Element e;
                        boolean isCandidateMethod;
                        boolean bl = isCandidateMethod = !BeanDefinitionInjectProcessor.this.modelUtils.isStatic((javax.lang.model.element.Element)method) && !BeanDefinitionInjectProcessor.this.modelUtils.isPrivate((javax.lang.model.element.Element)method) && !BeanDefinitionInjectProcessor.this.modelUtils.isAbstract((javax.lang.model.element.Element)method);
                        if (isCandidateMethod && (e = method.getEnclosingElement()) instanceof TypeElement && !e.equals(classElement)) {
                            BeanDefinitionVisitor writer;
                            String methodName = method.getSimpleName().toString();
                            if (method.getParameters().size() == 1 && NameUtils.isSetterName((String)methodName)) {
                                this.visitConfigurationPropertySetter((ExecutableElement)method);
                            } else if (NameUtils.isGetterName((String)methodName) && !(writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName())).isValidated()) {
                                writer.setValidated(IS_CONSTRAINT.test(BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)method)));
                            }
                        }
                    });
                } else {
                    TypeElement superClass = BeanDefinitionInjectProcessor.this.modelUtils.superClassFor(classElement);
                    if (superClass != null && !BeanDefinitionInjectProcessor.this.modelUtils.isObjectClass(superClass)) {
                        superClass.accept(this, o);
                    }
                }
                return this.scan(elements, o);
            }
            return null;
        }

        public BeanDefinitionVisitor getOrCreateBeanDefinitionWriter(TypeElement classElement, Name qualifiedName) {
            BeanDefinitionVisitor beanDefinitionWriter = this.beanDefinitionWriters.get(qualifiedName);
            if (beanDefinitionWriter == null) {
                beanDefinitionWriter = this.createBeanDefinitionWriterFor(classElement);
                DynamicName proxyKey = this.createProxyKey(beanDefinitionWriter.getBeanDefinitionName());
                this.beanDefinitionWriters.put(qualifiedName, beanDefinitionWriter);
                BeanDefinitionVisitor proxyWriter = this.beanDefinitionWriters.get(proxyKey);
                AnnotationMetadataHierarchy annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, this.constructorAnnotationMetadata});
                if (proxyWriter != null) {
                    if (this.constructorElement != null) {
                        proxyWriter.visitBeanDefinitionConstructor(this.constructorElement, this.constructorElement.isPrivate(), (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                    } else {
                        proxyWriter.visitDefaultConstructor((AnnotationMetadata)annotationMetadata, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                    }
                }
                if (this.constructorElement != null) {
                    beanDefinitionWriter.visitBeanDefinitionConstructor(this.constructorElement, this.constructorElement.isPrivate(), (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                } else {
                    beanDefinitionWriter.visitDefaultConstructor((AnnotationMetadata)annotationMetadata, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                }
            }
            return beanDefinitionWriter;
        }

        private void visitIntroductionAdviceInterface(final TypeElement classElement, final AnnotationMetadata typeAnnotationMetadata, AopProxyWriter aopProxyWriter) {
            JavaClassElement introductionType = this.elementFactory.newClassElement(classElement, typeAnnotationMetadata);
            AnnotationMetadata resolvedTypeMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(classElement);
            final boolean isAopProxyType = this.hasDeclaredAroundAdvice(resolvedTypeMetadata);
            boolean isConfigProps = typeAnnotationMetadata.hasAnnotation(BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE);
            if (isConfigProps) {
                BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperties(classElement, null);
            }
            classElement.asType().accept(new PublicAbstractMethodVisitor<Object, AopProxyWriter>(classElement, BeanDefinitionInjectProcessor.this.javaVisitorContext, (ClassElement)introductionType, isConfigProps){
                final /* synthetic */ ClassElement val$introductionType;
                final /* synthetic */ boolean val$isConfigProps;
                {
                    this.val$introductionType = classElement2;
                    this.val$isConfigProps = bl2;
                    super(classElement3, visitorContext);
                }

                @Override
                protected boolean isAcceptableMethod(ExecutableElement executableElement) {
                    return super.isAcceptableMethod(executableElement) || isAopProxyType || this.hasMethodLevelAdvice(executableElement);
                }

                private boolean hasMethodLevelAdvice(ExecutableElement executableElement) {
                    AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(executableElement);
                    return AnnBeanElementVisitor.this.hasDeclaredAroundAdvice(annotationMetadata);
                }

                @Override
                protected void accept(DeclaredType type, javax.lang.model.element.Element element, AopProxyWriter aopProxyWriter) {
                    ExecutableElement method = (ExecutableElement)element;
                    javax.lang.model.element.Element declaredTypeElement = type.asElement();
                    if (declaredTypeElement instanceof TypeElement) {
                        AnnotationMetadata annotationMetadata;
                        TypeElement owningType;
                        JavaClassElement declaringClassElement = AnnBeanElementVisitor.this.elementFactory.newClassElement((TypeElement)declaredTypeElement, AnnBeanElementVisitor.this.concreteClassMetadata);
                        if (!classElement.equals(declaredTypeElement)) {
                            aopProxyWriter.addOriginatingElement((Element)declaringClassElement);
                        }
                        if ((owningType = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method)) == null) {
                            throw new IllegalStateException("Owning type cannot be null");
                        }
                        JavaClassElement owningTypeElement = AnnBeanElementVisitor.this.elementFactory.newClassElement(owningType, typeAnnotationMetadata);
                        if (BeanDefinitionInjectProcessor.this.annotationUtils.isAnnotated(this.val$introductionType.getName(), method) || JavaAnnotationMetadataBuilder.hasAnnotation(method, Override.class)) {
                            annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(this.val$introductionType.getName(), classElement, method);
                            annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{typeAnnotationMetadata, annotationMetadata});
                        } else {
                            annotationMetadata = new AnnotationMetadataReference(aopProxyWriter.getBeanDefinitionName() + "$Reference", typeAnnotationMetadata);
                        }
                        JavaMethodElement javaMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement(this.val$introductionType, method, annotationMetadata);
                        String methodName = javaMethodElement.getName();
                        if (!annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_VALIDATED) && AnnBeanElementVisitor.this.isDeclaredBean && Arrays.stream(javaMethodElement.getParameters()).anyMatch(IS_CONSTRAINT)) {
                            annotationMetadata = javaMethodElement.annotate(BeanDefinitionInjectProcessor.ANN_VALIDATED).getAnnotationMetadata();
                        }
                        if (this.val$isConfigProps && javaMethodElement.isAbstract()) {
                            if (!aopProxyWriter.isValidated()) {
                                aopProxyWriter.setValidated(IS_CONSTRAINT.test(annotationMetadata));
                            }
                            if (!NameUtils.isGetterName((String)methodName)) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Only getter methods are allowed on @ConfigurationProperties interfaces: " + method, new Object[0]);
                                return;
                            }
                            if (javaMethodElement.hasParameters()) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Only zero argument getter methods are allowed on @ConfigurationProperties interfaces: " + method, new Object[0]);
                                return;
                            }
                            String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                            String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
                            String propertyType = javaMethodElement.getReturnType().getName();
                            if ("void".equals(propertyType)) {
                                BeanDefinitionInjectProcessor.this.error(classElement, "Getter methods must return a value @ConfigurationProperties interfaces: " + method, new Object[0]);
                                return;
                            }
                            PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(classElement, classElement, propertyType, propertyName, docComment, annotationMetadata.stringValue(Bindable.class, "defaultValue").orElse(null));
                            BeanDefinitionInjectProcessor.this.addPropertyMetadata(javaMethodElement, propertyMetadata);
                            annotationMetadata = javaMethodElement.annotate(BeanDefinitionInjectProcessor.ANN_CONFIGURATION_ADVICE, annBuilder -> {
                                if (!javaMethodElement.getReturnType().isPrimitive() && javaMethodElement.getReturnType().hasStereotype("javax.inject.Scope")) {
                                    annBuilder.member("bean", true);
                                }
                                if (typeAnnotationMetadata.hasStereotype(EachProperty.class)) {
                                    annBuilder.member("iterable", true);
                                }
                            }).getAnnotationMetadata();
                        }
                        if (annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) || annotationMetadata.hasStereotype("io.micronaut.aop.InterceptorBindingDefinitions")) {
                            io.micronaut.core.annotation.AnnotationValue[] interceptorTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)annotationMetadata, (InterceptorKind)InterceptorKind.AROUND);
                            aopProxyWriter.visitInterceptorBinding(interceptorTypes);
                        }
                        if (javaMethodElement.isAbstract()) {
                            aopProxyWriter.visitIntroductionMethod((TypedElement)owningTypeElement, (MethodElement)javaMethodElement);
                        } else {
                            boolean isInterface = declaringClassElement.isInterface();
                            boolean isDefault = method.isDefault();
                            if (isInterface && isDefault) {
                                owningTypeElement = this.val$introductionType;
                            }
                            aopProxyWriter.visitAroundMethod((TypedElement)owningTypeElement, (MethodElement)javaMethodElement);
                        }
                    }
                }
            }, aopProxyWriter);
        }

        @Override
        public Object visitExecutable(ExecutableElement method, Object o) {
            if (method.getKind() == ElementKind.CONSTRUCTOR) {
                BeanDefinitionInjectProcessor.this.error("Unexpected call to visitExecutable for ctor %s of %s", method.getSimpleName(), o);
                return null;
            }
            if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic(method) || BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(method)) {
                return null;
            }
            this.postponeIfParametersContainErrors(method);
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(method);
            AnnotationMetadata methodAnnotationMetadata = this.getMetadataHierarchy(annotationMetadata);
            TypeKind returnKind = method.getReturnType().getKind();
            if (returnKind == TypeKind.ERROR && !BeanDefinitionInjectProcessor.this.processingOver) {
                throw new PostponeToNextRoundException();
            }
            JavaMethodElement javaMethodElement = this.elementFactory.newMethodElement(this.concreteClassElement, method, methodAnnotationMetadata);
            if (this.isFactoryType && javaMethodElement.hasDeclaredStereotype(new String[]{Bean.class.getName(), "javax.inject.Scope"}) && !javaMethodElement.getReturnType().isPrimitive()) {
                if (!BeanDefinitionInjectProcessor.this.modelUtils.overridingOrHidingMethod(method, this.concreteClass, true).isPresent()) {
                    this.visitBeanFactoryElement(method);
                }
                return null;
            }
            boolean injected = methodAnnotationMetadata.hasDeclaredStereotype("javax.inject.Inject");
            boolean postConstruct = methodAnnotationMetadata.hasDeclaredAnnotation("javax.annotation.PostConstruct");
            boolean preDestroy = methodAnnotationMetadata.hasDeclaredAnnotation("javax.annotation.PreDestroy");
            if (injected || postConstruct || preDestroy || methodAnnotationMetadata.hasDeclaredStereotype(ConfigurationInject.class)) {
                if (this.isDeclaredBean) {
                    this.visitAnnotatedMethod(javaMethodElement, method, o);
                } else if (injected) {
                    this.visitAnnotatedMethod(javaMethodElement, method, o);
                }
                return null;
            }
            boolean isAbstract = javaMethodElement.isAbstract();
            boolean isPrivate = javaMethodElement.isPrivate();
            boolean isStatic = javaMethodElement.isStatic();
            boolean isPublic = javaMethodElement.isPublic();
            boolean isInternal = methodAnnotationMetadata.hasAnnotation(Internal.class);
            boolean hasInvalidModifiers = isAbstract || isStatic || isPrivate || isInternal;
            Set<Modifier> modifiers = method.getModifiers();
            boolean isExecutable = this.isExecutableThroughType(method.getEnclosingElement(), methodAnnotationMetadata, annotationMetadata, modifiers, isPublic) || this.hasAroundStereotype(annotationMetadata);
            boolean hasConstraints = false;
            if (this.isDeclaredBean && !methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.ANN_VALIDATED) && Arrays.stream(javaMethodElement.getParameters()).anyMatch(p -> p.hasStereotype(BeanDefinitionInjectProcessor.ANN_CONSTRAINT) || p.hasStereotype(BeanDefinitionInjectProcessor.ANN_VALID))) {
                hasConstraints = true;
                methodAnnotationMetadata = javaMethodElement.annotate(BeanDefinitionInjectProcessor.ANN_VALIDATED);
            }
            if (this.isDeclaredBean && isExecutable) {
                if (hasInvalidModifiers) {
                    if (isPrivate) {
                        BeanDefinitionInjectProcessor.this.error(method, "Method annotated as executable but is declared private. Change the method to be non-private in order for AOP advice to be applied.", new Object[0]);
                    }
                } else {
                    this.visitExecutableMethod(javaMethodElement, method, methodAnnotationMetadata);
                }
            } else if (this.isConfigurationPropertiesType && !BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(method) && !BeanDefinitionInjectProcessor.this.modelUtils.isStatic(method)) {
                BeanDefinitionVisitor writer;
                String methodName = javaMethodElement.getSimpleName();
                if (NameUtils.isSetterName((String)methodName) && javaMethodElement.getParameters().length == 1) {
                    this.visitConfigurationPropertySetter(method);
                } else if (NameUtils.isGetterName((String)methodName) && !(writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName())).isValidated()) {
                    writer.setValidated(IS_CONSTRAINT.test(methodAnnotationMetadata));
                }
            } else if (hasConstraints) {
                if (hasInvalidModifiers) {
                    if (isPrivate) {
                        BeanDefinitionInjectProcessor.this.error(method, "Method annotated with constraints but is declared private. Change the method to be non-private in order for AOP advice to be applied.", new Object[0]);
                    }
                } else if (isPublic) {
                    this.visitExecutableMethod(javaMethodElement, method, methodAnnotationMetadata);
                }
            }
            return null;
        }

        @NonNull
        private AnnotationMetadata getMetadataHierarchy(AnnotationMetadata annotationMetadata) {
            Object methodAnnotationMetadata = annotationMetadata instanceof AnnotationMetadataHierarchy ? annotationMetadata : new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, annotationMetadata});
            return methodAnnotationMetadata;
        }

        private boolean hasAroundStereotype(AnnotationMetadata annotationMetadata) {
            if (annotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                return true;
            }
            if (annotationMetadata.hasStereotype("io.micronaut.aop.InterceptorBindingDefinitions")) {
                return annotationMetadata.getAnnotationValuesByType(InterceptorBinding.class).stream().anyMatch(av -> av.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND) == InterceptorKind.AROUND);
            }
            return false;
        }

        private boolean isExecutableThroughType(javax.lang.model.element.Element enclosingElement, AnnotationMetadata annotationMetadataHierarchy, AnnotationMetadata declaredMetadata, Set<Modifier> modifiers, boolean isPublic) {
            return this.isExecutableType && (isPublic || modifiers.isEmpty() && this.concreteClass.equals(enclosingElement)) || annotationMetadataHierarchy.hasDeclaredStereotype(Executable.class) || declaredMetadata.hasStereotype(Executable.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitConfigurationPropertySetter(ExecutableElement method) {
            BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
            VariableElement parameter = method.getParameters().get(0);
            TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
            if (declaringClass != null) {
                AnnotationMetadata methodAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getDeclaredAnnotationMetadata(method);
                JavaClassElement javaClassElement = this.elementFactory.newClassElement(declaringClass, methodAnnotationMetadata);
                JavaMethodElement javaMethodElement = this.elementFactory.newMethodElement((ClassElement)javaClassElement, method, methodAnnotationMetadata);
                ParameterElement parameterElement = javaMethodElement.getParameters()[0];
                String propertyName = NameUtils.getPropertyNameForSetter((String)method.getSimpleName().toString());
                boolean isInterface = parameterElement.getType().isInterface();
                if (methodAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                    writer.visitConfigBuilderMethod(parameterElement.getType(), NameUtils.getterNameFor((String)propertyName), methodAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, isInterface);
                    try {
                        this.visitConfigurationBuilder(declaringClass, method, parameter.asType(), writer);
                    }
                    finally {
                        writer.visitConfigBuilderEnd();
                    }
                } else {
                    if (this.shouldExclude(this.configurationMetadata, propertyName)) {
                        return;
                    }
                    String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                    PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, parameterElement.getGenericType().getCanonicalName(), propertyName, docComment, null);
                    BeanDefinitionInjectProcessor.this.addPropertyMetadata(javaMethodElement, propertyMetadata);
                    boolean requiresReflection = true;
                    if (javaMethodElement.isPublic()) {
                        requiresReflection = false;
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isPackagePrivate(method) || javaMethodElement.isProtected()) {
                        String concretePackage;
                        String declaringPackage = javaClassElement.getPackageName();
                        requiresReflection = !declaringPackage.equals(concretePackage = this.concreteClassElement.getPackageName());
                    }
                    writer.visitSetterValue((TypedElement)javaClassElement, (MethodElement)javaMethodElement, requiresReflection, true);
                }
            }
        }

        void visitBeanFactoryElement(javax.lang.model.element.Element element) {
            ClassElement producedClassElement;
            AbstractJavaElement beanProducingElement;
            TypeMirror producedType = element instanceof ExecutableElement ? ((ExecutableElement)element).getReturnType() : element.asType();
            final TypeElement producedTypeElement = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(BeanDefinitionInjectProcessor.this.typeUtils.asElement(producedType));
            TypeElement factoryTypeElement = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(element);
            if (producedType.getKind().isPrimitive()) {
                BeanDefinitionInjectProcessor.this.error(element, "Produced type from a bean factory cannot be primitive", new Object[0]);
                return;
            }
            if (producedTypeElement == null || factoryTypeElement == null) {
                return;
            }
            final String producedTypeName = producedTypeElement.getQualifiedName().toString();
            JavaClassElement declaringClassElement = this.elementFactory.newClassElement(factoryTypeElement, this.concreteClassMetadata);
            final AnnotationMetadata methodAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(producedTypeElement, element);
            if (element instanceof ExecutableElement) {
                ExecutableElement executableElement = (ExecutableElement)element;
                JavaMethodElement methodElement = this.elementFactory.newMethodElement((ClassElement)declaringClassElement, executableElement, methodAnnotationMetadata);
                if (this.isFactoryType && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((javax.lang.model.element.Element)this.concreteClass, BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                    JavaMethodElement aopMethod = this.elementFactory.newMethodElement((ClassElement)declaringClassElement, executableElement, this.getMetadataHierarchy(methodAnnotationMetadata));
                    this.visitExecutableMethod(aopMethod, executableElement, methodAnnotationMetadata);
                }
                beanProducingElement = methodElement;
                producedClassElement = methodElement.getGenericReturnType();
            } else {
                JavaFieldElement fieldElement;
                beanProducingElement = fieldElement = this.elementFactory.newFieldElement((ClassElement)declaringClassElement, (VariableElement)element, methodAnnotationMetadata);
                producedClassElement = fieldElement.getGenericField();
            }
            final BeanDefinitionWriter beanMethodWriter = this.createFactoryBeanMethodWriterFor(element, producedTypeElement);
            Map allTypeArguments = producedClassElement.getAllTypeArguments();
            beanMethodWriter.visitTypeArguments(allTypeArguments);
            this.beanDefinitionWriters.put(new DynamicName(beanProducingElement.getDescription(false)), (BeanDefinitionVisitor)beanMethodWriter);
            if (beanProducingElement instanceof MethodElement) {
                beanMethodWriter.visitBeanFactoryMethod(this.concreteClassElement, (MethodElement)beanProducingElement);
            } else {
                beanMethodWriter.visitBeanFactoryField(this.concreteClassElement, (FieldElement)beanProducingElement);
            }
            if (methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) && !BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(this.concreteClass)) {
                io.micronaut.core.annotation.AnnotationValue[] interceptorTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)methodAnnotationMetadata, (InterceptorKind)InterceptorKind.AROUND);
                if (producedClassElement.isFinal()) {
                    javax.lang.model.element.Element nativeElement = (javax.lang.model.element.Element)producedClassElement.getNativeType();
                    BeanDefinitionInjectProcessor.this.error(nativeElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + nativeElement, new Object[0]);
                    return;
                }
                MethodElement constructor = producedClassElement.getPrimaryConstructor().orElse(null);
                if (!producedClassElement.isInterface() && constructor != null && constructor.getParameters().length > 0) {
                    javax.lang.model.element.Element nativeElement = (javax.lang.model.element.Element)constructor.getNativeType();
                    String proxyTargetMode = methodAnnotationMetadata.stringValue(BeanDefinitionInjectProcessor.AROUND_TYPE, "proxyTargetMode").orElseGet(() -> {
                        if (methodAnnotationMetadata.hasAnnotation("io.micronaut.test.annotation.MockBean")) {
                            return "WARN";
                        }
                        return "ERROR";
                    });
                    switch (proxyTargetMode) {
                        case "ALLOW": {
                            this.allowProxyConstruction(constructor);
                            break;
                        }
                        case "WARN": {
                            this.allowProxyConstruction(constructor);
                            BeanDefinitionInjectProcessor.this.warning(element, "The produced type of a @Factory method has constructor arguments and is proxied. This can lead to unexpected behaviour. See the javadoc for Around.ProxyTargetConstructorMode for more information: " + element, new Object[0]);
                            break;
                        }
                        default: {
                            BeanDefinitionInjectProcessor.this.error(element, "The produced type from a factory which has AOP proxy advice specified must define an accessible no arguments constructor. Proxying types with constructor arguments can lead to unexpected behaviour. See the javadoc for for Around.ProxyTargetConstructorMode for more information and possible solutions: " + element, new Object[0]);
                            return;
                        }
                    }
                }
                OptionalValues aopSettings = methodAnnotationMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class);
                LinkedHashMap<CharSequence, Boolean> finalSettings = new LinkedHashMap<CharSequence, Boolean>();
                for (CharSequence setting : aopSettings) {
                    Optional entry = aopSettings.get(setting);
                    entry.ifPresent(val -> finalSettings.put(setting, (Boolean)val));
                }
                finalSettings.put(Interceptor.PROXY_TARGET, true);
                AopProxyWriter proxyWriter = this.resolveAopProxyWriter((BeanDefinitionVisitor)beanMethodWriter, (OptionalValues<Boolean>)OptionalValues.of(Boolean.class, finalSettings), true, constructor, interceptorTypes);
                proxyWriter.visitTypeArguments(allTypeArguments);
                producedType.accept(new PublicMethodVisitor<Object, AopProxyWriter>(BeanDefinitionInjectProcessor.this.javaVisitorContext){

                    @Override
                    protected void accept(DeclaredType type, javax.lang.model.element.Element element, AopProxyWriter aopProxyWriter) {
                        ExecutableElement method = (ExecutableElement)element;
                        TypeElement owningType = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
                        JavaClassElement declaringClassElement = AnnBeanElementVisitor.this.elementFactory.newClassElement(owningType, AnnBeanElementVisitor.this.concreteClassMetadata);
                        Object annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.isAnnotated(producedTypeName, method) ? BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(element, method) : new AnnotationMetadataReference(beanMethodWriter.getBeanDefinitionName() + "$Reference", methodAnnotationMetadata);
                        JavaMethodElement advisedMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement((ClassElement)declaringClassElement, method, (AnnotationMetadata)annotationMetadata);
                        aopProxyWriter.visitAroundMethod((TypedElement)declaringClassElement, (MethodElement)advisedMethodElement);
                    }
                }, proxyWriter);
            } else if (methodAnnotationMetadata.hasStereotype(Executable.class)) {
                DeclaredType dt = (DeclaredType)producedType;
                final Map<String, Map<String, TypeMirror>> finalBeanTypeArgumentsMirrors = BeanDefinitionInjectProcessor.this.genericUtils.buildGenericTypeArgumentElementInfo(dt.asElement(), dt, Collections.emptyMap());
                producedType.accept(new PublicMethodVisitor<Object, BeanDefinitionWriter>(BeanDefinitionInjectProcessor.this.javaVisitorContext){

                    @Override
                    protected void accept(DeclaredType type, javax.lang.model.element.Element element, BeanDefinitionWriter beanWriter) {
                        ExecutableElement method = (ExecutableElement)element;
                        TypeElement owningType = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
                        if (owningType == null) {
                            throw new IllegalStateException("Owning type cannot be null");
                        }
                        AnnotationMetadataReference annotationMetadata = new AnnotationMetadataReference(beanMethodWriter.getBeanDefinitionName() + "$Reference", methodAnnotationMetadata);
                        JavaClassElement declaringClassElement = AnnBeanElementVisitor.this.elementFactory.newClassElement(producedTypeElement, AnnBeanElementVisitor.this.concreteClassMetadata);
                        JavaMethodElement executableMethod = AnnBeanElementVisitor.this.elementFactory.newMethodElement((ClassElement)declaringClassElement, method, (AnnotationMetadata)annotationMetadata, finalBeanTypeArgumentsMirrors);
                        beanMethodWriter.visitExecutableMethod((TypedElement)declaringClassElement, (MethodElement)executableMethod, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                    }
                }, beanMethodWriter);
            }
            if (methodAnnotationMetadata.isPresent(Bean.class, "preDestroy")) {
                Optional preDestroyMethod = methodAnnotationMetadata.getValue(Bean.class, "preDestroy", String.class);
                preDestroyMethod.ifPresent(destroyMethodName -> {
                    if (StringUtils.isNotEmpty((CharSequence)destroyMethodName)) {
                        TypeElement destroyMethodDeclaringClass = (TypeElement)BeanDefinitionInjectProcessor.this.typeUtils.asElement(producedType);
                        JavaClassElement destroyMethodDeclaringElement = this.elementFactory.newClassElement(destroyMethodDeclaringClass, AnnotationMetadata.EMPTY_METADATA);
                        Optional destroyMethod = destroyMethodDeclaringElement.getEnclosedElement(ElementQuery.ALL_METHODS.onlyAccessible(this.concreteClassElement).onlyInstance().named(name -> name.equals(destroyMethodName)).filter(e -> !e.hasParameters()));
                        if (destroyMethod.isPresent()) {
                            MethodElement destroyMethodElement = (MethodElement)destroyMethod.get();
                            beanMethodWriter.visitPreDestroyMethod((TypedElement)destroyMethodDeclaringElement, destroyMethodElement, false, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                        } else {
                            BeanDefinitionInjectProcessor.this.error(element, "@Bean method defines a preDestroy method that does not exist or is not public: " + destroyMethodName, new Object[0]);
                        }
                    }
                });
            }
        }

        private void allowProxyConstruction(MethodElement constructor) {
            ParameterElement[] parameters;
            for (ParameterElement parameter : parameters = constructor.getParameters()) {
                if (parameter.isPrimitive() && !parameter.isArray()) {
                    String name = parameter.getType().getName();
                    if ("boolean".equals(name)) {
                        parameter.annotate(Value.class, builder -> builder.value(false));
                        continue;
                    }
                    parameter.annotate(Value.class, builder -> builder.value(0));
                    continue;
                }
                parameter.annotate("javax.annotation.Nullable");
                parameter.removeAnnotation("javax.annotation.Nonnull");
            }
        }

        void visitExecutableMethod(MethodElement javaMethodElement, ExecutableElement method, AnnotationMetadata methodAnnotationMetadata) {
            TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(method);
            if (declaringClass == null || BeanDefinitionInjectProcessor.this.modelUtils.isObjectClass(declaringClass)) {
                return;
            }
            boolean isOwningClass = declaringClass.getQualifiedName().equals(this.concreteClass.getQualifiedName());
            if (isOwningClass && BeanDefinitionInjectProcessor.this.modelUtils.isAbstract(this.concreteClass) && !this.concreteClassMetadata.hasStereotype(BeanDefinitionInjectProcessor.INTRODUCTION_TYPE)) {
                return;
            }
            if (!isOwningClass && BeanDefinitionInjectProcessor.this.modelUtils.overridingOrHidingMethod(method, this.concreteClass, true).isPresent()) {
                return;
            }
            JavaClassElement declaringClassElement = this.elementFactory.newClassElement(declaringClass, this.concreteClassMetadata);
            BeanDefinitionVisitor beanWriter = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
            boolean preprocess = methodAnnotationMetadata.isTrue(Executable.class, "processOnStartup");
            if (preprocess) {
                beanWriter.setRequiresMethodProcessing(true);
            }
            if (methodAnnotationMetadata.hasStereotype(Adapter.class)) {
                this.visitAdaptedMethod(method, methodAnnotationMetadata);
            }
            boolean executableMethodVisited = false;
            if (!(beanWriter instanceof AopProxyWriter)) {
                boolean isPublic;
                boolean isConcrete = !this.concreteClassElement.isAbstract();
                boolean bl = isPublic = javaMethodElement.isPublic() || javaMethodElement.isPackagePrivate();
                if (this.isAopProxyType && isPublic || !this.isAopProxyType && methodAnnotationMetadata.hasStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE) || this.hasDeclaredAroundAdvice(methodAnnotationMetadata) && isConcrete) {
                    io.micronaut.core.annotation.AnnotationValue[] interceptorTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)methodAnnotationMetadata, (InterceptorKind)InterceptorKind.AROUND);
                    OptionalValues settings = methodAnnotationMetadata.getValues(BeanDefinitionInjectProcessor.AROUND_TYPE, Boolean.class);
                    AopProxyWriter aopProxyWriter = this.resolveAopProxyWriter(beanWriter, (OptionalValues<Boolean>)settings, false, this.constructorElement, interceptorTypes);
                    aopProxyWriter.visitInterceptorBinding(interceptorTypes);
                    if (javaMethodElement.isFinal()) {
                        if (this.hasDeclaredAroundAdvice(methodAnnotationMetadata)) {
                            BeanDefinitionInjectProcessor.this.error(method, "Method defines AOP advice but is declared final. Change the method to be non-final in order for AOP advice to be applied.", new Object[0]);
                        } else if (this.isAopProxyType && isPublic && !declaringClass.equals(this.concreteClass)) {
                            this.addOriginatingElementIfNecessary(beanWriter, declaringClass);
                            beanWriter.visitExecutableMethod((TypedElement)declaringClassElement, javaMethodElement, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                            executableMethodVisited = true;
                        } else {
                            BeanDefinitionInjectProcessor.this.error(method, "Public method inherits AOP advice but is declared final. Either make the method non-public or apply AOP advice only to public methods declared on the class.", new Object[0]);
                        }
                    } else {
                        this.addOriginatingElementIfNecessary(beanWriter, declaringClass);
                        aopProxyWriter.visitAroundMethod((TypedElement)declaringClassElement, javaMethodElement);
                        executableMethodVisited = true;
                    }
                }
            }
            if (!executableMethodVisited) {
                this.addOriginatingElementIfNecessary(beanWriter, declaringClass);
                beanWriter.visitExecutableMethod((TypedElement)declaringClassElement, javaMethodElement, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
            }
        }

        private boolean hasDeclaredAroundAdvice(AnnotationMetadata annotationMetadata) {
            if (annotationMetadata.hasDeclaredStereotype(BeanDefinitionInjectProcessor.AROUND_TYPE)) {
                return true;
            }
            if (annotationMetadata.hasDeclaredStereotype("io.micronaut.aop.InterceptorBindingDefinitions")) {
                return annotationMetadata.getDeclaredAnnotationValuesByType(InterceptorBinding.class).stream().anyMatch(av -> av.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND) == InterceptorKind.AROUND);
            }
            return false;
        }

        private void visitAdaptedMethod(final ExecutableElement sourceMethod, AnnotationMetadata methodAnnotationMetadata) {
            TypeElement typeElement;
            boolean isInterface;
            Optional targetType;
            if (methodAnnotationMetadata instanceof AnnotationMetadataHierarchy) {
                methodAnnotationMetadata = ((AnnotationMetadataHierarchy)methodAnnotationMetadata).getDeclaredMetadata();
            }
            if ((targetType = methodAnnotationMetadata.getValue(Adapter.class, String.class).flatMap(s -> Optional.ofNullable(BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement((CharSequence)s)))).isPresent() && (isInterface = JavaModelUtils.isInterface((javax.lang.model.element.Element)(typeElement = (TypeElement)targetType.get())))) {
                JavaClassElement typeToImplementElement = this.elementFactory.newClassElement(typeElement, BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(typeElement));
                final DeclaredType typeToImplement = (DeclaredType)typeElement.asType();
                String packageName = this.concreteClassElement.getPackageName();
                String declaringClassSimpleName = this.concreteClassElement.getSimpleName();
                String beanClassName = this.generateAdaptedMethodClassName(sourceMethod, typeElement, declaringClassSimpleName);
                JavaMethodElement sourceMethodElement = this.elementFactory.newMethodElement(this.concreteClassElement, sourceMethod, methodAnnotationMetadata);
                AopProxyWriter aopProxyWriter = new AopProxyWriter(packageName, beanClassName, true, false, (Element)sourceMethodElement, (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, methodAnnotationMetadata}), new ClassElement[]{typeToImplementElement}, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, null, new io.micronaut.core.annotation.AnnotationValue[0]);
                aopProxyWriter.visitDefaultConstructor(methodAnnotationMetadata, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                this.beanDefinitionWriters.put(BeanDefinitionInjectProcessor.this.elementUtils.getName(packageName + '.' + beanClassName), (BeanDefinitionVisitor)aopProxyWriter);
                Map typeVariables = typeToImplementElement.getTypeArguments();
                AnnotationMetadata finalMethodAnnotationMetadata = methodAnnotationMetadata;
                typeToImplement.accept(new PublicAbstractMethodVisitor<Object, AopProxyWriter>(typeElement, BeanDefinitionInjectProcessor.this.javaVisitorContext, (ClassElement)typeToImplementElement, (MethodElement)sourceMethodElement, typeVariables, typeElement, finalMethodAnnotationMetadata){
                    boolean first;
                    final /* synthetic */ ClassElement val$typeToImplementElement;
                    final /* synthetic */ MethodElement val$sourceMethodElement;
                    final /* synthetic */ Map val$typeVariables;
                    final /* synthetic */ TypeElement val$typeElement;
                    final /* synthetic */ AnnotationMetadata val$finalMethodAnnotationMetadata;
                    {
                        this.val$typeToImplementElement = classElement2;
                        this.val$sourceMethodElement = methodElement;
                        this.val$typeVariables = map;
                        this.val$typeElement = typeElement;
                        this.val$finalMethodAnnotationMetadata = annotationMetadata;
                        super(classElement, visitorContext);
                        this.first = true;
                    }

                    @Override
                    protected void accept(DeclaredType type, javax.lang.model.element.Element element, AopProxyWriter aopProxyWriter) {
                        if (!this.first) {
                            BeanDefinitionInjectProcessor.this.error(sourceMethod, "Interface to adapt [" + typeToImplement + "] is not a SAM type. More than one abstract method declared.", new Object[0]);
                            return;
                        }
                        this.first = false;
                        ExecutableElement targetMethod = (ExecutableElement)element;
                        JavaMethodElement targetMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement(this.val$typeToImplementElement, targetMethod, BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(targetMethod));
                        ParameterElement[] sourceParams = this.val$sourceMethodElement.getParameters();
                        ParameterElement[] targetParams = targetMethodElement.getParameters();
                        List<? extends VariableElement> targetParameters = targetMethod.getParameters();
                        int paramLen = targetParameters.size();
                        if (paramLen == sourceParams.length) {
                            if (this.val$sourceMethodElement.isSuspend()) {
                                BeanDefinitionInjectProcessor.this.error(sourceMethod, "Cannot adapt method [" + sourceMethod + "] to target method [" + targetMethod + "]. Kotlin suspend method not supported here.", new Object[0]);
                                return;
                            }
                            LinkedHashMap<String, ClassElement> genericTypes = new LinkedHashMap<String, ClassElement>(paramLen);
                            for (int i = 0; i < paramLen; ++i) {
                                TypeVariable tv;
                                String variableName;
                                TypeMirror targetMirror = targetParameters.get(i).asType();
                                ClassElement targetType = targetParams[i].getGenericType();
                                ClassElement sourceType = sourceParams[i].getGenericType();
                                if (targetMirror.getKind() == TypeKind.TYPEVAR && this.val$typeVariables.containsKey(variableName = (tv = (TypeVariable)targetMirror).toString())) {
                                    genericTypes.put(variableName, sourceType);
                                }
                                if (sourceType.isAssignable(targetType.getName())) continue;
                                BeanDefinitionInjectProcessor.this.error(sourceMethod, "Cannot adapt method [" + sourceMethod + "] to target method [" + targetMethod + "]. Type [" + sourceType.getName() + "] is not a subtype of type [" + targetType.getName() + "] for argument at position " + i, new Object[0]);
                                return;
                            }
                            if (!genericTypes.isEmpty()) {
                                Map typeData = Collections.singletonMap(this.val$typeToImplementElement.getName(), genericTypes);
                                aopProxyWriter.visitTypeArguments(typeData);
                            }
                            JavaClassElement declaringClassElement = AnnBeanElementVisitor.this.elementFactory.newClassElement(this.val$typeElement, this.val$finalMethodAnnotationMetadata);
                            AnnotationClassValue[] adaptedArgumentTypes = new AnnotationClassValue[paramLen];
                            for (int i = 0; i < adaptedArgumentTypes.length; ++i) {
                                ParameterElement parameterElement = sourceParams[i];
                                ClassElement genericType = parameterElement.getGenericType();
                                adaptedArgumentTypes[i] = new AnnotationClassValue(JavaModelUtils.getClassname((TypedElement)genericType));
                            }
                            JavaMethodElement javaMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement(AnnBeanElementVisitor.this.concreteClassElement, targetMethod, this.val$finalMethodAnnotationMetadata);
                            javaMethodElement.annotate(Adapter.class, builder -> {
                                AnnotationClassValue acv = new AnnotationClassValue(AnnBeanElementVisitor.this.concreteClassElement.getName());
                                builder.member("adaptedBean", new AnnotationClassValue[]{acv});
                                builder.member("adaptedMethod", this.val$sourceMethodElement.getName());
                                builder.member("adaptedArgumentTypes", adaptedArgumentTypes);
                                String qualifier = AnnBeanElementVisitor.this.concreteClassMetadata.stringValue("javax.inject.Named").orElse(null);
                                if (StringUtils.isNotEmpty((CharSequence)qualifier)) {
                                    builder.member("adaptedQualifier", qualifier);
                                }
                            });
                            aopProxyWriter.visitAroundMethod((TypedElement)declaringClassElement, (MethodElement)javaMethodElement);
                        } else {
                            BeanDefinitionInjectProcessor.this.error(sourceMethod, "Cannot adapt method [" + sourceMethod + "] to target method [" + targetMethod + "]. Argument lengths don't match.", new Object[0]);
                        }
                    }
                }, aopProxyWriter);
            }
        }

        private String generateAdaptedMethodClassName(ExecutableElement method, TypeElement typeElement, String declaringClassSimpleName) {
            String rootName = declaringClassSimpleName + '$' + typeElement.getSimpleName().toString() + '$' + method.getSimpleName().toString();
            return rootName + this.adaptedMethodIndex.incrementAndGet();
        }

        private AopProxyWriter resolveAopProxyWriter(BeanDefinitionVisitor beanWriter, OptionalValues<Boolean> aopSettings, boolean isFactoryType, MethodElement constructorElement, io.micronaut.core.annotation.AnnotationValue<?> ... interceptorBinding) {
            AopProxyWriter aopProxyWriter;
            BeanDefinitionVisitor aopWriter;
            String beanName = beanWriter.getBeanDefinitionName();
            DynamicName proxyKey = this.createProxyKey(beanName);
            BeanDefinitionVisitor beanDefinitionVisitor = aopWriter = beanWriter instanceof AopProxyWriter ? beanWriter : this.beanDefinitionWriters.get(proxyKey);
            if (aopWriter == null) {
                aopProxyWriter = new AopProxyWriter((BeanDefinitionWriter)beanWriter, aopSettings, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext, interceptorBinding);
                if (constructorElement != null) {
                    aopProxyWriter.visitBeanDefinitionConstructor(constructorElement, constructorElement.isPrivate(), (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                } else {
                    aopProxyWriter.visitDefaultConstructor(AnnotationMetadata.EMPTY_METADATA, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
                }
                if (isFactoryType) {
                    aopProxyWriter.visitSuperBeanDefinitionFactory(beanName);
                } else {
                    aopProxyWriter.visitSuperBeanDefinition(beanName);
                }
                aopWriter = aopProxyWriter;
                this.beanDefinitionWriters.put(proxyKey, aopWriter);
            } else {
                aopProxyWriter = (AopProxyWriter)aopWriter;
            }
            return aopProxyWriter;
        }

        void visitAnnotatedMethod(MethodElement javaMethodElement, ExecutableElement method, Object o) {
            boolean overriddenInjected;
            ClassElement declaringClass = javaMethodElement.getDeclaringType();
            boolean isParent = !declaringClass.getName().equals(this.concreteClassElement.getName());
            ExecutableElement overridingMethod = BeanDefinitionInjectProcessor.this.modelUtils.overridingOrHidingMethod(method, this.concreteClass, false).orElse(method);
            TypeElement overridingClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(overridingMethod);
            boolean overridden = isParent && overridingClass != null && !overridingClass.getQualifiedName().toString().equals(declaringClass.getName());
            boolean isPackagePrivate = javaMethodElement.isPackagePrivate();
            boolean isPrivate = javaMethodElement.isPrivate();
            if (overridden && !isPrivate && !isPackagePrivate) {
                return;
            }
            String packageOfOverridingClass = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(overridingMethod).getQualifiedName().toString();
            String packageOfDeclaringClass = declaringClass.getPackageName();
            boolean isPackagePrivateAndPackagesDiffer = overridden && isPackagePrivate && !packageOfOverridingClass.equals(packageOfDeclaringClass);
            boolean requiresReflection = isPrivate || isPackagePrivateAndPackagesDiffer;
            boolean bl = overriddenInjected = overridden && BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(overridingMethod).hasDeclaredStereotype("javax.inject.Inject");
            if (isParent && isPackagePrivate && !isPackagePrivateAndPackagesDiffer && overriddenInjected) {
                return;
            }
            if (isParent && overridden && !overriddenInjected && !isPackagePrivateAndPackagesDiffer && !isPrivate) {
                return;
            }
            if (!requiresReflection && BeanDefinitionInjectProcessor.this.modelUtils.isInheritedAndNotPublic(this.concreteClassElement, declaringClass, (Element)javaMethodElement)) {
                requiresReflection = true;
            }
            if (javaMethodElement.hasDeclaredAnnotation("javax.annotation.PostConstruct")) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                this.addOriginatingElementIfNecessary(writer, declaringClass);
                writer.visitPostConstructMethod((TypedElement)declaringClass, javaMethodElement, requiresReflection, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
            } else if (javaMethodElement.hasDeclaredAnnotation("javax.annotation.PreDestroy")) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                this.addOriginatingElementIfNecessary(writer, declaringClass);
                writer.visitPreDestroyMethod((TypedElement)declaringClass, javaMethodElement, requiresReflection, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
            } else if (javaMethodElement.hasDeclaredStereotype("javax.inject.Inject") || javaMethodElement.hasDeclaredStereotype(ConfigurationInject.class)) {
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                this.addOriginatingElementIfNecessary(writer, declaringClass);
                writer.visitMethodInjectionPoint((TypedElement)declaringClass, javaMethodElement, requiresReflection, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
            } else {
                BeanDefinitionInjectProcessor.this.error("Unexpected call to visitAnnotatedMethod(%s)", method);
            }
        }

        @Nullable
        private AopProxyWriter resolveAopWriter(BeanDefinitionVisitor writer) {
            DynamicName proxyKey = this.createProxyKey(writer.getBeanDefinitionName());
            BeanDefinitionVisitor aopWriter = this.beanDefinitionWriters.get(proxyKey);
            if (aopWriter instanceof AopProxyWriter) {
                return (AopProxyWriter)aopWriter;
            }
            if (this.isAopProxyType) {
                io.micronaut.core.annotation.AnnotationValue[] interceptorTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)this.concreteClassMetadata, (InterceptorKind)InterceptorKind.AROUND);
                return this.resolveAopProxyWriter(writer, this.aopSettings, this.isFactoryType, this.constructorElement, interceptorTypes);
            }
            return null;
        }

        @Override
        public Object visitVariable(VariableElement variable, Object o) {
            boolean isValue;
            if (variable.getKind() != ElementKind.FIELD) {
                return null;
            }
            if (BeanDefinitionInjectProcessor.this.modelUtils.isStatic(variable)) {
                AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(variable);
                if (this.isFactoryType && fieldAnnotationMetadata.hasDeclaredStereotype(Bean.class)) {
                    BeanDefinitionInjectProcessor.this.error(variable, "Beans produced from fields cannot be static", new Object[0]);
                }
                return null;
            }
            if (BeanDefinitionInjectProcessor.this.modelUtils.isFinal(variable)) {
                AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(variable);
                if (this.isFactoryType && fieldAnnotationMetadata.hasDeclaredStereotype(Bean.class)) {
                    if (BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(variable) || BeanDefinitionInjectProcessor.this.modelUtils.isProtected(variable)) {
                        BeanDefinitionInjectProcessor.this.error(variable, "Beans produced from fields cannot be private or protected", new Object[0]);
                    } else {
                        this.visitBeanFactoryElement(variable);
                    }
                } else {
                    boolean isConfigBuilder = fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class);
                    if (isConfigBuilder) {
                        this.visitConfigurationProperty(variable, fieldAnnotationMetadata);
                    }
                }
                return null;
            }
            AnnotationMetadata fieldAnnotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(variable);
            boolean isInjected = fieldAnnotationMetadata.hasStereotype("javax.inject.Inject") || fieldAnnotationMetadata.hasDeclaredStereotype("javax.inject.Qualifier") && !fieldAnnotationMetadata.hasDeclaredAnnotation(Bean.class);
            boolean bl = isValue = fieldAnnotationMetadata.hasStereotype(Value.class) || fieldAnnotationMetadata.hasStereotype(Property.class);
            if (isInjected || isValue) {
                TypeMirror type;
                boolean requiresReflection;
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                TypeElement declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(variable);
                if (declaringClass == null) {
                    return null;
                }
                JavaClassElement declaringClassElement = this.elementFactory.newClassElement(declaringClass, this.concreteClassMetadata);
                JavaFieldElement javaFieldElement = this.elementFactory.newFieldElement(this.concreteClassElement, variable, fieldAnnotationMetadata);
                this.addOriginatingElementIfNecessary(writer, declaringClass);
                boolean isPrivate = javaFieldElement.isPrivate();
                boolean bl2 = requiresReflection = isPrivate || BeanDefinitionInjectProcessor.this.modelUtils.isInheritedAndNotPublic(this.concreteClass, declaringClass, variable);
                if (!writer.isValidated()) {
                    writer.setValidated(IS_CONSTRAINT.test(fieldAnnotationMetadata));
                }
                if ((type = variable.asType()).getKind() == TypeKind.ERROR && !BeanDefinitionInjectProcessor.this.processingOver) {
                    throw new PostponeToNextRoundException();
                }
                if (isValue) {
                    writer.visitFieldValue((TypedElement)declaringClassElement, (FieldElement)javaFieldElement, requiresReflection, this.isConfigurationPropertiesType);
                } else {
                    writer.visitFieldInjectionPoint((TypedElement)declaringClassElement, (FieldElement)javaFieldElement, requiresReflection);
                }
            } else if (this.isConfigurationPropertiesType) {
                this.visitConfigurationProperty(variable, fieldAnnotationMetadata);
            } else if (this.isFactoryType && fieldAnnotationMetadata.hasDeclaredStereotype(Bean.class)) {
                if (BeanDefinitionInjectProcessor.this.modelUtils.isPrivate(variable) || BeanDefinitionInjectProcessor.this.modelUtils.isProtected(variable)) {
                    BeanDefinitionInjectProcessor.this.error(variable, "Beans produced from fields cannot be private or protected", new Object[0]);
                } else {
                    this.visitBeanFactoryElement(variable);
                }
            }
            return null;
        }

        private void addOriginatingElementIfNecessary(BeanDefinitionVisitor writer, TypeElement declaringClass) {
            if (!this.concreteClass.equals(declaringClass)) {
                writer.addOriginatingElement((Element)this.elementFactory.newClassElement(declaringClass, this.currentClassMetadata));
            }
        }

        private void addOriginatingElementIfNecessary(BeanDefinitionVisitor writer, ClassElement declaringClass) {
            if (!this.concreteClassElement.getName().equals(declaringClass.getName())) {
                writer.addOriginatingElement((Element)declaringClass);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitConfigurationProperty(VariableElement field, AnnotationMetadata fieldAnnotationMetadata) {
            boolean isMethodInjected;
            Optional<ExecutableElement> setterMethod = BeanDefinitionInjectProcessor.this.modelUtils.findSetterMethodFor(field);
            boolean isInjected = fieldAnnotationMetadata.hasStereotype("javax.inject.Inject");
            boolean isValue = fieldAnnotationMetadata.hasStereotype(Value.class) || fieldAnnotationMetadata.hasStereotype(Property.class);
            boolean bl = isMethodInjected = isInjected || setterMethod.isPresent() && BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype((javax.lang.model.element.Element)setterMethod.get(), "javax.inject.Inject");
            if (!isMethodInjected && !isValue) {
                TypeElement declaringClass;
                BeanDefinitionVisitor writer = this.getOrCreateBeanDefinitionWriter(this.concreteClass, this.concreteClass.getQualifiedName());
                if (!writer.isValidated()) {
                    writer.setValidated(IS_CONSTRAINT.test(fieldAnnotationMetadata));
                }
                if ((declaringClass = BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(field)) == null) {
                    return null;
                }
                JavaClassElement declaringClassElement = this.elementFactory.newClassElement(declaringClass, this.concreteClassMetadata);
                JavaFieldElement javaFieldElement = this.elementFactory.newFieldElement((ClassElement)declaringClassElement, field, fieldAnnotationMetadata);
                String fieldName = javaFieldElement.getName();
                if (fieldAnnotationMetadata.hasStereotype(ConfigurationBuilder.class)) {
                    boolean accessible = false;
                    if (BeanDefinitionInjectProcessor.this.modelUtils.isPublic(field)) {
                        accessible = true;
                    } else if (BeanDefinitionInjectProcessor.this.modelUtils.isPackagePrivate(field) || BeanDefinitionInjectProcessor.this.modelUtils.isProtected(field)) {
                        String declaringPackage = declaringClassElement.getPackageName();
                        String concretePackage = this.concreteClassElement.getPackageName();
                        accessible = declaringPackage.equals(concretePackage);
                    }
                    boolean isInterface = javaFieldElement.getType().isInterface();
                    if (accessible) {
                        writer.visitConfigBuilderField(javaFieldElement.getType(), fieldName, fieldAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, isInterface);
                    } else {
                        Optional<ExecutableElement> getterMethod = BeanDefinitionInjectProcessor.this.modelUtils.findGetterMethodFor(field);
                        if (getterMethod.isPresent()) {
                            writer.visitConfigBuilderMethod(javaFieldElement.getType(), getterMethod.get().getSimpleName().toString(), fieldAnnotationMetadata, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, isInterface);
                        } else {
                            BeanDefinitionInjectProcessor.this.error(field, "ConfigurationBuilder applied to a non accessible (private or package-private/protected in a different package) field must have a corresponding non-private getter method.", new Object[0]);
                        }
                    }
                    try {
                        this.visitConfigurationBuilder(declaringClass, field, field.asType(), writer);
                    }
                    finally {
                        writer.visitConfigBuilderEnd();
                    }
                } else {
                    if (this.shouldExclude(this.configurationMetadata, fieldName)) {
                        return null;
                    }
                    if (setterMethod.isPresent()) {
                        ExecutableElement method = setterMethod.get();
                        String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(method);
                        BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, BeanDefinitionInjectProcessor.this.getPropertyMetadataTypeReference(field.asType()), fieldName, docComment, null);
                    } else {
                        boolean isPrivate = javaFieldElement.isPrivate();
                        boolean requiresReflection = this.isInheritedAndNotPublic(BeanDefinitionInjectProcessor.this.modelUtils.classElementFor(field), field.getModifiers());
                        if (!isPrivate) {
                            String docComment = BeanDefinitionInjectProcessor.this.elementUtils.getDocComment(field);
                            PropertyMetadata propertyMetadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(this.concreteClass, declaringClass, BeanDefinitionInjectProcessor.this.getPropertyMetadataTypeReference(field.asType()), fieldName, docComment, null);
                            BeanDefinitionInjectProcessor.this.addPropertyMetadata(javaFieldElement, propertyMetadata);
                            writer.visitFieldValue((TypedElement)declaringClassElement, (FieldElement)javaFieldElement, requiresReflection, this.isConfigurationPropertiesType);
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public Object visitTypeParameter(TypeParameterElement e, Object o) {
            BeanDefinitionInjectProcessor.this.note("Visit param %s for %s", e.getSimpleName(), o);
            return super.visitTypeParameter(e, o);
        }

        @Override
        public Object visitUnknown(javax.lang.model.element.Element e, Object o) {
            if (!JavaModelUtils.isRecordOrRecordComponent((javax.lang.model.element.Element)e)) {
                BeanDefinitionInjectProcessor.this.note("Visit unknown %s for %s", e.getSimpleName(), o);
                return super.visitUnknown(e, o);
            }
            return o;
        }

        protected boolean isInheritedAndNotPublic(TypeElement declaringClass, Set<Modifier> modifiers) {
            PackageElement declaringPackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(declaringClass);
            PackageElement concretePackage = BeanDefinitionInjectProcessor.this.elementUtils.getPackageOf(this.concreteClass);
            return !declaringClass.equals(this.concreteClass) && !declaringPackage.equals(concretePackage) && !modifiers.contains((Object)Modifier.PUBLIC);
        }

        private void visitConfigurationBuilder(final TypeElement declaringClass, javax.lang.model.element.Element builderElement, TypeMirror builderType, final BeanDefinitionVisitor writer) {
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(builderElement);
            final Boolean allowZeroArgs = annotationMetadata.getValue(ConfigurationBuilder.class, "allowZeroArgs", Boolean.class).orElse(false);
            final List<Object> prefixes = Arrays.asList((Object[])annotationMetadata.getValue(ConfigurationBuilder.class, "prefixes", String[].class).orElse(new String[]{"set"}));
            final String configurationPrefix = annotationMetadata.getValue(ConfigurationBuilder.class, String.class).map(v -> v + ".").orElse("");
            final Set includes = annotationMetadata.getValue(ConfigurationBuilder.class, "includes", Set.class).orElse(Collections.emptySet());
            final Set excludes = annotationMetadata.getValue(ConfigurationBuilder.class, "excludes", Set.class).orElse(Collections.emptySet());
            PublicMethodVisitor visitor = new PublicMethodVisitor(BeanDefinitionInjectProcessor.this.javaVisitorContext){

                @Override
                protected void accept(DeclaredType type, javax.lang.model.element.Element element, Object o) {
                    String prefix;
                    ExecutableElement method = (ExecutableElement)element;
                    List<? extends VariableElement> params = method.getParameters();
                    String methodName = method.getSimpleName().toString();
                    String propertyName = NameUtils.decapitalize((String)methodName.substring((prefix = this.getMethodPrefix(prefixes, methodName)).length()));
                    if (AnnBeanElementVisitor.this.shouldExclude(includes, excludes, propertyName)) {
                        return;
                    }
                    int paramCount = params.size();
                    JavaMethodElement javaMethodElement = AnnBeanElementVisitor.this.elementFactory.newMethodElement(AnnBeanElementVisitor.this.concreteClassElement, method, AnnotationMetadata.EMPTY_METADATA);
                    if (paramCount < 2) {
                        VariableElement paramType = paramCount == 1 ? params.get(0) : null;
                        ClassElement parameterElement = null;
                        if (paramType != null) {
                            parameterElement = AnnBeanElementVisitor.this.elementFactory.newParameterElement(AnnBeanElementVisitor.this.concreteClassElement, paramType, AnnotationMetadata.EMPTY_METADATA).getGenericType();
                        }
                        PropertyMetadata metadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(AnnBeanElementVisitor.this.concreteClass, declaringClass, parameterElement != null ? parameterElement.getName() : null, configurationPrefix + propertyName, null, null);
                        writer.visitConfigBuilderMethod(prefix, javaMethodElement.getReturnType(), methodName, parameterElement, parameterElement != null ? parameterElement.getTypeArguments() : null, metadata.getPath());
                    } else if (paramCount == 2) {
                        VariableElement first = params.get(0);
                        VariableElement second = params.get(1);
                        TypeMirror tu = BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement(TimeUnit.class.getName()).asType();
                        TypeMirror typeMirror = first.asType();
                        if (typeMirror.toString().equals("long") && BeanDefinitionInjectProcessor.this.typeUtils.isAssignable(second.asType(), tu)) {
                            PropertyMetadata metadata = BeanDefinitionInjectProcessor.this.metadataBuilder.visitProperty(AnnBeanElementVisitor.this.concreteClass, declaringClass, Duration.class.getName(), configurationPrefix + propertyName, null, null);
                            writer.visitConfigBuilderDurationMethod(prefix, javaMethodElement.getReturnType(), methodName, metadata.getPath());
                        }
                    }
                }

                @Override
                protected boolean isAcceptable(javax.lang.model.element.Element element) {
                    if (BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype(element, Deprecated.class)) {
                        return false;
                    }
                    Set<Modifier> modifiers = element.getModifiers();
                    if (element.getKind() == ElementKind.METHOD) {
                        ExecutableElement method = (ExecutableElement)element;
                        int paramCount = method.getParameters().size();
                        return modifiers.contains((Object)Modifier.PUBLIC) && (paramCount > 0 && paramCount < 3 || allowZeroArgs != false && paramCount == 0) && this.isPrefixedWith(method, prefixes);
                    }
                    return false;
                }

                private boolean isPrefixedWith(javax.lang.model.element.Element enclosedElement, List<String> prefixes2) {
                    String name = enclosedElement.getSimpleName().toString();
                    for (String prefix : prefixes2) {
                        if (!name.startsWith(prefix)) continue;
                        return true;
                    }
                    return false;
                }

                private String getMethodPrefix(List<String> prefixes2, String methodName) {
                    for (String prefix : prefixes2) {
                        if (!methodName.startsWith(prefix)) continue;
                        return prefix;
                    }
                    return methodName;
                }
            };
            builderType.accept(visitor, null);
        }

        private BeanDefinitionWriter createBeanDefinitionWriterFor(TypeElement typeElement) {
            AnnotationMetadata annotationMetadata;
            Object classElement;
            if (typeElement == this.concreteClass) {
                classElement = this.concreteClassElement;
                annotationMetadata = classElement.getAnnotationMetadata();
            } else {
                annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.getAnnotationMetadata(typeElement);
                classElement = this.elementFactory.newClassElement(typeElement, annotationMetadata);
            }
            if (this.configurationMetadata != null) {
                String existingPrefix = annotationMetadata.stringValue(ConfigurationReader.class, "prefix").orElse("");
                String computedPrefix = StringUtils.isNotEmpty((CharSequence)existingPrefix) ? existingPrefix + "." + this.configurationMetadata.getName() : this.configurationMetadata.getName();
                classElement.annotate(ConfigurationReader.class, builder -> builder.member("prefix", computedPrefix));
            }
            BeanDefinitionWriter beanDefinitionWriter = new BeanDefinitionWriter(classElement, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext);
            beanDefinitionWriter.visitTypeArguments(classElement.getAllTypeArguments());
            return beanDefinitionWriter;
        }

        private DynamicName createProxyKey(String beanName) {
            return new DynamicName(beanName + "$Proxy");
        }

        private AopProxyWriter createIntroductionAdviceWriter(ClassElement typeElement) {
            AnnotationMetadata annotationMetadata = typeElement.getAnnotationMetadata();
            String packageName = typeElement.getPackageName();
            String beanClassName = typeElement.getSimpleName();
            Object[] aroundInterceptors = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)annotationMetadata, (InterceptorKind)InterceptorKind.AROUND);
            Object[] introductionInterceptors = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)annotationMetadata, (InterceptorKind)InterceptorKind.INTRODUCTION);
            Object[] interfaceTypes = (ClassElement[])Arrays.stream((Object[])annotationMetadata.getValue(Introduction.class, "interfaces", String[].class).orElse(new String[0])).map(ClassElement::of).toArray(ClassElement[]::new);
            io.micronaut.core.annotation.AnnotationValue[] interceptorTypes = (io.micronaut.core.annotation.AnnotationValue[])ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
            boolean isInterface = typeElement.isInterface();
            AopProxyWriter aopProxyWriter = new AopProxyWriter(packageName, beanClassName, isInterface, (Element)typeElement, annotationMetadata, (ClassElement[])interfaceTypes, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext, (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, this.configurationMetadata, interceptorTypes);
            aopProxyWriter.visitTypeArguments(typeElement.getAllTypeArguments());
            Set additionalInterfaces = Arrays.stream(interfaceTypes).map(ce -> BeanDefinitionInjectProcessor.this.elementUtils.getTypeElement(ce.getName())).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
            if (ArrayUtils.isNotEmpty((Object[])interfaceTypes)) {
                TypeElement te = (TypeElement)typeElement.getNativeType();
                List<? extends AnnotationMirror> annotationMirrors = te.getAnnotationMirrors();
                this.populateIntroductionInterfaces(annotationMirrors, additionalInterfaces);
                if (!additionalInterfaces.isEmpty()) {
                    for (TypeElement additionalInterface : additionalInterfaces) {
                        this.visitIntroductionAdviceInterface(additionalInterface, annotationMetadata, aopProxyWriter);
                    }
                }
            }
            return aopProxyWriter;
        }

        private void populateIntroductionInterfaces(List<? extends AnnotationMirror> annotationMirrors, Set<TypeElement> additionalInterfaces) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType.toString().equals(Introduction.class.getName())) {
                    Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                        ExecutableElement key = entry.getKey();
                        if (!key.toString().equalsIgnoreCase("interfaces()")) continue;
                        Object value = entry.getValue().getValue();
                        if (value instanceof List) {
                            for (Object v : (List)value) {
                                if (!(v instanceof AnnotationValue)) continue;
                                this.tryAddAnnotationValue(additionalInterfaces, (AnnotationValue)v);
                            }
                            continue;
                        }
                        if (!(value instanceof AnnotationValue)) continue;
                        this.tryAddAnnotationValue(additionalInterfaces, (AnnotationValue)value);
                    }
                    continue;
                }
                javax.lang.model.element.Element element = annotationType.asElement();
                if (!BeanDefinitionInjectProcessor.this.annotationUtils.hasStereotype(element, Introduction.class)) continue;
                this.populateIntroductionInterfaces(element.getAnnotationMirrors(), additionalInterfaces);
            }
        }

        private void tryAddAnnotationValue(Set<TypeElement> additionalInterfaces, AnnotationValue v) {
            TypeMirror tm;
            Object v2 = v.getValue();
            if (v2 instanceof TypeMirror && (tm = (TypeMirror)v2).getKind() == TypeKind.DECLARED) {
                DeclaredType dt = (DeclaredType)tm;
                additionalInterfaces.add((TypeElement)dt.asElement());
            }
        }

        private BeanDefinitionWriter createFactoryBeanMethodWriterFor(javax.lang.model.element.Element method, TypeElement producedElement) {
            AnnotationMetadata annotationMetadata = BeanDefinitionInjectProcessor.this.annotationUtils.newAnnotationBuilder().buildForParent(producedElement, method, false);
            annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.concreteClassMetadata, annotationMetadata});
            AbstractJavaElement factoryElement = method instanceof ExecutableElement ? this.elementFactory.newMethodElement(this.concreteClassElement, (ExecutableElement)method, annotationMetadata) : this.elementFactory.newFieldElement(this.concreteClassElement, (VariableElement)method, annotationMetadata);
            return new BeanDefinitionWriter((Element)factoryElement, OriginatingElements.of((Element[])new Element[]{factoryElement}), (ConfigurationMetadataBuilder)BeanDefinitionInjectProcessor.this.metadataBuilder, (VisitorContext)BeanDefinitionInjectProcessor.this.javaVisitorContext, Integer.valueOf(this.factoryMethodIndex.getAndIncrement()));
        }

        private boolean shouldExclude(Set<String> includes, Set<String> excludes, String propertyName) {
            if (!includes.isEmpty() && !includes.contains(propertyName)) {
                return true;
            }
            return !excludes.isEmpty() && excludes.contains(propertyName);
        }

        private boolean shouldExclude(ConfigurationMetadata configurationMetadata, String propertyName) {
            return this.shouldExclude(configurationMetadata.getIncludes(), configurationMetadata.getExcludes(), propertyName);
        }
    }
}

