/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class JavaAnnotationMetadataBuilder
extends AbstractAnnotationMetadataBuilder<Element, AnnotationMirror> {
    private static final Map<String, Map<Element, AnnotationValue>> ANNOTATION_DEFAULTS = new HashMap<String, Map<Element, AnnotationValue>>();
    private static final Map<ExecutableElement, List<ExecutableElement>> OVERRIDDEN_METHOD_CACHE = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(100L).build();
    private final Elements elementUtils;
    private final Messager messager;
    private final AnnotationUtils annotationUtils;
    private final ModelUtils modelUtils;

    public JavaAnnotationMetadataBuilder(Elements elements, Messager messager, AnnotationUtils annotationUtils, ModelUtils modelUtils) {
        this.elementUtils = elements;
        this.messager = messager;
        this.annotationUtils = annotationUtils;
        this.modelUtils = modelUtils;
    }

    @Nullable
    protected AnnotatedElementValidator getElementValidator() {
        return this.annotationUtils.getElementValidator();
    }

    protected void addError(@NonNull Element originatingElement, @NonNull String error) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, error, originatingElement);
    }

    protected void addWarning(@NonNull Element originatingElement, @NonNull String warning) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, warning, originatingElement);
    }

    protected String getAnnotationMemberName(Element member) {
        return member.getSimpleName().toString();
    }

    @Nullable
    protected String getRepeatableName(AnnotationMirror annotationMirror) {
        Element typeElement = annotationMirror.getAnnotationType().asElement();
        return this.getRepeatableNameForType(typeElement);
    }

    @Nullable
    protected String getRepeatableNameForType(Element annotationType) {
        List<? extends AnnotationMirror> mirrors = annotationType.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            String name = annotationMirror.getAnnotationType().toString();
            if (!Repeatable.class.getName().equals(name)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                AnnotationValue av;
                Object value;
                if (!entry.getKey().getSimpleName().toString().equals("value") || !((value = (av = entry.getValue()).getValue()) instanceof DeclaredType)) continue;
                Element element = ((DeclaredType)value).asElement();
                return JavaModelUtils.getClassName((TypeElement)((TypeElement)element));
            }
        }
        return null;
    }

    protected Optional<Element> getAnnotationMirror(String annotationName) {
        return Optional.ofNullable(this.elementUtils.getTypeElement(annotationName));
    }

    protected VisitorContext createVisitorContext() {
        return this.annotationUtils.newVisitorContext();
    }

    @NonNull
    protected RetentionPolicy getRetentionPolicy(@NonNull Element annotation) {
        List<? extends AnnotationMirror> annotationMirrors = annotation.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
            if (!Retention.class.getName().equals(annotationTypeName)) continue;
            Iterator<? extends AnnotationValue> i = annotationMirror.getElementValues().values().iterator();
            if (!i.hasNext()) break;
            AnnotationValue av = i.next();
            String v = av.getValue().toString();
            return RetentionPolicy.valueOf(v);
        }
        return RetentionPolicy.RUNTIME;
    }

    protected boolean isInheritedAnnotation(@NonNull AnnotationMirror annotationMirror) {
        List<? extends AnnotationMirror> annotationMirrors = annotationMirror.getAnnotationType().asElement().getAnnotationMirrors();
        for (AnnotationMirror annotationMirror2 : annotationMirrors) {
            if (!this.getAnnotationTypeName(annotationMirror2).equals(Inherited.class.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isInheritedAnnotationType(@NonNull Element annotationType) {
        for (AnnotationMirror annotationMirror : annotationType.getAnnotationMirrors()) {
            if (!this.getAnnotationTypeName(annotationMirror).equals(Inherited.class.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isMethodOrClassElement(Element element) {
        return element instanceof TypeElement || element instanceof ExecutableElement;
    }

    @NonNull
    protected String getDeclaringType(@NonNull Element element) {
        TypeElement typeElement = this.modelUtils.classElementFor(element);
        if (typeElement != null) {
            return typeElement.getQualifiedName().toString();
        }
        return element.getSimpleName().toString();
    }

    protected Element getTypeForAnnotation(AnnotationMirror annotationMirror) {
        return annotationMirror.getAnnotationType().asElement();
    }

    protected List<? extends AnnotationMirror> getAnnotationsForType(Element element) {
        ArrayList<? extends AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>(element.getAnnotationMirrors());
        annotationMirrors.removeIf(mirror -> this.getAnnotationTypeName((AnnotationMirror)mirror).equals("kotlin.Metadata"));
        ArrayList<AnnotationMirror> expanded = new ArrayList<AnnotationMirror>(annotationMirrors.size());
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            boolean repeatable = false;
            boolean hasOtherMembers = false;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (entry.getKey().getSimpleName().toString().equals("value")) {
                    Object value = entry.getValue().getValue();
                    if (!(value instanceof List)) continue;
                    String parentAnnotationName = this.getAnnotationTypeName(annotationMirror);
                    for (Object val : (List)value) {
                        String name;
                        if (!(val instanceof AnnotationMirror) || (name = this.getRepeatableName((AnnotationMirror)val)) == null || !name.equals(parentAnnotationName)) continue;
                        repeatable = true;
                        expanded.add((AnnotationMirror)val);
                    }
                    continue;
                }
                hasOtherMembers = true;
            }
            if (repeatable && !hasOtherMembers) continue;
            expanded.add(annotationMirror);
        }
        return expanded;
    }

    protected boolean isExcludedAnnotation(@NonNull Element element, @NonNull String annotationName) {
        if (annotationName.startsWith("java.lang.annotation") && element.getKind() == ElementKind.ANNOTATION_TYPE) {
            return false;
        }
        return super.isExcludedAnnotation((Object)element, annotationName);
    }

    protected List<Element> buildHierarchy(Element element, boolean inheritTypeAnnotations, boolean declaredOnly) {
        if (declaredOnly) {
            ArrayList<Element> onlyDeclared = new ArrayList<Element>(1);
            onlyDeclared.add(element);
            return onlyDeclared;
        }
        if (element instanceof TypeElement) {
            ArrayList<Element> hierarchy = new ArrayList<Element>();
            hierarchy.add(element);
            if (element.getKind() == ElementKind.ANNOTATION_TYPE) {
                return hierarchy;
            }
            this.populateTypeHierarchy(element, hierarchy);
            Collections.reverse(hierarchy);
            return hierarchy;
        }
        if (element instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)element;
            List<Object> hierarchy = inheritTypeAnnotations ? this.buildHierarchy(executableElement.getEnclosingElement(), false, declaredOnly) : new ArrayList<ExecutableElement>();
            hierarchy.addAll(this.findOverriddenMethods(executableElement));
            hierarchy.add(element);
            return hierarchy;
        }
        if (element instanceof VariableElement) {
            ArrayList<Element> hierarchy = new ArrayList<Element>();
            VariableElement variable = (VariableElement)element;
            Element enclosingElement = variable.getEnclosingElement();
            if (enclosingElement instanceof ExecutableElement) {
                ExecutableElement executableElement = (ExecutableElement)enclosingElement;
                int variableIdx = executableElement.getParameters().indexOf(variable);
                for (ExecutableElement overridden : this.findOverriddenMethods(executableElement)) {
                    hierarchy.add(overridden.getParameters().get(variableIdx));
                }
            }
            hierarchy.add(variable);
            return hierarchy;
        }
        ArrayList<Element> single = new ArrayList<Element>();
        single.add(element);
        return single;
    }

    protected Map<? extends Element, ?> readAnnotationRawValues(AnnotationMirror annotationMirror) {
        return annotationMirror.getElementValues();
    }

    @Nullable
    protected Element getAnnotationMember(Element originatingElement, CharSequence member) {
        if (originatingElement instanceof TypeElement) {
            List<? extends Element> enclosedElements = originatingElement.getEnclosedElements();
            for (Element element : enclosedElements) {
                if (!(element instanceof ExecutableElement) || !element.getSimpleName().toString().equals(member.toString())) continue;
                return element;
            }
        }
        return null;
    }

    protected OptionalValues<?> getAnnotationValues(Element originatingElement, Element member, Class<?> annotationType) {
        List<? extends AnnotationMirror> annotationMirrors = member.getAnnotationMirrors();
        String annotationName = annotationType.getName();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().endsWith(annotationName)) continue;
            Map<Element, ?> values = this.readAnnotationRawValues(annotationMirror);
            LinkedHashMap<CharSequence, Object> converted = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<Element, ?> entry : values.entrySet()) {
                Element key = entry.getKey();
                Object value = entry.getValue();
                this.readAnnotationRawValues(originatingElement, annotationName, member, key.getSimpleName().toString(), value, converted);
            }
            return OptionalValues.of(Object.class, converted);
        }
        return OptionalValues.empty();
    }

    protected void readAnnotationRawValues(Element originatingElement, String annotationName, Element member, String memberName, Object annotationValue, Map<CharSequence, Object> annotationValues) {
        if (memberName != null && annotationValue instanceof AnnotationValue && !annotationValues.containsKey(memberName)) {
            MetadataAnnotationValueVisitor resolver = new MetadataAnnotationValueVisitor(originatingElement);
            ((AnnotationValue)annotationValue).accept(resolver, this);
            Object resolvedValue = resolver.resolvedValue;
            if (resolvedValue != null) {
                this.validateAnnotationValue(originatingElement, annotationName, member, memberName, resolvedValue);
                annotationValues.put(memberName, resolvedValue);
            }
        }
    }

    protected boolean isValidationRequired(Element member) {
        List<? extends AnnotationMirror> annotationMirrors = member.getAnnotationMirrors();
        return this.isValidationRequired(annotationMirrors);
    }

    private boolean isValidationRequired(List<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            List childMirrors;
            Element element;
            String annotationName = this.getAnnotationTypeName(annotationMirror);
            if (annotationName.startsWith("javax.validation")) {
                return true;
            }
            if (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName) || (element = (Element)this.getAnnotationMirror(annotationName).orElse(null)) == null || !this.isValidationRequired(childMirrors = element.getAnnotationMirrors().stream().filter(ann -> !this.getAnnotationTypeName((AnnotationMirror)ann).equals(annotationName)).collect(Collectors.toList()))) continue;
            return true;
        }
        return false;
    }

    protected Object readAnnotationValue(Element originatingElement, Element member, String memberName, Object annotationValue) {
        if (memberName != null && annotationValue instanceof AnnotationValue) {
            MetadataAnnotationValueVisitor visitor = new MetadataAnnotationValueVisitor(originatingElement);
            ((AnnotationValue)annotationValue).accept(visitor, this);
            return visitor.resolvedValue;
        }
        if (memberName != null && annotationValue != null && ClassUtils.isJavaLangType(annotationValue.getClass())) {
            return annotationValue;
        }
        return null;
    }

    protected Map<? extends Element, ?> readAnnotationDefaultValues(AnnotationMirror annotationMirror) {
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        Element element = annotationMirror.getAnnotationType().asElement();
        return this.readAnnotationDefaultValues(annotationTypeName, element);
    }

    protected Map<? extends Element, ?> readAnnotationDefaultValues(String annotationTypeName, Element element) {
        TypeElement annotationElement;
        String annotationName;
        Map<String, Map<Element, AnnotationValue>> defaults = ANNOTATION_DEFAULTS;
        if (element instanceof TypeElement && !defaults.containsKey(annotationName = (annotationElement = (TypeElement)element).getQualifiedName().toString())) {
            LinkedHashMap defaultValues = new LinkedHashMap();
            List<? extends Element> allMembers = this.elementUtils.getAllMembers(annotationElement);
            allMembers.stream().filter(member -> member.getEnclosingElement().equals(annotationElement)).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(this::isValidDefaultValue).forEach(executableElement -> {
                AnnotationValue defaultValue = executableElement.getDefaultValue();
                defaultValues.put(executableElement, defaultValue);
            });
            defaults.put(annotationName, defaultValues);
        }
        return ANNOTATION_DEFAULTS.get(annotationTypeName);
    }

    private boolean isValidDefaultValue(ExecutableElement executableElement) {
        Object v;
        AnnotationValue defaultValue = executableElement.getDefaultValue();
        if (defaultValue != null && (v = defaultValue.getValue()) != null) {
            if (v instanceof String) {
                return StringUtils.isNotEmpty((CharSequence)((CharSequence)v));
            }
            return true;
        }
        return false;
    }

    protected String getAnnotationTypeName(AnnotationMirror annotationMirror) {
        return JavaModelUtils.getClassName((TypeElement)((TypeElement)annotationMirror.getAnnotationType().asElement()));
    }

    protected String getElementName(Element element) {
        if (element instanceof TypeElement) {
            return this.elementUtils.getBinaryName((TypeElement)element).toString();
        }
        return element.getSimpleName().toString();
    }

    private void populateTypeHierarchy(Element element, List<Element> hierarchy) {
        boolean isInterface = JavaModelUtils.resolveKind((Element)element, (ElementKind)ElementKind.INTERFACE).isPresent();
        Types typeUtils = this.modelUtils.getTypeUtils();
        if (isInterface) {
            TypeElement typeElement = (TypeElement)element;
            List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                Element e = typeUtils.asElement(typeMirror);
                if (e == null) continue;
                hierarchy.add(e);
                this.populateTypeHierarchy(e, hierarchy);
            }
        } else {
            while (JavaModelUtils.resolveKind((Element)element, (ElementKind)ElementKind.CLASS).isPresent()) {
                DeclaredType declaredType;
                TypeElement typeElement = (TypeElement)element;
                List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
                for (TypeMirror typeMirror : interfaces) {
                    if (!(typeMirror instanceof DeclaredType)) continue;
                    Element interfaceElement = ((DeclaredType)typeMirror).asElement();
                    hierarchy.add(interfaceElement);
                    this.populateTypeHierarchy(interfaceElement, hierarchy);
                }
                TypeMirror superMirror = typeElement.getSuperclass();
                if (superMirror instanceof DeclaredType && !(declaredType = (DeclaredType)superMirror).toString().equals(Object.class.getName())) {
                    element = declaredType.asElement();
                    hierarchy.add(element);
                    continue;
                }
                break;
            }
        }
    }

    private List<ExecutableElement> findOverriddenMethods(ExecutableElement sourceMethod) {
        return OVERRIDDEN_METHOD_CACHE.computeIfAbsent(sourceMethod, executableElement -> {
            ArrayList<ExecutableElement> overridden = new ArrayList<ExecutableElement>(3);
            Element enclosingElement = executableElement.getEnclosingElement();
            if (enclosingElement instanceof TypeElement) {
                TypeElement declaringElement = (TypeElement)enclosingElement;
                Set<TypeElement> allInterfaces = this.modelUtils.getAllInterfaces(declaringElement);
                for (TypeElement itfe : allInterfaces) {
                    this.addOverriddenMethodIfNecessary((ExecutableElement)executableElement, (List<ExecutableElement>)overridden, declaringElement, itfe);
                }
                Types typeUtils = this.modelUtils.getTypeUtils();
                TypeElement supertype = this.toTypeElement(declaringElement.getSuperclass(), typeUtils);
                while (supertype != null && !supertype.toString().equals(Object.class.getName())) {
                    this.addOverriddenMethodIfNecessary((ExecutableElement)executableElement, (List<ExecutableElement>)overridden, declaringElement, supertype);
                    supertype = this.toTypeElement(supertype.getSuperclass(), typeUtils);
                }
            }
            return overridden;
        });
    }

    private void addOverriddenMethodIfNecessary(ExecutableElement executableElement, List<ExecutableElement> overridden, TypeElement declaringElement, TypeElement supertype) {
        List<ExecutableElement> possibleMethods = ElementFilter.methodsIn(supertype.getEnclosedElements());
        for (ExecutableElement possibleMethod : possibleMethods) {
            if (!this.elementUtils.overrides(executableElement, possibleMethod, declaringElement)) continue;
            overridden.add(possibleMethod);
        }
    }

    private TypeElement toTypeElement(TypeMirror mirror, Types typeUtils) {
        Element e;
        if (mirror != null && (e = typeUtils.asElement(mirror)) instanceof TypeElement) {
            return (TypeElement)e;
        }
        return null;
    }

    public boolean hasAnnotation(Element element, Class<? extends Annotation> ann) {
        return this.hasAnnotation(element, ann.getName());
    }

    public boolean hasAnnotation(Element element, String ann) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        if (CollectionUtils.isNotEmpty(annotationMirrors)) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (!annotationType.toString().equals(ann)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasAnnotations(Element element) {
        return CollectionUtils.isNotEmpty(element.getAnnotationMirrors());
    }

    public static void clearCaches() {
        OVERRIDDEN_METHOD_CACHE.clear();
    }

    public static boolean hasAnnotation(ExecutableElement method, Class<? extends Annotation> ann) {
        List<? extends AnnotationMirror> annotationMirrors = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(ann.getName())) continue;
            return true;
        }
        return false;
    }

    private class MetadataAnnotationValueVisitor
    extends AbstractAnnotationValueVisitor8<Object, Object> {
        private final Element originatingElement;
        private Object resolvedValue;

        MetadataAnnotationValueVisitor(Element originatingElement) {
            this.originatingElement = originatingElement;
        }

        @Override
        public Object visitBoolean(boolean b, Object o) {
            this.resolvedValue = b;
            return null;
        }

        @Override
        public Object visitByte(byte b, Object o) {
            this.resolvedValue = b;
            return null;
        }

        @Override
        public Object visitChar(char c, Object o) {
            this.resolvedValue = Character.valueOf(c);
            return null;
        }

        @Override
        public Object visitDouble(double d, Object o) {
            this.resolvedValue = d;
            return null;
        }

        @Override
        public Object visitFloat(float f, Object o) {
            this.resolvedValue = Float.valueOf(f);
            return null;
        }

        @Override
        public Object visitInt(int i, Object o) {
            this.resolvedValue = i;
            return null;
        }

        @Override
        public Object visitLong(long i, Object o) {
            this.resolvedValue = i;
            return null;
        }

        @Override
        public Object visitShort(short s, Object o) {
            this.resolvedValue = s;
            return null;
        }

        @Override
        public Object visitString(String s, Object o) {
            this.resolvedValue = s;
            return null;
        }

        @Override
        public Object visitType(TypeMirror t, Object o) {
            Element typeElement;
            if (t instanceof DeclaredType && (typeElement = ((DeclaredType)t).asElement()) instanceof TypeElement) {
                String className = JavaModelUtils.getClassName((TypeElement)((TypeElement)typeElement));
                this.resolvedValue = new AnnotationClassValue(className);
            }
            return null;
        }

        @Override
        public Object visitEnumConstant(VariableElement c, Object o) {
            this.resolvedValue = c.toString();
            return null;
        }

        @Override
        public Object visitAnnotation(AnnotationMirror a, Object o) {
            if (a instanceof AnnotationValue) {
                this.resolvedValue = JavaAnnotationMetadataBuilder.this.readNestedAnnotationValue(this.originatingElement, a);
            }
            return null;
        }

        @Override
        public Object visitArray(List<? extends AnnotationValue> vals, Object o) {
            ArrayValueVisitor arrayValueVisitor = new ArrayValueVisitor();
            for (AnnotationValue annotationValue : vals) {
                annotationValue.accept(arrayValueVisitor, o);
            }
            this.resolvedValue = arrayValueVisitor.getValues();
            return null;
        }

        private class ArrayValueVisitor
        extends AbstractAnnotationValueVisitor8<Object, Object> {
            private List values = new ArrayList();
            private Class arrayType;

            private ArrayValueVisitor() {
            }

            Object[] getValues() {
                if (this.arrayType != null) {
                    for (Object value : this.values) {
                        if (value == null || this.arrayType.isInstance(value)) continue;
                        return ArrayUtils.EMPTY_OBJECT_ARRAY;
                    }
                    return this.values.toArray((Object[])Array.newInstance(this.arrayType, this.values.size()));
                }
                return this.values.toArray(new Object[0]);
            }

            @Override
            public Object visitBoolean(boolean b, Object o) {
                this.arrayType = Boolean.class;
                this.values.add(b);
                return null;
            }

            @Override
            public Object visitByte(byte b, Object o) {
                this.arrayType = Byte.class;
                this.values.add(b);
                return null;
            }

            @Override
            public Object visitChar(char c, Object o) {
                this.arrayType = Character.class;
                this.values.add(Character.valueOf(c));
                return null;
            }

            @Override
            public Object visitDouble(double d, Object o) {
                this.arrayType = Double.class;
                this.values.add(d);
                return null;
            }

            @Override
            public Object visitFloat(float f, Object o) {
                this.arrayType = Float.class;
                this.values.add(Float.valueOf(f));
                return null;
            }

            @Override
            public Object visitInt(int i, Object o) {
                this.arrayType = Integer.class;
                this.values.add(i);
                return null;
            }

            @Override
            public Object visitLong(long i, Object o) {
                this.arrayType = Long.class;
                this.values.add(i);
                return null;
            }

            @Override
            public Object visitShort(short s, Object o) {
                this.arrayType = Short.class;
                this.values.add(s);
                return null;
            }

            @Override
            public Object visitString(String s, Object o) {
                this.arrayType = String.class;
                this.values.add(s);
                return null;
            }

            @Override
            public Object visitType(TypeMirror t, Object o) {
                Element typeElement;
                TypeMirror componentType;
                this.arrayType = AnnotationClassValue.class;
                if (t instanceof DeclaredType) {
                    Element typeElement2 = ((DeclaredType)t).asElement();
                    if (typeElement2 instanceof TypeElement) {
                        String className = JavaModelUtils.getClassName((TypeElement)((TypeElement)typeElement2));
                        this.values.add(new AnnotationClassValue(className));
                    }
                } else if (t instanceof ArrayType && (componentType = ((ArrayType)t).getComponentType()) instanceof DeclaredType && (typeElement = ((DeclaredType)componentType).asElement()) instanceof TypeElement) {
                    String className = JavaModelUtils.getClassArrayName((TypeElement)((TypeElement)typeElement));
                    this.values.add(new AnnotationClassValue(className));
                }
                return null;
            }

            @Override
            public Object visitEnumConstant(VariableElement c, Object o) {
                this.arrayType = String.class;
                this.values.add(c.getSimpleName().toString());
                return null;
            }

            @Override
            public Object visitAnnotation(AnnotationMirror a, Object o) {
                this.arrayType = io.micronaut.core.annotation.AnnotationValue.class;
                io.micronaut.core.annotation.AnnotationValue annotationValue = JavaAnnotationMetadataBuilder.this.readNestedAnnotationValue(MetadataAnnotationValueVisitor.this.originatingElement, a);
                this.values.add(annotationValue);
                return null;
            }

            @Override
            public Object visitArray(List<? extends AnnotationValue> vals, Object o) {
                return null;
            }
        }
    }
}

