/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.JavaElementAnnotationMetadataFactory;
import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.PublicAbstractMethodVisitor;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaConstructorElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaEnumConstantElement;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.LoadedVisitor;
import io.micronaut.aop.Introduction;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.VersionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner8;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations", "micronaut.processing.project.dir", "micronaut.processing.group", "micronaut.processing.module"})
public class TypeElementVisitorProcessor
extends AbstractInjectAnnotationProcessor {
    private static final SoftServiceLoader<TypeElementVisitor> SERVICE_LOADER = SoftServiceLoader.load(TypeElementVisitor.class, (ClassLoader)TypeElementVisitorProcessor.class.getClassLoader()).disableFork();
    private static final Set<String> VISITOR_WARNINGS;
    private static final Set<String> SUPPORTED_ANNOTATION_NAMES;
    private List<LoadedVisitor> loadedVisitors;
    private Collection<TypeElementVisitor> typeElementVisitors;

    static Set<String> getVisitedAnnotationNames() {
        return SUPPORTED_ANNOTATION_NAMES;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeElementVisitors = this.findTypeElementVisitors();
        processingEnv.getOptions().entrySet().stream().filter(entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith("micronaut")).forEach(entry -> System.setProperty((String)entry.getKey(), entry.getValue() == null ? "" : (String)entry.getValue()));
        this.loadedVisitors = new ArrayList<LoadedVisitor>(this.typeElementVisitors.size());
        for (TypeElementVisitor visitor : this.typeElementVisitors) {
            TypeElementVisitor.VisitorKind visitorKind = visitor.getVisitorKind();
            TypeElementVisitor.VisitorKind incrementalProcessorKind = this.getIncrementalProcessorKind();
            if (incrementalProcessorKind != visitorKind) continue;
            try {
                this.loadedVisitors.add(new LoadedVisitor(visitor, this.genericUtils, processingEnv));
            }
            catch (NoClassDefFoundError | TypeNotPresentException throwable) {}
        }
        OrderUtil.reverseSort(this.loadedVisitors);
        for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
            try {
                loadedVisitor.getVisitor().start((VisitorContext)this.javaVisitorContext);
            }
            catch (Throwable e) {
                this.error("Error initializing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
            }
        }
    }

    protected boolean hasVisitors() {
        for (TypeElementVisitor typeElementVisitor : this.typeElementVisitors) {
            if (typeElementVisitor.getVisitorKind() != this.getVisitorKind()) continue;
            return true;
        }
        return false;
    }

    protected List<LoadedVisitor> getLoadedVisitors() {
        return this.loadedVisitors;
    }

    protected TypeElementVisitor.VisitorKind getIncrementalProcessorKind() {
        String type = this.getIncrementalProcessorType();
        if (type.equals("org.gradle.annotation.processing.aggregating")) {
            return TypeElementVisitor.VisitorKind.AGGREGATING;
        }
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (this.loadedVisitors.isEmpty()) {
            return Collections.emptySet();
        }
        return super.getSupportedAnnotationTypes();
    }

    @Override
    public Set<String> getSupportedOptions() {
        Stream baseOption = super.getSupportedOptions().stream();
        Stream visitorsOptions = this.typeElementVisitors.stream().map(TypeElementVisitor::getSupportedOptions).flatMap(Collection::stream);
        Stream visitorsAnnotationsOptions = this.typeElementVisitors.stream().filter(tev -> tev.getClass().isAnnotationPresent(SupportedOptions.class)).map(Object::getClass).map(cls -> cls.getAnnotation(SupportedOptions.class)).flatMap(supportedOptions -> Arrays.stream(supportedOptions.value()));
        return Stream.of(baseOption, visitorsAnnotationsOptions, visitorsOptions).flatMap(BaseStream::sequential).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        List<AbstractBeanDefinitionBuilder> beanDefinitionBuilders;
        if (!(this.loadedVisitors.isEmpty() || annotations.size() == 1 && Generated.class.getName().equals(annotations.iterator().next().getQualifiedName().toString()))) {
            TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
            TypeMirror groovyObjectType = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
            Predicate<TypeElement> notGroovyObject = typeElement -> groovyObjectType == null || !this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType);
            LinkedHashSet elements = new LinkedHashSet();
            for (TypeElement typeElement2 : annotations) {
                this.modelUtils.resolveTypeElements(roundEnv.getElementsAnnotatedWith(typeElement2)).filter(notGroovyObject).forEach(elements::add);
            }
            this.modelUtils.resolveTypeElements(roundEnv.getRootElements()).filter(notGroovyObject).forEach(elements::add);
            if (!elements.isEmpty()) {
                JavaElementFactory elementFactory = this.javaVisitorContext.getElementFactory();
                JavaElementAnnotationMetadataFactory javaElementAnnotationMetadataFactory = this.javaVisitorContext.getElementAnnotationMetadataFactory();
                List<JavaClassElement> javaClassElements = elements.stream().map(typeElement -> elementFactory.newSourceClassElement((TypeElement)typeElement, (ElementAnnotationMetadataFactory)elementAnnotationMetadataFactory)).toList();
                for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
                    for (JavaClassElement javaClassElement : javaClassElements) {
                        try {
                            if (!loadedVisitor.matchesClass((AnnotationMetadata)javaClassElement)) continue;
                            TypeElement typeElement2 = javaClassElement.getNativeType().element();
                            String className = typeElement2.getQualifiedName().toString();
                            typeElement2.accept(new ElementVisitor(javaClassElement, typeElement2, Collections.singletonList(loadedVisitor)), className);
                        }
                        catch (ProcessingException e) {
                            JavaNativeElement originatingElement = (JavaNativeElement)e.getOriginatingElement();
                            if (originatingElement == null) {
                                originatingElement = javaClassElement.getNativeType();
                            }
                            this.error(originatingElement.element(), e.getMessage(), new Object[0]);
                        }
                        catch (PostponeToNextRoundException e) {}
                    }
                }
            }
            for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
                try {
                    loadedVisitor.getVisitor().finish((VisitorContext)this.javaVisitorContext);
                }
                catch (Throwable e) {
                    this.error("Error finalizing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(beanDefinitionBuilders = this.javaVisitorContext.getBeanElementBuilders())) {
            try {
                AbstractBeanDefinitionBuilder.writeBeanDefinitionBuilders((ClassWriterOutputVisitor)this.classWriterOutputVisitor, beanDefinitionBuilders);
            }
            catch (IOException e) {
                String message = e.getMessage();
                this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
            }
        }
        if (roundEnv.processingOver()) {
            this.javaVisitorContext.finish();
            this.writeBeanDefinitionsToMetaInf();
        }
        return false;
    }

    @NonNull
    protected Collection<TypeElementVisitor> findTypeElementVisitors() {
        for (String visitorWarning : VISITOR_WARNINGS) {
            this.warning(visitorWarning, new Object[0]);
        }
        return TypeElementVisitorProcessor.findCoreTypeElementVisitors(null);
    }

    private void writeBeanDefinitionsToMetaInf() {
        try {
            this.classWriterOutputVisitor.finish();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.error("Error occurred writing META-INF files: %s", message != null ? message : e);
        }
    }

    @NonNull
    private static Collection<TypeElementVisitor> findCoreTypeElementVisitors(@Nullable Set<String> warnings) {
        return SERVICE_LOADER.collectAll(visitor -> {
            String version;
            Requires.Sdk sdk;
            if (!visitor.isEnabled()) {
                return false;
            }
            Requires requires = visitor.getClass().getAnnotation(Requires.class);
            if (requires != null && (sdk = requires.sdk()) == Requires.Sdk.MICRONAUT && StringUtils.isNotEmpty((CharSequence)(version = requires.version())) && !VersionUtils.isAtLeastMicronautVersion((String)version)) {
                try {
                    if (warnings != null) {
                        warnings.add("TypeElementVisitor [" + visitor.getClass().getName() + "] will be ignored because Micronaut version [" + VersionUtils.MICRONAUT_VERSION + "] must be at least " + version);
                    }
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return true;
        }).stream().filter(Objects::nonNull).collect(Collectors.toMap(Object::getClass, v -> v, (a, b) -> a)).values();
    }

    static {
        HashSet<String> warnings = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (TypeElementVisitor typeElementVisitor : TypeElementVisitorProcessor.findCoreTypeElementVisitors(warnings)) {
            Set supportedAnnotationNames;
            try {
                supportedAnnotationNames = typeElementVisitor.getSupportedAnnotationNames();
            }
            catch (Throwable e) {
                continue;
            }
            if (supportedAnnotationNames.equals(Collections.singleton("*"))) continue;
            names.addAll(supportedAnnotationNames);
        }
        SUPPORTED_ANNOTATION_NAMES = names;
        VISITOR_WARNINGS = warnings.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(warnings);
    }

    private class ElementVisitor
    extends ElementScanner8<Object, Object> {
        private final TypeElement concreteClass;
        private final List<LoadedVisitor> visitors;
        private JavaClassElement javaClassElement;

        ElementVisitor(JavaClassElement javaClassElement, TypeElement concreteClass, List<LoadedVisitor> visitors) {
            this.javaClassElement = javaClassElement;
            this.concreteClass = concreteClass;
            this.visitors = visitors;
        }

        @Override
        public Object visitUnknown(Element e, Object o) {
            return o;
        }

        @Override
        public Object visitType(TypeElement classElement, Object o) {
            boolean shouldVisit;
            if (!classElement.equals(this.javaClassElement.getNativeType().element())) {
                this.javaClassElement = TypeElementVisitorProcessor.this.javaVisitorContext.getElementFactory().newSourceClassElement(classElement, (ElementAnnotationMetadataFactory)TypeElementVisitorProcessor.this.javaVisitorContext.getElementAnnotationMetadataFactory());
            }
            for (LoadedVisitor visitor : this.visitors) {
                visitor.getVisitor().visitClass((ClassElement)this.javaClassElement, (VisitorContext)TypeElementVisitorProcessor.this.javaVisitorContext);
            }
            Element enclosingElement = classElement.getEnclosingElement();
            boolean bl = shouldVisit = !JavaModelUtils.isClass((Element)enclosingElement) || this.concreteClass.getQualifiedName().equals(classElement.getQualifiedName());
            if (shouldVisit) {
                if (this.javaClassElement.hasStereotype(Introduction.class) || this.javaClassElement.hasStereotype(Introspected.class) && this.javaClassElement.isAbstract()) {
                    classElement.asType().accept(new PublicAbstractMethodVisitor<Object, Object>(classElement, TypeElementVisitorProcessor.this.javaVisitorContext){

                        @Override
                        protected void accept(DeclaredType type, Element element, Object o) {
                            if (element instanceof ExecutableElement) {
                                ElementVisitor.this.visitExecutable((ExecutableElement)element, o);
                            }
                        }
                    }, null);
                    return null;
                }
                if (JavaModelUtils.isEnum((Element)classElement)) {
                    return this.scan(classElement.getEnclosedElements(), o);
                }
                List<? extends Element> elements = this.enclosedElements(classElement);
                Object value = null;
                for (Element element : elements) {
                    if (element instanceof TypeElement) continue;
                    value = this.scan(element, o);
                }
                return value;
            }
            return null;
        }

        private List<? extends Element> enclosedElements(TypeElement classElement) {
            ArrayList<Element> enclosedElements = new ArrayList<Element>(classElement.getEnclosedElements());
            TypeElement superClass = TypeElementVisitorProcessor.this.modelUtils.superClassFor(classElement);
            while (superClass != null && !TypeElementVisitorProcessor.this.modelUtils.isObjectClass(superClass)) {
                List<? extends Element> elements = superClass.getEnclosedElements();
                for (Element element : elements) {
                    if (element instanceof ExecutableElement) {
                        this.checkMethodOverride(enclosedElements, element);
                        continue;
                    }
                    if (!(element instanceof VariableElement)) continue;
                    this.checkFieldHide(enclosedElements, element);
                }
                superClass = TypeElementVisitorProcessor.this.modelUtils.superClassFor(superClass);
            }
            return enclosedElements;
        }

        private void checkFieldHide(List<Element> enclosedElements, Element elt1) {
            boolean hides = false;
            for (Element elt2 : enclosedElements) {
                if (elt1.equals(elt2) || !(elt2 instanceof VariableElement) || !TypeElementVisitorProcessor.this.elementUtils.hides(elt2, elt1)) continue;
                hides = true;
                break;
            }
            if (!hides) {
                enclosedElements.add(elt1);
            }
        }

        private void checkMethodOverride(List<Element> enclosedElements, Element elt1) {
            boolean overrides = false;
            for (Element elt2 : enclosedElements) {
                if (elt1.equals(elt2) || !(elt2 instanceof ExecutableElement) || !TypeElementVisitorProcessor.this.elementUtils.overrides((ExecutableElement)elt2, (ExecutableElement)elt1, TypeElementVisitorProcessor.this.modelUtils.classElementFor(elt2))) continue;
                overrides = true;
                break;
            }
            if (!overrides) {
                enclosedElements.add(elt1);
            }
        }

        @Override
        public Object visitExecutable(ExecutableElement executableElement, Object o) {
            if (this.javaClassElement == null) {
                return null;
            }
            if (executableElement.getSimpleName().toString().equals("<init>")) {
                JavaConstructorElement constructorElement = TypeElementVisitorProcessor.this.javaVisitorContext.getElementFactory().newConstructorElement((ClassElement)this.javaClassElement, executableElement, (ElementAnnotationMetadataFactory)TypeElementVisitorProcessor.this.javaVisitorContext.getElementAnnotationMetadataFactory());
                for (LoadedVisitor visitor : this.visitors) {
                    if (!visitor.matchesElement((AnnotationMetadata)constructorElement)) continue;
                    visitor.getVisitor().visitConstructor((ConstructorElement)constructorElement, (VisitorContext)TypeElementVisitorProcessor.this.javaVisitorContext);
                }
                return constructorElement;
            }
            JavaMethodElement methodElement = TypeElementVisitorProcessor.this.javaVisitorContext.getElementFactory().newSourceMethodElement((ClassElement)this.javaClassElement, executableElement, (ElementAnnotationMetadataFactory)TypeElementVisitorProcessor.this.javaVisitorContext.getElementAnnotationMetadataFactory());
            if (methodElement.getDeclaringType().isAssignable(Enum.class)) {
                return null;
            }
            for (LoadedVisitor visitor : this.visitors) {
                if (!visitor.matchesElement((AnnotationMetadata)methodElement)) continue;
                visitor.getVisitor().visitMethod((MethodElement)methodElement, (VisitorContext)TypeElementVisitorProcessor.this.javaVisitorContext);
            }
            return methodElement;
        }

        @Override
        public Object visitVariable(VariableElement variable, Object o) {
            if (variable.getKind() != ElementKind.FIELD) {
                return null;
            }
            if (variable.getKind() == ElementKind.ENUM_CONSTANT) {
                JavaEnumConstantElement constantElement = TypeElementVisitorProcessor.this.javaVisitorContext.getElementFactory().newEnumConstantElement((ClassElement)this.javaClassElement, variable, (ElementAnnotationMetadataFactory)TypeElementVisitorProcessor.this.javaVisitorContext.getElementAnnotationMetadataFactory());
                for (LoadedVisitor visitor : this.visitors) {
                    if (!visitor.matchesElement((AnnotationMetadata)constantElement)) continue;
                    visitor.getVisitor().visitEnumConstant((EnumConstantElement)constantElement, (VisitorContext)TypeElementVisitorProcessor.this.javaVisitorContext);
                }
                return constantElement;
            }
            JavaFieldElement fieldElement = TypeElementVisitorProcessor.this.javaVisitorContext.getElementFactory().newFieldElement((ClassElement)this.javaClassElement, variable, (ElementAnnotationMetadataFactory)TypeElementVisitorProcessor.this.javaVisitorContext.getElementAnnotationMetadataFactory());
            for (LoadedVisitor visitor : this.visitors) {
                if (!visitor.matchesElement((AnnotationMetadata)fieldElement)) continue;
                visitor.getVisitor().visitField((FieldElement)fieldElement, (VisitorContext)TypeElementVisitorProcessor.this.javaVisitorContext);
            }
            return fieldElement;
        }
    }
}

