/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.AbstractClassWriterOutputVisitor;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class AnnotationProcessingOutputVisitor
extends AbstractClassWriterOutputVisitor {
    private final Filer filer;
    private final Map<String, Optional<GeneratedFile>> metaInfFiles = new LinkedHashMap<String, Optional<GeneratedFile>>();
    private final Map<String, FileObject> openedFiles = new LinkedHashMap<String, FileObject>();
    private final Map<String, Optional<GeneratedFile>> generatedFiles = new LinkedHashMap<String, Optional<GeneratedFile>>();
    private final boolean isGradleFiler;

    public AnnotationProcessingOutputVisitor(Filer filer) {
        super(AnnotationProcessingOutputVisitor.isEclipseFiler(filer));
        String filerName;
        this.filer = filer;
        this.isGradleFiler = filer != null ? (filerName = filer.getClass().getName()).startsWith("org.gradle.api") || filerName.startsWith("org.jetbrains.kotlin.kapt3") : false;
    }

    private static boolean isEclipseFiler(Filer filer) {
        return filer != null && filer.getClass().getTypeName().startsWith("org.eclipse.jdt");
    }

    public OutputStream visitClass(String classname, @Nullable Element originatingElement) throws IOException {
        return this.visitClass(classname, new Element[]{originatingElement});
    }

    public OutputStream visitClass(String classname, Element ... originatingElements) throws IOException {
        javax.lang.model.element.Element[] nativeOriginatingElements;
        if (ArrayUtils.isNotEmpty((Object[])originatingElements)) {
            if (this.isGradleFiler) {
                Element e = originatingElements[0];
                Object nativeType = e.getNativeType();
                if (nativeType instanceof JavaNativeElement) {
                    JavaNativeElement javaNativeElement = (JavaNativeElement)nativeType;
                    nativeOriginatingElements = new javax.lang.model.element.Element[]{javaNativeElement.element()};
                } else {
                    nativeOriginatingElements = new javax.lang.model.element.Element[]{};
                }
            } else {
                ArrayList<javax.lang.model.element.Element> list = new ArrayList<javax.lang.model.element.Element>(originatingElements.length);
                for (Element originatingElement : originatingElements) {
                    Object nativeType = originatingElement.getNativeType();
                    if (!(nativeType instanceof JavaNativeElement)) continue;
                    JavaNativeElement javaNativeElement = (JavaNativeElement)nativeType;
                    list.add(javaNativeElement.element());
                }
                nativeOriginatingElements = list.toArray(new javax.lang.model.element.Element[0]);
            }
        } else {
            nativeOriginatingElements = new javax.lang.model.element.Element[]{};
        }
        JavaFileObject javaFileObject = this.filer.createClassFile(classname, nativeOriginatingElements);
        return javaFileObject.openOutputStream();
    }

    public void visitServiceDescriptor(String type, String classname, Element originatingElement) {
        String path = "META-INF/micronaut/" + type + "/" + classname;
        try {
            FileObject fileObject = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", path, ((JavaNativeElement)originatingElement.getNativeType()).element());
            try (Writer w = fileObject.openWriter();){
                w.write("");
            }
        }
        catch (IOException e) {
            throw new ClassGenerationException("Unable to generate Bean entry at path: " + path, (Throwable)e);
        }
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path, Element ... originatingElements) {
        return this.metaInfFiles.computeIfAbsent(path, s -> {
            String finalPath = "META-INF/" + path;
            javax.lang.model.element.Element[] nativeOriginatingElements = AnnotationProcessingOutputVisitor.toNativeOriginatingElements(originatingElements);
            return Optional.of(new GeneratedFileObject(finalPath, nativeOriginatingElements));
        });
    }

    private static javax.lang.model.element.Element[] toNativeOriginatingElements(Element[] originatingElements) {
        return (javax.lang.model.element.Element[])Arrays.stream(originatingElements).map(e -> ((JavaNativeElement)e.getNativeType()).element()).toArray(javax.lang.model.element.Element[]::new);
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return this.generatedFiles.computeIfAbsent(path, s -> Optional.of(new GeneratedFileObject(path, StandardLocation.SOURCE_OUTPUT, new javax.lang.model.element.Element[0])));
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path, Element ... originatingElements) {
        javax.lang.model.element.Element[] nativeOriginatingElements = AnnotationProcessingOutputVisitor.toNativeOriginatingElements(originatingElements);
        return this.generatedFiles.computeIfAbsent(path, s -> Optional.of(new GeneratedFileObject(path, StandardLocation.SOURCE_OUTPUT, nativeOriginatingElements)));
    }

    public Optional<GeneratedFile> visitGeneratedSourceFile(String packageName, String fileNameWithoutExtension, Element ... originatingElements) {
        javax.lang.model.element.Element[] nativeOriginatingElements = AnnotationProcessingOutputVisitor.toNativeOriginatingElements(originatingElements);
        String path = packageName.replace('.', File.separatorChar) + File.separator + fileNameWithoutExtension + ".java";
        return this.generatedFiles.computeIfAbsent(path, s -> Optional.of(new GeneratedFileObject(packageName, fileNameWithoutExtension, nativeOriginatingElements)));
    }

    class GeneratedFileObject
    implements GeneratedFile {
        private final String packageName;
        private final String fileName;
        private final String path;
        private final StandardLocation classOutput;
        private final javax.lang.model.element.Element[] originatingElements;
        private FileObject inputObject;
        private FileObject outputObject;

        GeneratedFileObject(String packageName, String fileName, javax.lang.model.element.Element ... originatingElements) {
            this.path = packageName.replace('.', File.separatorChar);
            this.packageName = packageName;
            this.fileName = fileName;
            this.classOutput = StandardLocation.SOURCE_OUTPUT;
            this.originatingElements = originatingElements;
        }

        GeneratedFileObject(String path, javax.lang.model.element.Element ... originatingElements) {
            this.path = path;
            this.classOutput = StandardLocation.CLASS_OUTPUT;
            this.originatingElements = originatingElements;
            this.packageName = null;
            this.fileName = null;
        }

        GeneratedFileObject(String path, StandardLocation location, javax.lang.model.element.Element ... originatingElements) {
            this.path = path;
            this.classOutput = location;
            this.originatingElements = originatingElements;
            this.packageName = null;
            this.fileName = null;
        }

        public URI toURI() {
            try {
                return this.getOutputObject().toUri();
            }
            catch (IOException e) {
                throw new ClassGenerationException("Unable to return URI for file object: " + this.path);
            }
        }

        public String getName() {
            return this.path;
        }

        public Writer openWriter() throws IOException {
            return this.getOutputObject().openWriter();
        }

        public OutputStream openOutputStream() throws IOException {
            return this.getOutputObject().openOutputStream();
        }

        public InputStream openInputStream() throws IOException {
            if (this.inputObject == null) {
                this.inputObject = this.openFileForReading(this.path);
            }
            return this.inputObject.openInputStream();
        }

        public Reader openReader() throws IOException {
            if (this.inputObject == null) {
                this.inputObject = this.openFileForReading(this.path);
            }
            return this.inputObject.openReader(true);
        }

        public CharSequence getTextContent() throws IOException {
            try {
                if (this.inputObject == null) {
                    this.inputObject = this.openFileForReading(this.path);
                }
                return this.inputObject.getCharContent(true);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        private FileObject openFileForReading(String path) {
            return AnnotationProcessingOutputVisitor.this.openedFiles.computeIfAbsent(path, s -> {
                try {
                    return AnnotationProcessingOutputVisitor.this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", path);
                }
                catch (IOException e) {
                    throw new ClassGenerationException("Unable to open file for path: " + path, (Throwable)e);
                }
            });
        }

        private FileObject getOutputObject() throws IOException {
            if (this.outputObject == null) {
                this.outputObject = this.packageName != null && this.fileName != null ? AnnotationProcessingOutputVisitor.this.filer.createSourceFile(this.packageName + "." + this.fileName, this.originatingElements) : AnnotationProcessingOutputVisitor.this.filer.createResource(this.classOutput, "", this.path, this.originatingElements);
            }
            return this.outputObject;
        }
    }
}

