/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.JavaElementAnnotationMetadataFactory;
import io.micronaut.annotation.processing.LoadedVisitor;
import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.VersionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations", "micronaut.processing.project.dir", "micronaut.processing.group", "micronaut.processing.module"})
public class TypeElementVisitorProcessor
extends AbstractInjectAnnotationProcessor {
    private static final SoftServiceLoader<TypeElementVisitor> SERVICE_LOADER = SoftServiceLoader.load(TypeElementVisitor.class, (ClassLoader)TypeElementVisitorProcessor.class.getClassLoader()).disableFork();
    private static final Set<String> VISITOR_WARNINGS;
    private static final Set<String> SUPPORTED_ANNOTATION_NAMES;
    private List<LoadedVisitor> loadedVisitors;
    private Collection<? extends TypeElementVisitor<?, ?>> typeElementVisitors;
    private final Set<String> pendingTypes = new LinkedHashSet<String>();

    static Set<String> getVisitedAnnotationNames() {
        return SUPPORTED_ANNOTATION_NAMES;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Collection<TypeElementVisitor<?, ?>> typeElementVisitors = this.findTypeElementVisitors();
        processingEnv.getOptions().entrySet().stream().filter(entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith("micronaut")).forEach(entry -> System.setProperty((String)entry.getKey(), entry.getValue() == null ? "" : (String)entry.getValue()));
        this.loadedVisitors = new ArrayList<LoadedVisitor>(typeElementVisitors.size());
        for (TypeElementVisitor<?, ?> visitor : typeElementVisitors) {
            TypeElementVisitor.VisitorKind visitorKind = visitor.getVisitorKind();
            TypeElementVisitor.VisitorKind incrementalProcessorKind = this.getIncrementalProcessorKind();
            if (incrementalProcessorKind != visitorKind) continue;
            try {
                this.loadedVisitors.add(new LoadedVisitor(visitor, processingEnv));
            }
            catch (NoClassDefFoundError | TypeNotPresentException throwable) {}
        }
        OrderUtil.reverseSort(this.loadedVisitors);
        for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
            try {
                loadedVisitor.getVisitor().start((VisitorContext)this.javaVisitorContext);
            }
            catch (Throwable e) {
                this.error("Error initializing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
            }
        }
    }

    protected boolean hasVisitors() {
        for (TypeElementVisitor<?, ?> typeElementVisitor : this.findTypeElementVisitors()) {
            if (typeElementVisitor.getVisitorKind() != this.getVisitorKind()) continue;
            return true;
        }
        return false;
    }

    protected List<LoadedVisitor> getLoadedVisitors() {
        return this.loadedVisitors;
    }

    protected TypeElementVisitor.VisitorKind getIncrementalProcessorKind() {
        String type = this.getIncrementalProcessorType();
        if (type.equals("org.gradle.annotation.processing.aggregating")) {
            return TypeElementVisitor.VisitorKind.AGGREGATING;
        }
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (this.loadedVisitors.isEmpty()) {
            return Collections.emptySet();
        }
        return super.getSupportedAnnotationTypes();
    }

    @Override
    public Set<String> getSupportedOptions() {
        Stream baseOption = super.getSupportedOptions().stream();
        Collection<TypeElementVisitor<?, ?>> typeElementVisitors = this.findTypeElementVisitors();
        Stream visitorsOptions = typeElementVisitors.stream().map(TypeElementVisitor::getSupportedOptions).flatMap(Collection::stream);
        Stream visitorsAnnotationsOptions = typeElementVisitors.stream().filter(tev -> tev.getClass().isAnnotationPresent(SupportedOptions.class)).map(Object::getClass).map(cls -> cls.getAnnotation(SupportedOptions.class)).flatMap(supportedOptions -> Arrays.stream(supportedOptions.value()));
        return Stream.of(baseOption, visitorsAnnotationsOptions, visitorsOptions).flatMap(BaseStream::sequential).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        List<AbstractBeanDefinitionBuilder> beanDefinitionBuilders;
        if (!(this.loadedVisitors.isEmpty() || annotations.size() == 1 && Generated.class.getName().equals(annotations.iterator().next().getQualifiedName().toString()))) {
            TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
            TypeMirror groovyObjectType = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
            Predicate<TypeElement> notGroovyObject = typeElement -> groovyObjectType == null || !this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType);
            LinkedHashSet elements = new LinkedHashSet();
            for (TypeElement typeElement2 : annotations) {
                this.modelUtils.resolveTypeElements(roundEnv.getElementsAnnotatedWith(typeElement2)).filter(notGroovyObject).forEach(elements::add);
            }
            this.modelUtils.resolveTypeElements(roundEnv.getRootElements()).filter(notGroovyObject).forEach(elements::add);
            this.pendingTypes.stream().map(this.elementUtils::getTypeElement).filter(Objects::nonNull).forEach(elements::add);
            this.pendingTypes.clear();
            if (!elements.isEmpty()) {
                JavaElementFactory elementFactory = this.javaVisitorContext.getElementFactory();
                JavaElementAnnotationMetadataFactory javaElementAnnotationMetadataFactory = this.javaVisitorContext.getElementAnnotationMetadataFactory();
                List<JavaClassElement> javaClassElements = elements.stream().map(typeElement -> elementFactory.newSourceClassElement((TypeElement)typeElement, (ElementAnnotationMetadataFactory)elementAnnotationMetadataFactory)).toList();
                for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
                    for (JavaClassElement javaClassElement : javaClassElements) {
                        try {
                            if (!loadedVisitor.matchesClass((AnnotationMetadata)javaClassElement)) continue;
                            this.visitClass(loadedVisitor, javaClassElement);
                        }
                        catch (ProcessingException e) {
                            JavaNativeElement originatingElement = (JavaNativeElement)e.getOriginatingElement();
                            if (originatingElement == null) {
                                originatingElement = javaClassElement.getNativeType();
                            }
                            this.error(originatingElement.element(), e.getMessage(), new Object[0]);
                        }
                        catch (PostponeToNextRoundException e) {
                            this.pendingTypes.add(javaClassElement.getName());
                        }
                    }
                }
            }
            for (LoadedVisitor loadedVisitor : this.loadedVisitors) {
                try {
                    loadedVisitor.getVisitor().finish((VisitorContext)this.javaVisitorContext);
                }
                catch (Throwable e) {
                    this.error("Error finalizing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(beanDefinitionBuilders = this.javaVisitorContext.getBeanElementBuilders())) {
            try {
                AbstractBeanDefinitionBuilder.writeBeanDefinitionBuilders((ClassWriterOutputVisitor)this.classWriterOutputVisitor, beanDefinitionBuilders);
            }
            catch (IOException e) {
                String message = e.getMessage();
                this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
            }
        }
        if (roundEnv.processingOver()) {
            this.javaVisitorContext.finish();
            this.writeBeanDefinitionsToMetaInf();
        }
        return false;
    }

    private void visitClass(LoadedVisitor visitor, JavaClassElement classElement) {
        visitor.getVisitor().visitClass((ClassElement)classElement, (VisitorContext)this.javaVisitorContext);
        for (ConstructorElement constructorElement : classElement.getSourceEnclosedElements(ElementQuery.CONSTRUCTORS)) {
            this.visitConstructor(visitor, constructorElement);
        }
        for (MemberElement memberElement : classElement.getSourceEnclosedElements(ElementQuery.ALL_FIELD_AND_METHODS)) {
            if (memberElement instanceof EnumConstantElement) {
                EnumConstantElement enumConstantElement = (EnumConstantElement)memberElement;
                this.visitEnumConstant(visitor, enumConstantElement);
                continue;
            }
            if (memberElement instanceof FieldElement) {
                FieldElement fieldElement = (FieldElement)memberElement;
                this.visitField(visitor, fieldElement);
                continue;
            }
            if (memberElement instanceof MethodElement) {
                MethodElement methodElement = (MethodElement)memberElement;
                this.visitMethod(visitor, methodElement);
                continue;
            }
            throw new IllegalStateException("Unknown element: " + memberElement);
        }
    }

    private void visitConstructor(LoadedVisitor visitor, ConstructorElement constructorElement) {
        if (visitor.matchesElement((AnnotationMetadata)constructorElement)) {
            visitor.getVisitor().visitConstructor(constructorElement, (VisitorContext)this.javaVisitorContext);
        }
    }

    private void visitMethod(LoadedVisitor visitor, MethodElement methodElement) {
        if (visitor.matchesElement((AnnotationMetadata)methodElement)) {
            visitor.getVisitor().visitMethod(methodElement, (VisitorContext)this.javaVisitorContext);
        }
    }

    private void visitEnumConstant(LoadedVisitor visitor, EnumConstantElement enumConstantElement) {
        if (visitor.matchesElement((AnnotationMetadata)enumConstantElement)) {
            visitor.getVisitor().visitEnumConstant(enumConstantElement, (VisitorContext)this.javaVisitorContext);
        }
    }

    private void visitField(LoadedVisitor visitor, FieldElement fieldElement) {
        if (visitor.matchesElement((AnnotationMetadata)fieldElement)) {
            visitor.getVisitor().visitField(fieldElement, (VisitorContext)this.javaVisitorContext);
        }
    }

    @NonNull
    protected synchronized Collection<? extends TypeElementVisitor<?, ?>> findTypeElementVisitors() {
        if (this.typeElementVisitors == null) {
            for (String visitorWarning : VISITOR_WARNINGS) {
                this.warning(visitorWarning, new Object[0]);
            }
            this.typeElementVisitors = TypeElementVisitorProcessor.findCoreTypeElementVisitors(null);
        }
        return this.typeElementVisitors;
    }

    private void writeBeanDefinitionsToMetaInf() {
        try {
            this.classWriterOutputVisitor.finish();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.error("Error occurred writing META-INF files: %s", message != null ? message : e);
        }
    }

    @NonNull
    private static Collection<? extends TypeElementVisitor<?, ?>> findCoreTypeElementVisitors(@Nullable Set<String> warnings) {
        return SERVICE_LOADER.collectAll(visitor -> {
            String version;
            Requires.Sdk sdk;
            if (!visitor.isEnabled()) {
                return false;
            }
            Requires requires = visitor.getClass().getAnnotation(Requires.class);
            if (requires != null && (sdk = requires.sdk()) == Requires.Sdk.MICRONAUT && StringUtils.isNotEmpty((CharSequence)(version = requires.version())) && !VersionUtils.isAtLeastMicronautVersion((String)version)) {
                try {
                    if (warnings != null) {
                        warnings.add("TypeElementVisitor [" + visitor.getClass().getName() + "] will be ignored because Micronaut version [" + VersionUtils.MICRONAUT_VERSION + "] must be at least " + version);
                    }
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return true;
        }).stream().filter(Objects::nonNull).map(e -> e).collect(Collectors.toMap(Object::getClass, v -> v, (a, b) -> a)).values();
    }

    static {
        HashSet<String> warnings = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (TypeElementVisitor<?, ?> typeElementVisitor : TypeElementVisitorProcessor.findCoreTypeElementVisitors(warnings)) {
            Set supportedAnnotationNames;
            try {
                supportedAnnotationNames = typeElementVisitor.getSupportedAnnotationNames();
            }
            catch (Throwable e) {
                continue;
            }
            if (supportedAnnotationNames.equals(Collections.singleton("*"))) continue;
            names.addAll(supportedAnnotationNames);
        }
        SUPPORTED_ANNOTATION_NAMES = names;
        VISITOR_WARNINGS = warnings.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(warnings);
    }
}

