/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaParameterElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.annotation.AbstractAnnotationElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.MethodElementAnnotationsHelper;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

@Internal
public class JavaMethodElement
extends AbstractJavaElement
implements MethodElement {
    protected final JavaClassElement owningType;
    protected final ExecutableElement executableElement;
    private JavaClassElement resolvedDeclaringClass;
    private ParameterElement[] parameters;
    private ParameterElement continuationParameter;
    private ClassElement genericReturnType;
    private ClassElement returnType;
    private Map<String, ClassElement> typeArguments;
    private Map<String, ClassElement> declaredTypeArguments;
    private final MethodElementAnnotationsHelper helper;

    public JavaMethodElement(JavaClassElement owningType, JavaNativeElement.Method nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext) {
        super(nativeElement, annotationMetadataFactory, visitorContext);
        this.executableElement = nativeElement.element();
        this.owningType = owningType;
        this.helper = new MethodElementAnnotationsHelper((AbstractAnnotationElement)this, annotationMetadataFactory);
    }

    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        return this.helper.getMethodAnnotationMetadata(this.presetAnnotationMetadata);
    }

    public ElementAnnotationMetadata getMethodAnnotationMetadata() {
        return this.helper.getMethodAnnotationMetadata(this.presetAnnotationMetadata);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.helper.getAnnotationMetadata(this.presetAnnotationMetadata);
    }

    @Override
    public JavaNativeElement.Method getNativeType() {
        return (JavaNativeElement.Method)super.getNativeType();
    }

    @Override
    protected AbstractJavaElement copyThis() {
        return new JavaMethodElement(this.owningType, this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext);
    }

    @Override
    protected void copyValues(AbstractJavaElement element) {
        super.copyValues(element);
        ((JavaMethodElement)element).parameters = this.parameters;
    }

    public MethodElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (MethodElement)super.withAnnotationMetadata(annotationMetadata);
    }

    public MethodElement withParameters(ParameterElement ... parameters) {
        JavaMethodElement methodElement = (JavaMethodElement)this.makeCopy();
        methodElement.parameters = parameters;
        return methodElement;
    }

    public Optional<ClassElement> getReceiverType() {
        TypeMirror receiverType = this.executableElement.getReceiverType();
        if (receiverType != null && receiverType.getKind() != TypeKind.NONE) {
            ClassElement classElement = this.newClassElement(receiverType, this.getDeclaringType().getTypeArguments());
            return Optional.of(classElement);
        }
        return Optional.empty();
    }

    @NonNull
    public ClassElement[] getThrownTypes() {
        List<? extends TypeMirror> thrownTypes = this.executableElement.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            return (ClassElement[])thrownTypes.stream().map(tm -> this.newClassElement((TypeMirror)tm, this.getDeclaringType().getTypeArguments())).toArray(ClassElement[]::new);
        }
        return ClassElement.ZERO_CLASS_ELEMENTS;
    }

    public boolean isDefault() {
        return this.executableElement.isDefault();
    }

    public boolean isVarArgs() {
        return this.executableElement.isVarArgs();
    }

    public boolean overrides(MethodElement overridden) {
        if (this.equals(overridden) || this.isStatic() || overridden.isStatic() || this.isPrivate() || overridden.isPrivate()) {
            return false;
        }
        if (overridden instanceof JavaMethodElement) {
            JavaMethodElement javaMethodElement = (JavaMethodElement)overridden;
            if (this.isPackagePrivate() && overridden.isPackagePrivate()) {
                return super.overrides(overridden);
            }
            return this.visitorContext.getElements().overrides(this.executableElement, javaMethodElement.executableElement, this.owningType.classElement);
        }
        return super.overrides(overridden);
    }

    public boolean isSubSignature(MethodElement element) {
        if (element instanceof JavaMethodElement) {
            JavaMethodElement javaMethodElement = (JavaMethodElement)element;
            return this.visitorContext.getTypes().isSubsignature((ExecutableType)this.executableElement.asType(), (ExecutableType)javaMethodElement.executableElement.asType());
        }
        return super.isSubSignature(element);
    }

    public boolean hides(MethodElement hiddenMethod) {
        if (this.isStatic() && this.getDeclaringType().isInterface()) {
            return false;
        }
        if (hiddenMethod instanceof JavaMethodElement) {
            JavaMethodElement javaMethodElement = (JavaMethodElement)hiddenMethod;
            return this.visitorContext.getElements().hides(this.getNativeType().element(), javaMethodElement.getNativeType().element());
        }
        return super.hides(hiddenMethod);
    }

    @NonNull
    public ClassElement getGenericReturnType() {
        if (this.genericReturnType == null) {
            this.genericReturnType = this.returnType(this.getDeclaringType().getTypeArguments());
        }
        return this.genericReturnType;
    }

    @NonNull
    public ClassElement getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.returnType(Collections.emptyMap());
        }
        return this.returnType;
    }

    public List<? extends GenericPlaceholderElement> getDeclaredTypeVariables() {
        return this.executableElement.getTypeParameters().stream().map(tpe -> (GenericPlaceholderElement)this.newClassElement(tpe.asType(), Collections.emptyMap())).toList();
    }

    public Map<String, ClassElement> getTypeArguments() {
        if (this.typeArguments == null) {
            this.typeArguments = super.getTypeArguments();
        }
        return this.typeArguments;
    }

    public Map<String, ClassElement> getDeclaredTypeArguments() {
        if (this.declaredTypeArguments == null) {
            this.declaredTypeArguments = this.resolveTypeArguments(this.executableElement, this.getDeclaringType().getTypeArguments());
        }
        return this.declaredTypeArguments;
    }

    public boolean isSuspend() {
        this.getParameters();
        return this.continuationParameter != null;
    }

    public ParameterElement[] getParameters() {
        if (this.parameters == null) {
            List<? extends VariableElement> parameters = this.executableElement.getParameters();
            ArrayList<JavaParameterElement> elts = new ArrayList<JavaParameterElement>(parameters.size());
            Iterator<? extends VariableElement> i = parameters.iterator();
            while (i.hasNext()) {
                VariableElement variableElement = i.next();
                if (!i.hasNext() && this.isSuspend(variableElement)) {
                    this.continuationParameter = this.newParameterElement(this, variableElement);
                    continue;
                }
                elts.add(this.newParameterElement(this, variableElement));
            }
            this.parameters = elts.toArray(new ParameterElement[0]);
        }
        return this.parameters;
    }

    public MethodElement withNewOwningType(ClassElement owningType) {
        JavaMethodElement javaMethodElement = new JavaMethodElement((JavaClassElement)owningType, this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext);
        this.copyValues(javaMethodElement);
        return javaMethodElement;
    }

    public ParameterElement[] getSuspendParameters() {
        Object[] parameters = this.getParameters();
        if (this.isSuspend()) {
            return (ParameterElement[])ArrayUtils.concat((Object[])parameters, (Object[])new ParameterElement[]{this.continuationParameter});
        }
        return parameters;
    }

    @NonNull
    protected JavaParameterElement newParameterElement(@NonNull MethodElement methodElement, @NonNull VariableElement variableElement) {
        return new JavaParameterElement(this.owningType, methodElement, new JavaNativeElement.Variable(variableElement), this.elementAnnotationMetadataFactory, this.visitorContext);
    }

    public JavaClassElement getDeclaringType() {
        if (this.resolvedDeclaringClass == null) {
            Element enclosingElement = this.executableElement.getEnclosingElement();
            if (enclosingElement instanceof TypeElement) {
                TypeElement te = (TypeElement)enclosingElement;
                String typeName = te.getQualifiedName().toString();
                if (this.owningType.getName().equals(typeName)) {
                    this.resolvedDeclaringClass = this.owningType;
                } else {
                    Map parentTypeArguments = this.owningType.getTypeArguments(typeName);
                    this.resolvedDeclaringClass = (JavaClassElement)this.newClassElement(te.asType(), parentTypeArguments);
                }
            } else {
                return this.owningType;
            }
        }
        return this.resolvedDeclaringClass;
    }

    public ClassElement getOwningType() {
        return this.owningType;
    }

    private ClassElement returnType(Map<String, ClassElement> genericInfo) {
        VariableElement varElement = (VariableElement)CollectionUtils.last(this.executableElement.getParameters());
        if (this.isSuspend(varElement)) {
            DeclaredType dt;
            DeclaredType dType = (DeclaredType)varElement.asType();
            TypeMirror tm = dType.getTypeArguments().iterator().next();
            if (tm.getKind() == TypeKind.WILDCARD) {
                tm = ((WildcardType)tm).getSuperBound();
            }
            if (tm instanceof DeclaredType && JavaMethodElement.sameType("kotlin.Unit", dt = (DeclaredType)tm)) {
                return PrimitiveElement.VOID;
            }
            return this.newClassElement(tm, genericInfo);
        }
        TypeMirror returnType = this.executableElement.getReturnType();
        return this.newClassElement(this.getNativeType(), returnType, genericInfo);
    }

    private static boolean sameType(String type, DeclaredType dt) {
        TypeElement te;
        Element elt = dt.asElement();
        return elt instanceof TypeElement && type.equals((te = (TypeElement)elt).getQualifiedName().toString());
    }

    private boolean isSuspend(VariableElement ve) {
        TypeMirror typeMirror;
        if (ve != null && (typeMirror = ve.asType()) instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)typeMirror;
            return JavaMethodElement.sameType("kotlin.coroutines.Continuation", dt);
        }
        return false;
    }

    public Collection<MethodElement> getOverriddenMethods() {
        return this.visitorContext.getNativeElementsHelper().findOverriddenMethods(this.owningType.classElement, this.executableElement).stream().map(overriddenMethod -> new JavaMethodElement(this.owningType, new JavaNativeElement.Method((ExecutableElement)overriddenMethod), this.elementAnnotationMetadataFactory, this.visitorContext)).collect(Collectors.toList());
    }
}

