/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.JavaNativeElementsHelper;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class JavaAnnotationMetadataBuilder
extends AbstractAnnotationMetadataBuilder<Element, AnnotationMirror> {
    private final Elements elementUtils;
    private final Messager messager;
    private final ModelUtils modelUtils;
    private final JavaNativeElementsHelper nativeElementsHelper;
    private final JavaVisitorContext visitorContext;

    @Deprecated(forRemoval=true, since="4.3.0")
    public JavaAnnotationMetadataBuilder(Elements elements, Messager messager, AnnotationUtils annotationUtils, ModelUtils modelUtils) {
        this(elements, messager, modelUtils, new JavaNativeElementsHelper(elements, modelUtils.getTypeUtils()), annotationUtils.newVisitorContext());
    }

    public JavaAnnotationMetadataBuilder(Elements elements, Messager messager, ModelUtils modelUtils, JavaNativeElementsHelper nativeElementsHelper, JavaVisitorContext visitorContext) {
        this.elementUtils = elements;
        this.messager = messager;
        this.modelUtils = modelUtils;
        this.nativeElementsHelper = nativeElementsHelper;
        this.visitorContext = visitorContext;
    }

    protected void addError(@NonNull Element originatingElement, @NonNull String error) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, error, originatingElement);
    }

    protected void addWarning(@NonNull Element originatingElement, @NonNull String warning) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, warning, originatingElement);
    }

    protected String getAnnotationMemberName(Element member) {
        return member.getSimpleName().toString();
    }

    @Nullable
    protected String getRepeatableName(AnnotationMirror annotationMirror) {
        Element typeElement = annotationMirror.getAnnotationType().asElement();
        return this.getRepeatableContainerNameForType(typeElement);
    }

    @Nullable
    protected String getRepeatableContainerNameForType(Element annotationType) {
        List<? extends AnnotationMirror> mirrors = annotationType.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            String name = annotationMirror.getAnnotationType().toString();
            if (!Repeatable.class.getName().equals(name)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                AnnotationValue av;
                Object value;
                if (!entry.getKey().getSimpleName().toString().equals("value") || !((value = (av = entry.getValue()).getValue()) instanceof DeclaredType)) continue;
                DeclaredType type = (DeclaredType)value;
                Element element = type.asElement();
                return JavaModelUtils.getClassName((TypeElement)((TypeElement)element));
            }
        }
        return null;
    }

    protected Optional<Element> getAnnotationMirror(String annotationName) {
        TypeElement typeElement = this.elementUtils.getTypeElement(annotationName);
        if (typeElement == null) {
            typeElement = this.elementUtils.getTypeElement(annotationName.replace('$', '.'));
        }
        return Optional.ofNullable(typeElement);
    }

    protected VisitorContext getVisitorContext() {
        return this.visitorContext;
    }

    @NonNull
    protected RetentionPolicy getRetentionPolicy(@NonNull Element annotation) {
        List<? extends AnnotationMirror> annotationMirrors = annotation.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
            if (!Retention.class.getName().equals(annotationTypeName)) continue;
            Iterator<? extends AnnotationValue> i = annotationMirror.getElementValues().values().iterator();
            if (!i.hasNext()) break;
            AnnotationValue av = i.next();
            String v = av.getValue().toString();
            return RetentionPolicy.valueOf(v);
        }
        return RetentionPolicy.RUNTIME;
    }

    protected Element getTypeForAnnotation(AnnotationMirror annotationMirror) {
        return annotationMirror.getAnnotationType().asElement();
    }

    protected List<? extends AnnotationMirror> getAnnotationsForType(Element element) {
        ArrayList<AnnotationMirror> expanded = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            boolean repeatable = false;
            boolean hasOtherMembers = false;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (entry.getKey().getSimpleName().toString().equals("value")) {
                    Object value = entry.getValue().getValue();
                    if (!(value instanceof List)) continue;
                    List list = (List)value;
                    String parentAnnotationName = this.getAnnotationTypeName(annotationMirror);
                    for (Object val : list) {
                        AnnotationMirror mirror;
                        String name;
                        if (!(val instanceof AnnotationMirror) || (name = this.getRepeatableName(mirror = (AnnotationMirror)val)) == null || !name.equals(parentAnnotationName)) continue;
                        repeatable = true;
                        expanded.add(mirror);
                    }
                    continue;
                }
                hasOtherMembers = true;
            }
            if (repeatable && !hasOtherMembers) continue;
            expanded.add(annotationMirror);
        }
        return expanded;
    }

    protected boolean isExcludedAnnotation(@NonNull Element element, @NonNull String annotationName) {
        if (annotationName.startsWith("java.lang.annotation") && element.getKind() == ElementKind.ANNOTATION_TYPE) {
            return false;
        }
        return super.isExcludedAnnotation((Object)element, annotationName);
    }

    protected List<Element> buildHierarchy(Element element, boolean inheritTypeAnnotations, boolean declaredOnly) {
        if (declaredOnly) {
            ArrayList<Element> onlyDeclared = new ArrayList<Element>(1);
            onlyDeclared.add(element);
            return onlyDeclared;
        }
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            ArrayList<Element> hierarchy = new ArrayList<Element>();
            if (element.getKind() == ElementKind.ANNOTATION_TYPE) {
                hierarchy.add(typeElement);
            } else {
                this.nativeElementsHelper.populateTypeHierarchy(typeElement, hierarchy);
            }
            return hierarchy;
        }
        if (element instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)element;
            List<Object> hierarchy = inheritTypeAnnotations ? this.buildHierarchy(executableElement.getEnclosingElement(), false, declaredOnly) : new ArrayList<ExecutableElement>();
            hierarchy.addAll(this.nativeElementsHelper.findOverriddenMethods(executableElement));
            hierarchy.add(element);
            return hierarchy;
        }
        if (element instanceof VariableElement) {
            VariableElement variable = (VariableElement)element;
            ArrayList<Element> hierarchy = new ArrayList<Element>();
            Element enclosingElement = variable.getEnclosingElement();
            if (enclosingElement instanceof ExecutableElement) {
                ExecutableElement executableElement = (ExecutableElement)enclosingElement;
                int variableIdx = executableElement.getParameters().indexOf(variable);
                for (ExecutableElement overridden : this.nativeElementsHelper.findOverriddenMethods(executableElement)) {
                    hierarchy.add(overridden.getParameters().get(variableIdx));
                }
            }
            hierarchy.add(variable);
            return hierarchy;
        }
        ArrayList<Element> single = new ArrayList<Element>(1);
        single.add(element);
        return single;
    }

    protected Map<? extends Element, ?> readAnnotationRawValues(AnnotationMirror annotationMirror) {
        return annotationMirror.getElementValues();
    }

    @Nullable
    protected Element getAnnotationMember(Element annotationElement, CharSequence member) {
        if (annotationElement instanceof TypeElement) {
            List<? extends Element> enclosedElements = annotationElement.getEnclosedElements();
            for (Element element : enclosedElements) {
                if (!(element instanceof ExecutableElement) || !element.getSimpleName().toString().equals(member.toString())) continue;
                return element;
            }
        }
        return null;
    }

    protected String getOriginatingClassName(@NonNull Element orginatingElement) {
        TypeElement typeElement = this.getOriginatingTypeElement(orginatingElement);
        if (typeElement != null) {
            return JavaModelUtils.getClassName((TypeElement)typeElement);
        }
        return null;
    }

    private TypeElement getOriginatingTypeElement(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return typeElement;
        }
        return this.getOriginatingTypeElement(element.getEnclosingElement());
    }

    protected <K extends Annotation> Optional<io.micronaut.core.annotation.AnnotationValue<K>> getAnnotationValues(Element originatingElement, Element member, Class<K> annotationType) {
        List<? extends AnnotationMirror> annotationMirrors = member.getAnnotationMirrors();
        String annotationName = annotationType.getName();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().endsWith(annotationName)) continue;
            Map<Element, ?> values = this.readAnnotationRawValues(annotationMirror);
            LinkedHashMap<CharSequence, Object> converted = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<Element, ?> entry : values.entrySet()) {
                Element key = entry.getKey();
                Object value = entry.getValue();
                this.readAnnotationRawValues(originatingElement, annotationName, key, key.getSimpleName().toString(), value, converted);
            }
            return Optional.of(io.micronaut.core.annotation.AnnotationValue.builder(annotationType).members(converted).build());
        }
        return Optional.empty();
    }

    protected void readAnnotationRawValues(Element originatingElement, String annotationName, Element member, String memberName, Object annotationValue, Map<CharSequence, Object> annotationValues) {
        this.readAnnotationRawValues(originatingElement, annotationName, member, memberName, annotationValue, annotationValues, new HashMap<String, Map<CharSequence, Object>>());
    }

    protected void readAnnotationRawValues(Element originatingElement, String annotationName, Element member, String memberName, Object annotationValue, Map<CharSequence, Object> annotationValues, Map<String, Map<CharSequence, Object>> resolvedDefaults) {
        if (memberName != null && annotationValue instanceof AnnotationValue) {
            AnnotationValue value = (AnnotationValue)annotationValue;
            if (!annotationValues.containsKey(memberName)) {
                MetadataAnnotationValueVisitor resolver = new MetadataAnnotationValueVisitor(originatingElement, (ExecutableElement)member, resolvedDefaults);
                value.accept(resolver, this);
                Object resolvedValue = resolver.resolvedValue;
                if (resolvedValue != null) {
                    if (this.isEvaluatedExpression(resolvedValue)) {
                        resolvedValue = this.buildEvaluatedExpressionReference(originatingElement, annotationName, memberName, resolvedValue);
                    }
                    this.validateAnnotationValue(originatingElement, annotationName, member, memberName, resolvedValue);
                    annotationValues.put(memberName, resolvedValue);
                }
            }
        }
    }

    protected boolean isValidationRequired(Element member) {
        List<? extends AnnotationMirror> annotationMirrors = member.getAnnotationMirrors();
        return this.isValidationRequired(annotationMirrors);
    }

    private boolean isValidationRequired(List<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            List childMirrors;
            Element element;
            String annotationName = this.getAnnotationTypeName(annotationMirror);
            if (annotationName.startsWith("jakarta.validation")) {
                return true;
            }
            if (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName) || (element = (Element)this.getAnnotationMirror(annotationName).orElse(null)) == null || !this.isValidationRequired(childMirrors = element.getAnnotationMirrors().stream().filter(ann -> !this.getAnnotationTypeName((AnnotationMirror)ann).equals(annotationName)).collect(Collectors.toList()))) continue;
            return true;
        }
        return false;
    }

    protected Object readAnnotationValue(Element originatingElement, Element member, String annotationName, String memberName, Object annotationValue) {
        if (memberName != null && annotationValue instanceof AnnotationValue) {
            AnnotationValue value = (AnnotationValue)annotationValue;
            MetadataAnnotationValueVisitor visitor = new MetadataAnnotationValueVisitor(originatingElement, (ExecutableElement)member, new HashMap<String, Map<CharSequence, Object>>());
            value.accept(visitor, this);
            return visitor.resolvedValue;
        }
        if (memberName != null && annotationValue != null && ClassUtils.isJavaLangType(annotationValue.getClass())) {
            if (this.isEvaluatedExpression(annotationValue)) {
                annotationValue = this.buildEvaluatedExpressionReference(originatingElement, annotationName, memberName, annotationValue);
            }
            return annotationValue;
        }
        return null;
    }

    protected Map<? extends Element, ?> readAnnotationDefaultValues(String annotationTypeName, Element element) {
        LinkedHashMap defaultValues = new LinkedHashMap();
        if (element instanceof TypeElement) {
            TypeElement annotationElement = (TypeElement)element;
            List<? extends Element> allMembers = this.elementUtils.getAllMembers(annotationElement);
            allMembers.stream().filter(member -> member.getEnclosingElement().equals(annotationElement)).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(this::isValidDefaultValue).forEach(executableElement -> {
                AnnotationValue defaultValue = executableElement.getDefaultValue();
                defaultValues.put(executableElement, defaultValue);
            });
        }
        return defaultValues;
    }

    private boolean isValidDefaultValue(ExecutableElement executableElement) {
        Object v;
        AnnotationValue defaultValue = executableElement.getDefaultValue();
        if (defaultValue != null && (v = defaultValue.getValue()) != null) {
            if (v instanceof String) {
                String string = (String)v;
                return StringUtils.isNotEmpty((CharSequence)string);
            }
            return true;
        }
        return false;
    }

    protected String getAnnotationTypeName(AnnotationMirror annotationMirror) {
        return JavaModelUtils.getClassName((TypeElement)((TypeElement)annotationMirror.getAnnotationType().asElement()));
    }

    protected String getElementName(Element element) {
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return this.elementUtils.getBinaryName(typeElement).toString();
        }
        return element.getSimpleName().toString();
    }

    public boolean hasAnnotation(Element element, Class<? extends Annotation> ann) {
        return this.hasAnnotation(element, ann.getName());
    }

    public boolean hasAnnotation(Element element, String ann) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        if (CollectionUtils.isNotEmpty(annotationMirrors)) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (!annotationType.toString().equals(ann)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasAnnotations(Element element) {
        return CollectionUtils.isNotEmpty(element.getAnnotationMirrors());
    }

    public static void clearCaches() {
        AbstractAnnotationMetadataBuilder.clearCaches();
    }

    public static boolean hasAnnotation(ExecutableElement method, Class<? extends Annotation> ann) {
        List<? extends AnnotationMirror> annotationMirrors = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(ann.getName())) continue;
            return true;
        }
        return false;
    }

    private class MetadataAnnotationValueVisitor
    extends AbstractAnnotationValueVisitor8<Object, Object> {
        private final Element originatingElement;
        private final ExecutableElement member;
        private Object resolvedValue;
        private final Map<String, Map<CharSequence, Object>> resolvedDefaults;

        MetadataAnnotationValueVisitor(Element originatingElement, ExecutableElement member, Map<String, Map<CharSequence, Object>> resolvedDefaults) {
            this.originatingElement = originatingElement;
            this.member = member;
            this.resolvedDefaults = resolvedDefaults;
        }

        @Override
        public Object visitBoolean(boolean b, Object o) {
            this.resolvedValue = b;
            return null;
        }

        @Override
        public Object visitByte(byte b, Object o) {
            this.resolvedValue = b;
            return null;
        }

        @Override
        public Object visitChar(char c, Object o) {
            this.resolvedValue = Character.valueOf(c);
            return null;
        }

        @Override
        public Object visitDouble(double d, Object o) {
            this.resolvedValue = d;
            return null;
        }

        @Override
        public Object visitFloat(float f, Object o) {
            this.resolvedValue = Float.valueOf(f);
            return null;
        }

        @Override
        public Object visitInt(int i, Object o) {
            this.resolvedValue = i;
            return null;
        }

        @Override
        public Object visitLong(long i, Object o) {
            this.resolvedValue = i;
            return null;
        }

        @Override
        public Object visitShort(short s, Object o) {
            this.resolvedValue = s;
            return null;
        }

        @Override
        public Object visitString(String s, Object o) {
            this.resolvedValue = s;
            return null;
        }

        @Override
        public Object visitType(TypeMirror t, Object o) {
            DeclaredType type;
            Element typeElement;
            if (t instanceof DeclaredType && (typeElement = (type = (DeclaredType)t).asElement()) instanceof TypeElement) {
                TypeElement element = (TypeElement)typeElement;
                String className = JavaModelUtils.getClassName((TypeElement)element);
                this.resolvedValue = new AnnotationClassValue(className);
            }
            return null;
        }

        @Override
        public Object visitEnumConstant(VariableElement c, Object o) {
            this.resolvedValue = c.toString();
            return null;
        }

        @Override
        public Object visitAnnotation(AnnotationMirror a, Object o) {
            if (a instanceof AnnotationValue) {
                this.resolvedValue = JavaAnnotationMetadataBuilder.this.readNestedAnnotationValue(this.originatingElement, a, this.resolvedDefaults);
            }
            return null;
        }

        @Override
        public Object visitArray(List<? extends AnnotationValue> vals, Object o) {
            ArrayValueVisitor arrayValueVisitor = new ArrayValueVisitor(this.member);
            for (AnnotationValue annotationValue : vals) {
                annotationValue.accept(arrayValueVisitor, o);
            }
            this.resolvedValue = arrayValueVisitor.getValues();
            return null;
        }

        private final class ArrayValueVisitor
        extends AbstractAnnotationValueVisitor8<Object, Object> {
            private final List<Object> values = new ArrayList<Object>();
            private final ExecutableElement member;

            private ArrayValueVisitor(ExecutableElement member) {
                this.member = member;
            }

            Object getValues() {
                Element element;
                Types typeUtils = JavaAnnotationMetadataBuilder.this.modelUtils.getTypeUtils();
                TypeMirror methodReturnType = this.member.getReturnType();
                if (methodReturnType instanceof NullType) {
                    return null;
                }
                if (!(methodReturnType instanceof ArrayType)) {
                    throw new IllegalStateException("Expected an array got: " + methodReturnType + " " + MetadataAnnotationValueVisitor.this.originatingElement + " " + this.member);
                }
                ArrayType at = (ArrayType)methodReturnType;
                TypeMirror arrayType = at.getComponentType();
                Class type = ClassUtils.getPrimitiveType((String)arrayType.toString()).orElse(null);
                if (type == null && (element = typeUtils.asElement(arrayType)) != null) {
                    type = element.getKind() == ElementKind.ENUM ? String.class : (element.getKind() == ElementKind.ANNOTATION_TYPE ? io.micronaut.core.annotation.AnnotationValue.class : (Class.class.getName().equals(element.toString()) ? AnnotationClassValue.class : (Class)ClassUtils.forName((String)element.toString(), (ClassLoader)this.getClass().getClassLoader()).orElse(null)));
                }
                if (type == null) {
                    throw new IllegalStateException("Cannot determine the type of: " + methodReturnType);
                }
                if ((type = ReflectionUtils.getPrimitiveType((Class)type)).isPrimitive()) {
                    Class wrapperType = ReflectionUtils.getWrapperType((Class)type);
                    Class<?> primitiveArrayType = Array.newInstance(type, 0).getClass();
                    Object[] emptyWrapperArray = (Object[])Array.newInstance(wrapperType, 0);
                    Object[] wrapperArray = this.values.toArray(emptyWrapperArray);
                    return ConversionService.SHARED.convertRequired((Object)wrapperArray, primitiveArrayType);
                }
                return ConversionService.SHARED.convertRequired(this.values, Array.newInstance(type, 0).getClass());
            }

            @Override
            public Object visitBoolean(boolean b, Object o) {
                this.values.add(b);
                return null;
            }

            @Override
            public Object visitByte(byte b, Object o) {
                this.values.add(b);
                return null;
            }

            @Override
            public Object visitChar(char c, Object o) {
                this.values.add(Character.valueOf(c));
                return null;
            }

            @Override
            public Object visitDouble(double d, Object o) {
                this.values.add(d);
                return null;
            }

            @Override
            public Object visitFloat(float f, Object o) {
                this.values.add(Float.valueOf(f));
                return null;
            }

            @Override
            public Object visitInt(int i, Object o) {
                this.values.add(i);
                return null;
            }

            @Override
            public Object visitLong(long i, Object o) {
                this.values.add(i);
                return null;
            }

            @Override
            public Object visitShort(short s, Object o) {
                this.values.add(s);
                return null;
            }

            @Override
            public Object visitString(String s, Object o) {
                this.values.add(s);
                return null;
            }

            @Override
            public Object visitType(TypeMirror t, Object o) {
                DeclaredType declaredType;
                Element typeElement;
                ArrayType arrayType;
                TypeMirror componentType;
                if (t instanceof DeclaredType) {
                    DeclaredType type = (DeclaredType)t;
                    Element typeElement2 = type.asElement();
                    if (typeElement2 instanceof TypeElement) {
                        TypeElement element = (TypeElement)typeElement2;
                        String className = JavaModelUtils.getClassName((TypeElement)element);
                        this.values.add(new AnnotationClassValue(className));
                    }
                } else if (t instanceof ArrayType && (componentType = (arrayType = (ArrayType)t).getComponentType()) instanceof DeclaredType && (typeElement = (declaredType = (DeclaredType)componentType).asElement()) instanceof TypeElement) {
                    TypeElement element = (TypeElement)typeElement;
                    String className = JavaModelUtils.getClassArrayName((TypeElement)element);
                    this.values.add(new AnnotationClassValue(className));
                }
                return null;
            }

            @Override
            public Object visitEnumConstant(VariableElement c, Object o) {
                this.values.add(c.getSimpleName().toString());
                return null;
            }

            @Override
            public Object visitAnnotation(AnnotationMirror a, Object o) {
                io.micronaut.core.annotation.AnnotationValue annotationValue = JavaAnnotationMetadataBuilder.this.readNestedAnnotationValue(MetadataAnnotationValueVisitor.this.originatingElement, a, MetadataAnnotationValueVisitor.this.resolvedDefaults);
                this.values.add(annotationValue);
                return null;
            }

            @Override
            public Object visitArray(List<? extends AnnotationValue> vals, Object o) {
                return null;
            }
        }
    }
}

