/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaPackageElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.ast.utils.AstBeanPropertiesUtils;
import io.micronaut.inject.ast.utils.EnclosedElementsQuery;
import io.micronaut.inject.processing.JavaModelUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

@Internal
public class JavaClassElement
extends AbstractJavaElement
implements ArrayableClassElement {
    private static final String KOTLIN_METADATA = "kotlin.Metadata";
    private static final String PREFIX_IS = "is";
    protected final TypeElement classElement;
    protected final int arrayDimensions;
    @Nullable
    final List<? extends TypeMirror> typeArguments;
    private final boolean isTypeVariable;
    private List<PropertyElement> beanProperties;
    private String simpleName;
    private String name;
    private String packageName;
    @Nullable
    private Map<String, ClassElement> resolvedTypeArguments;
    @Nullable
    private Map<String, Map<String, ClassElement>> resolvedAllTypeArguments;
    @Nullable
    private ClassElement resolvedSuperType;
    @Nullable
    private List<ClassElement> resolvedInterfaces;
    private final JavaEnclosedElementsQuery enclosedElementsQuery = new JavaEnclosedElementsQuery(false);
    private final JavaEnclosedElementsQuery sourceEnclosedElementsQuery = new JavaEnclosedElementsQuery(true);
    @Nullable
    private ElementAnnotationMetadata elementTypeAnnotationMetadata;
    @Nullable
    private ClassElement theType;
    @Nullable
    private AnnotationMetadata annotationMetadata;

    @Internal
    public JavaClassElement(JavaNativeElement.Class nativeType, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext) {
        this(nativeType, annotationMetadataFactory, visitorContext, null, null, 0, false);
    }

    JavaClassElement(JavaNativeElement.Class nativeType, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext, List<? extends TypeMirror> typeArguments, @Nullable Map<String, ClassElement> resolvedTypeArguments) {
        this(nativeType, annotationMetadataFactory, visitorContext, typeArguments, resolvedTypeArguments, 0, false);
    }

    JavaClassElement(JavaNativeElement.Class nativeType, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext, List<? extends TypeMirror> typeArguments, @Nullable Map<String, ClassElement> resolvedTypeArguments, int arrayDimensions) {
        this(nativeType, annotationMetadataFactory, visitorContext, typeArguments, resolvedTypeArguments, arrayDimensions, false);
    }

    JavaClassElement(JavaNativeElement.Class nativeType, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext, @Nullable List<? extends TypeMirror> typeArguments, @Nullable Map<String, ClassElement> resolvedTypeArguments, int arrayDimensions, boolean isTypeVariable) {
        super(nativeType, annotationMetadataFactory, visitorContext);
        this.classElement = nativeType.element();
        this.typeArguments = typeArguments;
        this.resolvedTypeArguments = resolvedTypeArguments;
        this.arrayDimensions = arrayDimensions;
        this.isTypeVariable = isTypeVariable;
    }

    @Override
    public @NonNull JavaNativeElement.Class getNativeType() {
        return (JavaNativeElement.Class)super.getNativeType();
    }

    @Override
    protected JavaClassElement copyThis() {
        return new JavaClassElement(this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext, this.typeArguments, this.resolvedTypeArguments, this.arrayDimensions);
    }

    @NonNull
    public ClassElement withTypeArguments(Map<String, ClassElement> newTypeArguments) {
        return new JavaClassElement(this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext, this.typeArguments, newTypeArguments, this.arrayDimensions);
    }

    public ClassElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (ClassElement)super.withAnnotationMetadata(annotationMetadata);
    }

    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        if (this.getNativeType().typeMirror() == null) {
            return super.getAnnotationMetadataToWrite();
        }
        return this.getTypeAnnotationMetadata();
    }

    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        if (this.presetAnnotationMetadata != null) {
            return this.presetAnnotationMetadata;
        }
        if (this.annotationMetadata == null) {
            this.annotationMetadata = this.getNativeType().typeMirror() == null ? super.getAnnotationMetadata() : new AnnotationMetadataHierarchy(true, new AnnotationMetadata[]{super.getAnnotationMetadata(), this.getTypeAnnotationMetadata()});
        }
        return this.annotationMetadata;
    }

    @NonNull
    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getTypeAnnotationMetadata() {
        if (this.elementTypeAnnotationMetadata == null) {
            this.elementTypeAnnotationMetadata = this.elementAnnotationMetadataFactory.buildTypeAnnotations((ClassElement)this);
        }
        return this.elementTypeAnnotationMetadata;
    }

    public boolean isTypeVariable() {
        return this.isTypeVariable;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isInner() {
        return this.classElement.getNestingKind().isNested();
    }

    public boolean isRecord() {
        return JavaModelUtils.isRecord((javax.lang.model.element.Element)this.classElement);
    }

    public boolean isPrimitive() {
        return ClassUtils.getPrimitiveType((String)this.getName()).isPresent();
    }

    public Collection<ClassElement> getInterfaces() {
        if (this.resolvedInterfaces == null) {
            this.resolvedInterfaces = this.classElement.getInterfaces().stream().map(mirror -> this.newClassElement((TypeMirror)mirror, this.getTypeArguments())).toList();
        }
        return this.resolvedInterfaces;
    }

    public Optional<ClassElement> getSuperType() {
        if (this.resolvedSuperType == null) {
            TypeMirror superclass = this.classElement.getSuperclass();
            if (superclass == null) {
                return Optional.empty();
            }
            javax.lang.model.element.Element element = this.visitorContext.getTypes().asElement(superclass);
            if (element instanceof TypeElement) {
                TypeElement superElement = (TypeElement)element;
                if (Object.class.getName().equals(superElement.getQualifiedName().toString())) {
                    return Optional.empty();
                }
                this.resolvedSuperType = this.newClassElement(superclass, this.getTypeArguments());
            }
        }
        return Optional.ofNullable(this.resolvedSuperType);
    }

    @Override
    public boolean isAbstract() {
        return this.classElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isInterface() {
        return JavaModelUtils.isInterface((javax.lang.model.element.Element)this.classElement);
    }

    @NonNull
    public List<PropertyElement> getBeanProperties() {
        if (this.beanProperties == null) {
            this.beanProperties = this.getBeanProperties(PropertyElementQuery.of((AnnotationMetadata)this));
        }
        return Collections.unmodifiableList(this.beanProperties);
    }

    @NonNull
    public List<PropertyElement> getBeanProperties(@NonNull PropertyElementQuery propertyElementQuery) {
        Set isProperties;
        if (this.isRecord()) {
            return AstBeanPropertiesUtils.resolveBeanProperties((PropertyElementQuery)propertyElementQuery, (ClassElement)this, this::getRecordMethods, this::getRecordFields, (boolean)true, Collections.emptySet(), methodElement -> Optional.empty(), methodElement -> Optional.empty(), this::mapToPropertyElement);
        }
        Function<MethodElement, Optional> customReaderPropertyNameResolver = methodElement -> Optional.empty();
        Function<MethodElement, Optional> customWriterPropertyNameResolver = methodElement -> Optional.empty();
        if (this.isKotlinClass(this.getNativeType().element()) && !(isProperties = this.getEnclosedElements(ElementQuery.ALL_METHODS).stream().map(Element::getName).filter(method -> method.startsWith(PREFIX_IS)).collect(Collectors.toSet())).isEmpty()) {
            customReaderPropertyNameResolver = methodElement -> {
                String methodName = methodElement.getSimpleName();
                if (methodName.startsWith(PREFIX_IS)) {
                    return Optional.of(methodName);
                }
                return Optional.empty();
            };
            customWriterPropertyNameResolver = methodElement -> {
                String methodName = methodElement.getSimpleName();
                String propertyName = NameUtils.getPropertyNameForSetter((String)methodName);
                String isPropertyName = PREFIX_IS + NameUtils.capitalize((String)propertyName);
                if (isProperties.contains(isPropertyName)) {
                    return Optional.of(isPropertyName);
                }
                return Optional.empty();
            };
        }
        return AstBeanPropertiesUtils.resolveBeanProperties((PropertyElementQuery)propertyElementQuery, (ClassElement)this, () -> this.getEnclosedElements(ElementQuery.ALL_METHODS), () -> this.getEnclosedElements(ElementQuery.ALL_FIELDS), (boolean)false, Collections.emptySet(), customReaderPropertyNameResolver, customWriterPropertyNameResolver, this::mapToPropertyElement);
    }

    private JavaPropertyElement mapToPropertyElement(AstBeanPropertiesUtils.BeanPropertyData value) {
        return new JavaPropertyElement((ClassElement)this, value.type, value.readAccessKind == null ? null : value.getter, value.writeAccessKind == null ? null : value.setter, value.field, this.elementAnnotationMetadataFactory, value.propertyName, value.readAccessKind == null ? PropertyElement.AccessKind.METHOD : PropertyElement.AccessKind.valueOf((String)value.readAccessKind.name()), value.writeAccessKind == null ? PropertyElement.AccessKind.METHOD : PropertyElement.AccessKind.valueOf((String)value.writeAccessKind.name()), value.isExcluded, this.visitorContext);
    }

    private List<MethodElement> getRecordMethods() {
        HashSet<String> recordComponents = new HashSet<String>();
        ArrayList<MethodElement> methodElements = new ArrayList<MethodElement>();
        if (JavaModelUtils.isRecord((javax.lang.model.element.Element)this.classElement)) {
            for (javax.lang.model.element.Element element : this.classElement.getEnclosedElements()) {
                if (!JavaModelUtils.isRecordComponent((javax.lang.model.element.Element)element) && !(element instanceof ExecutableElement) || element.getKind() == ElementKind.CONSTRUCTOR) continue;
                String name = element.getSimpleName().toString();
                if (element instanceof ExecutableElement) {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    if (!recordComponents.contains(name)) continue;
                    methodElements.add(new JavaMethodElement(this, new JavaNativeElement.Method(executableElement), this.elementAnnotationMetadataFactory, this.visitorContext));
                    continue;
                }
                if (!(element instanceof VariableElement)) continue;
                recordComponents.add(name);
            }
        }
        return methodElements;
    }

    private List<FieldElement> getRecordFields() {
        ArrayList<FieldElement> fieldElements = new ArrayList<FieldElement>();
        if (JavaModelUtils.isRecord((javax.lang.model.element.Element)this.classElement)) {
            for (javax.lang.model.element.Element element : this.classElement.getEnclosedElements()) {
                if (JavaModelUtils.isRecordComponent((javax.lang.model.element.Element)element) || !(element instanceof VariableElement)) continue;
                VariableElement variableElement = (VariableElement)element;
                fieldElements.add(new JavaFieldElement(this, new JavaNativeElement.Variable(variableElement), this.elementAnnotationMetadataFactory, this.visitorContext));
            }
        }
        return fieldElements;
    }

    private boolean isKotlinClass(javax.lang.model.element.Element element) {
        return element.getAnnotationMirrors().stream().anyMatch(am -> am.getAnnotationType().asElement().toString().equals(KOTLIN_METADATA));
    }

    @NonNull
    public <T extends Element> List<T> getEnclosedElements(@NonNull ElementQuery<T> query) {
        return this.enclosedElementsQuery.getEnclosedElements((ClassElement)this, query);
    }

    public final <T extends Element> List<T> getSourceEnclosedElements(@NonNull ElementQuery<T> query) {
        return this.sourceEnclosedElementsQuery.getEnclosedElements((ClassElement)this, query);
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public ClassElement withArrayDimensions(int arrayDimensions) {
        if (arrayDimensions == this.arrayDimensions) {
            return this;
        }
        return new JavaClassElement(this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext, this.typeArguments, this.resolvedTypeArguments, arrayDimensions, false);
    }

    @NonNull
    public String getSimpleName() {
        if (this.simpleName == null) {
            this.simpleName = JavaModelUtils.getClassNameWithoutPackage((TypeElement)this.classElement);
        }
        return this.simpleName;
    }

    @Override
    @NonNull
    public String getName() {
        if (this.name == null) {
            this.name = JavaModelUtils.getClassName((TypeElement)this.classElement);
        }
        return this.name;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = JavaModelUtils.getPackageName((TypeElement)this.classElement);
        }
        return this.packageName;
    }

    public io.micronaut.inject.ast.PackageElement getPackage() {
        javax.lang.model.element.Element enclosingElement;
        for (enclosingElement = this.classElement.getEnclosingElement(); enclosingElement != null && enclosingElement.getKind() != ElementKind.PACKAGE; enclosingElement = enclosingElement.getEnclosingElement()) {
        }
        if (enclosingElement instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)enclosingElement;
            return new JavaPackageElement(packageElement, this.elementAnnotationMetadataFactory, this.visitorContext);
        }
        return io.micronaut.inject.ast.PackageElement.DEFAULT_PACKAGE;
    }

    public boolean isAssignable(String type) {
        if (this.getName().equals(type)) {
            return true;
        }
        TypeElement otherElement = this.visitorContext.getElements().getTypeElement(type);
        if (otherElement != null) {
            return this.isAssignable(otherElement);
        }
        return false;
    }

    public boolean isAssignable(ClassElement type) {
        if (this.equals(type)) {
            return true;
        }
        if (type.isPrimitive()) {
            return this.isAssignable(type.getName());
        }
        if (type instanceof JavaClassElement) {
            JavaClassElement javaClassElement = (JavaClassElement)type;
            return this.isAssignable(javaClassElement.getNativeType().element());
        }
        return this.isAssignable(type.getName());
    }

    public Optional<ClassElement> getOptionalValueType() {
        if (this.isAssignable(Optional.class)) {
            return this.getFirstTypeArgument().or(() -> this.visitorContext.getClassElement(Object.class));
        }
        if (this.isAssignable(OptionalLong.class)) {
            return this.visitorContext.getClassElement(Long.class);
        }
        if (this.isAssignable(OptionalDouble.class)) {
            return this.visitorContext.getClassElement(Double.class);
        }
        if (this.isAssignable(OptionalInt.class)) {
            return this.visitorContext.getClassElement(Integer.class);
        }
        return Optional.empty();
    }

    private boolean isAssignable(TypeElement otherElement) {
        Types types = this.visitorContext.getTypes();
        TypeMirror thisType = types.erasure(this.classElement.asType());
        TypeMirror thatType = types.erasure(otherElement.asType());
        return types.isAssignable(thisType, thatType);
    }

    @NonNull
    public Optional<MethodElement> getPrimaryConstructor() {
        if (JavaModelUtils.isRecord((javax.lang.model.element.Element)this.classElement)) {
            Optional staticCreator = this.findStaticCreator();
            if (staticCreator.isPresent()) {
                return staticCreator;
            }
            if (this.isInner() && !this.isStatic()) {
                return Optional.empty();
            }
            List constructors = this.getAccessibleConstructors();
            Optional<ConstructorElement> annotatedConstructor = constructors.stream().filter(c -> c.hasStereotype("jakarta.inject.Inject") || c.hasStereotype(Creator.class)).findFirst();
            if (annotatedConstructor.isPresent()) {
                return annotatedConstructor.map(c -> c);
            }
            List<? extends RecordComponentElement> recordComponents = this.classElement.getRecordComponents();
            block0: for (ConstructorElement constructor : constructors) {
                ParameterElement[] parameters = constructor.getParameters();
                if (parameters.length != recordComponents.size()) continue;
                for (int i = 0; i < parameters.length; ++i) {
                    TypeMirror rightType;
                    ParameterElement parameter = parameters[i];
                    RecordComponentElement rce = recordComponents.get(i);
                    VariableElement ve = ((JavaNativeElement.Variable)parameter.getNativeType()).element();
                    TypeMirror leftType = this.visitorContext.getTypes().erasure(ve.asType());
                    if (!leftType.equals(rightType = this.visitorContext.getTypes().erasure(rce.asType()))) continue block0;
                }
                return Optional.of(constructor);
            }
            if (constructors.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((MethodElement)constructors.get(constructors.size() - 1));
        }
        return super.getPrimaryConstructor();
    }

    @NonNull
    public List<MethodElement> getAccessibleStaticCreators() {
        ArrayList<MethodElement> staticCreators = new ArrayList<MethodElement>(super.getAccessibleStaticCreators());
        if (!staticCreators.isEmpty()) {
            return staticCreators;
        }
        return this.visitorContext.getClassElement(this.getName() + "$Companion", this.elementAnnotationMetadataFactory).filter(Element::isStatic).flatMap(typeElement -> typeElement.getEnclosedElements(ElementQuery.ALL_METHODS.annotated(am -> am.hasStereotype(Creator.class))).stream().findFirst()).filter(method -> !method.isPrivate() && method.getReturnType().equals((Object)this)).stream().toList();
    }

    public Optional<ClassElement> getEnclosingType() {
        javax.lang.model.element.Element enclosingElement;
        if (this.isInner() && (enclosingElement = this.classElement.getEnclosingElement()) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)enclosingElement;
            return Optional.of(this.visitorContext.getElementFactory().newClassElement(typeElement, this.elementAnnotationMetadataFactory));
        }
        return Optional.empty();
    }

    @NonNull
    public List<ClassElement> getBoundGenericTypes() {
        if (this.typeArguments == null) {
            return Collections.emptyList();
        }
        return this.typeArguments.stream().map(tm -> this.newClassElement((TypeMirror)tm, this.getTypeArguments())).toList();
    }

    @NonNull
    public List<? extends GenericPlaceholderElement> getDeclaredGenericPlaceholders() {
        return this.classElement.getTypeParameters().stream().map(tpe -> (GenericPlaceholderElement)this.newClassElement(tpe.asType(), Collections.emptyMap())).toList();
    }

    @NonNull
    public ClassElement getRawClassElement() {
        return this.visitorContext.getElementFactory().newClassElement(this.classElement, this.elementAnnotationMetadataFactory).withArrayDimensions(this.getArrayDimensions());
    }

    @NonNull
    public ClassElement withTypeArguments(@NonNull Collection<ClassElement> typeArguments) {
        LinkedHashMap<String, ClassElement> boundByName = new LinkedHashMap<String, ClassElement>();
        Iterator<? extends TypeParameterElement> types = this.classElement.getTypeParameters().iterator();
        Iterator<ClassElement> args = typeArguments.iterator();
        while (types.hasNext() && args.hasNext()) {
            ClassElement next = args.next();
            Object nativeType = next.getNativeType();
            if (nativeType instanceof Class) {
                Class aClass = (Class)nativeType;
                next = this.visitorContext.getClassElement(aClass).orElse(next);
            }
            boundByName.put(types.next().getSimpleName().toString(), next);
        }
        return this.withTypeArguments(boundByName);
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments() {
        if (this.resolvedTypeArguments == null) {
            this.resolvedTypeArguments = this.resolveTypeArguments(this.classElement, this.typeArguments);
        }
        return this.resolvedTypeArguments;
    }

    @NonNull
    public Map<String, Map<String, ClassElement>> getAllTypeArguments() {
        if (this.resolvedAllTypeArguments == null) {
            this.resolvedAllTypeArguments = super.getAllTypeArguments();
        }
        return this.resolvedAllTypeArguments;
    }

    @NonNull
    public ClassElement getType() {
        if (this.theType == null) {
            this.theType = this.getNativeType().typeMirror() == null ? this : new JavaClassElement(new JavaNativeElement.Class(this.getNativeType().element()), this.elementAnnotationMetadataFactory, this.visitorContext, this.typeArguments, this.resolvedTypeArguments, this.arrayDimensions);
        }
        return this.theType;
    }

    private final class JavaEnclosedElementsQuery
    extends EnclosedElementsQuery<TypeElement, javax.lang.model.element.Element> {
        private final boolean isSource;
        private List<? extends javax.lang.model.element.Element> enclosedElements;

        private JavaEnclosedElementsQuery(boolean isSource) {
            this.isSource = isSource;
        }

        protected boolean hasAnnotation(javax.lang.model.element.Element element, Class<? extends Annotation> annotation) {
            return element.getAnnotation(annotation) != null;
        }

        protected TypeElement getNativeClassType(ClassElement classElement) {
            return ((JavaClassElement)classElement).getNativeType().element();
        }

        protected javax.lang.model.element.Element getNativeType(Element element) {
            return ((AbstractJavaElement)element).getNativeType().element();
        }

        protected String getElementName(javax.lang.model.element.Element element) {
            return element.getSimpleName().toString();
        }

        protected Set<javax.lang.model.element.Element> getExcludedNativeElements(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ElementQuery.Result<?> result) {
            if (result.isExcludePropertyElements()) {
                HashSet<javax.lang.model.element.Element> excludeElements = new HashSet<javax.lang.model.element.Element>();
                for (PropertyElement excludePropertyElement : JavaClassElement.this.getBeanProperties()) {
                    excludePropertyElement.getReadMethod().ifPresent(methodElement -> excludeElements.add(((JavaNativeElement)methodElement.getNativeType()).element()));
                    excludePropertyElement.getWriteMethod().ifPresent(methodElement -> excludeElements.add(((JavaNativeElement)methodElement.getNativeType()).element()));
                    excludePropertyElement.getField().ifPresent(methodElement -> excludeElements.add(((JavaNativeElement)methodElement.getNativeType()).element()));
                }
                return excludeElements;
            }
            return Collections.emptySet();
        }

        protected TypeElement getSuperClass(TypeElement classNode) {
            DeclaredType dt;
            javax.lang.model.element.Element element;
            TypeMirror superclass = classNode.getSuperclass();
            if (superclass instanceof DeclaredType && (element = (dt = (DeclaredType)superclass).asElement()) instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return typeElement;
            }
            return null;
        }

        @NonNull
        protected Collection<TypeElement> getInterfaces(TypeElement classNode) {
            List<? extends TypeMirror> interfaces = classNode.getInterfaces();
            ArrayList<TypeElement> result = new ArrayList<TypeElement>(interfaces.size());
            for (TypeMirror typeMirror : interfaces) {
                javax.lang.model.element.Element ifaceEl = JavaClassElement.this.visitorContext.getTypes().asElement(typeMirror);
                if (!(ifaceEl instanceof TypeElement)) continue;
                TypeElement element = (TypeElement)ifaceEl;
                result.add(element);
            }
            return result;
        }

        @NonNull
        protected List<javax.lang.model.element.Element> getEnclosedElements(TypeElement classNode, ElementQuery.Result<?> result, boolean includeAbstract) {
            List<? extends javax.lang.model.element.Element> ee = classNode == JavaClassElement.this.classElement ? this.getEnclosedElements() : classNode.getEnclosedElements();
            EnumSet<ElementKind> elementKinds = this.getElementKind(result);
            ArrayList<javax.lang.model.element.Element> list = new ArrayList<javax.lang.model.element.Element>(ee.size());
            for (javax.lang.model.element.Element element : ee) {
                Set<Modifier> modifiers = element.getModifiers();
                if (!elementKinds.contains((Object)element.getKind()) || !includeAbstract && !this.isNonAbstractMethod(modifiers)) continue;
                list.add(element);
            }
            return list;
        }

        private boolean isNonAbstractMethod(Set<Modifier> modifiers) {
            if (modifiers.contains((Object)Modifier.DEFAULT)) {
                return true;
            }
            if (modifiers.contains((Object)Modifier.PRIVATE)) {
                return true;
            }
            return !modifiers.contains((Object)Modifier.ABSTRACT);
        }

        protected boolean excludeClass(TypeElement classNode) {
            return classNode.getQualifiedName().toString().equals(Object.class.getName()) || classNode.getQualifiedName().toString().equals(Enum.class.getName());
        }

        protected boolean isAbstractClass(TypeElement classNode) {
            return classNode.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        protected boolean isInterface(TypeElement classNode) {
            return classNode.getKind() == ElementKind.INTERFACE;
        }

        protected @NonNull Element toAstElement(javax.lang.model.element.Element nativeType, Class<?> elementType) {
            JavaElementFactory elementFactory = JavaClassElement.this.visitorContext.getElementFactory();
            return switch (nativeType.getKind()) {
                case ElementKind.METHOD -> {
                    if (this.isSource) {
                        yield elementFactory.newSourceMethodElement((ClassElement)JavaClassElement.this, (ExecutableElement)nativeType, JavaClassElement.this.elementAnnotationMetadataFactory);
                    }
                    yield elementFactory.newMethodElement((ClassElement)JavaClassElement.this, (ExecutableElement)nativeType, JavaClassElement.this.elementAnnotationMetadataFactory);
                }
                case ElementKind.FIELD -> elementFactory.newFieldElement((ClassElement)JavaClassElement.this, (VariableElement)nativeType, JavaClassElement.this.elementAnnotationMetadataFactory);
                case ElementKind.ENUM_CONSTANT -> elementFactory.newEnumConstantElement((ClassElement)JavaClassElement.this, (VariableElement)nativeType, JavaClassElement.this.elementAnnotationMetadataFactory);
                case ElementKind.CONSTRUCTOR -> elementFactory.newConstructorElement((ClassElement)JavaClassElement.this, (ExecutableElement)nativeType, JavaClassElement.this.elementAnnotationMetadataFactory);
                case ElementKind.CLASS, ElementKind.ENUM, ElementKind.RECORD, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE -> {
                    if (this.isSource) {
                        yield elementFactory.newSourceClassElement((TypeElement)nativeType, JavaClassElement.this.elementAnnotationMetadataFactory);
                    }
                    yield elementFactory.newClassElement((TypeElement)nativeType, JavaClassElement.this.elementAnnotationMetadataFactory);
                }
                default -> throw new IllegalStateException("Unknown element: " + nativeType);
            };
        }

        private List<? extends javax.lang.model.element.Element> getEnclosedElements() {
            if (this.enclosedElements == null) {
                this.enclosedElements = JavaClassElement.this.classElement.getEnclosedElements();
            }
            return this.enclosedElements;
        }

        private EnumSet<ElementKind> getElementKind(ElementQuery.Result<?> result) {
            Class elementType = result.getElementType();
            if (elementType == MemberElement.class) {
                return EnumSet.of(ElementKind.FIELD, ElementKind.METHOD);
            }
            if (elementType == MethodElement.class) {
                return EnumSet.of(ElementKind.METHOD);
            }
            if (elementType == FieldElement.class) {
                if (result.isIncludeEnumConstants()) {
                    return EnumSet.of(ElementKind.FIELD, ElementKind.ENUM_CONSTANT);
                }
                return EnumSet.of(ElementKind.FIELD);
            }
            if (elementType == ConstructorElement.class) {
                return EnumSet.of(ElementKind.CONSTRUCTOR);
            }
            if (elementType == ClassElement.class) {
                return EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.RECORD, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE);
            }
            throw new IllegalArgumentException("Unsupported element type for query: " + elementType);
        }
    }
}

