/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationProcessingOutputVisitor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.GenericUtils;
import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.JavaElementAnnotationMetadataFactory;
import io.micronaut.annotation.processing.JavaNativeElementsHelper;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaBeanDefinitionBuilder;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.expressions.context.DefaultExpressionCompilationContextFactory;
import io.micronaut.expressions.context.ExpressionCompilationContextFactory;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.annotation.AbstractAnnotationElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.beans.BeanElement;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.visitor.BeanElementVisitorContext;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.visitor.util.VisitorContextUtils;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

@Internal
public final class JavaVisitorContext
implements VisitorContext,
BeanElementVisitorContext {
    private final Messager messager;
    private final Elements elements;
    private final Types types;
    private final ModelUtils modelUtils;
    private final AnnotationProcessingOutputVisitor outputVisitor;
    private final MutableConvertibleValues<Object> visitorAttributes;
    private final ProcessingEnvironment processingEnv;
    private final List<String> generatedResources = new ArrayList<String>();
    private final List<AbstractBeanDefinitionBuilder> beanDefinitionBuilders = new ArrayList<AbstractBeanDefinitionBuilder>();
    private final JavaElementFactory elementFactory;
    private final TypeElementVisitor.VisitorKind visitorKind;
    private final DefaultExpressionCompilationContextFactory expressionCompilationContextFactory;
    @Nullable
    private JavaFileManager standardFileManager;
    private final JavaAnnotationMetadataBuilder annotationMetadataBuilder;
    private final JavaElementAnnotationMetadataFactory elementAnnotationMetadataFactory;
    private final JavaNativeElementsHelper nativeElementsHelper;
    private final Filer filer;

    @Deprecated(forRemoval=true, since="4.3.0")
    public JavaVisitorContext(ProcessingEnvironment processingEnv, Messager messager, Elements elements, AnnotationUtils annotationUtils, Types types, ModelUtils modelUtils, GenericUtils genericUtils, Filer filer, MutableConvertibleValues<Object> visitorAttributes, TypeElementVisitor.VisitorKind visitorKind) {
        this(processingEnv, messager, elements, types, modelUtils, filer, visitorAttributes, visitorKind);
    }

    public JavaVisitorContext(ProcessingEnvironment processingEnv, Messager messager, Elements elements, Types types, ModelUtils modelUtils, Filer filer, MutableConvertibleValues<Object> visitorAttributes, TypeElementVisitor.VisitorKind visitorKind) {
        this.messager = messager;
        this.elements = elements;
        this.types = types;
        this.modelUtils = modelUtils;
        this.outputVisitor = new AnnotationProcessingOutputVisitor(filer);
        this.visitorAttributes = visitorAttributes;
        this.processingEnv = processingEnv;
        this.elementFactory = new JavaElementFactory(this);
        this.visitorKind = visitorKind;
        this.nativeElementsHelper = new JavaNativeElementsHelper(elements, types);
        this.annotationMetadataBuilder = new JavaAnnotationMetadataBuilder(elements, messager, modelUtils, this.nativeElementsHelper, this);
        this.elementAnnotationMetadataFactory = new JavaElementAnnotationMetadataFactory(false, this.annotationMetadataBuilder);
        this.expressionCompilationContextFactory = new DefaultExpressionCompilationContextFactory((VisitorContext)this);
        this.filer = filer;
    }

    public VisitorContext.Language getLanguage() {
        return VisitorContext.Language.JAVA;
    }

    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return this.visitorKind;
    }

    public ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    @NonNull
    public Iterable<URL> getClasspathResources(@NonNull String path) {
        this.info("EXPERIMENTAL: Compile time resource scanning is experimental", null);
        JavaFileManager standardFileManager = this.getStandardFileManager(this.processingEnv).orElse(null);
        if (standardFileManager != null) {
            try {
                ClassLoader classLoader = standardFileManager.getClassLoader(StandardLocation.CLASS_PATH);
                if (classLoader != null) {
                    Enumeration<URL> resources = classLoader.getResources(path);
                    return CollectionUtils.enumerationToIterable(resources);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public Optional<ClassElement> getClassElement(String name) {
        return this.getClassElement(name, (ElementAnnotationMetadataFactory)this.elementAnnotationMetadataFactory);
    }

    public Optional<ClassElement> getClassElement(String name, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        try {
            TypeElement typeElement = this.elements.getTypeElement(name);
            if (typeElement == null) {
                typeElement = this.elements.getTypeElement(name.replace('$', '.'));
            }
            return Optional.ofNullable(typeElement).map(typeElement1 -> this.elementFactory.newClassElement((TypeElement)typeElement1, annotationMetadataFactory));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    @NonNull
    public ClassElement[] getClassElements(@NonNull String aPackage, String ... stereotypes) {
        ArgumentUtils.requireNonNull((String)"aPackage", (Object)aPackage);
        ArgumentUtils.requireNonNull((String)"stereotypes", (Object)stereotypes);
        PackageElement packageElement = this.elements.getPackageElement(aPackage);
        if (packageElement != null) {
            ArrayList<ClassElement> classElements = new ArrayList<ClassElement>();
            this.populateClassElements(stereotypes, packageElement, classElements);
            return classElements.toArray(ClassElement.ZERO_CLASS_ELEMENTS);
        }
        return ClassElement.ZERO_CLASS_ELEMENTS;
    }

    @NonNull
    public JavaElementFactory getElementFactory() {
        return this.elementFactory;
    }

    @NonNull
    public JavaElementAnnotationMetadataFactory getElementAnnotationMetadataFactory() {
        return this.elementAnnotationMetadataFactory;
    }

    @NonNull
    public ExpressionCompilationContextFactory getExpressionCompilationContextFactory() {
        return this.expressionCompilationContextFactory;
    }

    @NonNull
    public JavaAnnotationMetadataBuilder getAnnotationMetadataBuilder() {
        return this.annotationMetadataBuilder;
    }

    public void info(String message, @Nullable Element element) {
        this.printMessage(message, Diagnostic.Kind.NOTE, element);
    }

    public void info(String message) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    public void fail(String message, @Nullable Element element) {
        this.printMessage(message, Diagnostic.Kind.ERROR, element);
    }

    public void warn(String message, @Nullable Element element) {
        this.printMessage(message, Diagnostic.Kind.WARNING, element);
    }

    public void warn(String message, @Nullable javax.lang.model.element.Element element) {
        if (element == null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, message);
        } else {
            this.messager.printMessage(Diagnostic.Kind.WARNING, message, element);
        }
    }

    private void printMessage(String message, Diagnostic.Kind kind, @Nullable Element element) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            if (element instanceof BeanElement) {
                BeanElement beanElement = (BeanElement)element;
                element = beanElement.getDeclaringClass();
            }
            if (element instanceof AbstractJavaElement) {
                AbstractJavaElement abstractJavaElement = (AbstractJavaElement)element;
                javax.lang.model.element.Element el = abstractJavaElement.getNativeType().element();
                this.messager.printMessage(kind, message, el);
            } else {
                this.messager.printMessage(kind, message);
            }
        }
    }

    public OutputStream visitClass(String classname, @Nullable Element originatingElement) throws IOException {
        return this.outputVisitor.visitClass(classname, new Element[]{originatingElement});
    }

    public OutputStream visitClass(String classname, Element ... originatingElements) throws IOException {
        return this.outputVisitor.visitClass(classname, originatingElements);
    }

    public void visitServiceDescriptor(String type, String classname) {
        this.outputVisitor.visitServiceDescriptor(type, classname);
    }

    public void visitServiceDescriptor(String type, String classname, Element originatingElement) {
        this.outputVisitor.visitServiceDescriptor(type, classname, originatingElement);
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path, Element ... originatingElements) {
        return this.outputVisitor.visitMetaInfFile(path, originatingElements);
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return this.outputVisitor.visitGeneratedFile(path);
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path, Element ... originatingElements) {
        return this.outputVisitor.visitGeneratedFile(path, originatingElements);
    }

    public Optional<GeneratedFile> visitGeneratedSourceFile(String packageName, String fileNameWithoutExtension, Element ... originatingElements) {
        return this.outputVisitor.visitGeneratedSourceFile(packageName, fileNameWithoutExtension, originatingElements);
    }

    public void finish() {
        this.outputVisitor.finish();
    }

    public Messager getMessager() {
        return this.messager;
    }

    public ModelUtils getModelUtils() {
        return this.modelUtils;
    }

    public Elements getElements() {
        return this.elements;
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    public AnnotationUtils getAnnotationUtils() {
        return new AnnotationUtils(this.processingEnv, this.elements, this.messager, this.types, this.modelUtils, this.getGenericUtils(), this.filer);
    }

    public Types getTypes() {
        return this.types;
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    public GenericUtils getGenericUtils() {
        return new GenericUtils(this.elements, this.types, this.modelUtils);
    }

    public JavaNativeElementsHelper getNativeElementsHelper() {
        return this.nativeElementsHelper;
    }

    public Map<String, String> getOptions() {
        Map processorOptions = VisitorContextUtils.getProcessorOptions((ProcessingEnvironment)this.processingEnv);
        Map systemPropsOptions = VisitorContextUtils.getSystemOptions();
        return Stream.of(processorOptions, systemPropsOptions).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> StringUtils.isNotEmpty((CharSequence)v2) ? v2 : v1));
    }

    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        this.visitorAttributes.put(key, value);
        return this;
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        this.visitorAttributes.remove(key);
        return this;
    }

    public MutableConvertibleValues<Object> clear() {
        this.visitorAttributes.clear();
        return this;
    }

    public Set<String> names() {
        return this.visitorAttributes.names();
    }

    public Collection<Object> values() {
        return this.visitorAttributes.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.visitorAttributes.get(name, conversionContext);
    }

    private void populateClassElements(@NonNull String[] stereotypes, PackageElement packageElement, List<ClassElement> classElements) {
        List<? extends javax.lang.model.element.Element> enclosedElements = packageElement.getEnclosedElements();
        boolean includeAll = Arrays.equals(stereotypes, new String[]{"*"});
        for (javax.lang.model.element.Element element : enclosedElements) {
            this.populateClassElements(stereotypes, includeAll, packageElement, element, classElements);
        }
    }

    private void populateClassElements(@NonNull String[] stereotypes, boolean includeAll, PackageElement packageElement, javax.lang.model.element.Element enclosedElement, List<ClassElement> classElements) {
        block9: {
            block6: {
                block8: {
                    JavaClassElement classElement;
                    block7: {
                        if (!(enclosedElement instanceof TypeElement)) break block6;
                        TypeElement element = (TypeElement)enclosedElement;
                        classElement = this.elementFactory.newClassElement(element, (ElementAnnotationMetadataFactory)this.elementAnnotationMetadataFactory);
                        if (includeAll) break block7;
                        if (!Arrays.stream(stereotypes).anyMatch(arg_0 -> ((JavaClassElement)classElement).hasStereotype(arg_0))) break block8;
                    }
                    if (!classElement.isAbstract()) {
                        classElements.add((ClassElement)classElement);
                    }
                }
                List<? extends javax.lang.model.element.Element> nestedElements = enclosedElement.getEnclosedElements();
                for (javax.lang.model.element.Element element : nestedElements) {
                    this.populateClassElements(stereotypes, includeAll, packageElement, element, classElements);
                }
                break block9;
            }
            if (enclosedElement instanceof PackageElement) {
                PackageElement element = (PackageElement)enclosedElement;
                this.populateClassElements(stereotypes, element, classElements);
            }
        }
    }

    private Optional<JavaFileManager> getStandardFileManager(ProcessingEnvironment processingEnv) {
        Optional contextMethod;
        if (this.standardFileManager == null && (contextMethod = ReflectionUtils.getMethod(processingEnv.getClass(), (String)"getContext", (Class[])new Class[0])).isPresent()) {
            Object context = ReflectionUtils.invokeMethod((Object)processingEnv, (Method)((Method)contextMethod.get()), (Object[])new Object[0]);
            try {
                if (context != null) {
                    Optional getMethod = ReflectionUtils.getMethod(context.getClass(), (String)"get", (Class[])new Class[]{Class.class});
                    this.standardFileManager = getMethod.map(method -> ReflectionUtils.invokeMethod((Object)context, (Method)method, (Object[])new Object[]{JavaFileManager.class})).orElse(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.ofNullable(this.standardFileManager);
    }

    public Collection<String> getGeneratedResources() {
        return Collections.unmodifiableCollection(this.generatedResources);
    }

    public void addGeneratedResource(@NonNull String resource) {
        this.generatedResources.add(resource);
    }

    @Internal
    public List<AbstractBeanDefinitionBuilder> getBeanElementBuilders() {
        ArrayList<AbstractBeanDefinitionBuilder> current = new ArrayList<AbstractBeanDefinitionBuilder>(this.beanDefinitionBuilders);
        this.beanDefinitionBuilders.clear();
        return current;
    }

    @Internal
    void addBeanDefinitionBuilder(JavaBeanDefinitionBuilder javaBeanDefinitionBuilder) {
        this.beanDefinitionBuilders.add(javaBeanDefinitionBuilder);
    }

    public BeanElementBuilder addAssociatedBean(Element originatingElement, ClassElement type) {
        JavaElementAnnotationMetadataFactory javaElementAnnotationMetadataFactory;
        if (type instanceof AbstractAnnotationElement) {
            AbstractAnnotationElement aae = (AbstractAnnotationElement)type;
            javaElementAnnotationMetadataFactory = aae.getElementAnnotationMetadataFactory();
        } else {
            javaElementAnnotationMetadataFactory = this.elementAnnotationMetadataFactory;
        }
        return new JavaBeanDefinitionBuilder(originatingElement, type, ConfigurationMetadataBuilder.INSTANCE, (ElementAnnotationMetadataFactory)javaElementAnnotationMetadataFactory, this);
    }
}

