/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kotlin.processing;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSPropertySetter;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeAlias;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeParameter;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.google.devtools.ksp.symbol.Modifier;
import com.google.devtools.ksp.symbol.Origin;
import com.google.devtools.ksp.symbol.Visibility;
import io.micronaut.kotlin.processing.visitor.KotlinVisitorContext;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\b\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"computeName", "", "declaration", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "resolveDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "visitorContext", "Lio/micronaut/kotlin/processing/visitor/KotlinVisitorContext;", "getBinaryName", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "getClassDeclaration", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "getVisibility", "Lcom/google/devtools/ksp/symbol/Visibility;", "Lcom/google/devtools/ksp/symbol/KSPropertySetter;", "inject-kotlin"})
public final class ExtensionsKt {
    @NotNull
    public static final String getBinaryName(@NotNull KSDeclaration $this$getBinaryName, @NotNull Resolver resolver, @NotNull KotlinVisitorContext visitorContext) {
        String signature;
        String binaryName;
        KSDeclaration parent;
        Intrinsics.checkNotNullParameter((Object)$this$getBinaryName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)visitorContext, (String)"visitorContext");
        KSDeclaration declaration2 = $this$getBinaryName;
        if (declaration2 instanceof KSFunctionDeclaration && (parent = declaration2.getParentDeclaration()) != null) {
            declaration2 = parent;
        }
        if (declaration2.getQualifiedName() != null) {
            KSName kSName = declaration2.getQualifiedName();
            Intrinsics.checkNotNull((Object)kSName);
            KSName kSName2 = resolver.mapKotlinNameToJava(kSName);
            v2 = kSName2 != null ? kSName2.asString() : null;
        } else {
            v2 = binaryName = null;
        }
        if (binaryName != null) {
            return binaryName;
        }
        KSClassDeclaration classDeclaration = ExtensionsKt.getClassDeclaration((KSAnnotated)declaration2, visitorContext);
        KSName qn = classDeclaration.getQualifiedName();
        if (qn != null) {
            String asString;
            KSName kSName = resolver.mapKotlinNameToJava(qn);
            String string = asString = kSName != null ? kSName.asString() : null;
            if (asString != null) {
                return asString;
            }
        }
        if (declaration2 instanceof KSClassDeclaration && declaration2.getOrigin() != Origin.SYNTHETIC && (signature = resolver.mapToJvmSignature(declaration2)) != null) {
            String string = Type.getType((String)signature).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(signature).className");
            return string;
        }
        return declaration2.getOrigin() != Origin.SYNTHETIC ? ExtensionsKt.computeName(declaration2) : declaration2.getSimpleName().asString();
    }

    private static final String computeName(KSDeclaration declaration2) {
        StringBuilder className = new StringBuilder(declaration2.getPackageName().asString());
        Object[] objectArray = new KSDeclaration[]{declaration2};
        List hierarchy = CollectionsKt.mutableListOf((Object[])objectArray);
        KSDeclaration parentDeclaration = declaration2.getParentDeclaration();
        while (parentDeclaration instanceof KSClassDeclaration) {
            hierarchy.add(0, parentDeclaration);
            parentDeclaration = ((KSClassDeclaration)parentDeclaration).getParentDeclaration();
        }
        CollectionsKt.joinTo$default((Iterable)hierarchy, (Appendable)className, (CharSequence)"$", (CharSequence)".", null, (int)0, null, null, (int)120, null);
        String string = className.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.toString()");
        return string;
    }

    @NotNull
    public static final Visibility getVisibility(@NotNull KSPropertySetter $this$getVisibility) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)$this$getVisibility, (String)"<this>");
        try {
            set = $this$getVisibility.getModifiers();
        }
        catch (IllegalStateException e) {
            set = SetsKt.setOf((Object)Modifier.INTERNAL);
        }
        Set modifierSet = set;
        return modifierSet.contains(Modifier.PUBLIC) ? Visibility.PUBLIC : (modifierSet.contains(Modifier.PRIVATE) ? Visibility.PRIVATE : (modifierSet.contains(Modifier.PROTECTED) || modifierSet.contains(Modifier.OVERRIDE) ? Visibility.PROTECTED : (modifierSet.contains(Modifier.INTERNAL) ? Visibility.INTERNAL : ($this$getVisibility.getOrigin() != Origin.JAVA && $this$getVisibility.getOrigin() != Origin.JAVA_LIB ? Visibility.PUBLIC : Visibility.JAVA_PACKAGE))));
    }

    @NotNull
    public static final KSClassDeclaration getClassDeclaration(@NotNull KSAnnotated $this$getClassDeclaration, @NotNull KotlinVisitorContext visitorContext) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visitorContext, (String)"visitorContext");
        KSAnnotated kSAnnotated = $this$getClassDeclaration;
        if (kSAnnotated instanceof KSType) {
            return ExtensionsKt.getClassDeclaration((KSAnnotated)((KSType)$this$getClassDeclaration).getDeclaration(), visitorContext);
        }
        if (kSAnnotated instanceof KSClassDeclaration) {
            return (KSClassDeclaration)$this$getClassDeclaration;
        }
        if (kSAnnotated instanceof KSTypeReference) {
            return ExtensionsKt.getClassDeclaration((KSAnnotated)((KSTypeReference)$this$getClassDeclaration).resolve().getDeclaration(), visitorContext);
        }
        if (kSAnnotated instanceof KSTypeParameter) {
            KSTypeReference kSTypeReference = (KSTypeReference)SequencesKt.firstOrNull((Sequence)((KSTypeParameter)$this$getClassDeclaration).getBounds());
            return ExtensionsKt.resolveDeclaration(kSTypeReference != null && (kSTypeReference = kSTypeReference.resolve()) != null ? kSTypeReference.getDeclaration() : null, visitorContext);
        }
        if (kSAnnotated instanceof KSTypeArgument) {
            KSTypeReference kSTypeReference = ((KSTypeArgument)$this$getClassDeclaration).getType();
            return ExtensionsKt.resolveDeclaration(kSTypeReference != null && (kSTypeReference = kSTypeReference.resolve()) != null ? kSTypeReference.getDeclaration() : null, visitorContext);
        }
        if (kSAnnotated instanceof KSTypeAlias) {
            KSDeclaration declaration2 = ((KSTypeAlias)$this$getClassDeclaration).getType().resolve().getDeclaration();
            return ExtensionsKt.getClassDeclaration((KSAnnotated)declaration2, visitorContext);
        }
        if (kSAnnotated instanceof KSValueParameter) {
            KSNode p = $this$getClassDeclaration.getParent();
            if (p instanceof KSDeclaration) {
                return ExtensionsKt.getClassDeclaration((KSAnnotated)p, visitorContext);
            }
            Resolver resolver = visitorContext.getResolver();
            String string = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Object::class.java.name");
            KSClassDeclaration kSClassDeclaration = UtilsKt.getJavaClassByName((Resolver)resolver, (String)string);
            Intrinsics.checkNotNull((Object)kSClassDeclaration);
            return kSClassDeclaration;
        }
        if (kSAnnotated instanceof KSFunctionDeclaration) {
            KSDeclaration parentDeclaration = ((KSFunctionDeclaration)$this$getClassDeclaration).getParentDeclaration();
            if (parentDeclaration != null) {
                return ExtensionsKt.getClassDeclaration((KSAnnotated)parentDeclaration, visitorContext);
            }
            Resolver resolver = visitorContext.getResolver();
            String string = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Object::class.java.name");
            KSClassDeclaration kSClassDeclaration = UtilsKt.getJavaClassByName((Resolver)resolver, (String)string);
            Intrinsics.checkNotNull((Object)kSClassDeclaration);
            return kSClassDeclaration;
        }
        if (kSAnnotated instanceof KSPropertyDeclaration) {
            KSDeclaration parentDeclaration = ((KSPropertyDeclaration)$this$getClassDeclaration).getParentDeclaration();
            if (parentDeclaration != null) {
                return ExtensionsKt.getClassDeclaration((KSAnnotated)parentDeclaration, visitorContext);
            }
            Resolver resolver = visitorContext.getResolver();
            String string = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Object::class.java.name");
            KSClassDeclaration kSClassDeclaration = UtilsKt.getJavaClassByName((Resolver)resolver, (String)string);
            Intrinsics.checkNotNull((Object)kSClassDeclaration);
            return kSClassDeclaration;
        }
        Resolver resolver = visitorContext.getResolver();
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Object::class.java.name");
        KSClassDeclaration kSClassDeclaration = UtilsKt.getJavaClassByName((Resolver)resolver, (String)string);
        Intrinsics.checkNotNull((Object)kSClassDeclaration);
        return kSClassDeclaration;
    }

    private static final KSClassDeclaration resolveDeclaration(KSDeclaration declaration2, KotlinVisitorContext visitorContext) {
        KSClassDeclaration kSClassDeclaration;
        if (declaration2 instanceof KSClassDeclaration) {
            kSClassDeclaration = (KSClassDeclaration)declaration2;
        } else {
            Resolver resolver = visitorContext.getResolver();
            String string = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Object::class.java.name");
            KSClassDeclaration kSClassDeclaration2 = UtilsKt.getJavaClassByName((Resolver)resolver, (String)string);
            kSClassDeclaration = kSClassDeclaration2;
            Intrinsics.checkNotNull((Object)kSClassDeclaration2);
        }
        return kSClassDeclaration;
    }
}

