/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kotlin.processing.visitor;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeReference;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.kotlin.processing.visitor.KotlinVisitorContext;
import io.micronaut.kotlin.processing.visitor.LoadedVisitor;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00030\u001dH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lio/micronaut/kotlin/processing/visitor/LoadedVisitor;", "Lio/micronaut/core/order/Ordered;", "visitor", "Lio/micronaut/inject/visitor/TypeElementVisitor;", "visitorContext", "Lio/micronaut/kotlin/processing/visitor/KotlinVisitorContext;", "(Lio/micronaut/inject/visitor/TypeElementVisitor;Lio/micronaut/kotlin/processing/visitor/KotlinVisitorContext;)V", "classAnnotation", "", "elementAnnotation", "getVisitor", "()Lio/micronaut/inject/visitor/TypeElementVisitor;", "getVisitorContext", "()Lio/micronaut/kotlin/processing/visitor/KotlinVisitorContext;", "getOrder", "", "getType", "type", "Lcom/google/devtools/ksp/symbol/KSType;", "default", "matches", "", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "annotationMetadata", "Lio/micronaut/core/annotation/AnnotationMetadata;", "resolveFromClassDeclaration", "", "javaClass", "Ljava/lang/Class;", "Companion", "inject-kotlin"})
public final class LoadedVisitor
implements Ordered {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TypeElementVisitor<?, ?> visitor;
    @NotNull
    private final KotlinVisitorContext visitorContext;
    @NotNull
    private String classAnnotation;
    @NotNull
    private String elementAnnotation;
    @NotNull
    public static final String ANY = "kotlin.Any";

    public LoadedVisitor(@NotNull TypeElementVisitor<?, ?> visitor, @NotNull KotlinVisitorContext visitorContext) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)visitorContext, (String)"visitorContext");
        this.visitor = visitor;
        this.visitorContext = visitorContext;
        this.classAnnotation = ANY;
        this.elementAnnotation = ANY;
        Class<TypeElementVisitor<?, ?>> javaClass = this.visitor.getClass();
        Resolver resolver = this.visitorContext.getResolver();
        String string = javaClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.name");
        KSClassDeclaration declaration2 = UtilsKt.getClassDeclarationByName((Resolver)resolver, (String)string);
        String tevClassName = TypeElementVisitor.class.getName();
        if (declaration2 != null) {
            Object v2;
            block9: {
                Sequence sequence = SequencesKt.map((Sequence)declaration2.getSuperTypes(), (Function1)reference.1.INSTANCE);
                for (Object e : sequence) {
                    KSType it = (KSType)e;
                    boolean bl = false;
                    KSName kSName = it.getDeclaration().getQualifiedName();
                    if (!Intrinsics.areEqual((Object)(kSName != null ? kSName.asString() : null), (Object)tevClassName)) continue;
                    v2 = e;
                    break block9;
                }
                v2 = null;
            }
            KSType reference2 = v2;
            if (reference2 == null) {
                this.resolveFromClassDeclaration(javaClass);
            } else {
                KSTypeReference classArgument = ((KSTypeArgument)reference2.getArguments().get(0)).getType();
                KSTypeReference elementArgument = ((KSTypeArgument)reference2.getArguments().get(1)).getType();
                if (classArgument != null && elementArgument != null) {
                    KSType kSType = classArgument.resolve();
                    String string2 = this.visitor.getClassType();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"visitor.classType");
                    this.classAnnotation = this.getType(kSType, string2);
                    KSType kSType2 = elementArgument.resolve();
                    String string3 = this.visitor.getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"visitor.elementType");
                    this.elementAnnotation = this.getType(kSType2, string3);
                } else {
                    this.resolveFromClassDeclaration(javaClass);
                }
            }
        } else {
            this.resolveFromClassDeclaration(javaClass);
        }
        if (Intrinsics.areEqual((Object)this.classAnnotation, (Object)ANY)) {
            String string4 = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Object::class.java.name");
            this.classAnnotation = string4;
        }
        if (Intrinsics.areEqual((Object)this.elementAnnotation, (Object)ANY)) {
            String string5 = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"Object::class.java.name");
            this.elementAnnotation = string5;
        }
    }

    @NotNull
    public final TypeElementVisitor<?, ?> getVisitor() {
        return this.visitor;
    }

    @NotNull
    public final KotlinVisitorContext getVisitorContext() {
        return this.visitorContext;
    }

    private final void resolveFromClassDeclaration(Class<TypeElementVisitor<?, ?>> javaClass) {
        Class[] classes = GenericTypeUtils.resolveInterfaceTypeArguments(javaClass, TypeElementVisitor.class);
        if (classes != null && classes.length == 2) {
            String string;
            String string2;
            Class classGeneric = classes[0];
            if (Intrinsics.areEqual((Object)classGeneric, Object.class)) {
                String string3 = this.visitor.getClassType();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                visitor.classType\n            }");
            } else {
                String string4 = classGeneric.getName();
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                classGeneric.name\n            }");
            }
            this.classAnnotation = string2;
            Class elementGeneric = classes[1];
            if (Intrinsics.areEqual((Object)elementGeneric, Object.class)) {
                String string5 = this.visitor.getElementType();
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n                visito\u2026elementType\n            }");
            } else {
                String string6 = elementGeneric.getName();
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"{\n                elemen\u2026eneric.name\n            }");
            }
            this.elementAnnotation = string;
        } else {
            String string = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Any::class.java.name");
            this.classAnnotation = string;
            String string7 = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"Any::class.java.name");
            this.elementAnnotation = string7;
        }
    }

    public int getOrder() {
        return this.visitor.getOrder();
    }

    /*
     * WARNING - void declaration
     */
    private final String getType(KSType type, String string) {
        Object object;
        if (!type.isError()) {
            void var3_3;
            KSName kSName = type.getDeclaration().getQualifiedName();
            Intrinsics.checkNotNull((Object)kSName);
            String elementAnnotation = kSName.asString();
            object = Intrinsics.areEqual((Object)elementAnnotation, (Object)ANY) ? string : var3_3;
        } else {
            String string2 = UUID.randomUUID().toString();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            //sigh\n   \u2026ID().toString()\n        }");
        }
        return object;
    }

    public final boolean matches(@NotNull KSClassDeclaration classDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        if (Intrinsics.areEqual((Object)this.classAnnotation, (Object)"java.lang.Object")) {
            return true;
        }
        AnnotationMetadata annotationMetadata = this.visitorContext.getAnnotationMetadataBuilder().buildDeclared(classDeclaration);
        return annotationMetadata.hasStereotype(this.classAnnotation);
    }

    public final boolean matches(@NotNull AnnotationMetadata annotationMetadata) {
        Intrinsics.checkNotNullParameter((Object)annotationMetadata, (String)"annotationMetadata");
        if (Intrinsics.areEqual((Object)this.elementAnnotation, (Object)"java.lang.Object")) {
            return true;
        }
        return annotationMetadata.hasStereotype(this.elementAnnotation);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/micronaut/kotlin/processing/visitor/LoadedVisitor$Companion;", "", "()V", "ANY", "", "inject-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

