/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kotlin.processing.visitor;

import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSVisitor;
import com.google.devtools.ksp.visitor.KSTopDownVisitor;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.VersionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.kotlin.processing.beans.BeanDefinitionProcessor;
import io.micronaut.kotlin.processing.visitor.KotlinClassElement;
import io.micronaut.kotlin.processing.visitor.KotlinClassNativeElement;
import io.micronaut.kotlin.processing.visitor.KotlinVisitorContext;
import io.micronaut.kotlin.processing.visitor.LoadedVisitor;
import io.micronaut.kotlin.processing.visitor.TypeElementSymbolProcessor;
import io.micronaut.kotlin.processing.visitor.TypeElementSymbolProcessor$process$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\fH\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/micronaut/kotlin/processing/visitor/TypeElementSymbolProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "loadedVisitors", "", "Lio/micronaut/kotlin/processing/visitor/LoadedVisitor;", "processed", "", "", "typeElementVisitors", "", "Lio/micronaut/inject/visitor/TypeElementVisitor;", "visitorContext", "Lio/micronaut/kotlin/processing/visitor/KotlinVisitorContext;", "findTypeElementVisitors", "finish", "", "newClassElement", "Lio/micronaut/inject/ast/ClassElement;", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "onError", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "start", "Companion", "ElementVisitor", "inject-kotlin"})
@SourceDebugExtension(value={"SMAP\nTypeElementSymbolProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeElementSymbolProcessor.kt\nio/micronaut/kotlin/processing/visitor/TypeElementSymbolProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,363:1\n473#2:364\n*S KotlinDebug\n*F\n+ 1 TypeElementSymbolProcessor.kt\nio/micronaut/kotlin/processing/visitor/TypeElementSymbolProcessor\n*L\n96#1:364\n*E\n"})
public class TypeElementSymbolProcessor
implements SymbolProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SymbolProcessorEnvironment environment;
    private List<LoadedVisitor> loadedVisitors;
    @Nullable
    private Collection<? extends TypeElementVisitor<?, ?>> typeElementVisitors;
    private KotlinVisitorContext visitorContext;
    @NotNull
    private final Set<String> processed;
    private static final SoftServiceLoader<TypeElementVisitor<?, ?>> SERVICE_LOADER = SoftServiceLoader.load(TypeElementVisitor.class);

    public TypeElementSymbolProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        this.processed = new LinkedHashSet();
    }

    @NotNull
    public ClassElement newClassElement(@NotNull KotlinVisitorContext visitorContext, @NotNull KSClassDeclaration classDeclaration) {
        Intrinsics.checkNotNullParameter((Object)visitorContext, (String)"visitorContext");
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        return visitorContext.getElementFactory().newClassElement(classDeclaration, visitorContext.getElementAnnotationMetadataFactory());
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        List<LoadedVisitor> list;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.environment.getOptions().entrySet().stream().filter(arg_0 -> TypeElementSymbolProcessor.process$lambda$0(process.1.INSTANCE, arg_0)).forEach(arg_0 -> TypeElementSymbolProcessor.process$lambda$1(process.2.INSTANCE, arg_0));
        if (this.typeElementVisitors == null) {
            this.typeElementVisitors = this.findTypeElementVisitors();
            Collection<TypeElementVisitor<?, ?>> collection = this.typeElementVisitors;
            Intrinsics.checkNotNull(collection);
            this.loadedVisitors = new ArrayList(collection.size());
            this.visitorContext = new KotlinVisitorContext(this.environment, resolver);
            this.start();
        }
        if ((list = this.loadedVisitors) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadedVisitors");
            list = null;
        }
        if (!((Collection)list).isEmpty()) {
            Sequence $this$filterIsInstance$iv = SequencesKt.flatMap((Sequence)resolver.getAllFiles(), (Function1)process.elements.1.INSTANCE);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)process$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            List elements2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)process.elements.2.INSTANCE));
            if (!((Collection)elements2).isEmpty()) {
                Map classElementsCache = new HashMap();
                for (KSClassDeclaration typeElement : elements2) {
                    if (typeElement.getClassKind() == ClassKind.ANNOTATION_CLASS) continue;
                    KSName kSName = typeElement.getQualifiedName();
                    String className = kSName != null ? kSName.asString() : null;
                    if (className == null || this.processed.contains(className)) continue;
                    this.processed.add(className);
                    List<LoadedVisitor> list2 = this.loadedVisitors;
                    if (list2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"loadedVisitors");
                        list2 = null;
                    }
                    for (LoadedVisitor loadedVisitor : list2) {
                        if (!loadedVisitor.matches(typeElement)) continue;
                        try {
                            typeElement.accept((KSVisitor)new ElementVisitor(loadedVisitor, typeElement, classElementsCache), (Object)className);
                        }
                        catch (ProcessingException e) {
                            BeanDefinitionProcessor.Helper.handleProcessingException(this.environment, e);
                        }
                    }
                }
            }
        }
        return CollectionsKt.emptyList();
    }

    public void finish() {
        List<LoadedVisitor> list = this.loadedVisitors;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadedVisitors");
            list = null;
        }
        for (LoadedVisitor loadedVisitor : list) {
            try {
                TypeElementVisitor<?, ?> typeElementVisitor = loadedVisitor.getVisitor();
                KotlinVisitorContext kotlinVisitorContext = this.visitorContext;
                if (kotlinVisitorContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"visitorContext");
                    kotlinVisitorContext = null;
                }
                typeElementVisitor.finish((VisitorContext)kotlinVisitorContext);
            }
            catch (ProcessingException e) {
                BeanDefinitionProcessor.Helper.handleProcessingException(this.environment, e);
            }
            catch (Throwable e) {
                KSPLogger.error$default((KSPLogger)this.environment.getLogger(), (String)("Error finalizing type visitor  [" + loadedVisitor.getVisitor() + "]: " + e.getMessage()), null, (int)2, null);
                this.environment.getLogger().exception(e);
            }
        }
        this.processed.clear();
        KotlinVisitorContext kotlinVisitorContext = this.visitorContext;
        if (kotlinVisitorContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"visitorContext");
            kotlinVisitorContext = null;
        }
        kotlinVisitorContext.finish();
    }

    public void onError() {
    }

    private final void start() {
        Collection<TypeElementVisitor<?, ?>> collection = this.typeElementVisitors;
        Intrinsics.checkNotNull(collection);
        for (TypeElementVisitor<?, ?> visitor : collection) {
            try {
                KotlinVisitorContext kotlinVisitorContext;
                KotlinVisitorContext kotlinVisitorContext2;
                List<LoadedVisitor> list = this.loadedVisitors;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"loadedVisitors");
                    list = null;
                }
                if ((kotlinVisitorContext2 = (kotlinVisitorContext = this.visitorContext)) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"visitorContext");
                    kotlinVisitorContext2 = null;
                }
                list.add(new LoadedVisitor(visitor, kotlinVisitorContext2));
            }
            catch (TypeNotPresentException typeNotPresentException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        List<LoadedVisitor> list = this.loadedVisitors;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadedVisitors");
            list = null;
        }
        OrderUtil.reverseSort(list);
        List<LoadedVisitor> list2 = this.loadedVisitors;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadedVisitors");
            list2 = null;
        }
        for (LoadedVisitor loadedVisitor : list2) {
            try {
                TypeElementVisitor<?, ?> typeElementVisitor = loadedVisitor.getVisitor();
                KotlinVisitorContext kotlinVisitorContext = this.visitorContext;
                if (kotlinVisitorContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"visitorContext");
                    kotlinVisitorContext = null;
                }
                typeElementVisitor.start((VisitorContext)kotlinVisitorContext);
            }
            catch (Throwable e) {
                KSPLogger.error$default((KSPLogger)this.environment.getLogger(), (String)("Error initializing type visitor [" + loadedVisitor.getVisitor() + "]: " + e.getMessage()), null, (int)2, null);
            }
        }
    }

    @NonNull
    private final Collection<TypeElementVisitor<?, ?>> findTypeElementVisitors() {
        Map typeElementVisitors = new HashMap(10);
        for (ServiceDefinition definition : SERVICE_LOADER) {
            String version;
            Requires.Sdk sdk;
            TypeElementVisitor typeElementVisitor;
            if (!definition.isPresent()) continue;
            try {
                typeElementVisitor = (TypeElementVisitor)definition.load();
            }
            catch (Throwable e) {
                KSPLogger.warn$default((KSPLogger)this.environment.getLogger(), (String)("TypeElementVisitor [" + definition.getName() + "] will be ignored due to loading error: " + e.getMessage()), null, (int)2, null);
                continue;
            }
            TypeElementVisitor visitor = typeElementVisitor;
            if (visitor == null || !visitor.isEnabled()) continue;
            Requires requires = visitor.getClass().getAnnotation(Requires.class);
            if (requires != null && (sdk = requires.sdk()) == Requires.Sdk.MICRONAUT && StringUtils.isNotEmpty((CharSequence)(version = requires.version())) && !VersionUtils.isAtLeastMicronautVersion((String)version)) {
                try {
                    KSPLogger.warn$default((KSPLogger)this.environment.getLogger(), (String)("TypeElementVisitor [" + definition.getName() + "] will be ignored because Micronaut version [" + VersionUtils.MICRONAUT_VERSION + "] must be at least " + version), null, (int)2, null);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Map map = typeElementVisitors;
            String string = definition.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            map.put(string, visitor);
        }
        return typeElementVisitors.values();
    }

    private static final boolean process$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void process$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RR\u0010\u0003\u001aF\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005 \u0006*\"\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/micronaut/kotlin/processing/visitor/TypeElementSymbolProcessor$Companion;", "", "()V", "SERVICE_LOADER", "Lio/micronaut/core/io/service/SoftServiceLoader;", "Lio/micronaut/inject/visitor/TypeElementVisitor;", "kotlin.jvm.PlatformType", "inject-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/micronaut/kotlin/processing/visitor/TypeElementSymbolProcessor$ElementVisitor;", "Lcom/google/devtools/ksp/visitor/KSTopDownVisitor;", "", "loadedVisitor", "Lio/micronaut/kotlin/processing/visitor/LoadedVisitor;", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "classElementsCache", "", "Lio/micronaut/kotlin/processing/visitor/KotlinClassNativeElement;", "Lio/micronaut/inject/ast/ClassElement;", "(Lio/micronaut/kotlin/processing/visitor/TypeElementSymbolProcessor;Lio/micronaut/kotlin/processing/visitor/LoadedVisitor;Lcom/google/devtools/ksp/symbol/KSClassDeclaration;Ljava/util/Map;)V", "defaultHandler", "node", "Lcom/google/devtools/ksp/symbol/KSNode;", "data", "visitClassDeclaration", "visitConstructor", "", "classElement", "ctor", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "visitField", "memberElement", "Lio/micronaut/inject/ast/FieldElement;", "visitMembers", "visitMethod", "Lio/micronaut/inject/ast/MethodElement;", "visitNativeProperty", "propertyNode", "Lio/micronaut/inject/ast/PropertyElement;", "inject-kotlin"})
    @SourceDebugExtension(value={"SMAP\nTypeElementSymbolProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeElementSymbolProcessor.kt\nio/micronaut/kotlin/processing/visitor/TypeElementSymbolProcessor$ElementVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n1313#2,2:364\n1855#3,2:366\n*S KotlinDebug\n*F\n+ 1 TypeElementSymbolProcessor.kt\nio/micronaut/kotlin/processing/visitor/TypeElementSymbolProcessor$ElementVisitor\n*L\n258#1:364,2\n267#1:366,2\n*E\n"})
    private final class ElementVisitor
    extends KSTopDownVisitor<Object, Object> {
        @NotNull
        private final LoadedVisitor loadedVisitor;
        @NotNull
        private final KSClassDeclaration classDeclaration;
        @NotNull
        private final Map<KotlinClassNativeElement, ClassElement> classElementsCache;

        public ElementVisitor(@NotNull LoadedVisitor loadedVisitor, @NotNull KSClassDeclaration classDeclaration, Map<KotlinClassNativeElement, ClassElement> classElementsCache) {
            Intrinsics.checkNotNullParameter((Object)loadedVisitor, (String)"loadedVisitor");
            Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
            Intrinsics.checkNotNullParameter(classElementsCache, (String)"classElementsCache");
            this.loadedVisitor = loadedVisitor;
            this.classDeclaration = classDeclaration;
            this.classElementsCache = classElementsCache;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object visitClassDeclaration(@NotNull KSClassDeclaration classDeclaration, @NotNull Object data) {
            Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            KSName kSName = classDeclaration.getQualifiedName();
            Intrinsics.checkNotNull((Object)kSName);
            if (Intrinsics.areEqual((Object)kSName.asString(), (Object)"kotlin.Any")) {
                return data;
            }
            if (classDeclaration.getClassKind() == ClassKind.ENUM_ENTRY) {
                return data;
            }
            if (Intrinsics.areEqual((Object)classDeclaration, (Object)this.classDeclaration)) {
                KotlinVisitorContext visitorContext = this.loadedVisitor.getVisitorContext();
                if (this.loadedVisitor.matches(classDeclaration)) {
                    void $this$forEach$iv;
                    ClassElement classElement2 = this.classElementsCache.computeIfAbsent(new KotlinClassNativeElement(classDeclaration, null, null, 6, null), arg_0 -> ElementVisitor.visitClassDeclaration$lambda$0((Function1)new Function1<KotlinClassNativeElement, ClassElement>(TypeElementSymbolProcessor.this, visitorContext, classDeclaration){
                        final /* synthetic */ TypeElementSymbolProcessor this$0;
                        final /* synthetic */ KotlinVisitorContext $visitorContext;
                        final /* synthetic */ KSClassDeclaration $classDeclaration;
                        {
                            this.this$0 = $receiver;
                            this.$visitorContext = $visitorContext;
                            this.$classDeclaration = $classDeclaration;
                            super(1);
                        }

                        @NotNull
                        public final ClassElement invoke(@NotNull KotlinClassNativeElement kotlinClassNativeElement) {
                            Intrinsics.checkNotNullParameter((Object)kotlinClassNativeElement, (String)"<anonymous parameter 0>");
                            return this.this$0.newClassElement(this.$visitorContext, this.$classDeclaration);
                        }
                    }, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)classElement2, (String)"computeIfAbsent(...)");
                    ClassElement classElement3 = classElement2;
                    try {
                        this.loadedVisitor.getVisitor().visitClass(classElement3, (VisitorContext)visitorContext);
                    }
                    catch (Exception e) {
                        throw new ProcessingException((Element)classElement3, e.getMessage(), (Throwable)e);
                    }
                    Sequence e = SequencesKt.filter((Sequence)classDeclaration.getAllFunctions(), (Function1)visitClassDeclaration.1.INSTANCE);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KSFunctionDeclaration it = (KSFunctionDeclaration)element$iv;
                        boolean bl = false;
                        this.visitConstructor(classElement3, it);
                    }
                    this.visitMembers(classElement3);
                    ElementQuery innerClassQuery = ElementQuery.ALL_INNER_CLASSES.onlyStatic().modifiers(ElementVisitor::visitClassDeclaration$lambda$2);
                    List innerClasses2 = classElement3.getEnclosedElements(innerClassQuery);
                    Intrinsics.checkNotNull((Object)innerClasses2);
                    Iterable $this$forEach$iv2 = innerClasses2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        ClassElement it = (ClassElement)element$iv;
                        boolean bl = false;
                        TypeElementVisitor<?, ?> visitor = this.loadedVisitor.getVisitor();
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type io.micronaut.kotlin.processing.visitor.KotlinClassElement");
                        KotlinClassElement kspClassElement = (KotlinClassElement)it;
                        if (!this.loadedVisitor.matches(kspClassElement.getDeclaration())) continue;
                        visitor.visitClass(it, (VisitorContext)this.loadedVisitor.getVisitorContext());
                        this.visitMembers(it);
                    }
                }
            }
            return data;
        }

        private final void visitMembers(ClassElement classElement2) {
            List properties = classElement2.getSyntheticBeanProperties();
            for (PropertyElement property : properties) {
                try {
                    Intrinsics.checkNotNull((Object)property);
                    this.visitNativeProperty(property);
                }
                catch (Exception e) {
                    throw new ProcessingException((Element)property, e.getMessage(), (Throwable)e);
                }
            }
            List memberElements = classElement2.getEnclosedElements(ElementQuery.ALL_FIELD_AND_METHODS);
            for (MemberElement memberElement : memberElements) {
                MemberElement memberElement2 = memberElement;
                if (memberElement2 instanceof FieldElement) {
                    Intrinsics.checkNotNull((Object)memberElement);
                    this.visitField((FieldElement)memberElement);
                    continue;
                }
                if (!(memberElement2 instanceof MethodElement)) continue;
                Intrinsics.checkNotNull((Object)memberElement);
                this.visitMethod((MethodElement)memberElement);
            }
        }

        private final void visitMethod(MethodElement memberElement) {
            TypeElementVisitor<?, ?> visitor = this.loadedVisitor.getVisitor();
            KotlinVisitorContext visitorContext = this.loadedVisitor.getVisitorContext();
            if (this.loadedVisitor.matches((AnnotationMetadata)memberElement)) {
                try {
                    visitor.visitMethod(memberElement, (VisitorContext)visitorContext);
                }
                catch (Exception e) {
                    throw new ProcessingException((Element)memberElement, e.getMessage());
                }
            }
        }

        private final void visitField(FieldElement memberElement) {
            TypeElementVisitor<?, ?> visitor = this.loadedVisitor.getVisitor();
            KotlinVisitorContext visitorContext = this.loadedVisitor.getVisitorContext();
            if (this.loadedVisitor.matches((AnnotationMetadata)memberElement)) {
                try {
                    visitor.visitField(memberElement, (VisitorContext)visitorContext);
                }
                catch (Exception e) {
                    throw new ProcessingException((Element)memberElement, e.getMessage());
                }
            }
        }

        private final void visitConstructor(ClassElement classElement2, KSFunctionDeclaration ctor) {
            TypeElementVisitor<?, ?> visitor = this.loadedVisitor.getVisitor();
            KotlinVisitorContext visitorContext = this.loadedVisitor.getVisitorContext();
            ConstructorElement ctorElement = visitorContext.getElementFactory().newConstructorElement(classElement2, ctor, visitorContext.getElementAnnotationMetadataFactory());
            if (this.loadedVisitor.matches((AnnotationMetadata)ctorElement)) {
                try {
                    visitor.visitConstructor(ctorElement, (VisitorContext)visitorContext);
                }
                catch (Exception e) {
                    throw new ProcessingException((Element)ctorElement, e.getMessage());
                }
            }
        }

        public final void visitNativeProperty(@NotNull PropertyElement propertyNode) {
            Intrinsics.checkNotNullParameter((Object)propertyNode, (String)"propertyNode");
            TypeElementVisitor<?, ?> visitor = this.loadedVisitor.getVisitor();
            KotlinVisitorContext visitorContext = this.loadedVisitor.getVisitorContext();
            if (this.loadedVisitor.matches((AnnotationMetadata)propertyNode)) {
                propertyNode.getField().ifPresent(arg_0 -> ElementVisitor.visitNativeProperty$lambda$4((Function1)new Function1<FieldElement, Unit>(visitor, visitorContext){
                    final /* synthetic */ TypeElementVisitor<?, ?> $visitor;
                    final /* synthetic */ KotlinVisitorContext $visitorContext;
                    {
                        this.$visitor = $visitor;
                        this.$visitorContext = $visitorContext;
                        super(1);
                    }

                    public final void invoke(@NotNull FieldElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$visitor.visitField(it, (VisitorContext)this.$visitorContext);
                    }
                }, arg_0));
                propertyNode.getWriteMethod().ifPresent(arg_0 -> ElementVisitor.visitNativeProperty$lambda$5((Function1)new Function1<MethodElement, Unit>(visitor, visitorContext){
                    final /* synthetic */ TypeElementVisitor<?, ?> $visitor;
                    final /* synthetic */ KotlinVisitorContext $visitorContext;
                    {
                        this.$visitor = $visitor;
                        this.$visitorContext = $visitorContext;
                        super(1);
                    }

                    public final void invoke(@NotNull MethodElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$visitor.visitMethod(it, (VisitorContext)this.$visitorContext);
                    }
                }, arg_0));
                propertyNode.getReadMethod().ifPresent(arg_0 -> ElementVisitor.visitNativeProperty$lambda$6((Function1)new Function1<MethodElement, Unit>(visitor, visitorContext){
                    final /* synthetic */ TypeElementVisitor<?, ?> $visitor;
                    final /* synthetic */ KotlinVisitorContext $visitorContext;
                    {
                        this.$visitor = $visitor;
                        this.$visitorContext = $visitorContext;
                        super(1);
                    }

                    public final void invoke(@NotNull MethodElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$visitor.visitMethod(it, (VisitorContext)this.$visitorContext);
                    }
                }, arg_0));
            }
        }

        @NotNull
        public Object defaultHandler(@NotNull KSNode node, @NotNull Object data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data;
        }

        private static final ClassElement visitClassDeclaration$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ClassElement)$tmp0.invoke(p0);
        }

        private static final boolean visitClassDeclaration$lambda$2(Set it) {
            return it.contains(ElementModifier.PUBLIC);
        }

        private static final void visitNativeProperty$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void visitNativeProperty$lambda$5(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void visitNativeProperty$lambda$6(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }
    }
}

