/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kotlin.processing.visitor;

import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSPropertyGetter;
import com.google.devtools.ksp.symbol.KSPropertySetter;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeParameter;
import com.google.devtools.ksp.symbol.KSValueParameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lio/micronaut/kotlin/processing/visitor/KotlinNativeElement;", "", "element", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "(Lcom/google/devtools/ksp/symbol/KSAnnotated;)V", "owner", "(Lcom/google/devtools/ksp/symbol/KSAnnotated;Lio/micronaut/kotlin/processing/visitor/KotlinNativeElement;)V", "kotlinNativeType", "(Lcom/google/devtools/ksp/symbol/KSAnnotated;Lio/micronaut/kotlin/processing/visitor/KotlinNativeElement;Ljava/lang/Object;)V", "getElement", "()Lcom/google/devtools/ksp/symbol/KSAnnotated;", "getKotlinNativeType$inject_kotlin", "()Ljava/lang/Object;", "getOwner", "()Lio/micronaut/kotlin/processing/visitor/KotlinNativeElement;", "equals", "", "other", "hashCode", "", "Helper", "inject-kotlin"})
public class KotlinNativeElement {
    @NotNull
    public static final Helper Helper = new Helper(null);
    @NotNull
    private final KSAnnotated element;
    @Nullable
    private final KotlinNativeElement owner;
    @NotNull
    private final Object kotlinNativeType;
    private static final ClassLoader classLoader = Helper.class.getClassLoader();
    private static final Optional<Class<?>> descriptorWithSourceClass = ClassUtils.forName((String)"org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource", (ClassLoader)classLoader);
    private static final Optional<Method> descriptorWithSourceGetSourceMethod = descriptorWithSourceClass.isEmpty() ? Optional.empty() : ReflectionUtils.findMethod(descriptorWithSourceClass.get(), (String)"getSource", (Class[])new Class[0]);
    private static final Optional<Class<?>> javaSourceElementCLass = ClassUtils.forName((String)"org.jetbrains.kotlin.load.java.sources.JavaSourceElement", (ClassLoader)classLoader);
    private static final Optional<Method> javaSourceElementGetJavaElementMethod = javaSourceElementCLass.isEmpty() ? Optional.empty() : ReflectionUtils.findMethod(javaSourceElementCLass.get(), (String)"getJavaElement", (Class[])new Class[0]);

    public KotlinNativeElement(@NotNull KSAnnotated element, @Nullable KotlinNativeElement owner, @NotNull Object kotlinNativeType) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)kotlinNativeType, (String)"kotlinNativeType");
        this.element = element;
        this.owner = owner;
        this.kotlinNativeType = kotlinNativeType;
    }

    @NotNull
    public final KSAnnotated getElement() {
        return this.element;
    }

    @Nullable
    public final KotlinNativeElement getOwner() {
        return this.owner;
    }

    @NotNull
    public final Object getKotlinNativeType$inject_kotlin() {
        return this.kotlinNativeType;
    }

    public KotlinNativeElement(@NotNull KSAnnotated element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this(element, null, Helper.resolveKotlinNativeType(element));
    }

    public KotlinNativeElement(@NotNull KSAnnotated element, @Nullable KotlinNativeElement owner) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this(element, owner, Helper.resolveKotlinNativeType(element));
    }

    public /* synthetic */ KotlinNativeElement(KSAnnotated kSAnnotated, KotlinNativeElement kotlinNativeElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kotlinNativeElement = null;
        }
        this(kSAnnotated, kotlinNativeElement);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinNativeElement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kotlinNativeType, (Object)((KotlinNativeElement)other).kotlinNativeType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.owner, (Object)((KotlinNativeElement)other).owner);
    }

    public int hashCode() {
        return this.kotlinNativeType.hashCode();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b \u0005*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\n0\n \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u000b\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b \u0005*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\n0\n \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/micronaut/kotlin/processing/visitor/KotlinNativeElement$Helper;", "", "()V", "classLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "descriptorWithSourceClass", "Ljava/util/Optional;", "Ljava/lang/Class;", "descriptorWithSourceGetSourceMethod", "Ljava/lang/reflect/Method;", "javaSourceElementCLass", "javaSourceElementGetJavaElementMethod", "extractNativeElement", "descriptor", "resolveKotlinNativeType", "nativeType", "inject-kotlin"})
    public static final class Helper {
        private Helper() {
        }

        @NotNull
        public final Object resolveKotlinNativeType(@NotNull Object nativeType) {
            Object object;
            String string;
            Intrinsics.checkNotNullParameter((Object)nativeType, (String)"nativeType");
            Object object2 = nativeType;
            if (object2 instanceof KSClassDeclaration) {
                string = "ClassOrObject";
            } else if (object2 instanceof KSValueParameter) {
                string = "Parameter";
            } else if (object2 instanceof KSPropertyDeclaration) {
                string = "Property";
            } else if (object2 instanceof KSPropertySetter) {
                string = "PropertySetter";
            } else if (object2 instanceof KSPropertyGetter) {
                string = "PropertyGetter";
            } else if (object2 instanceof KSFunctionDeclaration) {
                string = "Function";
            } else if (object2 instanceof KSTypeArgument) {
                string = "TypeArgument";
            } else if (object2 instanceof KSTypeParameter) {
                string = "TypeParameter";
            } else {
                throw new IllegalStateException("Unknown native type " + nativeType.getClass());
            }
            String kind = string;
            Class<?> javaClass = nativeType.getClass();
            Method method = ReflectionUtils.findMethod(javaClass, (String)("getKt" + kind), (Class[])new Class[0]).orElseGet(() -> Helper.resolveKotlinNativeType$lambda$1(javaClass));
            if (method != null && method.canAccess(nativeType)) {
                Object object3 = method.invoke(nativeType, new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"invoke(...)");
                object = this.extractNativeElement(object3);
            } else {
                object = this.extractNativeElement(nativeType);
            }
            return object;
        }

        private final Object extractNativeElement(Object descriptor) {
            try {
                if (descriptorWithSourceClass.isPresent()) {
                    Object t = descriptorWithSourceClass.get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    Class descriptorWithSourceClass = (Class)t;
                    if (descriptorWithSourceClass.isInstance(descriptor) && descriptorWithSourceGetSourceMethod.isPresent()) {
                        Object source = ((Method)descriptorWithSourceGetSourceMethod.get()).invoke(descriptor, new Object[0]);
                        if (javaSourceElementCLass.isPresent() && ((Class)javaSourceElementCLass.get()).isInstance(source)) {
                            Object object = ((Method)javaSourceElementGetJavaElementMethod.get()).invoke(source, new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                            return object;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return descriptor;
        }

        private static final Method resolveKotlinNativeType$lambda$1$lambda$0(Class $javaClass) {
            Intrinsics.checkNotNullParameter((Object)$javaClass, (String)"$javaClass");
            return ReflectionUtils.findMethod((Class)$javaClass, (String)"getDescriptor", (Class[])new Class[0]).orElse(null);
        }

        private static final Method resolveKotlinNativeType$lambda$1(Class $javaClass) {
            Intrinsics.checkNotNullParameter((Object)$javaClass, (String)"$javaClass");
            return ReflectionUtils.findMethod((Class)$javaClass, (String)"getPsi", (Class[])new Class[0]).orElseGet(() -> Helper.resolveKotlinNativeType$lambda$1$lambda$0($javaClass));
        }

        public /* synthetic */ Helper(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

