/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kotlin.processing;

import com.google.devtools.ksp.processing.KSBuiltIns;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeReference;
import io.micronaut.inject.utils.NativeElementsHelper;
import io.micronaut.kotlin.processing.visitor.KotlinClassNativeElement;
import io.micronaut.kotlin.processing.visitor.KotlinMethodNativeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0014J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J \u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0002H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006 "}, d2={"Lio/micronaut/kotlin/processing/KotlinNativeElementsHelper;", "Lio/micronaut/inject/utils/NativeElementsHelper;", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "(Lcom/google/devtools/ksp/processing/Resolver;)V", "getResolver", "()Lcom/google/devtools/ksp/processing/Resolver;", "setResolver", "excludeClass", "", "classNode", "findOverriddenMethods", "", "methodElement", "getClassCacheKey", "", "classElement", "getInterfaces", "getMethodCacheKey", "getMethodName", "", "element", "getMethods", "", "getSuperClass", "isInterface", "overrides", "m1", "m2", "owner", "micronaut-inject-kotlin"})
public final class KotlinNativeElementsHelper
extends NativeElementsHelper<KSClassDeclaration, KSFunctionDeclaration> {
    @NotNull
    private Resolver resolver;

    public KotlinNativeElementsHelper(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.resolver = resolver;
    }

    @NotNull
    public final Resolver getResolver() {
        return this.resolver;
    }

    public final void setResolver(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"<set-?>");
        this.resolver = resolver;
    }

    @NotNull
    protected Object getClassCacheKey(@NotNull KSClassDeclaration classElement2) {
        Intrinsics.checkNotNullParameter((Object)classElement2, (String)"classElement");
        return new KotlinClassNativeElement(classElement2, null, null);
    }

    @NotNull
    protected Object getMethodCacheKey(@NotNull KSFunctionDeclaration methodElement) {
        Intrinsics.checkNotNullParameter((Object)methodElement, (String)"methodElement");
        return new KotlinMethodNativeElement(methodElement);
    }

    @NotNull
    public final Collection<KSFunctionDeclaration> findOverriddenMethods(@NotNull KSFunctionDeclaration methodElement) {
        Intrinsics.checkNotNullParameter((Object)methodElement, (String)"methodElement");
        KSNode parent = methodElement.getParent();
        if (parent instanceof KSPropertyDeclaration) {
            parent = ((KSPropertyDeclaration)parent).getParent();
        }
        if (parent instanceof KSFunctionDeclaration) {
            parent = ((KSFunctionDeclaration)parent).getParent();
        }
        KSNode kSNode = parent;
        Intrinsics.checkNotNull((Object)kSNode, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
        Collection collection = super.findOverriddenMethods((Object)((KSClassDeclaration)kSNode), (Object)methodElement);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findOverriddenMethods(...)");
        return collection;
    }

    protected boolean overrides(@NotNull KSFunctionDeclaration m1, @NotNull KSFunctionDeclaration m2, @NotNull KSClassDeclaration owner) {
        Intrinsics.checkNotNullParameter((Object)m1, (String)"m1");
        Intrinsics.checkNotNullParameter((Object)m2, (String)"m2");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return this.resolver.overrides((KSDeclaration)m1, (KSDeclaration)m2);
    }

    @NotNull
    protected String getMethodName(@NotNull KSFunctionDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getSimpleName().asString();
    }

    @Nullable
    protected KSClassDeclaration getSuperClass(@NotNull KSClassDeclaration classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Sequence superTypes = classNode.getSuperTypes();
        for (KSTypeReference superclass : superTypes) {
            KSType resolved = superclass.resolve();
            KSDeclaration declaration2 = resolved.getDeclaration();
            if (!(declaration2 instanceof KSClassDeclaration) || ((KSClassDeclaration)declaration2).getClassKind() != ClassKind.CLASS) continue;
            KSName kSName = declaration2.getQualifiedName();
            if (Intrinsics.areEqual((Object)(kSName != null ? kSName.asString() : null), (Object)Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName())) continue;
            return (KSClassDeclaration)declaration2;
        }
        return null;
    }

    @NotNull
    protected Collection<KSClassDeclaration> getInterfaces(@NotNull KSClassDeclaration classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Sequence superTypes = classNode.getSuperTypes();
        Collection result = new ArrayList();
        for (KSTypeReference superclass : superTypes) {
            KSType resolved = superclass.resolve();
            KSDeclaration declaration2 = resolved.getDeclaration();
            if (!(declaration2 instanceof KSClassDeclaration) || ((KSClassDeclaration)declaration2).getClassKind() != ClassKind.INTERFACE) continue;
            result.add(declaration2);
        }
        return result;
    }

    @NotNull
    protected List<KSFunctionDeclaration> getMethods(@NotNull KSClassDeclaration classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        return SequencesKt.toMutableList((Sequence)classNode.getAllFunctions());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean excludeClass(@NotNull KSClassDeclaration classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        KSType t = classNode.asStarProjectedType();
        KSBuiltIns builtIns = this.resolver.getBuiltIns();
        if (Intrinsics.areEqual((Object)t, (Object)builtIns.getAnyType())) return true;
        if (Intrinsics.areEqual((Object)t, (Object)builtIns.getNothingType())) return true;
        if (Intrinsics.areEqual((Object)t, (Object)builtIns.getUnitType())) return true;
        if (classNode.getQualifiedName() == null) return false;
        KSName kSName = classNode.getQualifiedName();
        Intrinsics.checkNotNull((Object)kSName);
        if (Intrinsics.areEqual((Object)kSName.asString(), (Object)Enum.class.getName())) return true;
        KSName kSName2 = classNode.getQualifiedName();
        Intrinsics.checkNotNull((Object)kSName2);
        if (!Intrinsics.areEqual((Object)kSName2.asString(), (Object)Record.class.getName())) return false;
        return true;
    }

    protected boolean isInterface(@NotNull KSClassDeclaration classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        return classNode.getClassKind() == ClassKind.INTERFACE;
    }
}

