/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kotlin.processing;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSNode;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.AbstractClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.kotlin.processing.visitor.AbstractKotlinElement;
import io.micronaut.kotlin.processing.visitor.KotlinNativeElement;
import io.micronaut.kotlin.processing.visitor.KotlinVisitorContext;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J)\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0011\u001a\u00020\nH\u0016J/\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0011\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0019J7\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u001dJ/\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0011\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0019J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/micronaut/kotlin/processing/KotlinOutputVisitor;", "Lio/micronaut/inject/writer/AbstractClassWriterOutputVisitor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "context", "Lio/micronaut/kotlin/processing/visitor/KotlinVisitorContext;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;Lio/micronaut/kotlin/processing/visitor/KotlinVisitorContext;)V", "getNativeElements", "Lcom/google/devtools/ksp/processing/Dependencies;", "fileName", "", "originatingElements", "", "Lio/micronaut/inject/ast/Element;", "(Ljava/lang/String;[Lio/micronaut/inject/ast/Element;)Lcom/google/devtools/ksp/processing/Dependencies;", "normalizePath", "", "path", "visitClass", "Ljava/io/OutputStream;", "classname", "(Ljava/lang/String;[Lio/micronaut/inject/ast/Element;)Ljava/io/OutputStream;", "visitGeneratedFile", "Ljava/util/Optional;", "Lio/micronaut/inject/writer/GeneratedFile;", "(Ljava/lang/String;[Lio/micronaut/inject/ast/Element;)Ljava/util/Optional;", "visitGeneratedSourceFile", "packageName", "fileNameWithoutExtension", "(Ljava/lang/String;Ljava/lang/String;[Lio/micronaut/inject/ast/Element;)Ljava/util/Optional;", "visitMetaInfFile", "visitServiceDescriptor", "", "type", "originatingElement", "micronaut-inject-kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinOutputVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinOutputVisitor.kt\nio/micronaut/kotlin/processing/KotlinOutputVisitor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,102:1\n26#2:103\n26#2:106\n37#3,2:104\n*S KotlinDebug\n*F\n+ 1 KotlinOutputVisitor.kt\nio/micronaut/kotlin/processing/KotlinOutputVisitor\n*L\n60#1:103\n97#1:106\n91#1:104,2\n*E\n"})
public final class KotlinOutputVisitor
extends AbstractClassWriterOutputVisitor {
    @NotNull
    private final SymbolProcessorEnvironment environment;
    @NotNull
    private final KotlinVisitorContext context;

    public KotlinOutputVisitor(@NotNull SymbolProcessorEnvironment environment, @NotNull KotlinVisitorContext context) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(false);
        this.environment = environment;
        this.context = context;
    }

    @NotNull
    public OutputStream visitClass(@NotNull String classname, Element ... originatingElements) {
        Intrinsics.checkNotNullParameter((Object)classname, (String)"classname");
        Intrinsics.checkNotNullParameter((Object)originatingElements, (String)"originatingElements");
        return this.environment.getCodeGenerator().createNewFile(this.getNativeElements(classname, originatingElements), StringsKt.substringBeforeLast$default((String)classname, (char)'.', null, (int)2, null), StringsKt.substringAfterLast$default((String)classname, (char)'.', null, (int)2, null), "class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitServiceDescriptor(@NotNull String type, @NotNull String classname, @NotNull Element originatingElement) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)classname, (String)"classname");
        Intrinsics.checkNotNullParameter((Object)originatingElement, (String)"originatingElement");
        String fileName = type + File.separator + classname;
        String packageName = "META-INF.micronaut";
        Object object = new Element[]{originatingElement};
        object = this.environment.getCodeGenerator().createNewFile(this.getNativeElements(packageName + "." + fileName, (Element[])object), packageName, fileName, "");
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)object;
            boolean bl = false;
            OutputStream outputStream = it;
            Charset charset = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter(outputStream, charset);
            int n = 8192;
            (writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n)).write("");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public Optional<GeneratedFile> visitMetaInfFile(@NotNull String path, Element ... originatingElements) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)originatingElements, (String)"originatingElements");
        List<String> elements2 = this.normalizePath("META-INF/" + path);
        Optional<GeneratedFile> optional = Optional.of(new KotlinVisitorContext.KspGeneratedFile(this.environment, elements2, this.getNativeElements(path, originatingElements)));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @NotNull
    public Optional<GeneratedFile> visitGeneratedFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List<String> elements2 = this.normalizePath(path);
        boolean $i$f$emptyArray = false;
        KSFile[] kSFileArray = new KSFile[]{};
        Optional<GeneratedFile> optional = Optional.of(new KotlinVisitorContext.KspGeneratedFile(this.environment, elements2, new Dependencies(true, Arrays.copyOf(kSFileArray, kSFileArray.length))));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @NotNull
    public Optional<GeneratedFile> visitGeneratedFile(@NotNull String path, Element ... originatingElements) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)originatingElements, (String)"originatingElements");
        List<String> elements2 = this.normalizePath(path);
        Optional<GeneratedFile> optional = Optional.of(new KotlinVisitorContext.KspGeneratedFile(this.environment, elements2, this.getNativeElements(path, originatingElements)));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @NotNull
    public Optional<GeneratedFile> visitGeneratedSourceFile(@NotNull String packageName, @NotNull String fileNameWithoutExtension, Element ... originatingElements) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        Intrinsics.checkNotNullParameter((Object)originatingElements, (String)"originatingElements");
        char[] cArray = new char[]{'.'};
        List elements2 = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)packageName, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        String fileName = fileNameWithoutExtension + ".kt";
        elements2.add(fileName);
        Optional<GeneratedFile> optional = Optional.of(new KotlinVisitorContext.KspGeneratedFile(this.environment, elements2, this.getNativeElements(packageName + "." + fileName, originatingElements)));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    private final List<String> normalizePath(String path) {
        String[] stringArray = new String[]{"/"};
        return CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)StringsKt.replace$default((String)path, (String)"\\\\", (String)"/", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final Dependencies getNativeElements(String fileName, Element[] originatingElements) {
        KSFile[] kSFileArray;
        if (this.context.getAggregating()) {
            return Dependencies.Companion.getALL_FILES();
        }
        if (!(originatingElements.length == 0)) {
            List originatingFiles = new ArrayList(originatingElements.length);
            for (Element originatingElement : originatingElements) {
                KSFile nativeType;
                if (!(originatingElement instanceof AbstractKotlinElement) || (nativeType = UtilsKt.getContainingFile((KSNode)((KSNode)((KotlinNativeElement)((AbstractKotlinElement)originatingElement).getNativeType()).getElement()))) == null) continue;
                originatingFiles.add(nativeType);
            }
            Collection $this$toTypedArray$iv = originatingFiles;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            kSFileArray = thisCollection$iv.toArray(new KSFile[0]);
        } else {
            this.context.warn("File " + fileName + " is generated from a non-aggregating visitor and without any originating elements", (Element)null);
            boolean $i$f$emptyArray = false;
            kSFileArray = new KSFile[]{};
        }
        KSFile[] sources = kSFileArray;
        return new Dependencies(false, Arrays.copyOf(sources, sources.length));
    }
}

