/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DefaultBeanResolutionContext;
import io.micronaut.context.DefaultConstructorInjectionPoint;
import io.micronaut.context.DefaultFieldInjectionPoint;
import io.micronaut.context.DefaultMethodConstructorInjectionPoint;
import io.micronaut.context.DefaultMethodInjectionPoint;
import io.micronaut.context.EnvironmentAwareArgument;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.MissingMethodInjectionPoint;
import io.micronaut.context.Qualifier;
import io.micronaut.context.ReflectionConstructorInjectionPoint;
import io.micronaut.context.ReflectionFieldInjectionPoint;
import io.micronaut.context.ReflectionMethodConstructorInjectionPoint;
import io.micronaut.context.ReflectionMethodInjectionPoint;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Provided;
import io.micronaut.context.annotation.Type;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanInitializingEvent;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class AbstractBeanDefinition<T>
extends AbstractBeanContextConditional
implements BeanDefinition<T>,
EnvironmentConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBeanDefinition.class);
    protected final List<MethodInjectionPoint> methodInjectionPoints = new ArrayList<MethodInjectionPoint>(3);
    protected final List<FieldInjectionPoint> fieldInjectionPoints = new ArrayList<FieldInjectionPoint>(3);
    protected final List<MethodInjectionPoint> postConstructMethods = new ArrayList<MethodInjectionPoint>(1);
    protected final List<MethodInjectionPoint> preDestroyMethods = new ArrayList<MethodInjectionPoint>(1);
    protected final Map<MethodKey, ExecutableMethod<T, ?>> executableMethodMap = new LinkedHashMap(3);
    private final Class<T> type;
    private final boolean isAbstract;
    private final boolean singleton;
    private final boolean isProvided;
    private final boolean isConfigurationProperties;
    private final Class<?> declaringType;
    private final ConstructorInjectionPoint<T> constructor;
    private final Collection<Class> requiredComponents = new HashSet<Class>(3);
    private AnnotationMetadata beanAnnotationMetadata;
    private Environment environment;

    @Internal
    protected AbstractBeanDefinition(Class<T> producedType, Class<?> declaringType, String methodName, AnnotationMetadata methodMetadata, boolean requiresReflection, Argument ... arguments) {
        AnnotationMetadata beanAnnotationMetadata = this.getAnnotationMetadata();
        this.singleton = beanAnnotationMetadata.hasDeclaredStereotype(Singleton.class);
        this.isProvided = beanAnnotationMetadata.hasDeclaredStereotype(Provided.class);
        this.type = producedType;
        this.isAbstract = false;
        this.declaringType = declaringType;
        this.constructor = requiresReflection ? new ReflectionMethodConstructorInjectionPoint(this, declaringType, methodName, arguments, methodMetadata) : new DefaultMethodConstructorInjectionPoint(this, declaringType, methodName, arguments, methodMetadata);
        this.isConfigurationProperties = this.hasStereotype(ConfigurationReader.class) || this.isIterable();
        this.addRequiredComponents(arguments);
    }

    @Internal
    protected AbstractBeanDefinition(Class<T> type, AnnotationMetadata constructorAnnotationMetadata, boolean requiresReflection, Argument ... arguments) {
        AnnotationMetadata beanAnnotationMetadata = this.getAnnotationMetadata();
        this.type = type;
        this.isAbstract = Modifier.isAbstract(this.type.getModifiers());
        this.isProvided = beanAnnotationMetadata.hasDeclaredStereotype(Provided.class);
        this.singleton = beanAnnotationMetadata.hasDeclaredStereotype(Singleton.class);
        this.declaringType = type;
        this.constructor = requiresReflection ? new ReflectionConstructorInjectionPoint<T>(this, type, constructorAnnotationMetadata, arguments) : new DefaultConstructorInjectionPoint<T>(this, type, constructorAnnotationMetadata, arguments);
        this.isConfigurationProperties = this.hasStereotype(ConfigurationReader.class) || this.isIterable();
        this.addRequiredComponents(arguments);
    }

    @Override
    @Nonnull
    public List<Argument<?>> getTypeArguments(String type) {
        if (type == null) {
            return Collections.emptyList();
        }
        Map<String, Argument<?>[]> typeArguments = this.getTypeArgumentsMap();
        Argument<?>[] arguments = typeArguments.get(type);
        if (arguments != null) {
            return Arrays.asList(arguments);
        }
        return Collections.emptyList();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        if (this.beanAnnotationMetadata == null) {
            this.beanAnnotationMetadata = this.initializeAnnotationMetadata();
        }
        return this.beanAnnotationMetadata;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isIterable() {
        return this.hasDeclaredStereotype(EachProperty.class) || this.hasDeclaredStereotype(EachBean.class);
    }

    @Override
    public boolean isPrimary() {
        return this.hasDeclaredStereotype(Primary.class);
    }

    @Override
    public <R> Optional<ExecutableMethod<T, R>> findMethod(String name, Class ... argumentTypes) {
        MethodKey methodKey = new MethodKey(name, argumentTypes);
        ExecutableMethod<T, ?> invocableMethod = this.executableMethodMap.get(methodKey);
        if (invocableMethod != null) {
            return Optional.of(invocableMethod);
        }
        return Optional.empty();
    }

    @Override
    public Stream<ExecutableMethod<T, ?>> findPossibleMethods(String name) {
        if (this.executableMethodMap.keySet().stream().anyMatch(methodKey -> methodKey.name.equals(name))) {
            return this.executableMethodMap.values().stream().filter(method -> method.getMethodName().equals(name));
        }
        return Stream.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBeanDefinition that = (AbstractBeanDefinition)o;
        return this.getClass().equals(that.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "Definition: " + this.declaringType.getName();
    }

    @Override
    public boolean isProvided() {
        return this.isProvided;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public Optional<Class<? extends Annotation>> getScope() {
        return this.getAnnotationMetadata().getDeclaredAnnotationTypeByStereotype(Scope.class);
    }

    @Override
    public Class<T> getBeanType() {
        return this.type;
    }

    @Override
    public Optional<Class<?>> getDeclaringType() {
        return Optional.ofNullable(this.declaringType);
    }

    @Override
    public ConstructorInjectionPoint<T> getConstructor() {
        return this.constructor;
    }

    @Override
    public Collection<Class> getRequiredComponents() {
        return Collections.unmodifiableCollection(this.requiredComponents);
    }

    @Override
    public Collection<MethodInjectionPoint> getInjectedMethods() {
        return Collections.unmodifiableCollection(this.methodInjectionPoints);
    }

    @Override
    public Collection<FieldInjectionPoint> getInjectedFields() {
        return Collections.unmodifiableCollection(this.fieldInjectionPoints);
    }

    @Override
    public Collection<MethodInjectionPoint> getPostConstructMethods() {
        return Collections.unmodifiableCollection(this.postConstructMethods);
    }

    @Override
    public Collection<MethodInjectionPoint> getPreDestroyMethods() {
        return Collections.unmodifiableCollection(this.preDestroyMethods);
    }

    @Override
    public String getName() {
        return this.getBeanType().getName();
    }

    @Override
    public T inject(BeanContext context, T bean) {
        return (T)this.injectBean(new DefaultBeanResolutionContext(context, this), context, bean);
    }

    @Override
    public T inject(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
        return (T)this.injectBean(resolutionContext, context, bean);
    }

    @Override
    public Collection<ExecutableMethod<T, ?>> getExecutableMethods() {
        return Collections.unmodifiableCollection(this.executableMethodMap.values());
    }

    @Override
    @Internal
    public final void configure(Environment environment) {
        if (environment != null) {
            this.environment = environment;
            if (this.constructor instanceof EnvironmentConfigurable) {
                ((EnvironmentConfigurable)((Object)this.constructor)).configure(environment);
            }
            for (MethodInjectionPoint methodInjectionPoint : this.methodInjectionPoints) {
                if (!(methodInjectionPoint instanceof EnvironmentConfigurable)) continue;
                ((EnvironmentConfigurable)((Object)methodInjectionPoint)).configure(environment);
            }
            for (ExecutableMethod executableMethod : this.executableMethodMap.values()) {
                if (!(executableMethod instanceof EnvironmentConfigurable)) continue;
                ((EnvironmentConfigurable)((Object)executableMethod)).configure(environment);
            }
        }
    }

    @Internal
    protected final void warn(String message) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(message);
        }
    }

    @Internal
    protected final void warnMissingProperty(Class type, String method, String property) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Configuration property [{}] could not be set as the underlying method [{}] does not exist on builder [{}]. This usually indicates the configuration option was deprecated and has been removed by the builder implementation (potentially a third-party library).", new Object[]{property, method, type});
        }
    }

    @Internal
    protected final Object getProxiedBean(BeanContext beanContext) {
        DefaultBeanContext defaultBeanContext = (DefaultBeanContext)beanContext;
        Optional qualifier = this.getAnnotationMetadata().getAnnotationNameByStereotype(javax.inject.Qualifier.class);
        return defaultBeanContext.getProxyTargetBean(this.getBeanType(), qualifier.map(q -> Qualifiers.byAnnotation(this.getAnnotationMetadata(), q)).orElse(null));
    }

    @Internal
    protected final AbstractBeanDefinition<T> addExecutableMethod(ExecutableMethod<T, ?> executableMethod) {
        MethodKey key = new MethodKey(executableMethod.getMethodName(), executableMethod.getArgumentTypes());
        this.executableMethodMap.put(key, executableMethod);
        return this;
    }

    @Internal
    protected final AbstractBeanDefinition addInjectionPoint(Class declaringType, Class fieldType, String field, @Nullable AnnotationMetadata annotationMetadata, @Nullable Argument[] typeArguments, boolean requiresReflection) {
        if (annotationMetadata != null && annotationMetadata.hasDeclaredAnnotation(Inject.class)) {
            this.requiredComponents.add(fieldType);
        }
        if (requiresReflection) {
            this.fieldInjectionPoints.add(new ReflectionFieldInjectionPoint(this, declaringType, fieldType, field, annotationMetadata, typeArguments));
        } else {
            this.fieldInjectionPoints.add(new DefaultFieldInjectionPoint(this, declaringType, fieldType, field, annotationMetadata, typeArguments));
        }
        return this;
    }

    @Internal
    protected final AbstractBeanDefinition addInjectionPoint(Class declaringType, String method, @Nullable Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata, boolean requiresReflection) {
        return this.addInjectionPointInternal(declaringType, method, arguments, annotationMetadata, requiresReflection, this.methodInjectionPoints);
    }

    @Internal
    protected final AbstractBeanDefinition addPostConstruct(Class declaringType, String method, @Nullable Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata, boolean requiresReflection) {
        return this.addInjectionPointInternal(declaringType, method, arguments, annotationMetadata, requiresReflection, this.postConstructMethods);
    }

    @Internal
    protected final AbstractBeanDefinition addPreDestroy(Class declaringType, String method, Argument[] arguments, AnnotationMetadata annotationMetadata, boolean requiresReflection) {
        return this.addInjectionPointInternal(declaringType, method, arguments, annotationMetadata, requiresReflection, this.preDestroyMethods);
    }

    @Internal
    protected Object injectBean(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        return bean;
    }

    @Internal
    protected Object injectAnother(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        DefaultBeanContext defaultContext = (DefaultBeanContext)context;
        if (bean == null) {
            throw new BeanInstantiationException(resolutionContext, "Bean factory returned null");
        }
        return defaultContext.inject(resolutionContext, this, bean);
    }

    @Internal
    protected Object postConstruct(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        DefaultBeanContext defaultContext = (DefaultBeanContext)context;
        Collection<BeanRegistration<BeanInitializedEventListener>> beanInitializedEventListeners = ((DefaultBeanContext)context).beanInitializedEventListeners;
        if (CollectionUtils.isNotEmpty(beanInitializedEventListeners)) {
            for (BeanRegistration<BeanInitializedEventListener> registration : beanInitializedEventListeners) {
                BeanInitializedEventListener listener;
                BeanDefinition<BeanInitializedEventListener> definition = registration.getBeanDefinition();
                List<Argument<BeanInitializedEventListener>> typeArguments = definition.getTypeArguments(BeanInitializedEventListener.class);
                if (!CollectionUtils.isEmpty(typeArguments) && !typeArguments.get(0).getType().isAssignableFrom(this.getBeanType()) || (bean = (listener = registration.getBean()).onInitialized(new BeanInitializingEvent<Object>(context, this, bean))) != null) continue;
                throw new BeanInstantiationException(resolutionContext, "Listener [" + listener + "] returned null from onInitialized event");
            }
        }
        for (int i = 0; i < this.methodInjectionPoints.size(); ++i) {
            MethodInjectionPoint methodInjectionPoint = this.methodInjectionPoints.get(i);
            if (!methodInjectionPoint.isPostConstructMethod() || !methodInjectionPoint.requiresReflection()) continue;
            this.injectBeanMethod(resolutionContext, defaultContext, i, bean);
        }
        if (bean instanceof LifeCycle) {
            bean = ((LifeCycle)bean).start();
        }
        return bean;
    }

    protected Object preDestroy(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        DefaultBeanContext defaultContext = (DefaultBeanContext)context;
        for (int i = 0; i < this.methodInjectionPoints.size(); ++i) {
            MethodInjectionPoint methodInjectionPoint = this.methodInjectionPoints.get(i);
            if (!methodInjectionPoint.isPreDestroyMethod() || !methodInjectionPoint.requiresReflection()) continue;
            this.injectBeanMethod(resolutionContext, defaultContext, i, bean);
        }
        if (bean instanceof LifeCycle) {
            bean = ((LifeCycle)bean).stop();
        }
        return bean;
    }

    @Internal
    protected void injectBeanMethod(BeanResolutionContext resolutionContext, DefaultBeanContext context, int methodIndex, Object bean) {
        MethodInjectionPoint methodInjectionPoint = this.methodInjectionPoints.get(methodIndex);
        Argument<?>[] methodArgumentTypes = methodInjectionPoint.getArguments();
        Object[] methodArgs = new Object[methodArgumentTypes.length];
        for (int i = 0; i < methodArgumentTypes.length; ++i) {
            methodArgs[i] = this.getBeanForMethodArgument(resolutionContext, (BeanContext)context, methodIndex, i);
        }
        try {
            methodInjectionPoint.invoke(bean, methodArgs);
        }
        catch (Throwable e) {
            throw new BeanInstantiationException(this, e);
        }
    }

    @Internal
    protected final void injectBeanField(BeanResolutionContext resolutionContext, DefaultBeanContext context, int index, Object bean) {
        FieldInjectionPoint fieldInjectionPoint = this.fieldInjectionPoints.get(index);
        boolean isInject = fieldInjectionPoint.getAnnotationMetadata().hasDeclaredAnnotation(Inject.class);
        try {
            Object value = isInject ? this.getBeanForField(resolutionContext, (BeanContext)context, fieldInjectionPoint) : this.getValueForField(resolutionContext, context, index);
            if (value != null) {
                fieldInjectionPoint.set(bean, value);
            }
        }
        catch (Throwable e) {
            if (e instanceof BeanContextException) {
                throw (BeanContextException)e;
            }
            throw new DependencyInjectionException(resolutionContext, fieldInjectionPoint, "Error setting field value: " + e.getMessage(), e);
        }
    }

    @Internal
    protected final Object getValueForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex) {
        MethodInjectionPoint injectionPoint = this.methodInjectionPoints.get(methodIndex);
        Argument<?> argument = injectionPoint.getArguments()[argIndex];
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, injectionPoint, argument);
        if (context instanceof ApplicationContext) {
            try {
                String valueAnnStr = argument.getAnnotationMetadata().getValue(Value.class, String.class).orElse(null);
                Class argumentType = argument.getType();
                if (this.isInnerConfiguration(argumentType)) {
                    Object t = ((DefaultBeanContext)context).createBean(resolutionContext, argumentType, null);
                    return t;
                }
                String argumentName = argument.getName();
                String valString = this.resolvePropertyValueName(resolutionContext, injectionPoint.getAnnotationMetadata(), argument, valueAnnStr);
                ApplicationContext applicationContext = (ApplicationContext)context;
                ArgumentConversionContext conversionContext = ConversionContext.of(argument);
                Optional value = this.resolveValue(applicationContext, conversionContext, valueAnnStr != null, valString);
                if (argumentType == Optional.class) {
                    Object object = this.resolveOptionalObject(value);
                    return object;
                }
                if (value.isPresent()) {
                    Object t = value.get();
                    return t;
                }
                if (argument.isDeclaredAnnotationPresent(Nullable.class)) {
                    Object var15_18 = null;
                    return var15_18;
                }
                throw new DependencyInjectionException(resolutionContext, injectionPoint, conversionContext, valString);
            }
            finally {
                path.pop();
            }
        }
        path.pop();
        throw new DependencyInjectionException(resolutionContext, argument, "BeanContext must support property resolution");
    }

    @Internal
    protected final boolean containsValueForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex) {
        if (context instanceof ApplicationContext) {
            String cliOption;
            boolean result;
            MethodInjectionPoint injectionPoint = this.methodInjectionPoints.get(methodIndex);
            Argument<?> argument = injectionPoint.getArguments()[argIndex];
            String valueAnnStr = argument.getAnnotationMetadata().getValue(Value.class, String.class).orElse(null);
            String valString = this.resolvePropertyValueName(resolutionContext, injectionPoint.getAnnotationMetadata(), argument, valueAnnStr);
            ApplicationContext applicationContext = (ApplicationContext)context;
            Class type = argument.getType();
            boolean isConfigProps = type.isAnnotationPresent(ConfigurationProperties.class);
            boolean bl = result = isConfigProps || Map.class.isAssignableFrom(type) ? applicationContext.containsProperties(valString) : applicationContext.containsProperty(valString);
            if (!result && this.isConfigurationProperties() && (cliOption = this.resolveCliOption(argument.getName())) != null) {
                result = applicationContext.containsProperty(cliOption);
            }
            if (result && injectionPoint instanceof MissingMethodInjectionPoint) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Bean definition for type [{}] is compiled against an older version and value [{}] can no longer be set for missing method: {}", new Object[]{this.getBeanType(), valString, injectionPoint.getName()});
                }
                result = false;
            }
            return result;
        }
        return false;
    }

    @Internal
    protected final Object getBeanForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex) {
        MethodInjectionPoint injectionPoint = this.methodInjectionPoints.get(methodIndex);
        Object argument = injectionPoint.getArguments()[argIndex];
        if (argument instanceof DefaultArgument) {
            argument = new EnvironmentAwareArgument((DefaultArgument)argument);
            this.instrumentAnnotationMetadata(context, argument);
        }
        return this.getBeanForMethodArgument(resolutionContext, context, injectionPoint, (Argument)argument);
    }

    @Internal
    protected final Collection getBeansOfTypeForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromMethodArgument(resolutionContext, injectionPoint, argument, (beanType, qualifier) -> {
            boolean hasNoGenerics;
            boolean bl = hasNoGenerics = !argument.getType().isArray() && argument.getTypeVariables().isEmpty();
            if (hasNoGenerics) {
                return (Collection)((DefaultBeanContext)context).getBean(resolutionContext, beanType, qualifier);
            }
            return ((DefaultBeanContext)context).getBeansOfType(resolutionContext, beanType, qualifier);
        });
    }

    @Internal
    protected final Provider getBeanProviderForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromMethodArgument(resolutionContext, injectionPoint, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).getBeanProvider(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Optional findBeanForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromMethodArgument(resolutionContext, injectionPoint, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).findBean(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Stream streamOfTypeForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromMethodArgument(resolutionContext, injectionPoint, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).streamOfType(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Object getBeanForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex) {
        Class argumentType;
        ConstructorInjectionPoint<T> constructorInjectionPoint = this.getConstructor();
        Object argument = constructorInjectionPoint.getArguments()[argIndex];
        if (argument instanceof DefaultArgument) {
            argument = new EnvironmentAwareArgument((DefaultArgument)argument);
            this.instrumentAnnotationMetadata(context, argument);
        }
        if ((argumentType = argument.getType()) == BeanResolutionContext.class) {
            return resolutionContext;
        }
        if (argumentType.isArray()) {
            Collection beansOfType = this.getBeansOfTypeForConstructorArgument(resolutionContext, context, constructorInjectionPoint, (Argument)argument);
            return beansOfType.toArray((Object[])Array.newInstance(argumentType.getComponentType(), beansOfType.size()));
        }
        if (Collection.class.isAssignableFrom(argumentType)) {
            Collection beansOfType = this.getBeansOfTypeForConstructorArgument(resolutionContext, context, constructorInjectionPoint, (Argument)argument);
            return this.coerceCollectionToCorrectType(argumentType, beansOfType);
        }
        if (Stream.class.isAssignableFrom(argumentType)) {
            return this.streamOfTypeForConstructorArgument(resolutionContext, context, constructorInjectionPoint, (Argument)argument);
        }
        if (Provider.class.isAssignableFrom(argumentType)) {
            return this.getBeanProviderForConstructorArgument(resolutionContext, context, constructorInjectionPoint, (Argument)argument);
        }
        if (Optional.class.isAssignableFrom(argumentType)) {
            return this.findBeanForConstructorArgument(resolutionContext, context, constructorInjectionPoint, (Argument)argument);
        }
        BeanResolutionContext.Path path = resolutionContext.getPath();
        BeanResolutionContext.Segment current = (BeanResolutionContext.Segment)path.peek();
        boolean isNullable = argument.isDeclaredAnnotationPresent(Nullable.class);
        if (isNullable && current != null && current.getArgument().equals(argument)) {
            return null;
        }
        path.pushConstructorResolve(this, (Argument)argument);
        try {
            Qualifier qualifier = this.resolveQualifier(resolutionContext, (Argument)argument);
            Object bean = ((DefaultBeanContext)context).getBean(resolutionContext, argumentType, qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            if (isNullable) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, (Argument)argument, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Internal
    protected final Object getValueForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex) {
        ConstructorInjectionPoint<T> constructorInjectionPoint = this.getConstructor();
        BeanResolutionContext.Path path = resolutionContext.getPath();
        Argument<?> argument = constructorInjectionPoint.getArguments()[argIndex];
        path.pushConstructorResolve(this, argument);
        try {
            Object result;
            if (!(context instanceof ApplicationContext)) throw new DependencyInjectionException(resolutionContext, argument, "BeanContext must support property resolution");
            ApplicationContext propertyResolver = (ApplicationContext)context;
            AnnotationMetadata argMetadata = argument.getAnnotationMetadata();
            Optional valAnn = argMetadata.getValue(Value.class, String.class);
            String prop = valAnn.orElseGet(() -> (String)argMetadata.getValue(Property.class, "name", String.class).orElseThrow(() -> new IllegalStateException("Compiled getValueForMethodArgument(..) call present but @Value annotation missing.")));
            ArgumentConversionContext conversionContext = ConversionContext.of(argument);
            Optional value = this.resolveValue(propertyResolver, conversionContext, valAnn.isPresent(), prop);
            if (argument.getType() == Optional.class) {
                return this.resolveOptionalObject(value);
            }
            if (value.isPresent()) {
                result = value.get();
            } else {
                if (!argMetadata.hasDeclaredAnnotation(Nullable.class)) throw new DependencyInjectionException(resolutionContext, conversionContext, prop);
                result = null;
            }
            path.pop();
            return result;
        }
        catch (BeanInstantiationException | NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
    }

    @Internal
    protected final Provider getBeanProviderForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, ConstructorInjectionPoint constructorInjectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromConstructorArgument(resolutionContext, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).getBeanProvider(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Collection getBeansOfTypeForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, ConstructorInjectionPoint<T> constructorInjectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromConstructorArgument(resolutionContext, argument, (beanType, qualifier) -> {
            boolean hasNoGenerics;
            boolean bl = hasNoGenerics = !argument.getType().isArray() && argument.getTypeVariables().isEmpty();
            if (hasNoGenerics) {
                return (Collection)((DefaultBeanContext)context).getBean(resolutionContext, beanType, qualifier);
            }
            return ((DefaultBeanContext)context).getBeansOfType(resolutionContext, beanType, qualifier);
        });
    }

    @Internal
    protected final Stream streamOfTypeForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, ConstructorInjectionPoint<T> constructorInjectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromConstructorArgument(resolutionContext, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).streamOfType(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Optional findBeanForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, ConstructorInjectionPoint<T> constructorInjectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromConstructorArgument(resolutionContext, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).findBean(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Object getBeanForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        FieldInjectionPoint injectionPoint = this.fieldInjectionPoints.get(fieldIndex);
        this.instrumentAnnotationMetadata(context, injectionPoint);
        return this.getBeanForField(resolutionContext, context, injectionPoint);
    }

    @Internal
    protected final Object getValueForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        FieldInjectionPoint injectionPoint = this.fieldInjectionPoints.get(fieldIndex);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, injectionPoint);
        try {
            if (context instanceof PropertyResolver) {
                AnnotationMetadata annotationMetadata = injectionPoint.getAnnotationMetadata();
                String valueAnnVal = annotationMetadata.getValue(Value.class, String.class).orElse(null);
                Class fieldType = injectionPoint.getType();
                if (this.isInnerConfiguration(fieldType)) {
                    Object t = context.createBean(fieldType);
                    return t;
                }
                String valString = this.resolvePropertyValueName(resolutionContext, injectionPoint, valueAnnVal, annotationMetadata);
                Argument fieldArgument = injectionPoint.asArgument();
                ArgumentConversionContext conversionContext = ConversionContext.of(fieldArgument);
                Optional value = this.resolveValue((ApplicationContext)context, conversionContext, valueAnnVal != null, valString);
                if (fieldType == Optional.class) {
                    Object object = this.resolveOptionalObject(value);
                    return object;
                }
                if (value.isPresent()) {
                    Object t = value.get();
                    return t;
                }
                if (fieldArgument.isDeclaredAnnotationPresent(Nullable.class)) {
                    Object var13_16 = null;
                    return var13_16;
                }
                throw new DependencyInjectionException(resolutionContext, injectionPoint, "Error resolving field value [" + valString + "]. Property doesn't exist or cannot be converted");
            }
            throw new DependencyInjectionException(resolutionContext, injectionPoint, "@Value requires a BeanContext that implements PropertyResolver");
        }
        finally {
            path.pop();
        }
    }

    @Internal
    protected final <T1> Optional<T1> getValueForPath(BeanResolutionContext resolutionContext, BeanContext context, Argument<T1> propertyType, String ... propertyPath) {
        if (context instanceof PropertyResolver) {
            PropertyResolver propertyResolver = (PropertyResolver)context;
            Class<T> beanType = this.getBeanType();
            String pathString = propertyPath.length > 1 ? String.join((CharSequence)".", propertyPath) : propertyPath[0];
            String valString = this.resolvePropertyPath(resolutionContext, pathString);
            return propertyResolver.getProperty(valString, ConversionContext.of(propertyType));
        }
        return Optional.empty();
    }

    @Internal
    protected final boolean containsValueForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        if (context instanceof ApplicationContext) {
            String cliOption;
            boolean result;
            FieldInjectionPoint injectionPoint = this.fieldInjectionPoints.get(fieldIndex);
            AnnotationMetadata annotationMetadata = injectionPoint.getAnnotationMetadata();
            String valueAnnVal = annotationMetadata.getValue(Value.class, String.class).orElse(null);
            String valString = this.resolvePropertyValueName(resolutionContext, injectionPoint, valueAnnVal, annotationMetadata);
            ApplicationContext applicationContext = (ApplicationContext)context;
            Class fieldType = injectionPoint.getType();
            boolean isConfigProps = fieldType.isAnnotationPresent(ConfigurationProperties.class);
            boolean bl = result = isConfigProps || Map.class.isAssignableFrom(fieldType) ? applicationContext.containsProperties(valString) : applicationContext.containsProperty(valString);
            if (!result && this.isConfigurationProperties() && (cliOption = this.resolveCliOption(injectionPoint.getName())) != null) {
                return applicationContext.containsProperty(cliOption);
            }
            return result;
        }
        return false;
    }

    @Internal
    protected final boolean containsProperties(BeanResolutionContext resolutionContext, BeanContext context) {
        return this.containsProperties(resolutionContext, context, null);
    }

    @Internal
    protected final boolean containsProperties(BeanResolutionContext resolutionContext, BeanContext context, String subProperty) {
        boolean isSubProperty = StringUtils.isNotEmpty((CharSequence)subProperty);
        if (!isSubProperty && !this.requiredComponents.isEmpty()) {
            return true;
        }
        if (this.isConfigurationProperties && context instanceof ApplicationContext) {
            AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
            ApplicationContext appCtx = (ApplicationContext)context;
            if (annotationMetadata.getValue(ConfigurationProperties.class, "cliPrefix").isPresent()) {
                return true;
            }
            String path = this.getConfigurationPropertiesPath(resolutionContext);
            return appCtx.containsProperties(path);
        }
        return false;
    }

    @Internal
    protected final Object getBeanForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        Class beanType = injectionPoint.getType();
        if (beanType.isArray()) {
            Collection beansOfType = this.getBeansOfTypeForField(resolutionContext, context, injectionPoint);
            return beansOfType.toArray((Object[])Array.newInstance(beanType.getComponentType(), beansOfType.size()));
        }
        if (Collection.class.isAssignableFrom(beanType)) {
            Collection beansOfType = this.getBeansOfTypeForField(resolutionContext, context, injectionPoint);
            if (beanType.isInstance(beansOfType)) {
                return beansOfType;
            }
            return CollectionUtils.convertCollection(beanType, (Collection)beansOfType).orElse(null);
        }
        if (Stream.class.isAssignableFrom(beanType)) {
            return this.getStreamOfTypeForField(resolutionContext, context, injectionPoint);
        }
        if (Provider.class.isAssignableFrom(beanType)) {
            return this.getBeanProviderForField(resolutionContext, context, injectionPoint);
        }
        if (Optional.class.isAssignableFrom(beanType)) {
            return this.findBeanForField(resolutionContext, context, injectionPoint);
        }
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, injectionPoint);
        try {
            Qualifier qualifier = this.resolveQualifier(resolutionContext, injectionPoint);
            Object bean = ((DefaultBeanContext)context).getBean(resolutionContext, beanType, qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            if (injectionPoint.isDeclaredAnnotationPresent(Nullable.class)) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, injectionPoint, (Throwable)e);
        }
    }

    @Internal
    protected final Provider getBeanProviderForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        return this.resolveBeanWithGenericsForField(resolutionContext, injectionPoint, (beanType, qualifier) -> ((DefaultBeanContext)context).getBeanProvider(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Optional findBeanForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        return this.resolveBeanWithGenericsForField(resolutionContext, injectionPoint, (beanType, qualifier) -> ((DefaultBeanContext)context).findBean(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Collection getBeansOfTypeForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        return this.resolveBeanWithGenericsForField(resolutionContext, injectionPoint, (beanType, qualifier) -> {
            boolean hasNoGenerics;
            boolean bl = hasNoGenerics = !injectionPoint.getType().isArray() && injectionPoint.asArgument().getTypeVariables().isEmpty();
            if (hasNoGenerics) {
                return (Collection)((DefaultBeanContext)context).getBean(resolutionContext, beanType, qualifier);
            }
            return ((DefaultBeanContext)context).getBeansOfType(resolutionContext, beanType, qualifier);
        });
    }

    @Internal
    protected final Stream getStreamOfTypeForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        return this.resolveBeanWithGenericsForField(resolutionContext, injectionPoint, (beanType, qualifier) -> ((DefaultBeanContext)context).streamOfType(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected Map<String, Argument<?>[]> getTypeArgumentsMap() {
        return Collections.emptyMap();
    }

    protected AnnotationMetadata resolveAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private AnnotationMetadata initializeAnnotationMetadata() {
        AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata();
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            return new BeanAnnotationMetadata((DefaultAnnotationMetadata)annotationMetadata);
        }
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private AbstractBeanDefinition addInjectionPointInternal(Class declaringType, String method, @Nullable Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata, boolean requiresReflection, List<MethodInjectionPoint> targetInjectionPoints) {
        boolean isPreDestroy = targetInjectionPoints == this.preDestroyMethods;
        boolean isPostConstruct = targetInjectionPoints == this.postConstructMethods;
        DefaultMethodInjectionPoint injectionPoint = requiresReflection ? new ReflectionMethodInjectionPoint(this, declaringType, method, arguments, annotationMetadata) : new DefaultMethodInjectionPoint(this, declaringType, method, arguments, annotationMetadata);
        targetInjectionPoints.add(injectionPoint);
        if (isPostConstruct || isPreDestroy) {
            this.methodInjectionPoints.add(injectionPoint);
        }
        this.addRequiredComponents(arguments);
        return this;
    }

    private Object getBeanForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        Class argumentType = argument.getType();
        if (argumentType.isArray()) {
            Collection beansOfType = this.getBeansOfTypeForMethodArgument(resolutionContext, context, injectionPoint, argument);
            return beansOfType.toArray((Object[])Array.newInstance(argumentType.getComponentType(), beansOfType.size()));
        }
        if (Collection.class.isAssignableFrom(argumentType)) {
            Collection beansOfType = this.getBeansOfTypeForMethodArgument(resolutionContext, context, injectionPoint, argument);
            return this.coerceCollectionToCorrectType(argumentType, beansOfType);
        }
        if (Stream.class.isAssignableFrom(argumentType)) {
            return this.streamOfTypeForMethodArgument(resolutionContext, context, injectionPoint, argument);
        }
        if (Provider.class.isAssignableFrom(argumentType)) {
            return this.getBeanProviderForMethodArgument(resolutionContext, context, injectionPoint, argument);
        }
        if (Optional.class.isAssignableFrom(argumentType)) {
            return this.findBeanForMethodArgument(resolutionContext, context, injectionPoint, argument);
        }
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, injectionPoint, argument);
        try {
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            Object bean = ((DefaultBeanContext)context).getBean(resolutionContext, argumentType, qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            if (argument.isDeclaredAnnotationPresent(Nullable.class)) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, injectionPoint, argument, (Throwable)e);
        }
    }

    private Optional resolveValue(ApplicationContext context, ArgumentConversionContext<?> argument, boolean hasValueAnnotation, String valString) {
        String cliOption;
        if (hasValueAnnotation) {
            return context.resolvePlaceholders(valString).flatMap(v -> context.getConversionService().convert(v, argument));
        }
        Optional value = context.getProperty(valString, argument);
        if (!value.isPresent() && this.isConfigurationProperties() && (cliOption = this.resolveCliOption(argument.getArgument().getName())) != null) {
            return context.getProperty(cliOption, argument);
        }
        return value;
    }

    private String resolvePropertyValueName(BeanResolutionContext resolutionContext, AnnotationMetadata annotationMetadata, Argument argument, String valueAnnStr) {
        String valString;
        if (valueAnnStr != null) {
            valString = valueAnnStr;
        } else {
            valString = annotationMetadata.getValue(Property.class, "name", String.class).orElseGet(() -> (String)argument.getAnnotationMetadata().getValue(Property.class, "name", String.class).orElseThrow(() -> new DependencyInjectionException(resolutionContext, argument, "Value resolution attempted but @Value annotation is missing")));
            valString = this.substituteWildCards(resolutionContext, valString);
        }
        return valString;
    }

    private String resolvePropertyValueName(BeanResolutionContext resolutionContext, FieldInjectionPoint injectionPoint, String valueAnn, AnnotationMetadata annotationMetadata) {
        String valString;
        if (valueAnn != null) {
            valString = valueAnn;
        } else {
            valString = (String)annotationMetadata.getValue(Property.class, "name", String.class).orElseThrow(() -> new DependencyInjectionException(resolutionContext, injectionPoint, "Value resolution attempted but @Value annotation is missing"));
            valString = this.substituteWildCards(resolutionContext, valString);
        }
        return valString;
    }

    private String resolvePropertyPath(BeanResolutionContext resolutionContext, String path) {
        String valString = this.getConfigurationPropertiesPath(resolutionContext);
        return valString + "." + path;
    }

    private String getConfigurationPropertiesPath(BeanResolutionContext resolutionContext) {
        String valString = (String)this.getAnnotationMetadata().getValue(ConfigurationReader.class, "prefix", String.class).orElseThrow(() -> new IllegalStateException("Resolve property path called for non @ConfigurationProperties bean"));
        valString = this.substituteWildCards(resolutionContext, valString);
        return valString;
    }

    private String substituteWildCards(BeanResolutionContext resolutionContext, String valString) {
        Optional namedBean;
        if (valString.indexOf(42) > -1 && (namedBean = resolutionContext.get(Named.class.getName(), String.class)).isPresent()) {
            valString = valString.replace("*", (CharSequence)namedBean.get());
        }
        return valString;
    }

    private String resolveCliOption(String name) {
        String attr = "cliPrefix";
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        if (annotationMetadata.isPresent(ConfigurationProperties.class, attr)) {
            return annotationMetadata.getValue(ConfigurationProperties.class, attr, String.class).map(val -> val + name).orElse(null);
        }
        return null;
    }

    private boolean isInnerConfiguration(Class argumentType) {
        return this.isConfigurationProperties && argumentType.getName().indexOf(36) > -1 && !argumentType.isEnum() && !argumentType.isPrimitive() && Modifier.isPublic(argumentType.getModifiers()) && Modifier.isStatic(argumentType.getModifiers()) && this.isInnerOfAnySuperclass(argumentType);
    }

    private boolean isInnerOfAnySuperclass(Class argumentType) {
        for (Class<T> beanType = this.getBeanType(); beanType != null; beanType = beanType.getSuperclass()) {
            if (!(beanType.getName() + "$" + argumentType.getSimpleName()).equals(argumentType.getName())) continue;
            return true;
        }
        return false;
    }

    private <B, X extends RuntimeException> B resolveBeanWithGenericsFromMethodArgument(BeanResolutionContext resolutionContext, MethodInjectionPoint injectionPoint, Argument argument, BeanResolver<B> beanResolver) throws X {
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, injectionPoint, argument);
        try {
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            Class argumentType = argument.getType();
            Class genericType = this.resolveGenericType(argument, argumentType);
            B bean = beanResolver.resolveBean(genericType != null ? genericType : argumentType, qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, injectionPoint, argument, (Throwable)e);
        }
    }

    private Class resolveGenericType(Argument argument, Class argumentType) {
        Map genericTypes;
        Class genericType = argumentType.isArray() ? argumentType.getComponentType() : ((genericTypes = argument.getTypeVariables()).size() == 1 ? ((Argument)genericTypes.values().iterator().next()).getType() : null);
        return genericType;
    }

    private <B> B resolveBeanWithGenericsFromConstructorArgument(BeanResolutionContext resolutionContext, Argument argument, BeanResolver<B> beanResolver) {
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushConstructorResolve(this, argument);
        try {
            Class argumentType = argument.getType();
            Class genericType = this.resolveGenericType(argument, argumentType);
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            B bean = beanResolver.resolveBean(genericType != null ? genericType : argumentType, qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
    }

    private <B> B resolveBeanWithGenericsForField(BeanResolutionContext resolutionContext, FieldInjectionPoint injectionPoint, BeanResolver<B> beanResolver) {
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, injectionPoint);
        try {
            Optional<Class<?>> genericType = injectionPoint.getType().isArray() ? Optional.of(injectionPoint.getType().getComponentType()) : injectionPoint.asArgument().getFirstTypeVariable().map(Argument::getType);
            Qualifier qualifier = this.resolveQualifier(resolutionContext, injectionPoint);
            B bean = beanResolver.resolveBean(genericType.orElse(injectionPoint.getType()), qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, injectionPoint, (Throwable)e);
        }
    }

    private boolean isConfigurationProperties() {
        return this.isConfigurationProperties;
    }

    private Qualifier resolveQualifier(BeanResolutionContext resolutionContext, FieldInjectionPoint injectionPoint) {
        return this.resolveQualifier(resolutionContext, injectionPoint.asArgument());
    }

    private Qualifier resolveQualifier(BeanResolutionContext resolutionContext, Argument argument) {
        Qualifier qualifier = null;
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        Optional qualifierType = annotationMetadata.getAnnotationTypeByStereotype(javax.inject.Qualifier.class);
        if (qualifierType.isPresent()) {
            qualifier = Qualifiers.byAnnotation(annotationMetadata, (Class)qualifierType.get());
        }
        if (qualifier == null) {
            Class[] byType;
            Class[] classArray = byType = annotationMetadata.hasDeclaredAnnotation(Type.class) ? (Class[])annotationMetadata.getValue(Type.class, Class[].class).orElse(null) : null;
            if (byType != null) {
                qualifier = Qualifiers.byType(byType);
            } else {
                Optional<Qualifier> optional = resolutionContext.get(javax.inject.Qualifier.class.getName(), Map.class).map(map -> (Qualifier)map.get(argument));
                qualifier = optional.orElse(null);
                if (qualifier == null && this.isIterable() && argument.isAnnotationPresent(Parameter.class)) {
                    qualifier = optional.orElseGet(() -> {
                        Optional n = resolutionContext.get(Named.class.getName(), String.class);
                        return n.map(Qualifiers::byName).orElse(null);
                    });
                }
            }
        }
        return qualifier;
    }

    private Object resolveOptionalObject(Optional value) {
        if (!value.isPresent()) {
            return value;
        }
        Object convertedOptional = value.get();
        if (convertedOptional instanceof Optional) {
            return convertedOptional;
        }
        return value;
    }

    private Object coerceCollectionToCorrectType(Class collectionType, Collection beansOfType) {
        if (collectionType.isInstance(beansOfType)) {
            return beansOfType;
        }
        return CollectionUtils.convertCollection((Class)collectionType, (Collection)beansOfType).orElse(null);
    }

    private void addRequiredComponents(Argument ... arguments) {
        if (arguments != null) {
            for (Argument argument : arguments) {
                this.requiredComponents.add(argument.getType());
            }
        }
    }

    private void instrumentAnnotationMetadata(BeanContext context, Object object) {
        if (object instanceof EnvironmentConfigurable && context instanceof ApplicationContext) {
            ((EnvironmentConfigurable)object).configure(((ApplicationContext)context).getEnvironment());
        }
    }

    private static interface BeanResolver<T> {
        public T resolveBean(Class<T> var1, Qualifier<T> var2);
    }

    private final class MethodKey {
        final String name;
        final Class[] argumentTypes;

        MethodKey(String name, Class[] argumentTypes) {
            this.name = name;
            this.argumentTypes = argumentTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            if (!this.name.equals(methodKey.name)) {
                return false;
            }
            return Arrays.equals(this.argumentTypes, methodKey.argumentTypes);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.argumentTypes);
            return result;
        }
    }

    private final class BeanAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        BeanAnnotationMetadata(DefaultAnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return AbstractBeanDefinition.this.environment;
        }
    }
}

